/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal.win7;

import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.internal.DefaultColumnGroupHeaderRenderer;
import org.eclipse.nebula.widgets.grid.internal.ExpandToggleRenderer;
import org.eclipse.nebula.widgets.grid.internal.TextUtils;
import org.eclipse.nebula.widgets.grid.internal.win7.Win7ColumnHeaderUtil;
import org.eclipse.nebula.widgets.grid.internal.win7.Win7PaletteProvider;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;

public class Win7ColumnGroupHeaderRenderer
extends DefaultColumnGroupHeaderRenderer {
    int leftMargin = 6;
    int rightMargin = 6;
    int topMargin = 3;
    int bottomMargin = 3;
    int imageSpacing = 3;
    private ExpandToggleRenderer toggleRenderer = new ExpandToggleRenderer();
    private TextLayout textLayout;
    private Win7PaletteProvider palette;
    private int truncationStyle = 0x1000000;

    public Win7ColumnGroupHeaderRenderer(Win7PaletteProvider palette) {
        this.palette = palette;
    }

    @Override
    public void paint(GC gc, Object value) {
        GridColumnGroup group = (GridColumnGroup)((Object)value);
        gc.setFont(group.getHeaderFont());
        Win7ColumnHeaderUtil.drawColumn(gc, this.getBounds(), this.palette, this.isHover(), this.isSelected(), this.isMouseDown());
        int x = this.leftMargin;
        if (group.getImage() != null) {
            gc.drawImage(group.getImage(), this.getBounds().x + x, this.getBounds().y + this.topMargin);
            x = group.getImage().getBounds().width + this.imageSpacing;
        }
        int width = this.getBounds().width - x - this.rightMargin;
        if ((group.getStyle() & 2) != 0) {
            width -= this.toggleRenderer.getSize().x;
        }
        gc.setForeground(this.getDisplay().getSystemColor(21));
        if (!this.isWordWrap()) {
            gc.drawString(TextUtils.getShortStr(gc, group.getText(), width, this.truncationStyle), this.getBounds().x + x, this.getBounds().y + this.topMargin, true);
        } else {
            this.getTextLayout(gc, group);
            this.textLayout.setWidth(width < 1 ? 1 : width);
            this.textLayout.setText(group.getText());
            if (group.getParent().isAutoHeight()) {
                group.getParent().recalculateHeader();
            }
            this.textLayout.draw(gc, this.getBounds().x + x, this.getBounds().y + this.topMargin);
        }
        if ((group.getStyle() & 2) != 0) {
            this.toggleRenderer.setHover(this.isHover() && this.getHoverDetail().equals("toggle"));
            this.toggleRenderer.setExpanded(group.getExpanded());
            this.toggleRenderer.setBounds(this.getToggleBounds());
            this.toggleRenderer.paint(gc, null);
        }
    }

    @Override
    public void setDisplay(Display display) {
        super.setDisplay(display);
        this.toggleRenderer.setDisplay(display);
        this.palette.initializePalette(this.getDisplay(), Win7PaletteProvider.NORMAL_GRID_COLUMN_HEADER);
        this.palette.initializePalette(this.getDisplay(), Win7PaletteProvider.HOVER_GRID_COLUMN_HEADER);
    }

    private void getTextLayout(GC gc, GridColumnGroup group) {
        if (this.textLayout == null) {
            this.textLayout = new TextLayout(gc.getDevice());
            this.textLayout.setFont(gc.getFont());
            group.getParent().addListener(12, e -> this.textLayout.dispose());
        }
    }

    @Override
    public int getTruncationStyle() {
        return this.truncationStyle;
    }

    @Override
    public void setTruncationStyle(int truncationStyle) {
        this.truncationStyle = truncationStyle;
    }
}

