/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.tiles;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.tiles.DecoratorListener;
import org.eclipse.swt.SWTException;

public abstract class Decorator<T, U> {
    private final List<DecoratorListener> listeners = new ArrayList<DecoratorListener>();
    private int refcount = 0;
    private boolean disposed = false;

    public final void addDecoratorListener(DecoratorListener listener) {
        this.listeners.add(listener);
    }

    public abstract U decorate(T var1);

    public final void removeDecoratorListener(DecoratorListener listener) {
        this.listeners.remove(listener);
    }

    protected final void free() {
        if (this.disposed) {
            throw new SWTException("Already disposed");
        }
        --this.refcount;
        if (this.refcount == 0) {
            this.disposed = true;
            for (DecoratorListener listener : this.listeners) {
                listener.disposed();
            }
        }
    }

    protected final void use() {
        if (this.disposed) {
            throw new SWTException("Already disposed");
        }
        ++this.refcount;
    }
}

