/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.rangeslider.snippets;

import org.eclipse.nebula.widgets.opal.rangeslider.RangeSlider;
import org.eclipse.nebula.widgets.opal.titledseparator.TitledSeparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RangeSliderSnippet {
    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout(256));
        RangeSliderSnippet.createNormalSliders(new Group((Composite)shell, 0));
        RangeSliderSnippet.createDisabledSliders(new Group((Composite)shell, 0));
        RangeSliderSnippet.createDifferentSliders(new Group((Composite)shell, 0));
        RangeSliderSnippet.createSlidersCanceledSelectionListener(new Group((Composite)shell, 0));
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static void createNormalSliders(Group group) {
        group.setLayout((Layout)new GridLayout(3, false));
        TitledSeparator tsh = new TitledSeparator((Composite)group, 0);
        tsh.setText("Horizontal Range Slider");
        tsh.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        final RangeSlider hRangeSlider = new RangeSlider((Composite)group, 256);
        GridData gd = new GridData(4, 2, true, false, 1, 2);
        gd.widthHint = 250;
        hRangeSlider.setLayoutData((Object)gd);
        hRangeSlider.setMinimum(0);
        hRangeSlider.setMaximum(100);
        hRangeSlider.setLowerValue(0);
        hRangeSlider.setUpperValue(60);
        Label hLabelLower = new Label((Composite)group, 0);
        hLabelLower.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        hLabelLower.setText("Lower Value:");
        final Text hTextLower = new Text((Composite)group, 2048);
        hTextLower.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        hTextLower.setText(hRangeSlider.getLowerValue() + "   ");
        hTextLower.setEnabled(false);
        Label hLabelUpper = new Label((Composite)group, 0);
        hLabelUpper.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        hLabelUpper.setText("Upper Value:");
        final Text hTextUpper = new Text((Composite)group, 2048);
        hTextUpper.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        hTextUpper.setText(hRangeSlider.getUpperValue() + "   ");
        hTextUpper.setEnabled(false);
        hRangeSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                hTextLower.setText(hRangeSlider.getLowerValue() + "   ");
                hTextUpper.setText(hRangeSlider.getUpperValue() + "   ");
            }
        });
        TitledSeparator tsv = new TitledSeparator((Composite)group, 0);
        tsv.setText("Vertical Range Slider");
        tsv.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        RangeSlider vRangeSlider = new RangeSlider((Composite)group, 512);
        GridData gd2 = new GridData(2, 4, false, false, 1, 2);
        gd2.heightHint = 300;
        vRangeSlider.setLayoutData((Object)gd2);
        Label vLabelLower = new Label((Composite)group, 0);
        vLabelLower.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        vLabelLower.setText("Lower Value:");
        final Text vTextLower = new Text((Composite)group, 2048);
        vTextLower.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        vTextLower.setText(vRangeSlider.getLowerValue() + "   ");
        vTextLower.setEnabled(false);
        Label vLabelUpper = new Label((Composite)group, 0);
        vLabelUpper.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        vLabelUpper.setText("Upper Value:");
        final Text vTextUpper = new Text((Composite)group, 2048);
        vTextUpper.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        vTextUpper.setText(vRangeSlider.getUpperValue() + "   ");
        vTextUpper.setEnabled(false);
        vRangeSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                vTextLower.setText(hRangeSlider.getLowerValue() + "   ");
                vTextUpper.setText(hRangeSlider.getUpperValue() + "   ");
            }
        });
    }

    private static void createDisabledSliders(Group group) {
        group.setLayout((Layout)new GridLayout(3, false));
        TitledSeparator tsh = new TitledSeparator((Composite)group, 0);
        tsh.setText("Horizontal Range Slider, disabled");
        tsh.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        RangeSlider hRangeSlider = new RangeSlider((Composite)group, 256);
        GridData gd = new GridData(4, 2, true, false, 1, 2);
        gd.widthHint = 250;
        hRangeSlider.setLayoutData((Object)gd);
        hRangeSlider.setMinimum(0);
        hRangeSlider.setMaximum(100);
        hRangeSlider.setLowerValue(0);
        hRangeSlider.setUpperValue(60);
        hRangeSlider.setEnabled(false);
        Label hLabelLower = new Label((Composite)group, 0);
        hLabelLower.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        hLabelLower.setText("Lower Value:");
        Text hTextLower = new Text((Composite)group, 2048);
        hTextLower.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        hTextLower.setText(hRangeSlider.getLowerValue() + "   ");
        hTextLower.setEnabled(false);
        Label hLabelUpper = new Label((Composite)group, 0);
        hLabelUpper.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        hLabelUpper.setText("Upper Value:");
        Text hTextUpper = new Text((Composite)group, 2048);
        hTextUpper.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        hTextUpper.setText(hRangeSlider.getUpperValue() + "   ");
        hTextUpper.setEnabled(false);
        TitledSeparator tsv = new TitledSeparator((Composite)group, 0);
        tsv.setText("Vertical Range Slider, disabled");
        tsv.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        RangeSlider vRangeSlider = new RangeSlider((Composite)group, 512);
        GridData gd2 = new GridData(2, 4, false, false, 1, 2);
        gd2.heightHint = 300;
        vRangeSlider.setLayoutData((Object)gd2);
        vRangeSlider.setEnabled(false);
        Label vLabelLower = new Label((Composite)group, 0);
        vLabelLower.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        vLabelLower.setText("Lower Value:");
        Text vTextLower = new Text((Composite)group, 2048);
        vTextLower.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        vTextLower.setText(vRangeSlider.getLowerValue() + "   ");
        vTextLower.setEnabled(false);
        Label vLabelUpper = new Label((Composite)group, 0);
        vLabelUpper.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        vLabelUpper.setText("Upper Value:");
        Text vTextUpper = new Text((Composite)group, 2048);
        vTextUpper.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        vTextUpper.setText(vRangeSlider.getUpperValue() + "   ");
        vTextUpper.setEnabled(false);
    }

    private static void createDifferentSliders(Group group) {
        group.setLayout((Layout)new GridLayout(3, false));
        TitledSeparator tsh = new TitledSeparator((Composite)group, 0);
        tsh.setText("Horizontal Range Slider, between 100 and 1000, increment by 100");
        tsh.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        RangeSlider hRangeSlider = new RangeSlider((Composite)group, 256);
        GridData gd = new GridData(4, 2, true, false, 1, 2);
        gd.widthHint = 250;
        hRangeSlider.setLayoutData((Object)gd);
        hRangeSlider.setMinimum(100);
        hRangeSlider.setMaximum(1000);
        hRangeSlider.setLowerValue(200);
        hRangeSlider.setUpperValue(800);
        hRangeSlider.setIncrement(100);
        hRangeSlider.setPageIncrement(200);
        Label hLabelLower = new Label((Composite)group, 0);
        hLabelLower.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        hLabelLower.setText("Lower Value:");
        Text hTextLower = new Text((Composite)group, 2048);
        hTextLower.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        hTextLower.setText(hRangeSlider.getLowerValue() + "   ");
        hTextLower.setEnabled(false);
        Label hLabelUpper = new Label((Composite)group, 0);
        hLabelUpper.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        hLabelUpper.setText("Upper Value:");
        Text hTextUpper = new Text((Composite)group, 2048);
        hTextUpper.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        hTextUpper.setText(hRangeSlider.getUpperValue() + "   ");
        hTextUpper.setEnabled(false);
        TitledSeparator tsv = new TitledSeparator((Composite)group, 0);
        tsv.setText("Vertical Range Slider, between 100 and 1000, increment by 100");
        tsv.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        RangeSlider vRangeSlider = new RangeSlider((Composite)group, 512);
        GridData gd2 = new GridData(2, 4, false, false, 1, 2);
        gd2.heightHint = 300;
        vRangeSlider.setLayoutData((Object)gd2);
        vRangeSlider.setMinimum(100);
        vRangeSlider.setMaximum(1000);
        vRangeSlider.setLowerValue(200);
        vRangeSlider.setUpperValue(800);
        vRangeSlider.setIncrement(100);
        vRangeSlider.setPageIncrement(200);
        Label vLabelLower = new Label((Composite)group, 0);
        vLabelLower.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        vLabelLower.setText("Lower Value:");
        Text vTextLower = new Text((Composite)group, 2048);
        vTextLower.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        vTextLower.setText(vRangeSlider.getLowerValue() + "   ");
        vTextLower.setEnabled(false);
        Label vLabelUpper = new Label((Composite)group, 0);
        vLabelUpper.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        vLabelUpper.setText("Upper Value:");
        Text vTextUpper = new Text((Composite)group, 2048);
        vTextUpper.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        vTextUpper.setText(vRangeSlider.getUpperValue() + "   ");
        vTextUpper.setEnabled(false);
    }

    private static void createSlidersCanceledSelectionListener(Group group) {
        group.setLayout((Layout)new GridLayout(3, false));
        TitledSeparator tsh = new TitledSeparator((Composite)group, 0);
        tsh.setText("Horizontal Range Slider, cancel selection");
        tsh.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        RangeSlider hRangeSlider = new RangeSlider((Composite)group, 256);
        GridData gd = new GridData(4, 2, true, false, 1, 2);
        gd.widthHint = 250;
        hRangeSlider.setLayoutData((Object)gd);
        hRangeSlider.setMinimum(0);
        hRangeSlider.setMaximum(100);
        hRangeSlider.setLowerValue(0);
        hRangeSlider.setUpperValue(60);
        hRangeSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                e.doit = false;
            }
        });
        Label hLabelLower = new Label((Composite)group, 0);
        hLabelLower.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        hLabelLower.setText("Lower Value:");
        Text hTextLower = new Text((Composite)group, 2048);
        hTextLower.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        hTextLower.setText(hRangeSlider.getLowerValue() + "   ");
        hTextLower.setEnabled(false);
        Label hLabelUpper = new Label((Composite)group, 0);
        hLabelUpper.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        hLabelUpper.setText("Upper Value:");
        Text hTextUpper = new Text((Composite)group, 2048);
        hTextUpper.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        hTextUpper.setText(hRangeSlider.getUpperValue() + "   ");
        hTextUpper.setEnabled(false);
        TitledSeparator tsv = new TitledSeparator((Composite)group, 0);
        tsv.setText("Vertical Range Slider, cancel selection");
        tsv.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        RangeSlider vRangeSlider = new RangeSlider((Composite)group, 512);
        GridData gd2 = new GridData(2, 4, false, false, 1, 2);
        gd2.heightHint = 300;
        vRangeSlider.setLayoutData((Object)gd2);
        Label vLabelLower = new Label((Composite)group, 0);
        vLabelLower.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        vLabelLower.setText("Lower Value:");
        Text vTextLower = new Text((Composite)group, 2048);
        vTextLower.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        vTextLower.setText(vRangeSlider.getLowerValue() + "   ");
        vTextLower.setEnabled(false);
        Label vLabelUpper = new Label((Composite)group, 0);
        vLabelUpper.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        vLabelUpper.setText("Upper Value:");
        Text vTextUpper = new Text((Composite)group, 2048);
        vTextUpper.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        vTextUpper.setText(vRangeSlider.getUpperValue() + "   ");
        vTextUpper.setEnabled(false);
        vRangeSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                e.doit = false;
            }
        });
    }
}

