/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.exampleview;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBufferDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.ISample;
import org.eclipse.nebula.visualization.xygraph.dataprovider.Sample;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.ToolbarArmedXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.styleprovider.BooleanStyleProvider;
import org.eclipse.nebula.visualization.xygraph.styleprovider.IPointStyleProvider;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class XYGraphStyledBoolExampleView
extends ViewPart {
    public void createPartControl(Composite parent) {
        LightweightSystem lws = new LightweightSystem(new Canvas(parent, 0));
        XYGraph xyGraph = new XYGraph();
        ToolbarArmedXYGraph toolbarArmedXYGraph = new ToolbarArmedXYGraph((IXYGraph)xyGraph);
        xyGraph.setTitle("Simple Styled Example");
        lws.setContents((IFigure)toolbarArmedXYGraph);
        CircularBufferDataProvider traceDataProvider = new CircularBufferDataProvider(false);
        int i = 0;
        while (i < 20) {
            Sample sample = new Sample(Math.random(), Math.random());
            sample.setData((Object)(Math.random() < 0.5 ? 1 : 0));
            traceDataProvider.addSample((ISample)sample);
            ++i;
        }
        Trace trace = new Trace("Trace-Styled XY Plot", xyGraph.getPrimaryXAxis(), xyGraph.getPrimaryYAxis(), (IDataProvider)traceDataProvider);
        trace.setTraceColor(XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_GRAY));
        trace.setTraceType(Trace.TraceType.POINT);
        trace.setPointStyle(Trace.PointStyle.FILLED_SQUARE);
        trace.setPointSize(40);
        trace.setPointStyleProvider((IPointStyleProvider)new BooleanStyleProvider());
        xyGraph.addTrace(trace);
        xyGraph.performAutoScale();
    }

    public void setFocus() {
    }
}

