/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tree.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandCollapseCommand;

public class TreeExpandCollapseCommandHandler
extends AbstractLayerCommandHandler<TreeExpandCollapseCommand> {
    private final TreeLayer treeLayer;

    public TreeExpandCollapseCommandHandler(TreeLayer treeLayer) {
        this.treeLayer = treeLayer;
    }

    @Override
    public Class<TreeExpandCollapseCommand> getCommandClass() {
        return TreeExpandCollapseCommand.class;
    }

    @Override
    protected boolean doCommand(TreeExpandCollapseCommand command) {
        int parentIndex = command.getParentIndex();
        if (command.getParentIndex() < 0) {
            int rowPos = this.treeLayer.getRowPositionByIndex(command.getParentIndex() * -1);
            int colPos = this.treeLayer.isUseTreeColumnIndex() ? this.treeLayer.getColumnPositionByIndex(0) : 0;
            ILayerCell cell = this.treeLayer.getCellByPosition(colPos, rowPos);
            parentIndex = this.treeLayer.getRowIndexByPosition(cell.getOriginRowPosition());
        }
        this.treeLayer.expandOrCollapseIndex(parentIndex);
        return true;
    }
}

