/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.RepositoryPerson;
import org.eclipse.mylyn.internal.tasks.core.TaskComment;
import org.eclipse.mylyn.internal.tasks.ui.editors.CommentGroupStrategy;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;

public class CommentGroupStrategyTest
extends TestCase {
    private static final String MOCK_CURRENT_PERSON_ID = "mockCurrentPersonId";
    private static final String MOCK_TASK_ATTRIBUTE = "mockTaskAttribute";
    private static final String MOCK_TEXT = "mockText";
    private final List<ITaskComment> comments;
    private final TaskRepository repository = TaskTestUtil.createMockRepository();
    private final CommentGroupStrategy strategy;
    private final ITask task = TaskTestUtil.createMockTask("1");
    private final TaskData taskData = TaskTestUtil.createMockTaskData("1");

    public CommentGroupStrategyTest() {
        this.comments = new ArrayList<ITaskComment>();
        this.strategy = new CommentGroupStrategy();
    }

    private TaskComment mockComment(int number, String personId, Date date) {
        return this.mockComment(number, personId, date, MOCK_TEXT);
    }

    private TaskComment mockComment(int number, String personId, Date date, String text) {
        TaskAttribute taskAttribute = this.taskData.getRoot().createAttribute(MOCK_TASK_ATTRIBUTE + this.comments.size());
        TaskComment comment = new TaskComment(this.repository, this.task, taskAttribute);
        comment.setNumber(number);
        comment.setAuthor((IRepositoryPerson)new RepositoryPerson(this.repository, personId));
        comment.setCreationDate(date);
        comment.setText(text);
        return comment;
    }

    protected void setUp() throws Exception {
        this.comments.clear();
    }

    public void testGroupCommentsAuthoredLatestComment() {
        int recentComments = 12;
        int i = 0;
        while (i < recentComments) {
            this.comments.add((ITaskComment)this.mockComment(i + 1, "OtherPerson", new Date(i + 1)));
            ++i;
        }
        this.comments.add((ITaskComment)this.mockComment(recentComments + 1, MOCK_CURRENT_PERSON_ID, new Date(recentComments + 1)));
        List group = this.strategy.groupComments(this.comments, MOCK_CURRENT_PERSON_ID);
        CommentGroupStrategyTest.assertEquals((int)2, (int)group.size());
        CommentGroupStrategy.CommentGroup recentGroup = (CommentGroupStrategy.CommentGroup)group.get(0);
        CommentGroupStrategyTest.assertEquals((String)CommentGroupStrategy.CommentGroup.RECENT, (String)recentGroup.getGroupName());
        CommentGroupStrategyTest.assertEquals((int)recentComments, (int)recentGroup.getComments().size());
        CommentGroupStrategy.CommentGroup currentGroup = (CommentGroupStrategy.CommentGroup)group.get(1);
        CommentGroupStrategyTest.assertEquals((String)CommentGroupStrategy.CommentGroup.CURRENT, (String)currentGroup.getGroupName());
        CommentGroupStrategyTest.assertEquals((int)1, (int)currentGroup.getComments().size());
    }

    public void testGroupCommentsMaxCurrent() {
        int oneLessThanMaxCurrent = 11;
        int i = 0;
        while (i < oneLessThanMaxCurrent) {
            this.comments.add((ITaskComment)this.mockComment(i + 1, MOCK_CURRENT_PERSON_ID, new Date(i + 1)));
            ++i;
        }
        List group = this.strategy.groupComments(this.comments, MOCK_CURRENT_PERSON_ID);
        CommentGroupStrategyTest.assertEquals((int)1, (int)group.size());
        CommentGroupStrategy.CommentGroup currentGroup = (CommentGroupStrategy.CommentGroup)group.get(0);
        CommentGroupStrategyTest.assertEquals((String)CommentGroupStrategy.CommentGroup.CURRENT, (String)currentGroup.getGroupName());
        CommentGroupStrategyTest.assertEquals((int)oneLessThanMaxCurrent, (int)currentGroup.getComments().size());
    }

    public void testGroupCommentsNotAuthoredLastestComment() {
        int i = 0;
        while (i < 12) {
            this.comments.add((ITaskComment)this.mockComment(i + 1, "OtherPerson", new Date(i + 1)));
            ++i;
        }
        this.comments.add((ITaskComment)this.mockComment(13, "OtherPerson", new Date(13L)));
        List group = this.strategy.groupComments(this.comments, MOCK_CURRENT_PERSON_ID);
        CommentGroupStrategyTest.assertEquals((int)2, (int)group.size());
        CommentGroupStrategy.CommentGroup recentGroup = (CommentGroupStrategy.CommentGroup)group.get(0);
        CommentGroupStrategyTest.assertEquals((String)CommentGroupStrategy.CommentGroup.RECENT, (String)recentGroup.getGroupName());
        CommentGroupStrategyTest.assertEquals((int)1, (int)recentGroup.getComments().size());
        CommentGroupStrategy.CommentGroup currentGroup = (CommentGroupStrategy.CommentGroup)group.get(1);
        CommentGroupStrategyTest.assertEquals((String)CommentGroupStrategy.CommentGroup.CURRENT, (String)currentGroup.getGroupName());
        CommentGroupStrategyTest.assertEquals((int)12, (int)currentGroup.getComments().size());
    }

    public void testGroupComments_RecentAndOlder() {
        int total = 32;
        int i = 0;
        while (i < total) {
            this.comments.add((ITaskComment)this.mockComment(i + 1, "OtherPerson", new Date(i + 1)));
            ++i;
        }
        this.comments.add((ITaskComment)this.mockComment(total + 1, "OtherPerson", new Date(total + 1)));
        List group = this.strategy.groupComments(this.comments, MOCK_CURRENT_PERSON_ID);
        CommentGroupStrategyTest.assertEquals((int)3, (int)group.size());
        CommentGroupStrategy.CommentGroup olderGroup = (CommentGroupStrategy.CommentGroup)group.get(0);
        CommentGroupStrategyTest.assertEquals((String)CommentGroupStrategy.CommentGroup.OLDER, (String)olderGroup.getGroupName());
        CommentGroupStrategyTest.assertEquals((int)1, (int)olderGroup.getComments().size());
        CommentGroupStrategy.CommentGroup recentGroup = (CommentGroupStrategy.CommentGroup)group.get(1);
        CommentGroupStrategyTest.assertEquals((String)CommentGroupStrategy.CommentGroup.RECENT, (String)recentGroup.getGroupName());
        CommentGroupStrategyTest.assertEquals((int)20, (int)recentGroup.getComments().size());
        CommentGroupStrategy.CommentGroup currentGroup = (CommentGroupStrategy.CommentGroup)group.get(2);
        CommentGroupStrategyTest.assertEquals((String)CommentGroupStrategy.CommentGroup.CURRENT, (String)currentGroup.getGroupName());
        CommentGroupStrategyTest.assertEquals((int)12, (int)currentGroup.getComments().size());
    }

    public void testGroupCommentsRecentAndOlder2() {
        int older = 10;
        int recent = 20;
        int total = older + recent;
        int i = 0;
        while (i < total) {
            this.comments.add((ITaskComment)this.mockComment(i + 1, MOCK_CURRENT_PERSON_ID, new Date(i + 1)));
            ++i;
        }
        this.comments.add((ITaskComment)this.mockComment(total + 1, MOCK_CURRENT_PERSON_ID, new Date(total + 1)));
        List group = this.strategy.groupComments(this.comments, MOCK_CURRENT_PERSON_ID);
        CommentGroupStrategyTest.assertEquals((int)3, (int)group.size());
        CommentGroupStrategy.CommentGroup olderGroup = (CommentGroupStrategy.CommentGroup)group.get(0);
        CommentGroupStrategyTest.assertEquals((String)CommentGroupStrategy.CommentGroup.OLDER, (String)olderGroup.getGroupName());
        CommentGroupStrategyTest.assertEquals((int)older, (int)olderGroup.getComments().size());
        CommentGroupStrategy.CommentGroup recentGroup = (CommentGroupStrategy.CommentGroup)group.get(1);
        CommentGroupStrategyTest.assertEquals((String)CommentGroupStrategy.CommentGroup.RECENT, (String)recentGroup.getGroupName());
        CommentGroupStrategyTest.assertEquals((int)recent, (int)recentGroup.getComments().size());
        CommentGroupStrategy.CommentGroup currentGroup = (CommentGroupStrategy.CommentGroup)group.get(2);
        CommentGroupStrategyTest.assertEquals((String)CommentGroupStrategy.CommentGroup.CURRENT, (String)currentGroup.getGroupName());
        CommentGroupStrategyTest.assertEquals((int)1, (int)currentGroup.getComments().size());
    }

    public void testIsCurrentAuthoredPreviousComment() {
        this.comments.add((ITaskComment)this.mockComment(2, MOCK_CURRENT_PERSON_ID, new Date(2L)));
        boolean isCurrent = this.strategy.isCurrent(this.comments, (ITaskComment)this.mockComment(1, MOCK_CURRENT_PERSON_ID, new Date(1L)), MOCK_CURRENT_PERSON_ID);
        CommentGroupStrategyTest.assertEquals((boolean)false, (boolean)isCurrent);
    }

    public void testIsCurrentAuthoredPreviousCommentButSystemGenerated() {
        this.comments.add((ITaskComment)this.mockComment(2, MOCK_CURRENT_PERSON_ID, new Date(2L), "mylyn/context/zip"));
        boolean isCurrent = this.strategy.isCurrent(this.comments, (ITaskComment)this.mockComment(1, MOCK_CURRENT_PERSON_ID, new Date(1L)), MOCK_CURRENT_PERSON_ID);
        CommentGroupStrategyTest.assertEquals((boolean)true, (boolean)isCurrent);
    }

    public void testIsCurrentMaxCurrent() {
        int i = 0;
        while (i < 12) {
            this.comments.add((ITaskComment)this.mockComment(i + 1, MOCK_CURRENT_PERSON_ID, new Date(i + 1)));
            ++i;
        }
        boolean isCurrent = this.strategy.isCurrent(this.comments, (ITaskComment)this.mockComment(13, MOCK_CURRENT_PERSON_ID, new Date(13L)), MOCK_CURRENT_PERSON_ID);
        CommentGroupStrategyTest.assertEquals((boolean)false, (boolean)isCurrent);
    }

    public void testIsCurrentNoComment() {
        boolean isCurrent = this.strategy.isCurrent(this.comments, (ITaskComment)this.mockComment(1, MOCK_CURRENT_PERSON_ID, new Date(1L)), MOCK_CURRENT_PERSON_ID);
        CommentGroupStrategyTest.assertEquals((boolean)true, (boolean)isCurrent);
    }

    public void testIsCurrentNotAuthoredPreviousComment() {
        this.comments.add((ITaskComment)this.mockComment(2, "AnotherPerson", new Date(2L), MOCK_TEXT));
        boolean isCurrent = this.strategy.isCurrent(this.comments, (ITaskComment)this.mockComment(1, MOCK_CURRENT_PERSON_ID, new Date(1L)), MOCK_CURRENT_PERSON_ID);
        CommentGroupStrategyTest.assertEquals((boolean)true, (boolean)isCurrent);
    }
}

