/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.mylyn.commons.workbench.EditorHandle;
import org.eclipse.mylyn.commons.workbench.browser.AbstractUrlHandler;
import org.eclipse.mylyn.internal.gerrit.ui.GerritCompareUi;
import org.eclipse.mylyn.internal.gerrit.ui.GerritReviewBehavior;
import org.eclipse.mylyn.internal.gerrit.ui.editor.GerritTaskEditorPage;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.ui.spi.editor.ReviewSetSection;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.editor.IFormPage;

public class GerritUrlHandler
extends AbstractUrlHandler {
    private static final Pattern URL_PATTERN = Pattern.compile("/?(#/c)?/(\\d+)");

    public EditorHandle openUrl(IWorkbenchPage page, String url, int customFlags) {
        for (TaskRepository repository : TasksUi.getRepositoryManager().getRepositories("org.eclipse.mylyn.gerrit")) {
            GerritTaskEditorPage gerritPage;
            String taskId = this.getTaskId(repository, url);
            if (taskId == null) continue;
            int patchSetNumber = this.getPatchSetNumber(repository, url, taskId);
            EditorHandle editorHandle = TasksUiUtil.openTaskWithResult((TaskRepository)repository, (String)taskId);
            if (patchSetNumber > 0 && (gerritPage = this.revealPatchSet(editorHandle, patchSetNumber)) != null) {
                IFileItem file = this.getFileItem(gerritPage.getReview(), patchSetNumber, this.getFilePath(repository, url, taskId, patchSetNumber));
                this.openCompareEditor(file);
            }
            return editorHandle;
        }
        return null;
    }

    public void openCompareEditor(IFileItem file) {
        if (file != null) {
            GerritCompareUi.openFileComparisonEditor(new CompareConfiguration(), file, new GerritReviewBehavior(null));
        }
    }

    protected GerritTaskEditorPage revealPatchSet(EditorHandle editorHandle, Integer patchSetNumber) {
        TaskEditor taskEditor;
        IFormPage activePage;
        IWorkbenchPart part = editorHandle.getPart();
        if (part instanceof TaskEditor && (activePage = (taskEditor = (TaskEditor)part).setActivePage(GerritTaskEditorPage.class.getName())) instanceof GerritTaskEditorPage) {
            GerritTaskEditorPage gerritPage = (GerritTaskEditorPage)activePage;
            ReviewSetSection section = (ReviewSetSection)gerritPage.getPart(ReviewSetSection.class.getName());
            if (section != null && !section.getControl().isDisposed()) {
                section.revealPatchSet(patchSetNumber.intValue());
            }
            return gerritPage;
        }
        return null;
    }

    public String getTaskId(TaskRepository repository, String url) {
        String path;
        Matcher matcher;
        if (url.startsWith(repository.getRepositoryUrl()) && (matcher = URL_PATTERN.matcher(path = "/" + url.substring(repository.getRepositoryUrl().length()))).find()) {
            return matcher.group(2);
        }
        return null;
    }

    int getPatchSetNumber(TaskRepository repository, String url, String taskId) {
        String[] fragments = StringUtils.split((String)this.extractUrlQualifiers(repository, url, taskId), (String)"/");
        if (fragments.length > 0) {
            String patchSetFragment = fragments[0];
            try {
                return Integer.parseInt(patchSetFragment);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public String getFilePath(TaskRepository repository, String url, String taskId, int patchSetNumber) {
        String[] fragments;
        if (patchSetNumber > 0 && (fragments = StringUtils.split((String)this.extractUrlQualifiers(repository, url, taskId), (String)"/")).length > 1) {
            return String.join((CharSequence)"/", Arrays.copyOfRange(fragments, 1, fragments.length));
        }
        return null;
    }

    private String extractUrlQualifiers(TaskRepository repository, String url, String taskId) {
        String taskUrl = TasksUi.getRepositoryConnector((String)"org.eclipse.mylyn.gerrit").getTaskUrl(repository.getUrl(), taskId);
        return StringUtils.remove((String)url, (String)taskUrl);
    }

    public IFileItem getFileItem(IReview review, int patchSetNumber, String path) {
        if (review != null) {
            for (IReviewItemSet set : review.getSets()) {
                if (!set.getId().equals(Integer.toString(patchSetNumber))) continue;
                for (IFileItem item : set.getItems()) {
                    if (!path.equals(item.getName())) continue;
                    return item;
                }
            }
        }
        return null;
    }

    public int getPriority() {
        return 200;
    }
}

