/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.AbstractPartialRegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractFallibilityAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CyclicFallibilityAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CyclicPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.FallibilityAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.LoadingPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.SelfCyclicFallibilityAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class PartitionedTransformationAnalysis
extends AbstractPartialRegionsAnalysis<PartitionsAnalysis> {
    protected final @NonNull TransformationPartitioner transformationPartitioner;
    private final @NonNull Map<@NonNull Partition, @NonNull AbstractPartitionAnalysis<? extends @NonNull Partition>> partition2partitionAnalysis = new HashMap<Partition, AbstractPartitionAnalysis<? extends Partition>>();
    private final @NonNull Map<@NonNull Partition, @NonNull AbstractFallibilityAnalysis> partition2fallibilityAnalysis = new HashMap<Partition, AbstractFallibilityAnalysis>();
    private @Nullable RootPartitionAnalysis rootPartitionAnalysis = null;

    public PartitionedTransformationAnalysis(@NonNull TransformationPartitioner transformationPartitioner) {
        super(transformationPartitioner.getScheduleManager());
        this.transformationPartitioner = transformationPartitioner;
    }

    public void addPartitionAnalysis(@NonNull AbstractPartitionAnalysis<? extends @NonNull Partition> partitionAnalysis) {
        this.partition2partitionAnalysis.put(partitionAnalysis.getPartition(), partitionAnalysis);
    }

    public void analyzeFallibilities(@NonNull RootPartitionAnalysis rootPartitionAnalysis) {
        for (PartialRegionAnalysis<PartitionsAnalysis> nestedPartitionAnalysis : rootPartitionAnalysis.getPartitionAnalyses()) {
            if (nestedPartitionAnalysis instanceof CyclicPartitionAnalysis) {
                this.analyzeFallibilities((CyclicPartitionAnalysis)nestedPartitionAnalysis);
                continue;
            }
            if (nestedPartitionAnalysis instanceof LoadingPartitionAnalysis || nestedPartitionAnalysis instanceof MappingPartitionAnalysis) continue;
            throw new UnsupportedOperationException();
        }
    }

    protected @NonNull AbstractFallibilityAnalysis analyzeFallibilities(@NonNull CyclicPartitionAnalysis partitionAnalysis) {
        Iterable<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> partitionAnalyses = partitionAnalysis.getPartitionAnalyses();
        if (Iterables.size(partitionAnalyses) == 1) {
            PartialRegionAnalysis<@NonNull PartitionsAnalysis> nestedPartitionAnalysis = partitionAnalyses.iterator().next();
            if (nestedPartitionAnalysis instanceof CyclicPartitionAnalysis) {
                return this.analyzeFallibilities((CyclicPartitionAnalysis)nestedPartitionAnalysis);
            }
            assert (nestedPartitionAnalysis instanceof MappingPartitionAnalysis);
            return this.getFallibilityAnalysis(nestedPartitionAnalysis.getPartition());
        }
        CyclicFallibilityAnalysis cyclicFallibilityAnalysis = new CyclicFallibilityAnalysis(partitionAnalysis);
        for (PartialRegionAnalysis<PartitionsAnalysis> nestedPartitionAnalysis : partitionAnalyses) {
            if (nestedPartitionAnalysis instanceof CyclicPartitionAnalysis) {
                AbstractFallibilityAnalysis nestedFallibilityAnalysis = this.analyzeFallibilities((CyclicPartitionAnalysis)nestedPartitionAnalysis);
                cyclicFallibilityAnalysis.analyze(nestedFallibilityAnalysis);
                continue;
            }
            assert (nestedPartitionAnalysis instanceof MappingPartitionAnalysis);
            Partition nestedPartition = nestedPartitionAnalysis.getPartition();
            FallibilityAnalysis fallibilityAnalysis = this.partition2fallibilityAnalysis.get(nestedPartition);
            assert (fallibilityAnalysis == null);
            cyclicFallibilityAnalysis.analyze((PartitionAnalysis)nestedPartitionAnalysis);
            FallibilityAnalysis oldFallibilityAnalysis = this.partition2fallibilityAnalysis.put(nestedPartition, cyclicFallibilityAnalysis);
            assert (oldFallibilityAnalysis == null);
        }
        cyclicFallibilityAnalysis.analyze();
        return cyclicFallibilityAnalysis;
    }

    public void analyzePartitions(@NonNull Iterable<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> partitionAnalyses) {
        for (PartialRegionAnalysis<PartitionsAnalysis> partitionAnalysis : partitionAnalyses) {
            ((AbstractPartitionAnalysis)partitionAnalysis).analyzePartition();
        }
        for (PartialRegionAnalysis<PartitionsAnalysis> partitionAnalysis : partitionAnalyses) {
            ((AbstractPartitionAnalysis)partitionAnalysis).analyzePartition2();
        }
    }

    @Override
    protected @NonNull PartialRegionClassAnalysis<@NonNull PartitionsAnalysis> createClassAnalysis(@NonNull ClassDatum classDatum) {
        return new TraceClassPartitionAnalysis(this.transformationPartitioner.getTransformationAnalysis().getClassAnalysis(classDatum));
    }

    public @NonNull AbstractFallibilityAnalysis getFallibilityAnalysis(@NonNull Partition partition) {
        AbstractFallibilityAnalysis fallibilityAnalysis = this.partition2fallibilityAnalysis.get(partition);
        if (fallibilityAnalysis == null) {
            AbstractPartitionAnalysis<?> partitionAnalysis = this.getPartitionAnalysis(partition);
            fallibilityAnalysis = new SelfCyclicFallibilityAnalysis((MappingPartitionAnalysis)partitionAnalysis);
        }
        return fallibilityAnalysis;
    }

    public String getName() {
        return this.transformationPartitioner.getName();
    }

    public @NonNull AbstractPartitionAnalysis<?> getPartitionAnalysis(@NonNull Partition partition) {
        return (AbstractPartitionAnalysis)ClassUtil.nonNullState(this.partition2partitionAnalysis.get(partition));
    }

    public @NonNull RootPartitionAnalysis getRootPartitionAnalysis() {
        return (RootPartitionAnalysis)ClassUtil.nonNullState((Object)this.rootPartitionAnalysis);
    }

    public @NonNull AbstractTransformationAnalysis getTransformationAnalysis() {
        return this.transformationPartitioner.getTransformationAnalysis();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void setLoadingRegionAnalysis(@NonNull LoadingPartitionAnalysis loadingPartitionAnalysis) {
        for (ClassDatum classDatum : this.classDatum2classAnalysis.keySet()) {
            TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum);
            if (!this.scheduleManager.isInput((Element)typedModel)) continue;
            @NonNull PartialRegionClassAnalysis classAnalysis = (PartialRegionClassAnalysis)this.classDatum2classAnalysis.get(classDatum);
            assert (classAnalysis != null);
            Iterable<@NonNull PartialRegionAnalysis<@NonNull PRA>> producers = classAnalysis.getCompatibleProducers();
            if (!Iterables.isEmpty(producers)) continue;
            classAnalysis.addProducer(loadingPartitionAnalysis);
        }
        this.partition2partitionAnalysis.put((Partition)loadingPartitionAnalysis.getPartition(), loadingPartitionAnalysis);
    }

    public void setRootPartitionAnalysis(@NonNull RootPartitionAnalysis rootPartitionAnalysis) {
        this.rootPartitionAnalysis = rootPartitionAnalysis;
        this.partition2partitionAnalysis.put((Partition)rootPartitionAnalysis.getPartition(), rootPartitionAnalysis);
    }
}

