/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.AssociationStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.AttributeStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.ClassStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.ElementStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.EvaluationElement;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.MappingStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.TransformationStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.util.AbstractExtendingEvaluationStatusVisitor;

public class EvaluationStatus2StringVisitor
extends AbstractExtendingEvaluationStatusVisitor<String, StringBuilder> {
    protected static @NonNull String NULL_PLACEHOLDER = "\"<null>\"";
    private int indentDepth = 0;
    protected String prefix = "";
    private Map<ClassStatus, String> classId = new HashMap<ClassStatus, String>();
    private Map<MappingStatus, String> mappingId = new HashMap<MappingStatus, String>();

    public static String toString(@NonNull EvaluationElement evaluationElement) {
        try {
            StringBuilder s = new StringBuilder();
            EvaluationStatus2StringVisitor v = new EvaluationStatus2StringVisitor(s);
            evaluationElement.accept(v);
            return s.toString();
        }
        catch (Throwable e) {
            return e.toString();
        }
    }

    public EvaluationStatus2StringVisitor(@NonNull StringBuilder context) {
        super(context);
    }

    protected void append(String string) {
        if (string != null) {
            ((StringBuilder)this.context).append(string);
        } else {
            ((StringBuilder)this.context).append(NULL_PLACEHOLDER);
        }
    }

    protected void appendClassId(@NonNull ClassStatus object) {
        String id = this.classId.get(object);
        if (id == null) {
            id = String.valueOf(object.getType().getName()) + ":" + (this.classId.size() + 1);
            this.classId.put(object, id);
        }
        this.append(id);
    }

    protected void appendMappingId(MappingStatus object) {
        String id = this.mappingId.get(object);
        if (id == null) {
            id = String.valueOf(object.getReferredMappingCall().getReferredMapping().getName()) + ":" + (this.mappingId.size() + 1);
            this.mappingId.put(object, id);
        }
        this.append(id);
    }

    protected void popIndentation() {
        --this.indentDepth;
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < this.indentDepth) {
            s.append("  ");
            ++i;
        }
        this.prefix = s.toString();
    }

    protected void pushIndentation() {
        ++this.indentDepth;
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < this.indentDepth) {
            s.append("  ");
            ++i;
        }
        this.prefix = s.toString();
    }

    @Override
    public String visiting(@NonNull EvaluationElement visitable) {
        this.append(this.prefix);
        this.append(visitable.getClass().getName());
        return null;
    }

    @Override
    public @Nullable String visitAssociationStatus(@NonNull AssociationStatus object) {
        this.append(this.prefix);
        this.append(object.getForwardEReference().getName());
        this.append("-");
        this.append(object.getForwardEReference().getEOpposite().getName());
        for (MappingStatus source : object.getSources()) {
            this.append(" <<");
            this.appendMappingId(source);
        }
        for (MappingStatus target : object.getTargets()) {
            this.append(" >>");
            this.appendMappingId(target);
        }
        this.append("\n");
        return null;
    }

    @Override
    public @Nullable String visitAttributeStatus(@NonNull AttributeStatus object) {
        this.append(this.prefix);
        this.append(object.getEFeature().getName());
        for (MappingStatus source : object.getSources()) {
            this.append(" <<");
            this.appendMappingId(source);
        }
        for (MappingStatus target : object.getTargets()) {
            this.append(" >>");
            this.appendMappingId(target);
        }
        this.append("\n");
        return null;
    }

    @Override
    public @Nullable String visitClassStatus(@NonNull ClassStatus object) {
        this.append(this.prefix);
        this.appendClassId(object);
        this.append(" ");
        this.append(NameUtil.simpleNameFor((Object)object.getEObject()).replace(" ", "_"));
        for (MappingStatus source : object.getSources()) {
            this.append(" <<");
            this.appendMappingId(source);
        }
        for (MappingStatus target : object.getTargets()) {
            this.append(" >>");
            this.appendMappingId(target);
        }
        this.append("\n");
        this.pushIndentation();
        for (AttributeStatus attributeStatus : object.getOwnedAttributeStatuses()) {
            attributeStatus.accept(this);
        }
        this.popIndentation();
        return null;
    }

    @Override
    public @Nullable String visitMappingStatus(@NonNull MappingStatus object) {
        ClassStatus classStatus;
        AttributeStatus attributeStatus;
        ClassStatus classStatus2;
        this.append(this.prefix);
        this.appendMappingId(object);
        this.append("\n");
        this.pushIndentation();
        this.append(this.prefix);
        for (ElementStatus inputStatus : object.getInputs()) {
            this.append(" >>");
            if (inputStatus instanceof ClassStatus) {
                classStatus2 = (ClassStatus)inputStatus;
                this.appendClassId(classStatus2);
                continue;
            }
            if (!(inputStatus instanceof AttributeStatus)) continue;
            attributeStatus = (AttributeStatus)inputStatus;
            classStatus = attributeStatus.getOwningClassStatus();
            this.appendClassId(classStatus);
            this.append(":");
            this.append(attributeStatus.getEFeature().getName());
        }
        this.append("\n");
        this.append(this.prefix);
        for (ElementStatus outputStatus : object.getOutputs()) {
            this.append(" <<");
            if (outputStatus instanceof ClassStatus) {
                classStatus2 = (ClassStatus)outputStatus;
                this.appendClassId(classStatus2);
                continue;
            }
            if (!(outputStatus instanceof AttributeStatus)) continue;
            attributeStatus = (AttributeStatus)outputStatus;
            classStatus = attributeStatus.getOwningClassStatus();
            this.appendClassId(classStatus);
            this.append(":");
            this.append(attributeStatus.getEFeature().getName());
        }
        this.append("\n");
        this.popIndentation();
        return null;
    }

    @Override
    public @Nullable String visitTransformationStatus(@NonNull TransformationStatus object) {
        this.append("Class Statuses\n");
        this.pushIndentation();
        for (ClassStatus classStatus : object.getOwnedClassStatuses()) {
            classStatus.accept(this);
        }
        this.popIndentation();
        this.append("Mapping Statuses\n");
        this.pushIndentation();
        for (MappingStatus mappingStatus : object.getOwnedMappingStatuses()) {
            mappingStatus.accept(this);
        }
        this.popIndentation();
        this.append("\n");
        return null;
    }
}

