/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.LiteralExp;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.util.AbstractExtendingQVTbaseVisitor;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtbase.utilities.StandardLibraryHelper;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreHelper;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.OperationRegion;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.impl.RuleRegionImpl;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class ExpressionAnalyzer
extends AbstractExtendingQVTbaseVisitor<Node, RuleAnalysis> {
    private static final @NonNull String @NonNull [] ifArgNames = new String[]{"\u00abcondition\u00bb", "\u00abthen\u00bb", "\u00abelse\u00bb"};
    private static final @NonNull String @NonNull [] mapArgNames = new String[]{"\u00abkey\u00bb", "\u00abvalue\u00bb"};
    private static final @NonNull String @NonNull [] nullArgNames = new String[]{"\u00abequals\u00bb"};
    private static final @NonNull String @NonNull [] rangeArgNames = new String[]{"\u00abfirst\u00bb", "\u00ablast\u00bb"};
    private static final @NonNull String @NonNull [] srcArgNames = new String[]{"\u00absource\u00bb", "\u00abarg\u00bb"};
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull EnvironmentFactory environmentFactory;
    protected final @NonNull QVTcoreHelper helper;
    protected final @NonNull StandardLibraryHelper standardLibraryHelper;
    private ExpressionAnalyzer conditionalExpressionAnalyzer = null;
    private @Nullable Map<@NonNull OCLExpression, @NonNull Node> expression2knownNode;

    protected ExpressionAnalyzer(@NonNull RuleAnalysis context) {
        super((Object)context);
        this.scheduleManager = context.getScheduleManager();
        this.environmentFactory = this.scheduleManager.getEnvironmentFactory();
        this.helper = new QVTcoreHelper(this.environmentFactory);
        this.standardLibraryHelper = new StandardLibraryHelper(this.environmentFactory.getStandardLibrary());
    }

    public @NonNull Node analyze(Visitable element) {
        Node accept = (Node)element.accept((Visitor)this);
        assert (accept != null);
        return accept;
    }

    private @Nullable Node analyzeOperationCallExp_equals(@NonNull OperationCallExp operationCallExp) {
        Node targetNode;
        Node sourceNode;
        OCLExpression asSource = QVTcoreUtil.getOwnedSource((CallExp)operationCallExp);
        OCLExpression asTarget = QVTcoreUtil.getOwnedArgument((OperationCallExp)operationCallExp, (int)0);
        if (asSource instanceof VariableExp) {
            Variable referredVariable = QVTcoreUtil.getReferredVariable((VariableExp)((VariableExp)asSource));
            RuleRegion ruleRegion = (RuleRegion)((RuleAnalysis)((Object)this.context)).getRegion();
            sourceNode = ruleRegion.getNode((TypedElement)referredVariable);
            if (sourceNode != null) {
                Map<@NonNull OCLExpression, @NonNull Node> expression2knownNode2 = this.expression2knownNode;
                if (expression2knownNode2 == null) {
                    this.expression2knownNode = expression2knownNode2 = new HashMap<OCLExpression, Node>();
                }
                expression2knownNode2.put(asTarget, sourceNode);
            }
            if ((targetNode = this.analyze((Visitable)asTarget)) == sourceNode) {
                return null;
            }
            sourceNode = this.analyze((Visitable)asSource);
        } else if (asTarget instanceof VariableExp) {
            Variable referredVariable = QVTcoreUtil.getReferredVariable((VariableExp)((VariableExp)asTarget));
            RuleRegionImpl ruleRegion = (RuleRegionImpl)((RuleAnalysis)((Object)this.context)).getRegion();
            targetNode = ruleRegion.getNode((TypedElement)referredVariable);
            if (targetNode != null) {
                Map<@NonNull OCLExpression, @NonNull Node> expression2knownNode2 = this.expression2knownNode;
                if (expression2knownNode2 == null) {
                    this.expression2knownNode = expression2knownNode2 = new HashMap<OCLExpression, Node>();
                }
                expression2knownNode2.put(asSource, targetNode);
            }
            if (targetNode == (sourceNode = this.analyze((Visitable)asSource))) {
                return null;
            }
            targetNode = this.analyze((Visitable)asTarget);
        } else if (asSource instanceof NavigationCallExp) {
            targetNode = this.analyze((Visitable)asTarget);
            if (!targetNode.isDataType()) {
                Map<@NonNull OCLExpression, @NonNull Node> expression2knownNode2 = this.expression2knownNode;
                if (expression2knownNode2 == null) {
                    this.expression2knownNode = expression2knownNode2 = new HashMap<OCLExpression, Node>();
                }
                expression2knownNode2.put(asSource, targetNode);
            }
            if (targetNode == (sourceNode = this.analyze((Visitable)asSource))) {
                return null;
            }
        } else {
            sourceNode = this.analyze((Visitable)asSource);
            if (!sourceNode.isDataType()) {
                Map<@NonNull OCLExpression, @NonNull Node> expression2knownNode2 = this.expression2knownNode;
                if (expression2knownNode2 == null) {
                    this.expression2knownNode = expression2knownNode2 = new HashMap<OCLExpression, Node>();
                }
                expression2knownNode2.put(asTarget, sourceNode);
            }
            if ((targetNode = this.analyze((Visitable)asTarget)) == sourceNode) {
                return null;
            }
        }
        this.createExpressionEdge(targetNode, "\u00abequals\u00bb", sourceNode);
        return null;
    }

    private @Nullable Node analyzeOperationCallExp_includes(@NonNull Node sourceNode, @NonNull OperationCallExp operationCallExp) {
        Node targetNode = this.analyze((Visitable)operationCallExp.getOwnedArguments().get(0));
        String name = operationCallExp.getReferredOperation().getName();
        this.createPredicateEdge(sourceNode, "\u00ab" + name + "\u00bb", targetNode);
        if (sourceNode.isDataType()) {
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)sourceNode)) {
                NavigationEdge navigationEdge;
                Property property;
                Property oppositeProperty;
                if (!(edge instanceof NavigationEdge) || (oppositeProperty = (property = (navigationEdge = (NavigationEdge)edge).getProperty()).getOpposite()) == null || oppositeProperty.isIsMany()) continue;
                this.createNavigationEdge(targetNode, oppositeProperty, QVTscheduleUtil.getSourceNode((Edge)navigationEdge), false);
            }
        }
        return null;
    }

    private @NonNull Node analyzeOperationCallExp_oclAsType(@NonNull Node sourceNode, @NonNull OperationCallExp operationCallExp) {
        Type castType = QVTcoreUtil.getType((TypedElement)operationCallExp);
        CompleteClass requiredClass = this.environmentFactory.getCompleteModel().getCompleteClass(castType);
        CompleteClass predicatedClass = sourceNode.getCompleteClass();
        if (predicatedClass.conformsTo(requiredClass)) {
            sourceNode.addTypedElement((TypedElement)operationCallExp);
            return sourceNode;
        }
        for (NavigableEdge castEdge : sourceNode.getCastEdges()) {
            Node targetNode = castEdge.getEdgeTarget();
            predicatedClass = targetNode.getCompleteClass();
            if (!predicatedClass.conformsTo(requiredClass)) continue;
            targetNode.addTypedElement((TypedElement)operationCallExp);
            return targetNode;
        }
        Property castProperty = this.scheduleManager.getCastProperty(castType);
        Edge castEdge = sourceNode.getPredicateEdge(castProperty);
        if (castEdge != null) {
            Node castNode = castEdge.getEdgeTarget();
            castNode.addTypedElement((TypedElement)operationCallExp);
            return castNode;
        }
        String name = "a" + castType.getName();
        Node castNode = this.createStepNode(name, (CallExp)operationCallExp, sourceNode);
        castEdge = this.createCastEdge(sourceNode, castProperty, castNode);
        OCLExpression argument = (OCLExpression)operationCallExp.getOwnedArguments().get(0);
        if (!(argument instanceof TypeExp)) {
            Node argumentNode = this.analyze((Visitable)argument);
            this.createExpressionEdge(argumentNode, "\u00abarg\u00bb", castNode);
        }
        return castNode;
    }

    private @NonNull Node analyzeOperationCallExp_oclIsKindOf(@NonNull Node sourceNode, @NonNull OperationCallExp operationCallExp) {
        OCLExpression argument = (OCLExpression)operationCallExp.getOwnedArguments().get(0);
        Node operationNode = null;
        if (argument instanceof TypeExp) {
            String name = String.valueOf(operationCallExp.getReferredOperation().getName()) + "\\n" + ((TypeExp)argument).getReferredType().toString();
            operationNode = this.findOperationNode(name, sourceNode);
            if (operationNode == null) {
                operationNode = this.createConnectedOperationNode(name, nullArgNames, (TypedElement)operationCallExp, sourceNode);
            }
        } else {
            String name = QVTcoreUtil.getName((NamedElement)QVTcoreUtil.getReferredOperation((CallExp)operationCallExp));
            Node argumentNode = this.analyze((Visitable)argument);
            operationNode = this.findOperationNode(name, sourceNode, argumentNode);
            if (operationNode == null) {
                operationNode = this.createConnectedOperationNode(name, srcArgNames, (TypedElement)operationCallExp, sourceNode, argumentNode);
            }
        }
        return operationNode;
    }

    private @NonNull Node analyzeOperationCallExp_oclContainer(@NonNull Node sourceNode, @NonNull OperationCallExp operationCallExp) {
        Property oclContainerProperty = this.standardLibraryHelper.getOclContainerProperty();
        Edge oclContainerEdge = sourceNode.getPredicateEdge(oclContainerProperty);
        if (oclContainerEdge != null) {
            return oclContainerEdge.getEdgeTarget();
        }
        String name = QVTcoreUtil.getName((NamedElement)QVTcoreUtil.getReferredOperation((CallExp)operationCallExp));
        Node oclContainerNode = this.createStepNode(name, (CallExp)operationCallExp, sourceNode);
        oclContainerEdge = this.createNavigationEdge(sourceNode, oclContainerProperty, oclContainerNode, false);
        return oclContainerNode;
    }

    protected @NonNull Node createConnectedOperationNode(@NonNull String name, @NonNull TypedElement typedElement, Node ... sourceAndArgumentNodes) {
        Node reusedNode = this.findOperationNode(name, sourceAndArgumentNodes);
        if (reusedNode != null) {
            reusedNode.addTypedElement(typedElement);
            return reusedNode;
        }
        Node operationNode = this.createOperationNode(name, typedElement, sourceAndArgumentNodes);
        int i = 0;
        while (i < sourceAndArgumentNodes.length) {
            this.createExpressionEdge((Node)ClassUtil.nonNullState((Object)sourceAndArgumentNodes[i]), "\u00abarg" + i + "\u00bb", operationNode);
            ++i;
        }
        return operationNode;
    }

    protected @NonNull Node createConnectedOperationNode(@NonNull String name, @NonNull String @NonNull [] argNames, @NonNull TypedElement typedElement, Node ... sourceAndArgumentNodes) {
        assert (argNames.length == sourceAndArgumentNodes.length);
        Node reusedNode = this.findOperationNode(name, sourceAndArgumentNodes);
        if (reusedNode != null) {
            reusedNode.addTypedElement(typedElement);
            return reusedNode;
        }
        boolean isMatched = QVTscheduleUtil.isMatched((TypedElement)typedElement);
        ExpressionAnalyzer nestedAnalyzer = isMatched ? this : this.getConditionalExpressionAnalyzer();
        String nodeName = CompilerUtil.recoverVariableName((NamedElement)typedElement);
        if (nodeName == null) {
            nodeName = name;
        }
        Node operationNode = nestedAnalyzer.createOperationNode(nodeName, typedElement, sourceAndArgumentNodes);
        int i = 0;
        while (i < sourceAndArgumentNodes.length) {
            nestedAnalyzer.createExpressionEdge((Node)ClassUtil.nonNullState((Object)sourceAndArgumentNodes[i]), argNames[i], operationNode);
            ++i;
        }
        return operationNode;
    }

    public @NonNull NavigableEdge createCastEdge(@NonNull Node sourceNode, @NonNull Property castProperty, @NonNull Node castNode) {
        return ((RuleAnalysis)((Object)this.context)).createCastEdge(sourceNode, castProperty, castNode);
    }

    protected abstract @NonNull ExpressionAnalyzer createConditionalExpressionAnalyzer();

    protected @NonNull Node createDataTypeNode(@NonNull String name, @NonNull Node sourceNode, @NonNull NavigationCallExp navigationCallExp) {
        return ((RuleAnalysis)((Object)this.context)).createDataTypeNode(name, sourceNode, navigationCallExp);
    }

    protected @NonNull Node createDependencyNode(@NonNull String name, @NonNull ClassDatum classDatum) {
        return ((RuleAnalysis)((Object)this.context)).createDependencyNode(name, classDatum);
    }

    protected @NonNull Node createErrorNode(@NonNull String name, @NonNull ClassDatum classDatum) {
        return ((RuleAnalysis)((Object)this.context)).createErrorNode(name, classDatum);
    }

    protected @NonNull Edge createExpressionEdge(@NonNull Node sourceNode, @NonNull String name, @NonNull Node targetNode) {
        return ((RuleAnalysis)((Object)this.context)).createExpressionEdge(sourceNode, name, targetNode);
    }

    protected @NonNull Edge createIteratedEdge(@NonNull Node sourceNode, @NonNull String name, @NonNull Node targetNode) {
        return ((RuleAnalysis)((Object)this.context)).createIteratedEdge(sourceNode, name, targetNode);
    }

    protected @NonNull Node createIteratorNode(@NonNull Variable iterator, @NonNull Node sourceNode) {
        return ((RuleAnalysis)((Object)this.context)).createIteratorNode(iterator, sourceNode);
    }

    protected @NonNull Node createLetNode(@NonNull Variable letVariable, @NonNull Node inNode) {
        return ((RuleAnalysis)((Object)this.context)).createLetVariableNode(letVariable, inNode);
    }

    protected @NonNull Node createNavigableDataTypeNode(@NonNull Node targetNode, @NonNull NavigationAssignment navigationAssignment) {
        return ((RuleAnalysis)((Object)this.context)).createDataTypeNode(targetNode, navigationAssignment);
    }

    protected @NonNull Node createNavigableDataTypeNode(@NonNull Node sourceNode, @NonNull Property source2targetProperty) {
        assert (sourceNode.isMatched());
        return ((RuleAnalysis)((Object)this.context)).createDataTypeNode(sourceNode, source2targetProperty);
    }

    protected @NonNull NavigableEdge createNavigableNavigationEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode) {
        return ((RuleAnalysis)((Object)this.context)).createNavigationEdge(sourceNode, source2targetProperty, targetNode, false);
    }

    protected @NonNull NavigableEdge createNavigationEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable Boolean isPartial) {
        return ((RuleAnalysis)((Object)this.context)).createNavigationEdge(sourceNode, source2targetProperty, targetNode, isPartial);
    }

    protected @NonNull NavigableEdge createNavigationOrRealizedEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable NavigationAssignment navigationAssignment) {
        NavigableEdge navigationEdge = sourceNode.getNavigationEdge(source2targetProperty);
        assert (navigationEdge == null);
        Boolean isPartial = navigationAssignment != null ? Boolean.valueOf(navigationAssignment.isIsPartial()) : null;
        navigationEdge = navigationAssignment != null || ((RuleAnalysis)((Object)this.context)).isPropertyAssignment(sourceNode, source2targetProperty) ? this.createRealizedNavigationEdge(sourceNode, source2targetProperty, targetNode, isPartial) : this.createNavigationEdge(sourceNode, source2targetProperty, targetNode, isPartial);
        return navigationEdge;
    }

    protected @NonNull Node createNullNode(@NonNull TypedElement typedElement) {
        return ((RuleAnalysis)((Object)this.context)).createNullNode(this.isUnconditional(), typedElement);
    }

    protected @NonNull Node createOperationNode(@NonNull String name, @NonNull TypedElement typedElement, Node ... argNodes) {
        return ((RuleAnalysis)((Object)this.context)).createOperationNode(this.isUnconditional(), name, typedElement, argNodes);
    }

    protected @NonNull Edge createPredicateEdge(@NonNull Node sourceNode, @Nullable String name, @NonNull Node targetNode) {
        return ((RuleAnalysis)((Object)this.context)).createPredicateEdge(sourceNode, name, targetNode);
    }

    protected @NonNull Node createPredicatedClassNode(@NonNull Node parentNode, @NonNull NavigationAssignment navigationAssignment) {
        return ((RuleAnalysis)((Object)this.context)).createDependencyClassNode(parentNode, navigationAssignment);
    }

    protected @NonNull Node createRealizedDataTypeNode(@NonNull Node sourceNode, @NonNull Property source2targetProperty) {
        return ((RuleAnalysis)((Object)this.context)).createRealizedDataTypeNode(sourceNode, source2targetProperty);
    }

    protected @NonNull Edge createRealizedExpressionEdge(@NonNull Node sourceNode, @Nullable String name, @NonNull Node targetNode) {
        return ((RuleAnalysis)((Object)this.context)).createRealizedExpressionEdge(sourceNode, name, targetNode);
    }

    protected @NonNull NavigableEdge createRealizedNavigationEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable Boolean isPartial) {
        return ((RuleAnalysis)((Object)this.context)).createRealizedNavigationEdge(sourceNode, source2targetProperty, targetNode, isPartial);
    }

    protected @NonNull Node createStepNode(@NonNull String name, @NonNull CallExp callExp, @NonNull Node sourceNode) {
        return ((RuleAnalysis)((Object)this.context)).createStepNode(name, callExp, sourceNode, sourceNode.isMatched() && QVTscheduleUtil.isMatched((TypedElement)callExp));
    }

    protected @Nullable Node findOperationNode(@NonNull String name, Node ... sourceAndArgumentNodes) {
        if (sourceAndArgumentNodes.length > 0) {
            for (Edge searchEdge : sourceAndArgumentNodes[0].getComputationEdges()) {
                Iterable reusedEdges;
                int iSize;
                Node reusedNode = searchEdge.getEdgeTarget();
                if (!reusedNode.isOperation() || !name.equals(reusedNode.getName()) || (iSize = Iterables.size((Iterable)(reusedEdges = reusedNode.getArgumentEdges()))) != sourceAndArgumentNodes.length) continue;
                int i = 0;
                for (Edge reusedEdge : reusedEdges) {
                    Node reusedArgumentNode = reusedEdge.getEdgeSource();
                    if (reusedArgumentNode != sourceAndArgumentNodes[i]) break;
                    ++i;
                }
                if (i != iSize) continue;
                return reusedNode;
            }
        }
        return null;
    }

    private @NonNull ExpressionAnalyzer getConditionalExpressionAnalyzer() {
        ExpressionAnalyzer conditionalExpressionAnalyzer2 = this.conditionalExpressionAnalyzer;
        if (conditionalExpressionAnalyzer2 == null) {
            this.conditionalExpressionAnalyzer = conditionalExpressionAnalyzer2 = this.createConditionalExpressionAnalyzer();
        }
        return conditionalExpressionAnalyzer2;
    }

    protected @NonNull NavigableEdge getNavigationEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable NavigationAssignment navigationAssignment) {
        if (targetNode.isExplicitNull()) {
            return this.getNavigationEdgeToNull(sourceNode, source2targetProperty, targetNode, navigationAssignment);
        }
        if (targetNode.isClass() && !targetNode.isOperation()) {
            return this.getNavigationEdgeToClass(sourceNode, source2targetProperty, targetNode, navigationAssignment);
        }
        if (targetNode.isDataType()) {
            return this.getNavigationEdgeToDataType(sourceNode, source2targetProperty, targetNode, navigationAssignment);
        }
        return this.getNavigationEdgeToExpression(sourceNode, source2targetProperty, targetNode, navigationAssignment);
    }

    protected @NonNull NavigableEdge getNavigationEdgeToDataType(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable NavigationAssignment navigationAssignment) {
        assert (targetNode.isDataType());
        Type type = source2targetProperty.getType();
        assert (type instanceof DataType);
        NavigableEdge navigationEdge = sourceNode.getNavigationEdge(source2targetProperty);
        if (navigationEdge == null) {
            if (!targetNode.isOperation()) {
                navigationEdge = this.createNavigationOrRealizedEdge(sourceNode, source2targetProperty, targetNode, navigationAssignment);
            } else {
                CompleteClass propertyCompleteClass = this.scheduleManager.getClassDatum((TypedElement)source2targetProperty).getCompleteClass();
                CompleteClass valueCompleteClass = targetNode.getCompleteClass();
                if (valueCompleteClass == propertyCompleteClass) {
                    navigationEdge = this.createNavigationOrRealizedEdge(sourceNode, source2targetProperty, targetNode, navigationAssignment);
                } else if (navigationAssignment == null) {
                    Node stepNode = this.createNavigableDataTypeNode(sourceNode, source2targetProperty);
                    navigationEdge = this.createNavigationOrRealizedEdge(sourceNode, source2targetProperty, stepNode, navigationAssignment);
                    ((RuleAnalysis)((Object)this.context)).createEqualsEdge(targetNode, stepNode);
                } else {
                    navigationEdge = this.createNavigationOrRealizedEdge(sourceNode, source2targetProperty, targetNode, navigationAssignment);
                }
            }
        } else if (targetNode != navigationEdge.getEdgeTarget()) {
            ((RuleAnalysis)((Object)this.context)).createEqualsEdge(targetNode, navigationEdge.getEdgeTarget());
        }
        return navigationEdge;
    }

    protected @NonNull NavigableEdge getNavigationEdgeToClass(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable NavigationAssignment navigationAssignment) {
        assert (targetNode.isClass());
        NavigableEdge navigationEdge = sourceNode.getNavigationEdge(source2targetProperty);
        if (navigationEdge != null) {
            Node target = navigationEdge.getEdgeTarget();
            if (target != targetNode) {
                ((RuleAnalysis)((Object)this.context)).createEqualsEdge(targetNode, target);
            }
        } else {
            navigationEdge = this.createNavigationOrRealizedEdge(sourceNode, source2targetProperty, targetNode, navigationAssignment);
        }
        return navigationEdge;
    }

    protected @NonNull NavigableEdge getNavigationEdgeToExpression(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable NavigationAssignment navigationAssignment) {
        assert (targetNode.isExpression());
        if (navigationAssignment != null) {
            NavigableEdge navigationEdge = sourceNode.getNavigationEdge(source2targetProperty);
            assert (navigationEdge == null);
            navigationEdge = this.createNavigationOrRealizedEdge(sourceNode, source2targetProperty, targetNode, navigationAssignment);
            return navigationEdge;
        }
        NavigableEdge navigationEdge = sourceNode.getNavigationEdge(source2targetProperty);
        if (navigationEdge != null) {
            Node valueNode = navigationEdge.getEdgeTarget();
            assert (valueNode.isRealized());
            Type type = source2targetProperty.getType();
            Edge equalsEdge = ((RuleAnalysis)((Object)this.context)).createEqualsEdge(targetNode, valueNode);
            if (type instanceof DataType) assert (equalsEdge.isRealized());
            return navigationEdge;
        }
        navigationEdge = this.createNavigationOrRealizedEdge(sourceNode, source2targetProperty, targetNode, navigationAssignment);
        return navigationEdge;
    }

    protected @NonNull NavigableEdge getNavigationEdgeToNull(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable NavigationAssignment navigationAssignment) {
        assert (targetNode.isExplicitNull());
        return this.createNavigationOrRealizedEdge(sourceNode, source2targetProperty, targetNode, navigationAssignment);
    }

    private void instantiate(@NonNull Node instantiatedNode, @NonNull Node referenceNode) {
        for (NavigableEdge referenceEdge : referenceNode.getNavigationEdges()) {
            if (referenceEdge.isSecondary()) continue;
            Node referenceTargetNode = referenceEdge.getEdgeTarget();
            String name = QVTscheduleUtil.getName((Nameable)referenceTargetNode);
            ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)referenceTargetNode);
            Node instantiatedTargetNode = this.createDependencyNode(name, classDatum);
            this.createNavigationEdge(instantiatedNode, QVTscheduleUtil.getProperty((NavigableEdge)referenceEdge), instantiatedTargetNode, false);
            this.instantiate(instantiatedTargetNode, referenceTargetNode);
        }
    }

    protected boolean isUnconditional() {
        return true;
    }

    public @NonNull Node visiting(@NonNull Visitable visitable) {
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }

    public @NonNull Node visitCollectionLiteralExp(@NonNull CollectionLiteralExp collectionLiteralExp) {
        List ownedParts = collectionLiteralExp.getOwnedParts();
        int iSize = ownedParts.size();
        @NonNull Node[] partNodes = new Node[iSize];
        int i = 0;
        while (i < iSize) {
            partNodes[i] = this.analyze((Visitable)ownedParts.get(i));
            ++i;
        }
        Node operationNode = this.createConnectedOperationNode((String)ClassUtil.nonNullState((Object)collectionLiteralExp.getKind().toString()), (TypedElement)collectionLiteralExp, partNodes);
        return operationNode;
    }

    public @NonNull Node visitCollectionItem(@NonNull CollectionItem collectionItem) {
        return this.analyze((Visitable)collectionItem.getOwnedItem());
    }

    public @NonNull Node visitCollectionRange(@NonNull CollectionRange collectionRange) {
        Node firstNode = this.analyze((Visitable)collectionRange.getOwnedFirst());
        Node lastNode = this.analyze((Visitable)collectionRange.getOwnedLast());
        Node operationNode = this.createConnectedOperationNode("..", rangeArgNames, (TypedElement)collectionRange, firstNode, lastNode);
        return operationNode;
    }

    public @NonNull Node visitElement(@NonNull Element element) {
        Class oclInvalidType = this.scheduleManager.getStandardLibrary().getOclInvalidType();
        ClassDatum classDatum = this.scheduleManager.getClassDatum(this.scheduleManager.getDomainUsageAnalysis().getPrimitiveTypeModel(), oclInvalidType);
        Node errorNode = this.createErrorNode("\u00aberror\u00bb", classDatum);
        for (EObject eObject : element.eContents()) {
            Node node = this.analyze((Visitable)((Element)eObject));
            this.createExpressionEdge(node, "?", errorNode);
        }
        return errorNode;
    }

    public @NonNull Node visitIfExp(@NonNull IfExp ifExp) {
        ExpressionAnalyzer conditionalExpressionAnalyzer = this.getConditionalExpressionAnalyzer();
        Node conditionNode = this.analyze((Visitable)ifExp.getOwnedCondition());
        Node thenNode = conditionalExpressionAnalyzer.analyze((Visitable)ifExp.getOwnedThen());
        Node elseNode = conditionalExpressionAnalyzer.analyze((Visitable)ifExp.getOwnedElse());
        Node ifNode = this.createConnectedOperationNode("if", ifArgNames, (TypedElement)ifExp, conditionNode, thenNode, elseNode);
        return ifNode;
    }

    public @NonNull Node visitLetExp(@NonNull LetExp letExp) {
        ClassDatum classDatum;
        CompleteClass requiredClass;
        Variable ownedVariable = letExp.getOwnedVariable();
        Node initNode = this.analyze((Visitable)ownedVariable.getOwnedInit());
        assert (initNode != null);
        Type type = QVTcoreUtil.getType((TypedElement)ownedVariable);
        CompleteClass actualClass = initNode.getCompleteClass();
        if (actualClass.conformsTo(requiredClass = QVTscheduleUtil.getCompleteClass((ClassDatum)(classDatum = this.scheduleManager.getClassDatum((TypedElement)ownedVariable))))) {
            ((RuleRegion)((RuleAnalysis)((Object)this.context)).getRegion()).addVariableNode((VariableDeclaration)ownedVariable, initNode);
            initNode.addTypedElement((TypedElement)ownedVariable);
        } else {
            Node varNode = this.createLetNode(ownedVariable, initNode);
            Property castProperty = this.scheduleManager.getCastProperty(type);
            this.createNavigationEdge(initNode, castProperty, varNode, false);
        }
        return this.analyze((Visitable)letExp.getOwnedIn());
    }

    public @NonNull Node visitLiteralExp(@NonNull LiteralExp literalExp) {
        Node operationNode = this.createOperationNode((String)ClassUtil.nonNullState((Object)literalExp.toString()), (TypedElement)literalExp, new Node[0]);
        return operationNode;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Node visitLoopExp(@NonNull LoopExp loopExp) {
        Node bodyNode;
        assert (!loopExp.isIsSafe());
        Node sourceNode = this.analyze((Visitable)loopExp.getOwnedSource());
        @NonNull List ownedIterators = ClassUtil.nullFree((List)loopExp.getOwnedIterators());
        @NonNull Node[] argNodes = new Node[1 + ownedIterators.size() + (loopExp instanceof IterateExp ? 1 : 0)];
        int i = 1;
        for (Variable iterator : ownedIterators) {
            Node iteratorNode = this.createIteratorNode(iterator, sourceNode);
            Type iteratorType = QVTcoreUtil.getType((TypedElement)iterator);
            this.createIteratedEdge(sourceNode, "\u00abiterator\u00bb", iteratorNode);
            argNodes[i++] = iteratorNode;
        }
        if (loopExp instanceof IterateExp) {
            Variable accumulator = QVTcoreUtil.getOwnedResult((IterateExp)((IterateExp)loopExp));
            Node iteratorNode = this.createIteratorNode(accumulator, sourceNode);
            Type iteratorType = QVTcoreUtil.getType((TypedElement)accumulator);
            this.createIteratedEdge(sourceNode, "\u00abiterator\u00bb", iteratorNode);
            argNodes[i++] = iteratorNode;
        }
        argNodes[0] = bodyNode = this.getConditionalExpressionAnalyzer().analyze((Visitable)loopExp.getOwnedBody());
        String iterationName = "\u00ab" + loopExp.getReferredIteration().getName() + "\u00bb";
        Node accumulateNode = this.createOperationNode(iterationName, (TypedElement)loopExp, argNodes);
        this.createExpressionEdge(sourceNode, "\u00absource\u00bb", accumulateNode);
        this.createExpressionEdge(bodyNode, "\u00abbody\u00bb", accumulateNode);
        i = 1;
        for (Variable iterator : ownedIterators) {
            Node iteratorNode = argNodes[i++];
            this.createExpressionEdge(iteratorNode, "\u00ab" + iterator.getName() + "\u00bb", accumulateNode);
        }
        return accumulateNode;
    }

    public @NonNull Node visitMapLiteralExp(@NonNull MapLiteralExp mapLiteralExp) {
        List ownedParts = mapLiteralExp.getOwnedParts();
        int iSize = ownedParts.size();
        @NonNull Node[] partNodes = new Node[iSize];
        int i = 0;
        while (i < iSize) {
            partNodes[i] = this.analyze((Visitable)ownedParts.get(i));
            ++i;
        }
        Node operationNode = this.createConnectedOperationNode((String)ClassUtil.nonNullState((Object)mapLiteralExp.getName()), (TypedElement)mapLiteralExp, partNodes);
        return operationNode;
    }

    public @NonNull Node visitMapLiteralPart(@NonNull MapLiteralPart mapLiteralPart) {
        OCLExpression ownedValue = QVTcoreUtil.getOwnedValue((MapLiteralPart)mapLiteralPart);
        Node keyNode = this.analyze((Visitable)mapLiteralPart.getOwnedKey());
        Node valueNode = this.analyze((Visitable)ownedValue);
        Node operationNode = this.createConnectedOperationNode("Part", mapArgNames, (TypedElement)ownedValue, keyNode, valueNode);
        return operationNode;
    }

    public @NonNull Node visitNavigationCallExp(@NonNull NavigationCallExp navigationCallExp) {
        assert (!navigationCallExp.isIsSafe());
        Property referredProperty = PivotUtil.getReferredProperty((NavigationCallExp)navigationCallExp);
        OCLExpression ownedSource = QVTcoreUtil.getOwnedSource((CallExp)navigationCallExp);
        Node sourceNode = this.analyze((Visitable)ownedSource);
        if (sourceNode.isClass()) {
            Node targetNode;
            NavigableEdge navigationEdge;
            if (!referredProperty.isIsMany() && (navigationEdge = sourceNode.getNavigationEdge(referredProperty)) != null) {
                return navigationEdge.getEdgeTarget();
            }
            String name = CompilerUtil.recoverVariableName((NamedElement)navigationCallExp);
            if (name == null) {
                name = QVTcoreUtil.getName((NamedElement)referredProperty);
            }
            Type type = QVTcoreUtil.getType((TypedElement)referredProperty);
            Node node = targetNode = this.expression2knownNode != null ? this.expression2knownNode.get(navigationCallExp) : null;
            if (targetNode == null) {
                if (type instanceof DataType) {
                    targetNode = sourceNode.getNavigationTarget(referredProperty);
                    if (targetNode == null) {
                        targetNode = this.createDataTypeNode(name, sourceNode, navigationCallExp);
                    }
                } else {
                    targetNode = this.createStepNode(name, (CallExp)navigationCallExp, sourceNode);
                }
            }
            this.getNavigationEdge(sourceNode, referredProperty, targetNode, null);
            return targetNode;
        }
        return ((RuleAnalysis)((Object)this.context)).getUnknownNode((TypedElement)ownedSource);
    }

    public @NonNull Node visitNullLiteralExp(@NonNull NullLiteralExp nullLiteralExp) {
        return this.createNullNode((TypedElement)nullLiteralExp);
    }

    public @NonNull Node visitOCLExpression(@NonNull OCLExpression oclExpression) {
        return ((RuleAnalysis)((Object)this.context)).getUnknownNode((TypedElement)oclExpression);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable Node visitOperationCallExp(@NonNull OperationCallExp operationCallExp) {
        Type returnType;
        Node operationNode;
        boolean isMatched;
        if (this.isUnconditional() && !(isMatched = QVTscheduleUtil.isMatched((TypedElement)operationCallExp))) {
            return this.getConditionalExpressionAnalyzer().visitOperationCallExp(operationCallExp);
        }
        assert (!operationCallExp.isIsSafe());
        Operation referredOperation = operationCallExp.getReferredOperation();
        OCLExpression ownedSource = operationCallExp.getOwnedSource();
        if (ownedSource instanceof VariableExp) {
            Transformation transformation = QVTbaseUtil.getContainingTransformation((EObject)operationCallExp);
            Variable thisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)this.scheduleManager.getStandardLibrary(), (Transformation)transformation);
            if (((VariableExp)ownedSource).getReferredVariable() == thisVariable) {
                ownedSource = null;
            }
        }
        String operationName = (String)ClassUtil.nonNullState((Object)referredOperation.getName());
        if (ownedSource == null) {
            List ownedArguments = operationCallExp.getOwnedArguments();
            int iSize = ownedArguments.size();
            @NonNull Node[] argNodes = new Node[iSize];
            @NonNull String[] argNames = new String[iSize];
            int i = 0;
            while (i < iSize) {
                argNodes[i] = this.analyze((Visitable)ownedArguments.get(i));
                argNames[i] = "\u00ab" + ((Parameter)referredOperation.getOwnedParameters().get(i)).getName() + "\u00bb";
                ++i;
            }
            Node operationNode2 = this.createConnectedOperationNode(operationName, argNames, (TypedElement)operationCallExp, argNodes);
            return operationNode2;
        }
        OperationId operationId = referredOperation.getOperationId();
        if (operationCallExp.eContainer() instanceof Predicate && !(ownedSource.getType() instanceof DataType) && PivotUtil.isSameOperation((OperationId)operationId, (OperationId)this.standardLibraryHelper.getOclAnyEqualsId())) {
            return this.analyzeOperationCallExp_equals(operationCallExp);
        }
        Node sourceNode = this.analyze((Visitable)ownedSource);
        if (operationId == this.standardLibraryHelper.getOclAnyOclAsTypeId()) {
            return this.analyzeOperationCallExp_oclAsType(sourceNode, operationCallExp);
        }
        if (PivotUtil.isSameOperation((OperationId)operationId, (OperationId)this.standardLibraryHelper.getOclElementOclContainerId())) {
            return this.analyzeOperationCallExp_oclContainer(sourceNode, operationCallExp);
        }
        if (PivotUtil.isSameOperation((OperationId)operationId, (OperationId)this.standardLibraryHelper.getOclAnyOclIsKindOfId())) {
            return this.analyzeOperationCallExp_oclIsKindOf(sourceNode, operationCallExp);
        }
        if (operationCallExp.eContainer() instanceof Predicate && sourceNode.getCompleteClass().getPrimaryClass() instanceof CollectionType && "includes".equals(operationName)) {
            return this.analyzeOperationCallExp_includes(sourceNode, operationCallExp);
        }
        List ownedArguments = operationCallExp.getOwnedArguments();
        int iSize = ownedArguments.size();
        @NonNull Node[] argNodes = new Node[iSize + 1];
        @NonNull String[] argNames = new String[iSize + 1];
        argNodes[0] = sourceNode;
        argNames[0] = "\u00abself\u00bb";
        int i = 0;
        while (i < iSize) {
            argNodes[i + 1] = this.analyze((Visitable)ownedArguments.get(i));
            argNames[i + 1] = "\u00ab" + ((Parameter)referredOperation.getOwnedParameters().get(i)).getName() + "\u00bb";
            ++i;
        }
        if ("<>".equals(operationName)) {
            operationName.toString();
        }
        if ((operationNode = this.findOperationNode(operationName, argNodes)) == null) {
            operationNode = this.createOperationNode(operationName, (TypedElement)operationCallExp, argNodes);
            int i2 = 0;
            while (i2 <= iSize) {
                this.createExpressionEdge(argNodes[i2], argNames[i2], operationNode);
                ++i2;
            }
            if (referredOperation.getBodyExpression() != null) {
                OperationRegion operationRegion = this.scheduleManager.analyzeOperation(operationCallExp);
                @NonNull Iterable referenceNodes = QVTscheduleUtil.getDependencyNodes((OperationRegion)operationRegion);
                for (Node referenceNode : referenceNodes) {
                    ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)referenceNode);
                    Node dependencyHead = ((RuleAnalysis)((Object)this.context)).getDependencyHead(classDatum);
                    if (dependencyHead != null) continue;
                    dependencyHead = ((RuleAnalysis)((Object)this.context)).createDependencyHead(classDatum);
                    this.createExpressionEdge(dependencyHead, QVTscheduleUtil.getName((Nameable)dependencyHead), operationNode);
                    this.instantiate(dependencyHead, referenceNode);
                }
            }
        } else {
            operationNode.addTypedElement((TypedElement)operationCallExp);
            if ("<>".equals(operationName)) {
                operationName.toString();
            }
        }
        if ((returnType = operationCallExp.getType()) instanceof DataType) {
            return operationNode;
        }
        return operationNode;
    }

    public @NonNull Node visitShadowExp(@NonNull ShadowExp shadowExp) {
        List ownedParts = shadowExp.getOwnedParts();
        int iSize = ownedParts.size();
        @NonNull Node[] partNodes = new Node[iSize];
        @NonNull String[] partNames = new String[iSize];
        int i = 0;
        while (i < iSize) {
            ShadowPart shadowPart = (ShadowPart)ownedParts.get(i);
            partNodes[i] = this.analyze((Visitable)shadowPart);
            partNames[i] = (String)ClassUtil.nonNullState((Object)shadowPart.getName());
            ++i;
        }
        Node operationNode = this.createConnectedOperationNode((String)ClassUtil.nonNullState((Object)shadowExp.getType().getName()), partNames, (TypedElement)shadowExp, partNodes);
        return operationNode;
    }

    public @NonNull Node visitShadowPart(@NonNull ShadowPart shadowPart) {
        Node partNode = this.analyze((Visitable)shadowPart.getOwnedInit());
        Node operationNode = this.createConnectedOperationNode((String)ClassUtil.nonNullState((Object)shadowPart.getName()), (TypedElement)shadowPart, partNode);
        return operationNode;
    }

    public @NonNull Node visitStringLiteralExp(@NonNull StringLiteralExp stringLiteralExp) {
        Node operationNode = this.createOperationNode((String)ClassUtil.nonNullState((Object)stringLiteralExp.getStringSymbol()), (TypedElement)stringLiteralExp, new Node[0]);
        return operationNode;
    }

    public @NonNull Node visitTupleLiteralExp(@NonNull TupleLiteralExp tupleLiteralExp) {
        List ownedParts = tupleLiteralExp.getOwnedParts();
        int iSize = ownedParts.size();
        @NonNull Node[] partNodes = new Node[iSize];
        int i = 0;
        while (i < iSize) {
            partNodes[i] = this.analyze((Visitable)ownedParts.get(i));
            ++i;
        }
        Node operationNode = this.createConnectedOperationNode((String)ClassUtil.nonNullState((Object)tupleLiteralExp.getName()), (TypedElement)tupleLiteralExp, partNodes);
        return operationNode;
    }

    public @NonNull Node visitTupleLiteralPart(@NonNull TupleLiteralPart tupleLiteralPart) {
        Node partNode = this.analyze((Visitable)tupleLiteralPart.getOwnedInit());
        Node operationNode = this.createConnectedOperationNode((String)ClassUtil.nonNullState((Object)tupleLiteralPart.getName()), (TypedElement)tupleLiteralPart, partNode);
        return operationNode;
    }

    public @NonNull Node visitTypeExp(@NonNull TypeExp typeExp) {
        DomainUsage domainUsage = this.scheduleManager.getDomainUsage((Element)typeExp);
        Type referredType = QVTcoreUtil.getReferredType((TypeExp)typeExp);
        TypedModel typedModel = domainUsage.getTypedModel((Element)typeExp);
        assert (typedModel != null);
        ClassDatum classDatum = this.scheduleManager.getClassDatum(typedModel, (Class)referredType);
        String typeName = PrettyPrinter.printType((Element)QVTscheduleUtil.getCompleteClass((ClassDatum)classDatum));
        Node operationNode = this.createConnectedOperationNode(typeName, (TypedElement)typeExp, new Node[0]);
        return operationNode;
    }

    public @NonNull Node visitVariableExp(@NonNull VariableExp variableExp) {
        Variable referredVariable = QVTcoreUtil.getReferredVariable((VariableExp)variableExp);
        return ((RuleAnalysis)((Object)this.context)).getReferenceNode((VariableDeclaration)referredVariable);
    }
}

