/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphStringBuilder;

public class DOTStringBuilder
implements GraphStringBuilder {
    protected static @NonNull String NULL_PLACEHOLDER = "\"<null>\"";
    private final @NonNull StringBuilder s = new StringBuilder();
    private int indents = 0;
    private boolean indentPending = false;
    private final @NonNull Map<Object, String> node2name = new HashMap<Object, String>();
    private final @NonNull Map<String, Set<String>> edges = new HashMap<String, Set<String>>();
    private final @NonNull List<String> clusterName = new ArrayList<String>();
    private final @NonNull Map<String, String> attributes = new HashMap<String, String>();

    public DOTStringBuilder() {
        this.append("digraph ");
        this.append("schedule");
        this.append(" {");
        ++this.indents;
        this.append("fontname=arial;");
        this.append("edge [fontname=arial,penwidth=2];");
        this.append("node [shape=rectangle,fontname=arial,penwidth=2];");
        this.append("compound=true;");
        this.newLine();
    }

    public void append(@Nullable Number number) {
        if (this.indentPending) {
            this.indentPending = false;
            int i = 0;
            while (i < this.indents) {
                this.append("  ");
                ++i;
            }
        }
        if (number != null) {
            this.s.append(number.toString());
        } else {
            this.s.append(NULL_PLACEHOLDER);
        }
    }

    public void append(@Nullable String string) {
        if (this.indentPending) {
            this.indentPending = false;
            int i = 0;
            while (i < this.indents) {
                this.append("  ");
                ++i;
            }
        }
        if (string != null) {
            this.s.append(string);
        } else {
            this.s.append(NULL_PLACEHOLDER);
        }
    }

    @Override
    public void appendAttributedEdge(@NonNull GraphStringBuilder.GraphNode source, @NonNull GraphStringBuilder.GraphEdge edge, @NonNull GraphStringBuilder.GraphNode target) {
    }

    @Override
    public void appendAttributedNode(@NonNull String nodeName) {
        boolean isHead = this.attributes.containsKey("head");
        if (isHead) {
            this.append("{rank=source;");
        }
        this.append(nodeName);
        this.appendAttributes();
        if (isHead) {
            this.append("}");
        }
    }

    private void appendAttributes() {
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            if (isFirst) {
                this.s.append("[");
            } else {
                this.s.append(",");
            }
            isFirst = false;
            this.s.append(entry.getKey());
            this.s.append("=");
            this.s.append(entry.getValue());
        }
        if (!isFirst) {
            this.s.append("]");
        }
        this.attributes.clear();
    }

    public void appendEdge(@NonNull GraphStringBuilder.GraphNode source, @NonNull GraphStringBuilder.GraphNode target) {
        String sourceName = this.appendNode(source);
        String targetName = this.appendNode(target);
        Set<String> edgeSet = this.edges.get(sourceName);
        if (edgeSet == null) {
            edgeSet = new HashSet<String>();
            this.edges.put(sourceName, edgeSet);
        }
        if (edgeSet.add(targetName)) {
            this.append(sourceName);
            this.append(" -> ");
            this.append(targetName);
            this.newLine();
        }
    }

    @Override
    public void appendEdge(@NonNull GraphStringBuilder.GraphNode source, @NonNull GraphStringBuilder.GraphEdge edge, @NonNull GraphStringBuilder.GraphNode target) {
        String sourceName = this.appendNode(source);
        String targetName = this.appendNode(target);
        this.append(sourceName);
        this.append(" -> ");
        this.append(targetName);
        this.attributes.clear();
        edge.appendEdgeAttributes(this, source, target);
        this.appendAttributes();
        this.newLine();
    }

    public void appendEdge(@NonNull GraphStringBuilder.GraphNode source, @NonNull GraphStringBuilder.GraphNode target, @Nullable String suffix) {
        String sourceName = this.appendNode(source);
        String targetName = this.appendNode(target);
        Set<String> edgeSet = this.edges.get(sourceName);
        if (edgeSet == null) {
            edgeSet = new HashSet<String>();
            this.edges.put(sourceName, edgeSet);
        }
        if (edgeSet.add(targetName)) {
            this.append(sourceName);
            this.append(" -> ");
            this.append(targetName);
            if (suffix != null) {
                this.append(suffix);
            }
            this.newLine();
        }
    }

    @Override
    public @NonNull String appendNode(@NonNull GraphStringBuilder.GraphNode object) {
        String name = this.node2name.get(object);
        if (name == null) {
            name = "a" + this.node2name.size();
            this.node2name.put(object, name);
            this.attributes.clear();
            object.appendNode(this, name);
            this.newLine();
        }
        return name;
    }

    public @NonNull String appendNode(@NonNull Object object, String label) {
        String name = this.node2name.get(object);
        if (name == null) {
            name = "a" + this.node2name.size();
            this.node2name.put(object, name);
        }
        this.append(name);
        this.append("[label=\"" + label + "\"];");
        this.newLine();
        return name;
    }

    public void newLine() {
        this.append("\n");
        this.indentPending = true;
    }

    @Override
    public void popCluster() {
        --this.indents;
        this.append("}");
        this.newLine();
    }

    @Override
    public void pushCluster() {
        String name = "cluster_" + this.clusterName.size();
        this.clusterName.add(name);
        this.append("subgraph " + name + " {");
        ++this.indents;
        this.newLine();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            this.append(entry.getKey());
            this.append("=");
            this.append(entry.getValue());
            this.append(";");
            this.newLine();
        }
        this.attributes.clear();
    }

    public void pushCluster(String label) {
        String name = "cluster_" + this.clusterName.size();
        this.clusterName.add(name);
        this.append("subgraph " + name + " {");
        ++this.indents;
        this.newLine();
        this.append("color=grey;");
        this.newLine();
        if (label != null) {
            this.append("label=\"" + label + "\";");
            this.newLine();
        }
    }

    @Override
    public void setArrowhead(@NonNull String value) {
        this.attributes.put("arrowhead", value);
    }

    @Override
    public void setColor(@NonNull String value) {
        this.attributes.put("color", value);
    }

    @Override
    public void setHead() {
        this.attributes.put("head", "true");
    }

    @Override
    public void setLabel(String value) {
        this.attributes.put("label", String.valueOf('\"') + value + '\"');
    }

    public void setLhead(String value) {
        this.attributes.put("lhead", value);
    }

    public void setLtail(String value) {
        this.attributes.put("ltail", value);
    }

    @Override
    public void setPenwidth(@NonNull Integer value) {
        this.attributes.put("penwidth", value.toString());
    }

    @Override
    public void setShape(@NonNull String value) {
        this.attributes.put("shape", value);
    }

    @Override
    public void setStyle(@NonNull String value) {
        this.attributes.put("style", value);
    }

    public @NonNull String toString() {
        if (this.indents > 0) {
            --this.indents;
            this.append("}");
            this.newLine();
        }
        return this.s.toString();
    }
}

