/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.etl;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.resource.OCLASResourceFactory;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.qvtd.compiler.internal.etl.EolTask;
import org.eclipse.qvtd.compiler.internal.etl.EtlTask;
import org.eclipse.qvtd.compiler.internal.etl.FlockTask;
import org.eclipse.qvtd.compiler.internal.etl.PivotModel;
import org.eclipse.qvtd.compiler.internal.etl.QvtMtcExecutionException;
import org.eclipse.qvtd.compiler.internal.qvtcconfig.Configuration;
import org.eclipse.qvtd.compiler.internal.qvtcconfig.Direction;
import org.eclipse.qvtd.compiler.internal.qvtcconfig.QVTcConfigPackage;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphBuilder;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphMLBuilder;
import org.eclipse.qvtd.pivot.schedule.SchedulePackage;
import org.eclipse.qvtd.pivot.schedule.util.ScheduleVisitor;
import org.eclipse.qvtd.pivot.schedule.utilities.ScheduleToCallGraph;
import org.eclipse.qvtd.pivot.schedule.utilities.ScheduleToDependencyGraphVisitor;

public class MtcBroker {
    private static final String ECORE_URI = "http://www.eclipse.org/emf/2002/Ecore";
    private static final String CONFIG_MODEL_NAME = "config";
    private static final String CONFIG_URI = "http://www.eclipse.org/qvt/examples/0.1/QVTcConfig";
    private static final String CONFIG_QUERIES_EOL = "helpers/ConfigQueries.eol";
    private static final String ECORE_CONTAINMENT_MM = "platform:/resource/org.eclipse.qvtd.compiler/model/ECoreContainmentTree.ecore";
    private static final String ECORE_CONTAINMENT_URI = "http://www.eclipse.org/qvt/examples/0.1/ECoreContainemntTree";
    private static final String ECORE_TO_TREE_EOL = "utils/EcoreToContainmentTree.etl";
    private static final String QVTS_URI = "http://www.eclipse.org/qvt/2015/Schedule";
    private static final String OCL_STD_LIB_MODEL_NAME = "oclStdLib";
    private static final String OCL_STD_LIB_URI = "http://www.eclipse.org/ocl/2015/Library.oclas";
    private static final String PIVOT_URI = "http://www.eclipse.org/ocl/2015/Pivot";
    private static final String QVTB_URI = "http://www.eclipse.org/qvt/2015/QVTbase";
    private static final String QVTCB_URI = "http://www.eclipse.org/qvt/2015/QVTcoreBase";
    private static final String QVTC_URI = "http://www.eclipse.org/qvt/2015/QVTcore";
    private static final String QVTI_URI = "http://www.eclipse.org/qvt/2015/QVTimperative";
    private static final String QVTC_FULL_NS = "http://www.eclipse.org/qvt/2015/QVTcore,http://www.eclipse.org/qvt/2015/QVTcoreBase,http://www.eclipse.org/qvt/2015/QVTbase,http://www.eclipse.org/ocl/2015/Pivot";
    protected static final String QVTI_FULL_NS = "http://www.eclipse.org/qvt/2015/QVTimperative,http://www.eclipse.org/qvt/2015/QVTcoreBase,http://www.eclipse.org/qvt/2015/QVTbase,http://www.eclipse.org/ocl/2015/Pivot";
    private static final String QVTS_FULL_NS = "http://www.eclipse.org/qvt/2015/Schedule,http://www.eclipse.org/qvt/2015/QVTimperative,http://www.eclipse.org/qvt/2015/QVTcoreBase,http://www.eclipse.org/qvt/2015/QVTbase,http://www.eclipse.org/ocl/2015/Pivot";
    private static final String QVTC_TO_QVTU_FLOCK = "mtc/QVTcToQVTu.mig";
    private static final String QVTU_TO_QVTM_FLOCK = "mtc/QVTuToQVTm.mig";
    private static final String QVTM_TO_QVTP_ETL = "mtc/QVTmToQVTiPartition.etl";
    private static final String QVTP_TO_QVTS_ETL = "scheduling/QVTpToSchedule.etl";
    private static final String QVTP_FLAT_SCHEDULE_EOL = "scheduling/FlatSchedule.eol";
    private static final String QVTP_SIMPLE_NESTING_SCHEDULE_EOL = "scheduling/NestedSchedule.eol";
    private static final String QVTPS_TO_QVTI_ETL = "mtc/QVTs-pToQVTi.etl";
    private static final String LEFT_DIR_NAME = "L";
    private static final String RIGHT_DIR_NAME = "R";
    private static final String MIDDLE_DIR_NAME = "M";
    protected boolean createGraphml = false;
    private boolean darkTheme = false;
    private boolean nestedSchedule = true;
    private String qvtcasUri;
    private String qvtuUri;
    private String qvtmUri;
    protected String partitionUri;
    protected String qvtiUri;
    private String configUri;
    protected String scheduleUri;
    private PivotModel configModel;
    protected PivotModel oclStdLibModel;
    private URI dependencyGraphUri;
    private URI callGraphUri;
    private String rMetamodel;
    private PivotModel rMetamodelModel;
    private Map<String, List<PivotModel>> candidateMetamodelContainmentTrees;
    @NonNull
    private EnvironmentFactory environmentFactory;
    @Nullable
    protected Map<?, ?> savingOptions;
    private URI baseUri;
    private URI debugUri;
    private PivotModel cModel;
    private PivotModel uModel;
    private PivotModel mModel;
    protected PivotModel pModel;
    protected PivotModel sModel;
    protected PivotModel iModel;

    public MtcBroker(URI baseURI, String qvtcSource, @NonNull EnvironmentFactory environmentFactory) throws QvtMtcExecutionException {
        this(baseURI, qvtcSource, environmentFactory, null);
    }

    public MtcBroker(URI baseURI, String qvtcSource, @NonNull EnvironmentFactory environmentFactory, Map<?, ?> savingOptions) throws QvtMtcExecutionException {
        this.savingOptions = savingOptions;
        this.environmentFactory = environmentFactory;
        this.baseUri = baseURI;
        this.debugUri = baseURI.appendSegment("debug");
        String dgPath = this.debugUri.appendSegment(qvtcSource).trimFileExtension() + "Dependencies";
        String cgPath = this.debugUri.appendSegment(qvtcSource).trimFileExtension() + "Calls";
        System.out.println("Executing the QVTc to QVTi MTC for " + qvtcSource);
        this.baseUri = baseURI;
        URI qvtcURI = baseURI.appendSegment(qvtcSource);
        this.qvtcasUri = qvtcURI.toString();
        URI modelsBaseUri = qvtcURI.trimFileExtension();
        this.qvtuUri = modelsBaseUri.appendFileExtension("qvtu.qvtcas").toString();
        this.qvtmUri = modelsBaseUri.appendFileExtension("qvtm.qvtcas").toString();
        this.partitionUri = modelsBaseUri.appendFileExtension("qvtp.qvtias").toString();
        this.qvtiUri = modelsBaseUri.appendFileExtension("qvtias").toString();
        this.configUri = URI.createURI((String)(String.valueOf(modelsBaseUri.toString()) + "Config")).appendFileExtension("xmi").toString();
        this.scheduleUri = URI.createURI((String)(String.valueOf(modelsBaseUri.toString()) + "Schedule")).appendFileExtension("xmi").toString();
        this.dependencyGraphUri = URI.createURI((String)dgPath).appendFileExtension("graphml");
        this.callGraphUri = URI.createURI((String)cgPath).appendFileExtension("graphml");
        this.candidateMetamodelContainmentTrees = new HashMap<String, List<PivotModel>>();
        this.registerMetamodels(environmentFactory);
    }

    public PivotModel getcModel() {
        return this.cModel;
    }

    public PivotModel getuModel() {
        return this.uModel;
    }

    public PivotModel getmModel() {
        return this.mModel;
    }

    public PivotModel getpModel() {
        return this.pModel;
    }

    public PivotModel getsModel() {
        return this.sModel;
    }

    public PivotModel getiModel() {
        return this.iModel;
    }

    public void prepare() throws QvtMtcExecutionException {
        this.loadConfigurationModel();
        this.loadOclStdLibModel();
        this.createContainmentTrees();
    }

    public void execute() throws QvtMtcExecutionException {
        this.prepare();
        this.cModel = this.createASModel(this.qvtcasUri, "QVTc", "QVT", QVTC_FULL_NS, true, false, true, false);
        this.uModel = this.qvtcToQvtu(this.cModel);
        this.mModel = this.qvtuToQvtm(this.uModel);
        this.pModel = this.qvtmToQvtp(this.mModel);
        this.sModel = this.qvtpToQvts(this.pModel);
        if (this.nestedSchedule) {
            this.qvtpNestingScheduling(this.pModel, this.sModel);
        } else {
            this.qvtpFlatScheduling(this.pModel, this.sModel);
        }
        if (this.createGraphml) {
            this.qvtsToGraphML(this.sModel);
        }
        this.iModel = this.qvtpQvtsToQvti(this.pModel, this.sModel);
    }

    /*
     * Unable to fully structure code
     */
    protected void qvtsToGraphML(PivotModel sModel) throws QvtMtcExecutionException {
        block51: {
            depBuilder = new GraphMLBuilder();
            callBuilder = new GraphMLBuilder();
            s = null;
            try {
                try {
                    s = sModel.getSchedule();
                }
                catch (Exception e) {
                    throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
                }
            }
            finally {
                if (s == null) break block51;
                depVisitor = new ScheduleToDependencyGraphVisitor((GraphBuilder)depBuilder, this.darkTheme);
                callVisitor = new ScheduleToCallGraph((GraphBuilder)callBuilder, this.darkTheme);
                ** for (eContent : this.configModel.getResource().getContents())
            }
lbl-1000:
            // 1 sources

            {
                if (!(eContent instanceof Configuration)) continue;
                c = (Configuration)eContent;
                depVisitor.setInputDirection(c.getInputDirection().getName());
                depVisitor.setMiddleDirection("middle");
                for (Direction od : c.getOutputDirection()) {
                    depVisitor.getOutputDirection().add(od.getName());
                }
                continue;
            }
lbl24:
            // 1 sources

            s.accept((ScheduleVisitor)depVisitor);
            try {
                eContent = null;
                var10_14 = null;
                try {
                    writer = new BufferedWriter(new OutputStreamWriter(URIConverter.INSTANCE.createOutputStream(this.dependencyGraphUri), "utf-8"));
                    try {
                        writer.write(depBuilder.toString());
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                }
                catch (Throwable var10_15) {
                    if (eContent == null) {
                        eContent = var10_15;
                    } else if (eContent != var10_15) {
                        eContent.addSuppressed(var10_15);
                    }
                    throw eContent;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            s.accept((ScheduleVisitor)callVisitor);
            try {
                e = null;
                var10_14 = null;
                try {
                    writer = new BufferedWriter(new OutputStreamWriter(URIConverter.INSTANCE.createOutputStream(this.callGraphUri), "utf-8"));
                    try {
                        writer.write(callBuilder.toString());
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                }
                catch (Throwable var10_16) {
                    if (e == null) {
                        e = var10_16;
                    } else if (e != var10_16) {
                        e.addSuppressed(var10_16);
                    }
                    throw e;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Graphs created.");
    }

    public void executeQvtcToQvtu() throws QvtMtcExecutionException {
        this.prepare();
        this.cModel = this.createASModel(this.qvtcasUri, "QVTc", "QVT", QVTC_FULL_NS, true, false, true, false);
        this.uModel = this.qvtcToQvtu(this.cModel);
    }

    public void executeQvtuToQvtm() throws QvtMtcExecutionException {
        this.prepare();
        this.uModel = this.createASModel(this.qvtuUri, "QVTu", "QVT", QVTC_FULL_NS, true, false, false, false);
        this.mModel = this.qvtuToQvtm(this.uModel);
    }

    public void executeQvtmToQvtp() throws QvtMtcExecutionException {
        this.prepare();
        this.mModel = this.createASModel(this.qvtmUri, "QVTm", "QVT", QVTC_FULL_NS, true, false, false, false);
        this.pModel = this.qvtmToQvtp(this.mModel);
    }

    public void executeQvtsToGraphML() throws QvtMtcExecutionException {
        this.prepare();
        this.sModel = this.createASModel(this.scheduleUri, "QVTs", "QVT", QVTS_FULL_NS, true, false, false, true);
        this.qvtsToGraphML(this.sModel);
    }

    public void executeQvtpQvtsToQvti() throws QvtMtcExecutionException {
        this.prepare();
        this.pModel = this.createASModel(this.partitionUri, "QVTp", "QVT", QVTI_FULL_NS, true, false, false, true);
        this.sModel = this.createASModel(this.scheduleUri, "QVTs", "QVT", QVTS_FULL_NS, false, true, false, true);
        this.iModel = this.qvtpQvtsToQvti(this.pModel, this.sModel);
    }

    public void executeQvtpToQvts(boolean dryRun) throws QvtMtcExecutionException {
        block14: {
            this.prepare();
            try {
                try {
                    this.pModel = this.createASModel(this.partitionUri, "QVTp", "QVT", QVTI_FULL_NS, true, false, false, true);
                    this.sModel = this.qvtpToQvts(this.pModel);
                }
                catch (QvtMtcExecutionException e) {
                    e.printStackTrace();
                    if (this.pModel != null && this.sModel != null) {
                        this.sModel.setStoredOnDisposal(!dryRun);
                    }
                    if (this.nestedSchedule) {
                        this.qvtpNestingScheduling(this.pModel, this.sModel);
                    } else {
                        this.qvtpFlatScheduling(this.pModel, this.sModel);
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (this.pModel != null && this.sModel != null) {
                    this.sModel.setStoredOnDisposal(!dryRun);
                }
                if (this.nestedSchedule) {
                    this.qvtpNestingScheduling(this.pModel, this.sModel);
                } else {
                    this.qvtpFlatScheduling(this.pModel, this.sModel);
                }
                throw throwable;
            }
            if (this.pModel != null && this.sModel != null) {
                this.sModel.setStoredOnDisposal(!dryRun);
            }
            if (this.nestedSchedule) {
                this.qvtpNestingScheduling(this.pModel, this.sModel);
            } else {
                this.qvtpFlatScheduling(this.pModel, this.sModel);
            }
        }
    }

    public void disposeModels() {
        this.cModel.dispose();
        this.uModel.dispose();
        this.mModel.dispose();
        this.pModel.dispose();
        this.sModel.dispose();
        this.iModel.dispose();
    }

    private PivotModel qvtcToQvtu(EmfModel cModel) throws QvtMtcExecutionException {
        PivotModel uModel = null;
        uModel = this.createASModel(this.qvtuUri, "QVTu", "QVT", QVTC_FULL_NS, false, true, false, false);
        if (cModel != null && uModel != null) {
            FlockTask flock = null;
            try {
                try {
                    flock = new FlockTask(java.net.URI.create(this.getResourceURI(QVTC_TO_QVTU_FLOCK)));
                }
                catch (URISyntaxException e) {
                    throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
                }
            }
            finally {
                if (flock != null) {
                    flock.setOriginalModel((IModel)cModel);
                    flock.setMigratedModel((IModel)uModel);
                    flock.models.add(this.configModel);
                    flock.models.add(this.oclStdLibModel);
                    flock.execute();
                }
            }
        }
        this.environmentFactory.getMetamodelManager().getASResourceSet().getResources().remove((Object)cModel.getResource());
        return uModel;
    }

    private PivotModel qvtuToQvtm(PivotModel uModel) throws QvtMtcExecutionException {
        PivotModel mModel = null;
        mModel = this.createASModel(this.qvtmUri, "QVTm", "QVT", QVTC_FULL_NS, false, true, false, false);
        if (uModel != null && mModel != null) {
            uModel.setCachingEnabled(true);
            uModel.clearCache();
            uModel.setStoredOnDisposal(false);
            FlockTask flock = null;
            try {
                try {
                    flock = new FlockTask(java.net.URI.create(this.getResourceURI(QVTU_TO_QVTM_FLOCK)));
                }
                catch (URISyntaxException e) {
                    throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
                }
            }
            finally {
                if (flock != null) {
                    flock.setOriginalModel((IModel)uModel);
                    flock.setMigratedModel((IModel)mModel);
                    flock.models.add(this.configModel);
                    flock.models.add(this.oclStdLibModel);
                    flock.execute();
                }
            }
        }
        this.environmentFactory.getMetamodelManager().getASResourceSet().getResources().remove((Object)uModel.getResource());
        return mModel;
    }

    private PivotModel qvtmToQvtp(PivotModel mModel) throws QvtMtcExecutionException {
        PivotModel pModel = null;
        pModel = this.createASModel(this.partitionUri, "QVTp", "QVT", QVTI_FULL_NS, false, true, false, true);
        if (mModel != null && pModel != null) {
            mModel.setCachingEnabled(true);
            mModel.clearCache();
            mModel.setStoredOnDisposal(false);
            EtlTask etl = null;
            try {
                try {
                    etl = new EtlTask(java.net.URI.create(this.getResourceURI(QVTM_TO_QVTP_ETL)));
                }
                catch (URISyntaxException e) {
                    throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
                }
            }
            finally {
                if (etl != null) {
                    etl.models.add(mModel);
                    etl.models.add(pModel);
                    etl.models.add(this.configModel);
                    etl.models.add(this.oclStdLibModel);
                    etl.execute();
                }
            }
        }
        this.environmentFactory.getMetamodelManager().getASResourceSet().getResources().remove((Object)mModel.getResource());
        return pModel;
    }

    protected PivotModel qvtpToQvts(PivotModel pModel) throws QvtMtcExecutionException {
        PivotModel sModel = null;
        sModel = this.createASModel(this.scheduleUri, "QVTs", "QVT", QVTS_FULL_NS, false, true, false, true);
        pModel.setCachingEnabled(true);
        pModel.clearCache();
        pModel.setStoredOnDisposal(false);
        if (pModel != null && sModel != null) {
            EtlTask etl = null;
            try {
                try {
                    etl = new EtlTask(java.net.URI.create(this.getResourceURI(QVTP_TO_QVTS_ETL)));
                }
                catch (URISyntaxException e) {
                    throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
                }
            }
            finally {
                if (etl != null) {
                    etl.models.add(pModel);
                    etl.models.add(sModel);
                    etl.models.add(this.configModel);
                    etl.models.add(this.oclStdLibModel);
                    etl.models.add((IModel)this.candidateMetamodelContainmentTrees.get(RIGHT_DIR_NAME).get(0));
                    etl.execute();
                }
            }
        }
        return sModel;
    }

    protected void qvtpFlatScheduling(PivotModel pModel, PivotModel sModel) throws QvtMtcExecutionException {
        this.qvtpScheduling(pModel, sModel, QVTP_FLAT_SCHEDULE_EOL);
    }

    protected void qvtpNestingScheduling(PivotModel pModel, PivotModel sModel) throws QvtMtcExecutionException {
        this.qvtpScheduling(pModel, sModel, QVTP_SIMPLE_NESTING_SCHEDULE_EOL);
    }

    protected void qvtpScheduling(PivotModel pModel, PivotModel sModel, String schedulingTxURI) throws QvtMtcExecutionException {
        if (pModel != null && sModel != null) {
            sModel.setCachingEnabled(true);
            sModel.clearCache();
            pModel.setStoredOnDisposal(true);
            sModel.setStoredOnDisposal(true);
            EolTask eol = null;
            try {
                eol = new EolTask(java.net.URI.create(this.getResourceURI(schedulingTxURI)));
            }
            catch (URISyntaxException e) {
                throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
            }
            if (eol != null) {
                eol.models.add(pModel);
                eol.models.add(sModel);
                eol.models.add(this.oclStdLibModel);
                eol.models.add(this.configModel);
                eol.models.add((IModel)this.candidateMetamodelContainmentTrees.get(RIGHT_DIR_NAME).get(0));
                eol.execute();
            }
        }
    }

    protected PivotModel qvtpQvtsToQvti(PivotModel pModel, PivotModel sModel) throws QvtMtcExecutionException {
        PivotModel iModel = null;
        iModel = this.createASModel(this.qvtiUri, "QVTi", "QVT", QVTI_FULL_NS, false, true, false, true);
        if (pModel != null && sModel != null && iModel != null) {
            EtlTask etl = null;
            try {
                try {
                    etl = new EtlTask(java.net.URI.create(this.getResourceURI(QVTPS_TO_QVTI_ETL)));
                }
                catch (URISyntaxException e) {
                    throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
                }
            }
            finally {
                if (etl != null) {
                    etl.models.add(pModel);
                    etl.models.add(sModel);
                    etl.models.add(iModel);
                    etl.models.add(this.oclStdLibModel);
                    etl.execute();
                }
            }
        }
        return iModel;
    }

    protected void createContainmentTrees() throws QvtMtcExecutionException {
        EtlTask eol = null;
        ArrayList<URI> loadedUris = new ArrayList<URI>();
        try {
            eol = new EtlTask(java.net.URI.create(this.getResourceURI(ECORE_TO_TREE_EOL)));
        }
        catch (URISyntaxException e) {
            throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
        }
        if (eol != null) {
            Map<String, List<String>> mms = this.getCandidateMetamodels();
            for (Map.Entry<String, List<String>> pairs : mms.entrySet()) {
                ArrayList<PivotModel> trees = new ArrayList<PivotModel>();
                for (String mm : pairs.getValue()) {
                    URI modelUri = null;
                    try {
                        try {
                            URI mmSegments = URI.createURI((String)mm);
                            if (mmSegments.segments().length == 1) {
                                modelUri = this.baseUri.appendSegment(mm);
                                continue;
                            }
                            modelUri = mmSegments.resolve(this.baseUri);
                        }
                        catch (IllegalArgumentException e) {
                            throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
                        }
                    }
                    finally {
                        if (modelUri != null && !loadedUris.contains(modelUri)) {
                            loadedUris.add(modelUri);
                            PivotModel mmModel = null;
                            PivotModel treeModel = null;
                            mmModel = this.createModel(modelUri.toString(), "mm", "", ECORE_URI, true, false, true, false);
                            String cgUri = String.valueOf(mmModel.getModelFileUri().trimFileExtension().toString()) + "ContainmentTree.xmi";
                            treeModel = this.createModel(cgUri, "tree", String.valueOf(pairs.getKey().toLowerCase()) + "Tree", ECORE_CONTAINMENT_URI, false, true, true, false);
                            if (mmModel != null && treeModel != null) {
                                eol.models.add(mmModel);
                                eol.models.add(treeModel);
                                eol.execute();
                                eol.models.clear();
                                trees.add(treeModel);
                            }
                        }
                    }
                }
                this.candidateMetamodelContainmentTrees.put(pairs.getKey(), trees);
            }
        }
    }

    private Map<String, List<String>> getCandidateMetamodels() throws QvtMtcExecutionException {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        EolTask eol = null;
        try {
            eol = new EolTask(java.net.URI.create(this.getResourceURI(CONFIG_QUERIES_EOL)));
        }
        catch (URISyntaxException e) {
            throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
        }
        if (eol != null) {
            eol.addModel((IModel)this.configModel);
            eol.executeOperation("getAllMetamodelFiles");
            Object mmList = eol.getResult();
            for (Map.Entry pairs : ((Map)mmList).entrySet()) {
                System.out.println(String.valueOf((String)pairs.getKey()) + " = " + pairs.getValue());
                result.put((String)pairs.getKey(), (List)pairs.getValue());
            }
        }
        return result;
    }

    protected void loadConfigurationModel() throws QvtMtcExecutionException {
        this.configModel = this.createModel(this.configUri, CONFIG_MODEL_NAME, "", CONFIG_URI, true, false, true, false);
    }

    protected void loadOclStdLibModel() throws QvtMtcExecutionException {
        OCLASResourceFactory.getInstance();
        this.oclStdLibModel = this.createASModel(OCL_STD_LIB_URI, OCL_STD_LIB_MODEL_NAME, "", PIVOT_URI, true, false, true, false);
    }

    private void registerMetamodels(@NonNull EnvironmentFactory environmentFactory) throws QvtMtcExecutionException {
        URI mmURI = null;
        ResourceSet externalResourceSet = environmentFactory.getResourceSet();
        QVTcConfigPackage cp = QVTcConfigPackage.eINSTANCE;
        externalResourceSet.getPackageRegistry().put((Object)cp.getNsURI(), (Object)cp);
        mmURI = null;
        try {
            try {
                mmURI = URI.createURI((String)ECORE_CONTAINMENT_MM);
            }
            catch (IllegalArgumentException e) {
                throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
            }
        }
        finally {
            Resource r;
            EObject eObject;
            if (mmURI != null && (eObject = (EObject)(r = externalResourceSet.getResource(mmURI, true)).getContents().get(0)) instanceof EPackage) {
                EPackage p = (EPackage)eObject;
                externalResourceSet.getPackageRegistry().put((Object)p.getNsURI(), (Object)p);
            }
        }
        SchedulePackage sp = SchedulePackage.eINSTANCE;
        externalResourceSet.getPackageRegistry().put((Object)sp.getNsURI(), (Object)sp);
    }

    protected PivotModel createModel(String modeUri, String modelName, String modelAliases, String metamodelUris, boolean readOnLoad, boolean storeOnDispoal, boolean cached, boolean expand) throws QvtMtcExecutionException {
        PivotModel model = new PivotModel(this.environmentFactory, false, this.savingOptions);
        StringProperties properties = new StringProperties();
        properties.put((Object)"name", (Object)modelName);
        properties.put((Object)"aliases", (Object)modelAliases);
        properties.put((Object)"metamodelUri", (Object)metamodelUris);
        properties.put((Object)"modelUri", (Object)modeUri);
        properties.put((Object)"readOnLoad", (Object)String.valueOf(readOnLoad));
        properties.put((Object)"storeOnDisposal", (Object)String.valueOf(storeOnDispoal));
        properties.put((Object)EmfModel.PROPERTY_CACHED, (Object)String.valueOf(cached));
        properties.put((Object)"expand", (Object)String.valueOf(expand));
        try {
            model.load(properties, "");
        }
        catch (EolModelLoadingException e) {
            throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
        }
        return model;
    }

    private PivotModel createASModel(String modeUri, String modelName, String modelAliases, String metamodelUris, boolean readOnLoad, boolean storeOnDispoal, boolean cached, boolean expand) throws QvtMtcExecutionException {
        PivotModel model = new PivotModel(this.environmentFactory, true, this.savingOptions);
        StringProperties properties = new StringProperties();
        properties.put((Object)"name", (Object)modelName);
        properties.put((Object)"aliases", (Object)modelAliases);
        properties.put((Object)"metamodelUri", (Object)metamodelUris);
        properties.put((Object)"modelUri", (Object)modeUri);
        properties.put((Object)"readOnLoad", (Object)String.valueOf(readOnLoad));
        properties.put((Object)"storeOnDisposal", (Object)String.valueOf(storeOnDispoal));
        properties.put((Object)EmfModel.PROPERTY_CACHED, (Object)String.valueOf(cached));
        properties.put((Object)"expand", (Object)String.valueOf(expand));
        try {
            model.load(properties, "");
        }
        catch (EolModelLoadingException e) {
            throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
        }
        return model;
    }

    public static String changeResourceToSource(String resourcePath) {
        String result = resourcePath.indexOf("/bin/") > -1 ? resourcePath.replaceAll("/bin/", "/src/") : resourcePath;
        return result;
    }

    public static String changeModelResourceToSource(String resourcePath) {
        String result = resourcePath.indexOf("/bin/") > -1 ? resourcePath.replaceAll("/bin/", "/model/") : resourcePath;
        return result;
    }

    private String getResourceURI(String resource) throws URISyntaxException {
        URL r = MtcBroker.class.getResource(resource);
        String uri = r.toURI().toString();
        return uri;
    }

    public void setCreateGraphml(boolean createGraphml) {
        this.setCreateGraphml(createGraphml, false);
    }

    public void setCreateGraphml(boolean createGraphml, boolean darkTheme) {
        this.createGraphml = createGraphml;
        this.darkTheme = darkTheme;
    }

    public void setNestedSchedule(boolean nestedSchedule) {
        this.nestedSchedule = nestedSchedule;
    }
}

