/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtbase.tests;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.tests.TestFileSystemHelper;

public abstract class QVTbaseTestFileSystemHelper
extends TestFileSystemHelper {
    protected void appendBuildSpec(@NonNull Writer s) throws IOException {
        s.append("  <buildSpec>\n");
        s.append("    <buildCommand>\n");
        s.append("      <name>org.eclipse.jdt.core.javabuilder</name>\n");
        s.append("      <arguments>\n");
        s.append("      </arguments>\n");
        s.append("    </buildCommand>\n");
        s.append("    <buildCommand>\n");
        s.append("      <name>org.eclipse.pde.ManifestBuilder</name>\n");
        s.append("      <arguments>\n");
        s.append("      </arguments>\n");
        s.append("    </buildCommand>\n");
        s.append("    <buildCommand>\n");
        s.append("      <name>org.eclipse.pde.SchemaBuilder</name>\n");
        s.append("      <arguments>\n");
        s.append("      </arguments>\n");
        s.append("    </buildCommand>\n");
        s.append("    <!--buildCommand>\n");
        s.append("      <name>org.eclipse.qvtd.xtext.qvtbase.ui.qvtdbuilder</name>\n");
        s.append("      <arguments>\n");
        s.append("        <dictionary>\n");
        s.append("          <key>disabledExtensions</key>\n");
        s.append("          <value>*</value>\n");
        s.append("        </dictionary>\n");
        s.append("       <dictionary>\n");
        s.append("          <key>disabledPaths</key>\n");
        s.append("          <value>target/**</value>\n");
        s.append("        </dictionary>\n");
        s.append("        <dictionary>\n");
        s.append("          <key>enabledExtensions</key>\n");
        s.append("          <value>qvtc,qvti,qvtr,umlx</value>\n");
        s.append("        </dictionary>\n");
        s.append("        <dictionary>\n");
        s.append("          <key>enabledPaths</key>\n");
        s.append("          <value>model/**</value>\n");
        s.append("        </dictionary>\n");
        s.append("      </arguments>\n");
        s.append("    </buildCommand-->\n");
        s.append("  </buildSpec>\n");
    }

    protected void appendNatures(@NonNull Writer s) throws IOException {
        s.append("  <natures>\n");
        s.append("    <!--nature>org.eclipse.qvtd.xtext.qvtbase.ui.qvtdnature</nature-->\n");
        s.append("    <nature>org.eclipse.jdt.core.javanature</nature>\n");
        s.append("    <nature>org.eclipse.pde.PluginNature</nature>\n");
        s.append("  </natures>\n");
    }

    public @Nullable File createBuildDotProperties(@NonNull File projectFolder, @NonNull String projectName) {
        File file = new File(projectFolder, "build.properties");
        try {
            FileWriter s = new FileWriter(file);
            ((Writer)s).append("bin.includes = META-INF/\n");
            ((Writer)s).append("source.. = test-src/\n");
            ((Writer)s).append("");
            ((Writer)s).close();
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
        return file;
    }

    public @Nullable File createDotClasspathFile(@NonNull File projectFolder, @NonNull String projectName) {
        File file = new File(projectFolder, ".classpath");
        try {
            FileWriter s = new FileWriter(file);
            ((Writer)s).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            ((Writer)s).append("<classpath>\n");
            ((Writer)s).append("\t<classpathentry kind=\"con\" path=\"org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.8\"/>\n");
            ((Writer)s).append("\t<classpathentry kind=\"con\" path=\"org.eclipse.pde.core.requiredPlugins\"/>\n");
            ((Writer)s).append("\t<classpathentry kind=\"src\" path=\"test-src\"/>\n");
            ((Writer)s).append("\t<classpathentry kind=\"output\" path=\"bin\"/>\n");
            ((Writer)s).append("</classpath>\n");
            ((Writer)s).append("");
            ((Writer)s).close();
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
        return file;
    }

    public @Nullable File createManifestFile(@NonNull File projectFolder, @NonNull String projectName) {
        File metaInfFolder = new File(projectFolder, "META-INF");
        metaInfFolder.mkdir();
        File file = new File(metaInfFolder, "MANIFEST.MF");
        try {
            FileWriter s = new FileWriter(file);
            ((Writer)s).append("Manifest-Version: 1.0\n");
            ((Writer)s).append("Bundle-ManifestVersion: 2\n");
            ((Writer)s).append("Bundle-Name: " + projectName + "\n");
            ((Writer)s).append("Automatic-Module-Name: " + projectName + "\n");
            ((Writer)s).append("Bundle-SymbolicName: " + projectName + ";singleton:=true\n");
            ((Writer)s).append("Bundle-Version: 1.0.0.qualifier\n");
            boolean isFirst = true;
            for (String requiredBundle : this.getRequiredBundles()) {
                ((Writer)s).append(isFirst ? "Require-Bundle: " : ",\n ");
                ((Writer)s).append(requiredBundle);
                isFirst = false;
            }
            ((Writer)s).append("\n");
            ((Writer)s).append("Bundle-RequiredExecutionEnvironment: JavaSE-1.8\n");
            ((Writer)s).close();
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
        return file;
    }

    protected @NonNull List<@NonNull String> getRequiredBundles() {
        ArrayList<@NonNull String> requiredBundles = new ArrayList<String>();
        requiredBundles.add("org.eclipse.qvtd.runtime");
        return requiredBundles;
    }
}

