/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.common.parser.PropertyLabelParser;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.tools.utils.MultiplicityElementUtil;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ValueSpecification;

public class AssociationEndLabelParser
extends PropertyLabelParser {
    protected static final String ALT_MODIFIER_FORMAT = "{%s}%s";

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Collection<String> maskValues = this.getMaskValues(element);
        if (maskValues.isEmpty()) {
            return "<empty label>";
        }
        Object result = "";
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject != null && eObject instanceof Property) {
            Property property = (Property)eObject;
            if (maskValues.contains("visibility")) {
                result = String.format("%s %s", switch (property.getVisibility().getValue()) {
                    case 3 -> "~";
                    case 0 -> "+";
                    case 2 -> "#";
                    case 1 -> "-";
                    default -> "+";
                }, result);
            }
            if (maskValues.contains("derived") && property.isDerived()) {
                result = String.format("%s/", result);
            }
            if (maskValues.contains("name") && property.isSetName()) {
                String name = UMLLabelInternationalization.getInstance().getLabel((NamedElement)property);
                if (maskValues.contains("nonNavigableRole") || property.getOwningAssociation() == null || !property.getOwningAssociation().getOwnedEnds().contains((Object)property)) {
                    result = String.format("%s%s", result, name);
                }
            }
            if (maskValues.contains("type")) {
                String type = "<Undefined>";
                if (property.getType() != null) {
                    type = UMLLabelInternationalization.getInstance().getLabel((NamedElement)property.getType());
                }
                if (maskValues.contains("undefinedType") || !"<Undefined>".equals(type)) {
                    result = String.format("%s: %s", result, type);
                }
            }
            if (maskValues.contains("multiplicity")) {
                String multiplicity = this.justMultiplicityFormat(maskValues) ? MultiplicityElementUtil.formatMultiplicityNoBrackets((MultiplicityElement)property) : MultiplicityElementUtil.formatMultiplicity((MultiplicityElement)property);
                if ((multiplicity = MultiplicityElementUtil.manageDefaultMultiplicity((String)multiplicity, (!maskValues.contains("defaultMultiplicity") ? 1 : 0) != 0)) != null && !multiplicity.isEmpty()) {
                    result = (String)result + " " + multiplicity;
                }
            }
            if (maskValues.contains("defaultValue") && property.getDefaultValue() != null) {
                ValueSpecification valueSpecification = property.getDefaultValue();
                result = String.format("%s= %s", result, ValueSpecificationUtil.getSpecificationValue((ValueSpecification)valueSpecification, (boolean)true));
            }
            if (maskValues.contains("modifiers")) {
                EList redefinedProperties;
                StringBuffer sb = new StringBuffer();
                if (property.isReadOnly()) {
                    sb.append(sb.length() == 0 ? "readOnly" : ", readOnly");
                }
                if (property.isOrdered()) {
                    sb.append(sb.length() == 0 ? "ordered" : ", ordered");
                }
                if (property.isUnique()) {
                    sb.append(sb.length() == 0 ? "unique" : ", unique");
                }
                if (property.isDerivedUnion()) {
                    sb.append(sb.length() == 0 ? "union" : ", union");
                }
                if ((redefinedProperties = property.getRedefinedProperties()) != null && !redefinedProperties.isEmpty()) {
                    for (Property p : redefinedProperties) {
                        sb.append((String)(sb.length() == 0 ? UMLLabelInternationalization.getInstance().getLabel((NamedElement)p) : ", redefines " + UMLLabelInternationalization.getInstance().getLabel((NamedElement)p)));
                    }
                }
                if (sb.length() != 0) {
                    result = String.format(ALT_MODIFIER_FORMAT, sb.toString(), result);
                }
            }
        }
        return result;
    }

    private boolean justMultiplicityFormat(Collection<String> maskValues) {
        boolean nonBlockDefault;
        boolean blockDefault = maskValues.size() == 1 && maskValues.contains("multiplicity");
        boolean bl = nonBlockDefault = maskValues.size() == 2 && maskValues.contains("multiplicity") && maskValues.contains("defaultMultiplicity");
        return blockDefault || nonBlockDefault;
    }

    @Override
    public Map<String, String> getMasks() {
        return super.getMasks();
    }

    @Override
    public Collection<String> getDefaultValue(IAdaptable element) {
        View view = (View)element.getAdapter(View.class);
        if (view == null) {
            return super.getDefaultValue(element);
        }
        if (view.getType() != null && view.getType().contains("multiplicity")) {
            return Arrays.asList("multiplicity", "defaultMultiplicity");
        }
        if (view.getType() != null && view.getType().contains("role")) {
            return Arrays.asList("name", "visibility", "derived");
        }
        return super.getDefaultValue(element);
    }
}

