/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.core.services;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.ElementServices;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public final class TemplateBindingServices {
    public static final TemplateBindingServices INSTANCE = new TemplateBindingServices();

    private TemplateBindingServices() {
    }

    private ClassifierTemplateParameter createNewClassifierTemplateParameter(ParameterableElement context, TemplateSignature templateSignature, String newTemplateClassName) {
        ClassifierTemplateParameter result = UMLFactory.eINSTANCE.createClassifierTemplateParameter();
        Class newGenericClass = UMLFactory.eINSTANCE.createClass();
        newGenericClass.setName(newTemplateClassName);
        result.setOwnedDefault((ParameterableElement)newGenericClass);
        result.setParameteredElement((ParameterableElement)newGenericClass);
        templateSignature.getOwnedParameters().add((Object)result);
        return result;
    }

    public String parseInputLabel(TemplateBinding templateBinding, String inputLabel) {
        String result = inputLabel;
        String validLabel = "[a-zA-Z_0-9]+(\\s)*->(\\s)*[a-zA-Z_0-9\\?]+((\\s)*,(\\s)*[a-zA-Z_0-9]+(\\s)*->(\\s)*[a-zA-Z_0-9\\?]+)*";
        TemplateSignature templateSignature = templateBinding.getSignature();
        if (inputLabel.matches("[a-zA-Z_0-9]+(\\s)*->(\\s)*[a-zA-Z_0-9\\?]+((\\s)*,(\\s)*[a-zA-Z_0-9]+(\\s)*->(\\s)*[a-zA-Z_0-9\\?]+)*") && templateSignature != null) {
            String[] splittedSubstitutionLabels = inputLabel.split("(\\s)*,");
            int i = 0;
            EList paramSubstitutions = templateBinding.getParameterSubstitutions();
            String[] stringArray = splittedSubstitutionLabels;
            int n = splittedSubstitutionLabels.length;
            int n2 = 0;
            while (n2 < n) {
                String substitutionLabel = stringArray[n2];
                String[] substitutionArray = substitutionLabel.split("(\\s)*->(\\s)*");
                String formalLabel = substitutionArray[0].trim();
                String actualLabel = substitutionArray[1].trim();
                if (paramSubstitutions.size() <= i) break;
                TemplateParameterSubstitution templateParamSubstitution = (TemplateParameterSubstitution)paramSubstitutions.get(i);
                TemplateParameter formal = templateParamSubstitution.getFormal();
                if (formal == null) {
                    if (templateSignature.getOwnedParameters().size() > i) {
                        TemplateParameter templateParam = (TemplateParameter)templateSignature.getOwnedParameters().get(i);
                        templateParamSubstitution.setFormal(templateParam);
                    } else {
                        ClassifierTemplateParameter createTemplateParam = this.createNewClassifierTemplateParameter((ParameterableElement)templateSignature.getTemplate(), templateSignature, formalLabel);
                        templateParamSubstitution.setFormal((TemplateParameter)createTemplateParam);
                    }
                } else {
                    ParameterableElement ownedDefault = formal.getOwnedDefault();
                    if (ownedDefault instanceof NamedElement) {
                        ((NamedElement)ownedDefault).setName(formalLabel);
                    }
                }
                if ("?".equals(actualLabel)) {
                    templateParamSubstitution.setActual(null);
                } else {
                    Type foundType = ElementServices.INSTANCE.findTypeByName((EObject)templateBinding, actualLabel);
                    if (foundType != null) {
                        templateParamSubstitution.setActual((ParameterableElement)foundType);
                    }
                }
                ++i;
                ++n2;
            }
        }
        return result;
    }
}

