/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.rules.container;

import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.types.Activator;
import org.eclipse.papyrus.infra.emf.types.rules.container.HierarchyPermission;
import org.eclipse.papyrus.infra.emf.types.rules.container.InvariantContainerRuleConfiguration;
import org.eclipse.papyrus.infra.services.edit.context.TypeContext;
import org.eclipse.papyrus.infra.types.core.impl.ConfiguredHintedSpecializationElementType;
import org.eclipse.papyrus.infra.types.rulebased.core.AbstractRule;

public class InvariantContainerRule
extends AbstractRule<InvariantContainerRuleConfiguration> {
    protected boolean approveCreationRequest(ConfiguredHintedSpecializationElementType typeToCreate, CreateElementRequest request) {
        EObject newContainer = request.getContainer();
        return this.canContain(newContainer);
    }

    protected boolean approveSetRequest(ConfiguredHintedSpecializationElementType typeToMove, SetRequest request) {
        EObject newContainer = request.getElementToEdit();
        return this.canContain(newContainer);
    }

    protected boolean approveMoveRequest(ConfiguredHintedSpecializationElementType typeToMove, MoveRequest request) {
        EObject newContainer = request.getTargetContainer();
        return this.canContain(newContainer);
    }

    protected boolean canContain(EObject container) {
        if (container == null) {
            return false;
        }
        boolean isValid = false;
        try {
            IElementType newContainerElementType = ElementTypeRegistry.getInstance().getElementType(container, TypeContext.getContext((EObject)container));
            for (HierarchyPermission permission : ((InvariantContainerRuleConfiguration)this.invariantRuleConfiguration).getPermissions()) {
                boolean matchesSpecialization;
                IElementMatcher matcher;
                boolean isPermitted = permission.isPermitted();
                String permissionContainerTypeID = permission.getContainerType();
                boolean isStrict = permission.isStrict();
                IElementType permissionContainerType = ElementTypeRegistry.getInstance().getType(permissionContainerTypeID);
                if (permissionContainerType instanceof IMetamodelType) {
                    if (isStrict) {
                        isValid = permissionContainerType.equals(newContainerElementType) ? isPermitted : !isPermitted;
                        continue;
                    }
                    if (newContainerElementType.equals(permissionContainerType)) {
                        isValid = isPermitted;
                        continue;
                    }
                    isValid = Arrays.asList(newContainerElementType.getAllSuperTypes()).contains(permissionContainerType) ? isPermitted : !isPermitted;
                    continue;
                }
                if (!(permissionContainerType instanceof ISpecializationType) || (matcher = ((ISpecializationType)permissionContainerType).getMatcher()) == null) continue;
                boolean bl = matchesSpecialization = matcher.matches(container) && newContainerElementType.equals(((ISpecializationType)permissionContainerType).getMetamodelType());
                if (matchesSpecialization) {
                    if (isStrict) {
                        ISpecializationType[] subtypes = ElementTypeRegistry.getInstance().getSpecializationsOf(permissionContainerTypeID);
                        if (subtypes != null && subtypes.length > 0) {
                            ISpecializationType[] iSpecializationTypeArray = subtypes;
                            int n = subtypes.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ISpecializationType subType = iSpecializationTypeArray[n2];
                                isValid = subType.getMatcher().matches(container) ? isPermitted : !isPermitted;
                                ++n2;
                            }
                            continue;
                        }
                        isValid = isPermitted;
                        continue;
                    }
                    isValid = isPermitted;
                    continue;
                }
                boolean bl2 = isValid = !isPermitted;
            }
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return isValid;
    }

    public boolean matches(EObject eObject) {
        EObject container = eObject.eContainer();
        return this.canContain(container);
    }
}

