/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.tests;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.util.CompositeChangeDescription;
import org.eclipse.emf.workspace.CompositeEMFOperation;
import org.eclipse.emf.workspace.tests.AbstractEMFOperationTest;
import org.eclipse.emf.workspace.tests.AbstractTest;
import org.eclipse.emf.workspace.tests.fixtures.LibraryDefaultBookTrigger;
import org.eclipse.emf.workspace.tests.fixtures.LibraryDefaultNameTrigger;
import org.eclipse.emf.workspace.tests.fixtures.NonEMFCompositeOperation;
import org.eclipse.emf.workspace.tests.fixtures.NullOperation;
import org.eclipse.emf.workspace.tests.fixtures.TestOperation;
import org.eclipse.emf.workspace.tests.fixtures.TestUndoContext;

public class CompositeEMFOperationTest
extends AbstractTest {
    private static IStatus ERROR_STATUS = new Status(4, "bogus", 1, "no message", null);

    public CompositeEMFOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(CompositeEMFOperationTest.class, "Composite EMF Operation Tests");
    }

    public void test_contexts() {
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        UndoContext ctx1 = new UndoContext();
        UndoContext ctx2 = new UndoContext();
        UndoContext ctx3 = new UndoContext();
        NullOperation child1 = new NullOperation();
        NullOperation child2 = new NullOperation();
        NullOperation child3 = new NullOperation();
        child1.addContext((IUndoContext)ctx1);
        child2.addContext((IUndoContext)ctx2);
        child2.addContext((IUndoContext)ctx1);
        child3.addContext((IUndoContext)ctx3);
        CompositeEMFOperationTest.assertEquals((Object)Collections.EMPTY_LIST, Arrays.asList(composite.getContexts()));
        composite.add((IUndoableOperation)child1);
        CompositeEMFOperationTest.assertEquals(Arrays.asList(ctx1), Arrays.asList(composite.getContexts()));
        composite.add((IUndoableOperation)child2);
        CompositeEMFOperationTest.assertEquals(Arrays.asList(ctx1, ctx2), Arrays.asList(composite.getContexts()));
        composite.add((IUndoableOperation)child3);
        CompositeEMFOperationTest.assertEquals(Arrays.asList(ctx1, ctx2, ctx3), Arrays.asList(composite.getContexts()));
        composite.remove((IUndoableOperation)child2);
        CompositeEMFOperationTest.assertEquals(Arrays.asList(ctx1, ctx3), Arrays.asList(composite.getContexts()));
        composite.remove((IUndoableOperation)child1);
        CompositeEMFOperationTest.assertEquals(Arrays.asList(ctx3), Arrays.asList(composite.getContexts()));
        composite.remove((IUndoableOperation)child3);
        CompositeEMFOperationTest.assertEquals((Object)Collections.EMPTY_LIST, Arrays.asList(composite.getContexts()));
    }

    public void test_contexts_listIterator_125151() {
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        UndoContext ctx1 = new UndoContext();
        UndoContext ctx2 = new UndoContext();
        UndoContext ctx3 = new UndoContext();
        NullOperation child1 = new NullOperation();
        NullOperation child2 = new NullOperation();
        NullOperation child3 = new NullOperation();
        child1.addContext((IUndoContext)ctx1);
        child2.addContext((IUndoContext)ctx2);
        child2.addContext((IUndoContext)ctx1);
        child3.addContext((IUndoContext)ctx3);
        ListIterator iter = composite.listIterator();
        CompositeEMFOperationTest.assertEquals((Object)Collections.EMPTY_LIST, Arrays.asList(composite.getContexts()));
        iter.add(child1);
        CompositeEMFOperationTest.assertEquals(Arrays.asList(ctx1), Arrays.asList(composite.getContexts()));
        iter.add(child2);
        CompositeEMFOperationTest.assertEquals(Arrays.asList(ctx1, ctx2), Arrays.asList(composite.getContexts()));
        iter.add(child3);
        CompositeEMFOperationTest.assertEquals(Arrays.asList(ctx1, ctx2, ctx3), Arrays.asList(composite.getContexts()));
        iter.previous();
        iter.previous();
        iter.remove();
        CompositeEMFOperationTest.assertEquals(Arrays.asList(ctx1, ctx3), Arrays.asList(composite.getContexts()));
        iter.previous();
        iter.remove();
        CompositeEMFOperationTest.assertEquals(Arrays.asList(ctx3), Arrays.asList(composite.getContexts()));
        iter.next();
        iter.remove();
        CompositeEMFOperationTest.assertEquals((Object)Collections.EMPTY_LIST, Arrays.asList(composite.getContexts()));
    }

    public void test_canExecute() {
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        CompositeEMFOperation composite2 = new CompositeEMFOperation(this.domain, "Composite");
        composite.add((IUndoableOperation)new NullOperation());
        composite.add((IUndoableOperation)new NullOperation());
        composite.add((IUndoableOperation)composite2);
        composite.add((IUndoableOperation)new NullOperation());
        composite2.add((IUndoableOperation)new NullOperation());
        composite2.add((IUndoableOperation)new NullOperation(false));
        composite2.add((IUndoableOperation)new NullOperation());
        CompositeEMFOperationTest.assertFalse((boolean)composite.canExecute());
    }

    public void test_canUndo() {
        TestUndoContext ctx = new TestUndoContext();
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        CompositeEMFOperation composite2 = new CompositeEMFOperation(this.domain, "Composite");
        composite.add((IUndoableOperation)new NullOperation());
        composite.add((IUndoableOperation)new NullOperation());
        composite.add((IUndoableOperation)composite2);
        composite.add((IUndoableOperation)new NullOperation());
        composite2.add((IUndoableOperation)new NullOperation());
        composite2.add((IUndoableOperation)new NullOperation(true, false));
        composite2.add((IUndoableOperation)new NullOperation());
        composite.addContext((IUndoContext)ctx);
        CompositeEMFOperationTest.assertTrue((boolean)composite.canExecute());
        try {
            this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertFalse((boolean)composite.canUndo());
        CompositeEMFOperationTest.assertFalse((boolean)this.history.canUndo((IUndoContext)ctx));
    }

    public void test_canRedo() {
        TestUndoContext ctx = new TestUndoContext();
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        CompositeEMFOperation composite2 = new CompositeEMFOperation(this.domain, "Composite");
        composite.add((IUndoableOperation)new NullOperation());
        composite.add((IUndoableOperation)new NullOperation());
        composite.add((IUndoableOperation)composite2);
        composite.add((IUndoableOperation)new NullOperation());
        composite2.add((IUndoableOperation)new NullOperation());
        composite2.add((IUndoableOperation)new NullOperation(true, true, false));
        composite2.add((IUndoableOperation)new NullOperation());
        composite.addContext((IUndoContext)ctx);
        CompositeEMFOperationTest.assertTrue((boolean)composite.canExecute());
        try {
            this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertTrue((boolean)composite.canUndo());
        CompositeEMFOperationTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
        try {
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertFalse((boolean)composite.canRedo());
        CompositeEMFOperationTest.assertFalse((boolean)this.history.canRedo((IUndoContext)ctx));
    }

    public void test_execute_undo_redo() {
        this.startReading();
        final Book book = (Book)this.find("root/Root Book");
        CompositeEMFOperationTest.assertNotNull((Object)book);
        String oldTitle = book.getTitle();
        Writer oldAuthor = book.getAuthor();
        String newTitle = "New Title";
        final Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
        CompositeEMFOperationTest.assertNotNull((Object)newAuthor);
        this.commit();
        String[] externalData = new String[]{"..."};
        TestUndoContext ctx = new TestUndoContext();
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        composite.add((IUndoableOperation)new TestOperation(this.domain){

            @Override
            protected void doExecute() {
                book.setTitle("New Title");
            }
        });
        composite.add((IUndoableOperation)new ChangeExternalData(externalData, book));
        composite.add((IUndoableOperation)new TestOperation(this.domain){

            @Override
            protected void doExecute() {
                newAuthor.getBooks().add((Object)book);
            }
        });
        try {
            composite.addContext((IUndoContext)ctx);
            this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        CompositeEMFOperationTest.assertSame((Object)"New Title", (Object)book.getTitle());
        CompositeEMFOperationTest.assertEquals((String)"New Title", (String)externalData[0]);
        CompositeEMFOperationTest.assertSame((Object)newAuthor, (Object)book.getAuthor());
        this.commit();
        try {
            CompositeEMFOperationTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        CompositeEMFOperationTest.assertSame((Object)oldTitle, (Object)book.getTitle());
        CompositeEMFOperationTest.assertEquals((String)"...", (String)externalData[0]);
        CompositeEMFOperationTest.assertSame((Object)oldAuthor, (Object)book.getAuthor());
        this.commit();
        try {
            CompositeEMFOperationTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        CompositeEMFOperationTest.assertSame((Object)"New Title", (Object)book.getTitle());
        CompositeEMFOperationTest.assertEquals((String)"New Title", (String)externalData[0]);
        CompositeEMFOperationTest.assertSame((Object)newAuthor, (Object)book.getAuthor());
        this.commit();
    }

    public void test_execute_undo_redo_nested() {
        this.startReading();
        final Book book = (Book)this.find("root/Root Book");
        CompositeEMFOperationTest.assertNotNull((Object)book);
        String oldTitle = book.getTitle();
        Writer oldAuthor = book.getAuthor();
        String newTitle = "New Title";
        final Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
        CompositeEMFOperationTest.assertNotNull((Object)newAuthor);
        this.commit();
        String[] externalData = new String[]{"..."};
        String[] externalData2 = new String[]{":::"};
        TestUndoContext ctx = new TestUndoContext();
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        composite.add((IUndoableOperation)new TestOperation(this.domain){

            @Override
            protected void doExecute() {
                book.setTitle("New Title");
            }
        });
        composite.add((IUndoableOperation)new ChangeExternalData(externalData, book));
        NonEMFCompositeOperation composite2 = new NonEMFCompositeOperation();
        composite2.add((IUndoableOperation)new ChangeExternalData(externalData2, book));
        composite.add((IUndoableOperation)composite2);
        composite2.add((IUndoableOperation)new TestOperation(this.domain){

            @Override
            protected void doExecute() {
                newAuthor.getBooks().add((Object)book);
            }
        });
        try {
            composite.addContext((IUndoContext)ctx);
            this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        CompositeEMFOperationTest.assertSame((Object)"New Title", (Object)book.getTitle());
        CompositeEMFOperationTest.assertEquals((String)"New Title", (String)externalData[0]);
        CompositeEMFOperationTest.assertEquals((String)"New Title", (String)externalData2[0]);
        CompositeEMFOperationTest.assertSame((Object)newAuthor, (Object)book.getAuthor());
        this.commit();
        try {
            CompositeEMFOperationTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        CompositeEMFOperationTest.assertSame((Object)oldTitle, (Object)book.getTitle());
        CompositeEMFOperationTest.assertEquals((String)"...", (String)externalData[0]);
        CompositeEMFOperationTest.assertEquals((String)":::", (String)externalData2[0]);
        CompositeEMFOperationTest.assertSame((Object)oldAuthor, (Object)book.getAuthor());
        this.commit();
        try {
            CompositeEMFOperationTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        CompositeEMFOperationTest.assertSame((Object)"New Title", (Object)book.getTitle());
        CompositeEMFOperationTest.assertEquals((String)"New Title", (String)externalData[0]);
        CompositeEMFOperationTest.assertEquals((String)"New Title", (String)externalData2[0]);
        CompositeEMFOperationTest.assertSame((Object)newAuthor, (Object)book.getAuthor());
        this.commit();
    }

    public void test_rollback_nested() {
        IStatus status;
        String[] externalData2;
        String[] externalData;
        Writer oldAuthor;
        String oldTitle;
        Book book;
        block5: {
            this.startReading();
            book = (Book)this.find("root/Root Book");
            CompositeEMFOperationTest.assertNotNull((Object)book);
            oldTitle = book.getTitle();
            oldAuthor = book.getAuthor();
            final Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
            CompositeEMFOperationTest.assertNotNull((Object)newAuthor);
            this.commit();
            externalData = new String[]{"..."};
            externalData2 = new String[]{":::"};
            TestUndoContext ctx = new TestUndoContext();
            CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
            composite.add((IUndoableOperation)new TestOperation(this.domain){

                @Override
                protected void doExecute() {
                    newAuthor.getBooks().add((Object)book);
                }
            });
            composite.add((IUndoableOperation)new ChangeExternalData(externalData, book));
            NonEMFCompositeOperation composite2 = new NonEMFCompositeOperation();
            composite2.add((IUndoableOperation)new ChangeExternalData(externalData2, book));
            composite.add((IUndoableOperation)composite2);
            composite2.add((IUndoableOperation)new TestOperation(this.domain){

                @Override
                protected void doExecute() {
                    book.setTitle(null);
                }
            });
            status = null;
            try {
                try {
                    validationEnabled = true;
                    composite.addContext((IUndoContext)ctx);
                    status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    this.fail((Exception)((Object)e));
                    validationEnabled = false;
                    break block5;
                }
            }
            catch (Throwable throwable) {
                validationEnabled = false;
                throw throwable;
            }
            validationEnabled = false;
        }
        CompositeEMFOperationTest.assertNotNull(status);
        CompositeEMFOperationTest.assertNotNull((Object)this.findValidationStatus(status, 4));
        this.startReading();
        CompositeEMFOperationTest.assertSame((Object)oldAuthor, (Object)book.getAuthor());
        CompositeEMFOperationTest.assertEquals((String)oldTitle, (String)book.getTitle());
        CompositeEMFOperationTest.assertEquals((String)"...", (String)externalData[0]);
        CompositeEMFOperationTest.assertEquals((String)":::", (String)externalData2[0]);
        this.commit();
    }

    public void test_triggerCommands() {
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultNameTrigger());
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultBookTrigger());
        final Library[] newLibrary = new Library[1];
        String[] externalData = new String[]{"..."};
        TestUndoContext ctx = new TestUndoContext();
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        composite.add((IUndoableOperation)new TestOperation(this.domain){

            @Override
            protected void doExecute() {
                newLibrary[0] = EXTLibraryFactory.eINSTANCE.createLibrary();
                CompositeEMFOperationTest.this.root.getBranches().add((Object)newLibrary[0]);
                CompositeEMFOperationTest.assertNull((Object)newLibrary[0].getName());
                CompositeEMFOperationTest.assertTrue((boolean)newLibrary[0].getBooks().isEmpty());
            }
        });
        composite.add((IUndoableOperation)new ChangeExternalData(externalData, newLibrary));
        try {
            composite.addContext((IUndoContext)ctx);
            this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        CompositeEMFOperationTest.assertEquals((String)"New Library", (String)newLibrary[0].getName());
        CompositeEMFOperationTest.assertEquals((int)1, (int)newLibrary[0].getBooks().size());
        CompositeEMFOperationTest.assertEquals((String)"New Book", (String)((Book)newLibrary[0].getBooks().get(0)).getTitle());
        CompositeEMFOperationTest.assertEquals((String)"New Book", (String)externalData[0]);
        this.commit();
        try {
            CompositeEMFOperationTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        CompositeEMFOperationTest.assertFalse((boolean)this.root.getBranches().contains((Object)newLibrary[0]));
        CompositeEMFOperationTest.assertEquals((String)"...", (String)externalData[0]);
        CompositeEMFOperationTest.assertFalse((boolean)"New Library".equals(newLibrary[0].getName()));
        CompositeEMFOperationTest.assertEquals((int)0, (int)newLibrary[0].getBooks().size());
        this.commit();
        try {
            CompositeEMFOperationTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        CompositeEMFOperationTest.assertTrue((boolean)this.root.getBranches().contains((Object)newLibrary[0]));
        CompositeEMFOperationTest.assertEquals((String)"New Library", (String)newLibrary[0].getName());
        CompositeEMFOperationTest.assertEquals((int)1, (int)newLibrary[0].getBooks().size());
        CompositeEMFOperationTest.assertEquals((String)"New Book", (String)((Book)newLibrary[0].getBooks().get(0)).getTitle());
        CompositeEMFOperationTest.assertEquals((String)"New Book", (String)externalData[0]);
        this.commit();
    }

    public void test_triggerCommands_aggregate() {
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultNameTrigger(true));
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultBookTrigger(true));
        final Library[] newLibrary = new Library[1];
        TestUndoContext ctx = new TestUndoContext();
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        composite.add((IUndoableOperation)new TestOperation(this.domain){

            @Override
            protected void doExecute() {
                newLibrary[0] = EXTLibraryFactory.eINSTANCE.createLibrary();
                CompositeEMFOperationTest.this.root.getBranches().add((Object)newLibrary[0]);
                CompositeEMFOperationTest.assertNull((Object)newLibrary[0].getName());
                CompositeEMFOperationTest.assertTrue((boolean)newLibrary[0].getBooks().isEmpty());
            }
        });
        try {
            composite.addContext((IUndoContext)ctx);
            this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        CompositeEMFOperationTest.assertEquals((String)"New Library", (String)newLibrary[0].getName());
        CompositeEMFOperationTest.assertEquals((int)1, (int)newLibrary[0].getBooks().size());
        CompositeEMFOperationTest.assertEquals((String)"New Book", (String)((Book)newLibrary[0].getBooks().get(0)).getTitle());
        this.commit();
        try {
            CompositeEMFOperationTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        CompositeEMFOperationTest.assertFalse((boolean)this.root.getBranches().contains((Object)newLibrary[0]));
        CompositeEMFOperationTest.assertFalse((boolean)"New Library".equals(newLibrary[0].getName()));
        CompositeEMFOperationTest.assertEquals((int)0, (int)newLibrary[0].getBooks().size());
        this.commit();
        try {
            CompositeEMFOperationTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        CompositeEMFOperationTest.assertTrue((boolean)this.root.getBranches().contains((Object)newLibrary[0]));
        CompositeEMFOperationTest.assertEquals((String)"New Library", (String)newLibrary[0].getName());
        CompositeEMFOperationTest.assertEquals((int)1, (int)newLibrary[0].getBooks().size());
        CompositeEMFOperationTest.assertEquals((String)"New Book", (String)((Book)newLibrary[0].getBooks().get(0)).getTitle());
        this.commit();
    }

    public void test_validation() {
        IStatus status;
        String[] externalData;
        Writer oldAuthor;
        String oldTitle;
        Book book;
        block5: {
            this.startReading();
            book = (Book)this.find("root/Root Book");
            CompositeEMFOperationTest.assertNotNull((Object)book);
            oldTitle = book.getTitle();
            oldAuthor = book.getAuthor();
            final String newTitle = null;
            final Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
            CompositeEMFOperationTest.assertNotNull((Object)newAuthor);
            this.commit();
            externalData = new String[]{"..."};
            TestUndoContext ctx = new TestUndoContext();
            CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
            composite.add((IUndoableOperation)new TestOperation(this.domain){

                @Override
                protected void doExecute() {
                    book.setTitle(newTitle);
                }
            });
            composite.add((IUndoableOperation)new ChangeExternalData(externalData, book));
            composite.add((IUndoableOperation)new TestOperation(this.domain){

                @Override
                protected void doExecute() {
                    newAuthor.getBooks().add((Object)book);
                }
            });
            status = null;
            try {
                try {
                    validationEnabled = true;
                    composite.addContext((IUndoContext)ctx);
                    status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    this.fail((Exception)((Object)e));
                    validationEnabled = false;
                    break block5;
                }
            }
            catch (Throwable throwable) {
                validationEnabled = false;
                throw throwable;
            }
            validationEnabled = false;
        }
        CompositeEMFOperationTest.assertNotNull(status);
        CompositeEMFOperationTest.assertTrue((boolean)status.matches(4));
        status = this.findValidationStatus(status, 4);
        CompositeEMFOperationTest.assertNotNull((Object)status);
        this.startReading();
        CompositeEMFOperationTest.assertSame((Object)oldTitle, (Object)book.getTitle());
        CompositeEMFOperationTest.assertEquals((String)"...", (String)externalData[0]);
        CompositeEMFOperationTest.assertSame((Object)oldAuthor, (Object)book.getAuthor());
        this.commit();
    }

    public void test_execute_error_123614() {
        TestUndoContext ctx = new TestUndoContext();
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        MarkerOperation marker1 = new MarkerOperation();
        composite.add((IUndoableOperation)marker1);
        FailCancelOperation op = new FailCancelOperation(ERROR_STATUS, Status.OK_STATUS, Status.OK_STATUS, false);
        composite.add((IUndoableOperation)op);
        MarkerOperation marker2 = new MarkerOperation();
        composite.add((IUndoableOperation)marker2);
        IStatus status = null;
        try {
            composite.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasExecuted);
        CompositeEMFOperationTest.assertFalse((boolean)marker2.wasExecuted);
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasUndone);
        CompositeEMFOperationTest.assertEquals((int)4, (int)status.getSeverity());
    }

    public void test_execute_cancel_123614() {
        TestUndoContext ctx = new TestUndoContext();
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        MarkerOperation marker1 = new MarkerOperation();
        composite.add((IUndoableOperation)marker1);
        FailCancelOperation op = new FailCancelOperation(Status.CANCEL_STATUS, Status.OK_STATUS, Status.OK_STATUS, false);
        composite.add((IUndoableOperation)op);
        MarkerOperation marker2 = new MarkerOperation();
        composite.add((IUndoableOperation)marker2);
        IStatus status = null;
        try {
            composite.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasExecuted);
        CompositeEMFOperationTest.assertFalse((boolean)marker2.wasExecuted);
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasUndone);
        CompositeEMFOperationTest.assertEquals((int)8, (int)status.getSeverity());
    }

    public void test_execute_cancelMonitor_123614() {
        TestUndoContext ctx = new TestUndoContext();
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        MarkerOperation marker1 = new MarkerOperation();
        composite.add((IUndoableOperation)marker1);
        FailCancelOperation op = new FailCancelOperation(Status.CANCEL_STATUS, Status.OK_STATUS, Status.OK_STATUS, true);
        composite.add((IUndoableOperation)op);
        MarkerOperation marker2 = new MarkerOperation();
        composite.add((IUndoableOperation)marker2);
        IStatus status = null;
        try {
            composite.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasExecuted);
        CompositeEMFOperationTest.assertFalse((boolean)marker2.wasExecuted);
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasUndone);
        CompositeEMFOperationTest.assertEquals((int)8, (int)status.getSeverity());
    }

    public void test_undo_error_123614() {
        TestUndoContext ctx = new TestUndoContext();
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        MarkerOperation marker1 = new MarkerOperation();
        composite.add((IUndoableOperation)marker1);
        FailCancelOperation op = new FailCancelOperation(Status.OK_STATUS, ERROR_STATUS, Status.OK_STATUS, false);
        composite.add((IUndoableOperation)op);
        MarkerOperation marker2 = new MarkerOperation();
        composite.add((IUndoableOperation)marker2);
        IStatus status = null;
        try {
            composite.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasExecuted);
        CompositeEMFOperationTest.assertTrue((boolean)marker2.wasExecuted);
        CompositeEMFOperationTest.assertFalse((boolean)marker1.wasUndone);
        CompositeEMFOperationTest.assertEquals((int)0, (int)status.getSeverity());
        marker1.reset();
        marker2.reset();
        try {
            status = this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertFalse((boolean)marker1.wasUndone);
        CompositeEMFOperationTest.assertTrue((boolean)marker2.wasUndone);
        CompositeEMFOperationTest.assertTrue((boolean)marker2.wasRedone);
        CompositeEMFOperationTest.assertEquals((int)4, (int)status.getSeverity());
    }

    public void test_undo_cancel_123614() {
        TestUndoContext ctx = new TestUndoContext();
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        MarkerOperation marker1 = new MarkerOperation();
        composite.add((IUndoableOperation)marker1);
        FailCancelOperation op = new FailCancelOperation(Status.OK_STATUS, Status.CANCEL_STATUS, Status.OK_STATUS, false);
        composite.add((IUndoableOperation)op);
        MarkerOperation marker2 = new MarkerOperation();
        composite.add((IUndoableOperation)marker2);
        IStatus status = null;
        try {
            composite.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasExecuted);
        CompositeEMFOperationTest.assertTrue((boolean)marker2.wasExecuted);
        CompositeEMFOperationTest.assertFalse((boolean)marker1.wasUndone);
        CompositeEMFOperationTest.assertEquals((int)0, (int)status.getSeverity());
        marker1.reset();
        marker2.reset();
        try {
            status = this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertFalse((boolean)marker1.wasUndone);
        CompositeEMFOperationTest.assertTrue((boolean)marker2.wasUndone);
        CompositeEMFOperationTest.assertTrue((boolean)marker2.wasRedone);
        CompositeEMFOperationTest.assertEquals((int)8, (int)status.getSeverity());
    }

    public void test_undo_cancelMonitor_123614() {
        TestUndoContext ctx = new TestUndoContext();
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        MarkerOperation marker1 = new MarkerOperation();
        composite.add((IUndoableOperation)marker1);
        FailCancelOperation op = new FailCancelOperation(Status.OK_STATUS, Status.CANCEL_STATUS, Status.OK_STATUS, true);
        composite.add((IUndoableOperation)op);
        MarkerOperation marker2 = new MarkerOperation();
        composite.add((IUndoableOperation)marker2);
        IStatus status = null;
        try {
            composite.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasExecuted);
        CompositeEMFOperationTest.assertTrue((boolean)marker2.wasExecuted);
        CompositeEMFOperationTest.assertFalse((boolean)marker1.wasUndone);
        CompositeEMFOperationTest.assertEquals((int)0, (int)status.getSeverity());
        marker1.reset();
        marker2.reset();
        try {
            status = this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertFalse((boolean)marker1.wasUndone);
        CompositeEMFOperationTest.assertTrue((boolean)marker2.wasUndone);
        CompositeEMFOperationTest.assertTrue((boolean)marker2.wasRedone);
        CompositeEMFOperationTest.assertEquals((int)8, (int)status.getSeverity());
    }

    public void test_redo_error_123614() {
        TestUndoContext ctx = new TestUndoContext();
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        MarkerOperation marker1 = new MarkerOperation();
        composite.add((IUndoableOperation)marker1);
        FailCancelOperation op = new FailCancelOperation(Status.OK_STATUS, Status.OK_STATUS, ERROR_STATUS, false);
        composite.add((IUndoableOperation)op);
        MarkerOperation marker2 = new MarkerOperation();
        composite.add((IUndoableOperation)marker2);
        IStatus status = null;
        try {
            composite.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasExecuted);
        CompositeEMFOperationTest.assertTrue((boolean)marker2.wasExecuted);
        CompositeEMFOperationTest.assertFalse((boolean)marker1.wasUndone);
        CompositeEMFOperationTest.assertEquals((int)0, (int)status.getSeverity());
        marker1.reset();
        marker2.reset();
        try {
            status = this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasUndone);
        CompositeEMFOperationTest.assertTrue((boolean)marker2.wasUndone);
        CompositeEMFOperationTest.assertFalse((boolean)marker2.wasRedone);
        CompositeEMFOperationTest.assertEquals((int)0, (int)status.getSeverity());
        marker1.reset();
        marker2.reset();
        try {
            status = this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasRedone);
        CompositeEMFOperationTest.assertFalse((boolean)marker2.wasRedone);
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasUndone);
        CompositeEMFOperationTest.assertEquals((int)4, (int)status.getSeverity());
    }

    public void test_redo_cancel_123614() {
        TestUndoContext ctx = new TestUndoContext();
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        MarkerOperation marker1 = new MarkerOperation();
        composite.add((IUndoableOperation)marker1);
        FailCancelOperation op = new FailCancelOperation(Status.OK_STATUS, Status.OK_STATUS, Status.CANCEL_STATUS, false);
        composite.add((IUndoableOperation)op);
        MarkerOperation marker2 = new MarkerOperation();
        composite.add((IUndoableOperation)marker2);
        IStatus status = null;
        try {
            composite.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasExecuted);
        CompositeEMFOperationTest.assertTrue((boolean)marker2.wasExecuted);
        CompositeEMFOperationTest.assertFalse((boolean)marker1.wasUndone);
        CompositeEMFOperationTest.assertEquals((int)0, (int)status.getSeverity());
        marker1.reset();
        marker2.reset();
        try {
            status = this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasUndone);
        CompositeEMFOperationTest.assertTrue((boolean)marker2.wasUndone);
        CompositeEMFOperationTest.assertFalse((boolean)marker2.wasRedone);
        CompositeEMFOperationTest.assertEquals((int)0, (int)status.getSeverity());
        marker1.reset();
        marker2.reset();
        try {
            status = this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasRedone);
        CompositeEMFOperationTest.assertFalse((boolean)marker2.wasRedone);
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasUndone);
        CompositeEMFOperationTest.assertEquals((int)8, (int)status.getSeverity());
    }

    public void test_redo_cancelMonitor_123614() {
        TestUndoContext ctx = new TestUndoContext();
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        MarkerOperation marker1 = new MarkerOperation();
        composite.add((IUndoableOperation)marker1);
        FailCancelOperation op = new FailCancelOperation(Status.OK_STATUS, Status.OK_STATUS, Status.CANCEL_STATUS, true);
        composite.add((IUndoableOperation)op);
        MarkerOperation marker2 = new MarkerOperation();
        composite.add((IUndoableOperation)marker2);
        IStatus status = null;
        try {
            composite.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasExecuted);
        CompositeEMFOperationTest.assertTrue((boolean)marker2.wasExecuted);
        CompositeEMFOperationTest.assertFalse((boolean)marker1.wasUndone);
        CompositeEMFOperationTest.assertEquals((int)0, (int)status.getSeverity());
        marker1.reset();
        marker2.reset();
        try {
            status = this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasUndone);
        CompositeEMFOperationTest.assertTrue((boolean)marker2.wasUndone);
        CompositeEMFOperationTest.assertFalse((boolean)marker2.wasRedone);
        CompositeEMFOperationTest.assertEquals((int)0, (int)status.getSeverity());
        marker1.reset();
        marker2.reset();
        try {
            status = this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasRedone);
        CompositeEMFOperationTest.assertFalse((boolean)marker2.wasRedone);
        CompositeEMFOperationTest.assertTrue((boolean)marker1.wasUndone);
        CompositeEMFOperationTest.assertEquals((int)8, (int)status.getSeverity());
    }

    public void test_noTransactionNesting_pureEMF_135545() {
        TransactionCapture capture = new TransactionCapture();
        this.domain.addResourceSetListener((ResourceSetListener)capture);
        this.startReading();
        int originalBranchCount = this.root.getBranches().size();
        this.commit();
        TestUndoContext ctx = new TestUndoContext();
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        composite.setTransactionNestingEnabled(false);
        composite.add((IUndoableOperation)new TestOperation(this.domain){

            @Override
            protected void doExecute() {
                CompositeEMFOperationTest.this.root.getBranches().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
            }
        });
        CompositeEMFOperation nestedComposite = new CompositeEMFOperation(this.domain, "Nested");
        nestedComposite.add((IUndoableOperation)new TestOperation(this.domain){

            @Override
            protected void doExecute() {
                CompositeEMFOperationTest.this.root.getBranches().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
            }
        });
        nestedComposite.add((IUndoableOperation)new TestOperation(this.domain){

            @Override
            protected void doExecute() {
                CompositeEMFOperationTest.this.root.getBranches().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
            }
        });
        composite.add((IUndoableOperation)nestedComposite);
        try {
            composite.addContext((IUndoContext)ctx);
            this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        Transaction transaction = capture.getTransaction();
        CompositeEMFOperationTest.assertNotNull((Object)transaction);
        Collection<ChangeDescription> changes = this.getChanges(transaction);
        CompositeEMFOperationTest.assertEquals((int)1, (int)changes.size());
        capture.clear();
        this.startReading();
        CompositeEMFOperationTest.assertEquals((int)(originalBranchCount + 3), (int)this.root.getBranches().size());
        this.commit();
        try {
            CompositeEMFOperationTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        transaction = capture.getTransaction();
        CompositeEMFOperationTest.assertNotNull((Object)transaction);
        changes = this.getChanges(transaction);
        CompositeEMFOperationTest.assertEquals((int)0, (int)changes.size());
        this.startReading();
        CompositeEMFOperationTest.assertEquals((int)originalBranchCount, (int)this.root.getBranches().size());
        this.commit();
        try {
            CompositeEMFOperationTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        transaction = capture.getTransaction();
        CompositeEMFOperationTest.assertNotNull((Object)transaction);
        changes = this.getChanges(transaction);
        CompositeEMFOperationTest.assertEquals((int)0, (int)changes.size());
        this.startReading();
        CompositeEMFOperationTest.assertEquals((int)(originalBranchCount + 3), (int)this.root.getBranches().size());
        this.commit();
    }

    public void test_noTransactionNesting_mixed_135545() {
        TransactionCapture capture = new TransactionCapture();
        this.domain.addResourceSetListener((ResourceSetListener)capture);
        this.startReading();
        int originalBranchCount = this.root.getBranches().size();
        Book book = (Book)this.find("root/Root Book");
        String title = book.getTitle();
        this.commit();
        String[] externalData = new String[]{"..."};
        TestUndoContext ctx = new TestUndoContext();
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        composite.setTransactionNestingEnabled(false);
        composite.add((IUndoableOperation)new TestOperation(this.domain){

            @Override
            protected void doExecute() {
                CompositeEMFOperationTest.this.root.getBranches().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
            }
        });
        CompositeEMFOperation nestedComposite = new CompositeEMFOperation(this.domain, "Nested");
        nestedComposite.add((IUndoableOperation)new ChangeExternalData(externalData, book));
        nestedComposite.add((IUndoableOperation)new TestOperation(this.domain){

            @Override
            protected void doExecute() {
                CompositeEMFOperationTest.this.root.getBranches().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
            }
        });
        nestedComposite.add((IUndoableOperation)new TestOperation(this.domain){

            @Override
            protected void doExecute() {
                CompositeEMFOperationTest.this.root.getBranches().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
            }
        });
        composite.add((IUndoableOperation)nestedComposite);
        try {
            composite.addContext((IUndoContext)ctx);
            this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        Transaction transaction = capture.getTransaction();
        CompositeEMFOperationTest.assertNotNull((Object)transaction);
        Collection<ChangeDescription> changes = this.getChanges(transaction);
        CompositeEMFOperationTest.assertEquals((int)3, (int)changes.size());
        capture.clear();
        this.startReading();
        CompositeEMFOperationTest.assertEquals((int)(originalBranchCount + 3), (int)this.root.getBranches().size());
        CompositeEMFOperationTest.assertEquals((String)title, (String)externalData[0]);
        this.commit();
        try {
            CompositeEMFOperationTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        transaction = capture.getTransaction();
        CompositeEMFOperationTest.assertNotNull((Object)transaction);
        changes = this.getChanges(transaction);
        CompositeEMFOperationTest.assertEquals((int)0, (int)changes.size());
        this.startReading();
        CompositeEMFOperationTest.assertEquals((int)originalBranchCount, (int)this.root.getBranches().size());
        CompositeEMFOperationTest.assertEquals((String)"...", (String)externalData[0]);
        this.commit();
        try {
            CompositeEMFOperationTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        transaction = capture.getTransaction();
        CompositeEMFOperationTest.assertNotNull((Object)transaction);
        changes = this.getChanges(transaction);
        CompositeEMFOperationTest.assertEquals((int)0, (int)changes.size());
        this.startReading();
        CompositeEMFOperationTest.assertEquals((int)(originalBranchCount + 3), (int)this.root.getBranches().size());
        CompositeEMFOperationTest.assertEquals((String)title, (String)externalData[0]);
        this.commit();
    }

    public void test_noTransactionNesting_differentOptions_135545() {
        TransactionCapture capture = new TransactionCapture();
        this.domain.addResourceSetListener((ResourceSetListener)capture);
        this.startReading();
        int originalBranchCount = this.root.getBranches().size();
        this.commit();
        TestUndoContext ctx = new TestUndoContext();
        CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
        composite.setTransactionNestingEnabled(false);
        composite.add((IUndoableOperation)new TestOperation(this.domain){

            @Override
            protected void doExecute() {
                CompositeEMFOperationTest.this.root.getBranches().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
            }
        });
        CompositeEMFOperation nestedComposite = new CompositeEMFOperation(this.domain, "Nested");
        nestedComposite.add((IUndoableOperation)new TestOperation(this.domain, Collections.singletonMap("silent", Boolean.TRUE)){

            @Override
            protected void doExecute() {
                CompositeEMFOperationTest.this.root.getBranches().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
            }
        });
        nestedComposite.add((IUndoableOperation)new TestOperation(this.domain){

            @Override
            protected void doExecute() {
                CompositeEMFOperationTest.this.root.getBranches().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
            }
        });
        nestedComposite.add((IUndoableOperation)new TestOperation(this.domain){

            @Override
            protected void doExecute() {
                CompositeEMFOperationTest.this.root.getBranches().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
            }
        });
        composite.add((IUndoableOperation)nestedComposite);
        try {
            composite.addContext((IUndoContext)ctx);
            this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        Transaction transaction = capture.getTransaction();
        CompositeEMFOperationTest.assertNotNull((Object)transaction);
        Collection<ChangeDescription> changes = this.getChanges(transaction);
        CompositeEMFOperationTest.assertEquals((int)3, (int)changes.size());
        capture.clear();
        this.startReading();
        CompositeEMFOperationTest.assertEquals((int)(originalBranchCount + 4), (int)this.root.getBranches().size());
        this.commit();
        try {
            CompositeEMFOperationTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        transaction = capture.getTransaction();
        CompositeEMFOperationTest.assertNotNull((Object)transaction);
        changes = this.getChanges(transaction);
        CompositeEMFOperationTest.assertEquals((int)0, (int)changes.size());
        this.startReading();
        CompositeEMFOperationTest.assertEquals((int)originalBranchCount, (int)this.root.getBranches().size());
        this.commit();
        try {
            CompositeEMFOperationTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        transaction = capture.getTransaction();
        CompositeEMFOperationTest.assertNotNull((Object)transaction);
        changes = this.getChanges(transaction);
        CompositeEMFOperationTest.assertEquals((int)0, (int)changes.size());
        this.startReading();
        CompositeEMFOperationTest.assertEquals((int)(originalBranchCount + 4), (int)this.root.getBranches().size());
        this.commit();
    }

    public void test_errorInNestedAEO_transactionNesting_250253() {
        AbstractEMFOperationTest.RollbackListener l = new AbstractEMFOperationTest.RollbackListener();
        l.install(this.domain);
        try {
            this.startReading();
            int originalBranchCount = this.root.getBranches().size();
            final Library[] shouldNotCreate = new Library[1];
            this.commit();
            TestUndoContext ctx = new TestUndoContext();
            CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
            composite.add((IUndoableOperation)new TestOperation(this.domain){

                @Override
                protected void doExecute() {
                    CompositeEMFOperationTest.this.root.getBranches().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
                }
            });
            composite.add((IUndoableOperation)new TestOperation(this.domain){

                @Override
                protected void doExecute() {
                    CompositeEMFOperationTest.this.root.getBranches().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
                    this.setStatus((IStatus)new Status(4, "org.eclipse.emf.workspace.tests", "I want to fail"));
                }
            });
            composite.add((IUndoableOperation)new TestOperation(this.domain){

                @Override
                protected void doExecute() {
                    shouldNotCreate[0] = EXTLibraryFactory.eINSTANCE.createLibrary();
                    CompositeEMFOperationTest.this.root.getBranches().add((Object)shouldNotCreate[0]);
                }
            });
            try {
                composite.addContext((IUndoContext)ctx);
                this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                this.fail((Exception)((Object)e));
            }
            l.assertRolledBack();
            this.startReading();
            CompositeEMFOperationTest.assertEquals((int)originalBranchCount, (int)this.root.getBranches().size());
            CompositeEMFOperationTest.assertNull((String)"Executed the third child command", (Object)shouldNotCreate[0]);
            this.commit();
        }
        finally {
            l.uninstall(this.domain);
        }
    }

    public void test_errorInNestedAEO_noTransactionNesting_250253() {
        AbstractEMFOperationTest.RollbackListener l = new AbstractEMFOperationTest.RollbackListener();
        l.install(this.domain);
        try {
            this.startReading();
            int originalBranchCount = this.root.getBranches().size();
            final Library[] shouldNotCreate = new Library[1];
            this.commit();
            TestUndoContext ctx = new TestUndoContext();
            CompositeEMFOperation composite = new CompositeEMFOperation(this.domain, "Composite");
            composite.setTransactionNestingEnabled(false);
            composite.add((IUndoableOperation)new TestOperation(this.domain){

                @Override
                protected void doExecute() {
                    CompositeEMFOperationTest.this.root.getBranches().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
                }
            });
            composite.add((IUndoableOperation)new TestOperation(this.domain){

                @Override
                protected void doExecute() {
                    CompositeEMFOperationTest.this.root.getBranches().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
                    this.setStatus((IStatus)new Status(4, "org.eclipse.emf.workspace.tests", "I want to fail"));
                }
            });
            composite.add((IUndoableOperation)new TestOperation(this.domain){

                @Override
                protected void doExecute() {
                    shouldNotCreate[0] = EXTLibraryFactory.eINSTANCE.createLibrary();
                    CompositeEMFOperationTest.this.root.getBranches().add((Object)shouldNotCreate[0]);
                }
            });
            try {
                composite.addContext((IUndoContext)ctx);
                this.history.execute((IUndoableOperation)composite, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                this.fail((Exception)((Object)e));
            }
            l.assertRolledBack();
            this.startReading();
            CompositeEMFOperationTest.assertEquals((int)originalBranchCount, (int)this.root.getBranches().size());
            CompositeEMFOperationTest.assertNull((String)"Executed the third child command", (Object)shouldNotCreate[0]);
            this.commit();
        }
        finally {
            l.uninstall(this.domain);
        }
    }

    private Collection<ChangeDescription> getChanges(Transaction tx) {
        Collection result = null;
        CompositeChangeDescription composite = (CompositeChangeDescription)tx.getChangeDescription();
        try {
            Field changes = composite.getClass().getDeclaredField("changes");
            changes.setAccessible(true);
            result = (Collection)changes.get(composite);
        }
        catch (Exception e) {
            CompositeEMFOperationTest.fail((String)("Could not access private changes field of CompositeChangeDescription: " + e.getLocalizedMessage()));
        }
        return result;
    }

    private static class ChangeExternalData
    extends AbstractOperation {
        private final String[] externalData;
        private Book book;
        private Library[] library;
        private String oldData;

        ChangeExternalData(String[] externalData, Book book) {
            super("Change External Data");
            this.externalData = externalData;
            this.book = book;
        }

        ChangeExternalData(String[] externalData, Library[] library) {
            super("Change External Data");
            this.externalData = externalData;
            this.library = library;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.oldData = this.externalData[0];
            if (this.book == null) {
                this.book = (Book)this.library[0].getBooks().get(0);
            }
            this.externalData[0] = this.book.getTitle();
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.externalData[0] = this.oldData;
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.externalData[0] = this.book.getTitle();
            return Status.OK_STATUS;
        }
    }

    private static class FailCancelOperation
    extends AbstractOperation {
        private final IStatus executeStatus;
        private final IStatus undoStatus;
        private final IStatus redoStatus;
        private final boolean cancelMonitor;

        FailCancelOperation(IStatus exec, IStatus undo, IStatus redo, boolean cancel) {
            super("Fail/Cancel Operation");
            this.executeStatus = exec;
            this.undoStatus = undo;
            this.redoStatus = redo;
            this.cancelMonitor = cancel;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.executeStatus.getSeverity() == 8 && this.cancelMonitor) {
                monitor.setCanceled(true);
                return Status.OK_STATUS;
            }
            return this.executeStatus;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.undoStatus.getSeverity() == 8 && this.cancelMonitor) {
                monitor.setCanceled(true);
                return Status.OK_STATUS;
            }
            return this.undoStatus;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.redoStatus.getSeverity() == 8 && this.cancelMonitor) {
                monitor.setCanceled(true);
                return Status.OK_STATUS;
            }
            return this.redoStatus;
        }
    }

    static class MarkerOperation
    extends AbstractOperation {
        boolean wasExecuted;
        boolean wasUndone;
        boolean wasRedone;

        MarkerOperation() {
            super("Marker operation");
        }

        void reset() {
            this.wasExecuted = false;
            this.wasUndone = false;
            this.wasRedone = false;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.wasExecuted = true;
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.wasUndone = true;
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.wasRedone = true;
            return Status.OK_STATUS;
        }
    }

    private static class TransactionCapture
    extends ResourceSetListenerImpl {
        private Transaction transaction;

        private TransactionCapture() {
        }

        public boolean isPostcommitOnly() {
            return true;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            if (this.transaction == null) {
                this.transaction = event.getTransaction();
            }
        }

        void clear() {
            this.transaction = null;
        }

        Transaction getTransaction() {
            return this.transaction;
        }
    }
}

