/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum StreamMode implements Enumerator
{
    DEVELOPMENT(0, "Development", "Development"),
    MAINTENANCE(1, "Maintenance", "Maintenance"),
    CLOSED(2, "Closed", "Closed");

    public static final int DEVELOPMENT_VALUE = 0;
    public static final int MAINTENANCE_VALUE = 1;
    public static final int CLOSED_VALUE = 2;
    private static final StreamMode[] VALUES_ARRAY;
    public static final List<StreamMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new StreamMode[]{DEVELOPMENT, MAINTENANCE, CLOSED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static StreamMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StreamMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StreamMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StreamMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StreamMode get(int value) {
        switch (value) {
            case 0: {
                return DEVELOPMENT;
            }
            case 1: {
                return MAINTENANCE;
            }
            case 2: {
                return CLOSED;
            }
        }
        return null;
    }

    private StreamMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

