/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.mongodb;

import com.mongodb.DBObject;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.internal.mongodb.MongoDBStore;
import org.eclipse.emf.cdo.server.mongodb.IMongoDBStore;
import org.eclipse.emf.cdo.spi.server.LongIDStore;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public interface IDHandler
extends Comparator<CDOID> {
    public IMongoDBStore getStore();

    public Set<CDOID.ObjectType> getObjectIDTypes();

    public CDOID getMinCDOID();

    public CDOID getMaxCDOID();

    public boolean isLocalCDOID(CDOID var1);

    public CDOID getNextCDOID(CDORevision var1);

    public CDOID createCDOID(String var1);

    public CDOID getNextLocalObjectID();

    public void setNextLocalObjectID(CDOID var1);

    public CDOID getLastObjectID();

    public void setLastObjectID(CDOID var1);

    public void write(DBObject var1, String var2, CDOID var3);

    public CDOID read(DBObject var1, String var2);

    public Object toValue(CDOID var1);

    public CDOID fromValue(Object var1);

    public static class LongValue
    extends Lifecycle
    implements IDHandler {
        public static final CDOID MIN = CDOID.NULL;
        public static final CDOID MAX = LongValue.create(Long.MAX_VALUE);
        private MongoDBStore store;
        private CDOID lastObjectID = MIN;
        private CDOID nextLocalObjectID = MAX;

        public LongValue(MongoDBStore store) {
            this.store = store;
        }

        @Override
        public MongoDBStore getStore() {
            return this.store;
        }

        @Override
        public Set<CDOID.ObjectType> getObjectIDTypes() {
            return LongIDStore.OBJECT_ID_TYPES;
        }

        @Override
        public CDOID getMinCDOID() {
            return MIN;
        }

        @Override
        public CDOID getMaxCDOID() {
            return MAX;
        }

        @Override
        public int compare(CDOID id1, CDOID id2) {
            return id1.compareTo((Object)id2);
        }

        @Override
        public CDOID createCDOID(String val) {
            Long id = Long.valueOf(val);
            return LongValue.create(id);
        }

        @Override
        public synchronized CDOID getLastObjectID() {
            return this.lastObjectID;
        }

        @Override
        public synchronized void setLastObjectID(CDOID lastObjectID) {
            this.lastObjectID = lastObjectID;
        }

        @Override
        public synchronized CDOID getNextLocalObjectID() {
            return this.nextLocalObjectID;
        }

        @Override
        public synchronized void setNextLocalObjectID(CDOID nextLocalObjectID) {
            this.nextLocalObjectID = nextLocalObjectID;
        }

        @Override
        public synchronized CDOID getNextCDOID(CDORevision revision) {
            if (revision.getBranch().isLocal()) {
                CDOID result = this.nextLocalObjectID;
                this.nextLocalObjectID = LongValue.create(LongValue.value(result) - 1L);
                return result;
            }
            this.lastObjectID = LongValue.create(LongValue.value(this.lastObjectID) + 1L);
            return this.lastObjectID;
        }

        @Override
        public boolean isLocalCDOID(CDOID id) {
            return this.compare(id, this.nextLocalObjectID) > 0;
        }

        private static CDOID create(long id) {
            return CDOIDUtil.createLong((long)id);
        }

        private static long value(CDOID id) {
            return CDOIDUtil.getLong((CDOID)id);
        }

        @Override
        public void write(DBObject doc, String key, CDOID id) {
            long value = this.toValue(id);
            doc.put(key, (Object)value);
        }

        @Override
        public CDOID read(DBObject doc, String key) {
            long value = (Long)doc.get(key);
            return this.fromValue(value);
        }

        @Override
        public Long toValue(CDOID id) {
            return CDOIDUtil.getLong((CDOID)id);
        }

        @Override
        public CDOID fromValue(Object value) {
            return CDOIDUtil.createLong((long)((Long)value));
        }
    }
}

