/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;

public class StatementBatcher
extends Notifier
implements AutoCloseable,
Consumer<String> {
    private final Connection connection;
    private final int batchSize;
    private final List<String> batchedSQL = new ArrayList<String>();
    private Statement statement;
    private int totalUpdateCount;

    public StatementBatcher(Connection connection) {
        this(connection, DBUtil.MAX_BATCH_SIZE);
    }

    public StatementBatcher(Connection connection, int batchSize) {
        this.connection = connection;
        this.batchSize = batchSize;
    }

    public final Connection getConnection() {
        return this.connection;
    }

    public final Statement getStatement() {
        return this.statement;
    }

    public final int getBatchSize() {
        return this.batchSize;
    }

    public final int getBatchCount() {
        return this.batchedSQL.size();
    }

    public final int getTotalUpdateCount() {
        return this.totalUpdateCount;
    }

    @Override
    public final void accept(String sql) {
        this.batch(sql);
    }

    public int batch(String sql) {
        this.fireEvent((IEvent)new BatchEvent(this, sql));
        try {
            this.ensureStatement().addBatch(sql);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
        this.batchedSQL.add(sql);
        if (this.getBatchCount() >= this.batchSize) {
            return this.doExecuteBatch();
        }
        return 0;
    }

    public final boolean isClosed() {
        try {
            return this.statement != null && this.statement.isClosed();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            if (this.statement != null) {
                try {
                    if (this.getBatchCount() != 0) {
                        this.doExecuteBatch();
                    }
                }
                finally {
                    DBUtil.close(this.statement);
                }
            }
            this.fireEvent((IEvent)new CloseEvent(this, this.totalUpdateCount));
        }
    }

    protected final Statement ensureStatement() throws SQLException {
        if (this.statement == null) {
            this.statement = this.connection.createStatement();
        }
        return this.statement;
    }

    protected final int doExecuteBatch() {
        int[] updateCounts;
        int sum = 0;
        try {
            updateCounts = this.statement.executeBatch();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
        IListener[] listeners = this.getListeners();
        int i = 0;
        while (i < updateCounts.length) {
            String sql;
            int updateCount = updateCounts[i];
            if (updateCount != -2) {
                if (updateCount < 0) {
                    sql = this.batchedSQL.get(i);
                    throw new DBException("Batch statement " + i + " was not successful: " + updateCount + "  [" + sql + "]");
                }
                sum += updateCount;
                this.totalUpdateCount += updateCount;
            }
            if (listeners.length != 0) {
                sql = this.batchedSQL.get(i);
                this.fireEvent((IEvent)new ResultEvent(this, sql, updateCount, this.totalUpdateCount));
            }
            ++i;
        }
        return sum;
    }

    public static final class BatchEvent
    extends Event {
        private static final long serialVersionUID = 1L;
        private final String sql;

        private BatchEvent(StatementBatcher batcher, String sql) {
            super((INotifier)batcher);
            this.sql = sql;
        }

        public String getSQL() {
            return this.sql;
        }

        public String toString() {
            return this.sql;
        }
    }

    public static final class CloseEvent
    extends Event {
        private static final long serialVersionUID = 1L;
        private final int totalUpdateCount;

        private CloseEvent(StatementBatcher batcher, int totalUpdateCount) {
            super((INotifier)batcher);
            this.totalUpdateCount = totalUpdateCount;
        }

        public int getTotalUpdateCount() {
            return this.totalUpdateCount;
        }

        public String toString() {
            return "Total updates: " + this.totalUpdateCount;
        }
    }

    public static final class ResultEvent
    extends Event {
        private static final long serialVersionUID = 1L;
        private final String sql;
        private final int updateCount;
        private final int totalUpdateCount;

        private ResultEvent(StatementBatcher batcher, String sql, int updateCount, int totalUpdateCount) {
            super((INotifier)batcher);
            this.sql = sql;
            this.updateCount = updateCount;
            this.totalUpdateCount = totalUpdateCount;
        }

        public String getSQL() {
            return this.sql;
        }

        public int getUpdateCount() {
            return this.updateCount;
        }

        public int getTotalUpdateCount() {
            return this.totalUpdateCount;
        }

        public String toString() {
            return "Result: " + this.sql + "  -->  " + this.updateCount;
        }
    }
}

