/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transfer;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.transfer.CDOTransferElement;
import org.eclipse.emf.cdo.transfer.CDOTransferType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.io.IORuntimeException;

public abstract class CDOTransferSystem {
    private boolean readOnly;

    protected CDOTransferSystem(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public abstract String getType();

    protected ResourceSet provideResourceSet() {
        return null;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public CDOTransferType getDefaultTransferType(CDOTransferElement element) {
        if (element.isDirectory()) {
            return CDOTransferType.FOLDER;
        }
        return null;
    }

    public abstract URI getURI(IPath var1);

    public CDOTransferElement getElement(String path) {
        return this.getElement((IPath)new Path(path));
    }

    public abstract CDOTransferElement getElement(IPath var1);

    public abstract CDOTransferElement getElement(URI var1);

    public abstract void createFolder(IPath var1);

    public Resource createModel(ResourceSet resourceSet, IPath path) {
        URI uri = this.getURI(path);
        return resourceSet.createResource(uri);
    }

    public abstract void createBinary(IPath var1, InputStream var2, IProgressMonitor var3);

    public abstract void createText(IPath var1, InputStream var2, String var3, IProgressMonitor var4);

    public void saveModels(EList<Resource> resources, IProgressMonitor monitor) {
        try {
            try {
                monitor.beginTask("", resources.size());
                for (Resource resource : resources) {
                    ConcurrencyUtil.checkCancelation((IProgressMonitor)monitor);
                    monitor.subTask("Saving " + resource.getURI());
                    resource.save(null);
                    monitor.worked(1);
                }
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
        finally {
            monitor.done();
        }
    }
}

