/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.internal.mylyn;

import java.io.Writer;
import java.util.Objects;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mylyn.internal.wikitext.ui.editor.MarkupProjectionViewer;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.FastMarkupPartitioner;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.ui.WikiText;
import org.eclipse.mylyn.wikitext.ui.editor.MarkupSourceViewerConfiguration;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.StringBuilderWriter;
import org.eclipse.net4j.util.ui.widgets.EntryControlAdvisor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.editors.text.EditorsUI;

public class MylynEntryControlAdvisor
extends EntryControlAdvisor {
    private static final String DOCUMENT_KEY = "net4j.document";
    private final MarkupLanguage markupLanguage;

    public MylynEntryControlAdvisor(String description) {
        String name = Objects.requireNonNullElse(description, "Markdown");
        this.markupLanguage = WikiText.getMarkupLanguage((String)name);
    }

    protected Control doCreateControl(Composite parent, final EntryControlAdvisor.ControlConfig config) {
        Document document = new Document();
        FastMarkupPartitioner partitioner = new FastMarkupPartitioner();
        partitioner.setMarkupLanguage(this.markupLanguage == null ? null : this.markupLanguage.clone());
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        MarkupProjectionViewer viewer = new MarkupProjectionViewer(parent, null, null, false, 576);
        viewer.configure((SourceViewerConfiguration)new MarkupSourceViewerConfiguration(EditorsUI.getPreferenceStore()));
        final StyledText text = viewer.getTextWidget();
        text.setData(MarkupLanguage.class.getName(), (Object)this.markupLanguage);
        text.setData(ISourceViewer.class.getName(), (Object)viewer);
        text.addVerifyKeyListener(e -> this.processKeyEvent((Control)text, config, (KeyEvent)e));
        document.addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                MylynEntryControlAdvisor.this.processModifyEvent((Control)text, config);
            }
        });
        viewer.setDocument((IDocument)document);
        text.setData(DOCUMENT_KEY, (Object)document);
        return text;
    }

    public String getEntry(Control control) {
        IDocument document = MylynEntryControlAdvisor.getDocument(control);
        return document.get();
    }

    public void setEntry(Control control, String entry) {
        IDocument document = MylynEntryControlAdvisor.getDocument(control);
        document.set(entry);
        ((StyledText)control).setSelection(entry.length());
    }

    public void renderHTML(Control control, StringBuilder html) {
        String entry = this.getEntry(control);
        StringBuilderWriter out = new StringBuilderWriter(html);
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)out, false);
        builder.setEmitAsDocument(false);
        MarkupParser parser = new MarkupParser(this.markupLanguage, (DocumentBuilder)builder);
        parser.parse(entry);
    }

    private static IDocument getDocument(Control control) {
        return (IDocument)control.getData(DOCUMENT_KEY);
    }

    public static final class Factory
    extends EntryControlAdvisor.Factory {
        public static final String TYPE = "mylyn";

        public Factory() {
            super(TYPE);
        }

        public EntryControlAdvisor create(String description) throws ProductCreationException {
            return new MylynEntryControlAdvisor(description);
        }
    }
}

