/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.lm;

import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.internal.client.LMResourceSetConfigurer;
import org.eclipse.emf.cdo.lm.modules.DependencyDefinition;
import org.eclipse.emf.cdo.lm.modules.ModulesFactory;
import org.eclipse.emf.cdo.tests.lm.AbstractLMTest;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assume;

public class LMResourceSetTest
extends AbstractLMTest {
    private static final String MODULE_A = "A";
    private static final String MODULE_B = "B";
    private static final String INITIAL_STREAM = "InitialStream";
    private static final String TAG1_0 = "Tag1.0";

    public void testResourceSetReconfiguration() throws Exception {
        ISystemDescriptor systemDescriptor = LMResourceSetTest.createSystemRepository();
        System system = systemDescriptor.getSystem();
        AbstractLMTest.ModuleCreationResult resultA = this.createModule(systemDescriptor, system, MODULE_A, INITIAL_STREAM, 0, 1);
        LMResourceSetTest.assertCheckoutResult(resultA);
        this.createDependencyModule(resultA, MODULE_B);
        LMResourceSetTest.assertCheckoutResult(resultA);
        this.updateAssemblyDescriptor(resultA.assemblyDescriptor);
        LMResourceSetTest.assertCheckoutResult(resultA);
    }

    private AbstractLMTest.ModuleCreationResult createDependencyModule(AbstractLMTest.ModuleCreationResult referer, String moduleName) throws Exception {
        ISystemDescriptor systemDescriptor = referer.assemblyDescriptor.getSystemDescriptor();
        System system = systemDescriptor.getSystem();
        AbstractLMTest.ModuleCreationResult result = this.createModule(systemDescriptor, system, moduleName, INITIAL_STREAM, 0, 1);
        this.publishTag(systemDescriptor, system, result.stream, TAG1_0);
        this.editModuleDefinition(referer.assemblyDescriptor, moduleDefinition -> {
            DependencyDefinition dependency = ModulesFactory.eINSTANCE.createDependencyDefinition(moduleName);
            moduleDefinition.getDependencies().add((Object)dependency);
        });
        return result;
    }

    private static void assertCheckoutResult(AbstractLMTest.ModuleCreationResult moduleCreationResult) {
        ResourceSet resourceSet = moduleCreationResult.assemblyDescriptor.getCheckout().getView().getResourceSet();
        LMResourceSetConfigurer.Result configurerResult = LMResourceSetConfigurer.Result.of((ResourceSet)resourceSet);
        Assume.assumeThat((Object)configurerResult, (Matcher)IsInstanceOf.instanceOf(LMResourceSetConfigurer.CheckoutResult.class));
    }
}

