/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.util.NotAuthenticatedException;
import org.eclipse.emf.cdo.internal.net4j.CDONet4jSessionConfigurationImpl;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDOSession;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.session.CDOUserInfoManager;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.internal.cdo.session.CDOSessionImpl;
import org.eclipse.emf.internal.cdo.session.DelegatingSessionProtocol;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.ISignalProtocol;
import org.eclipse.net4j.signal.RemoteException;
import org.eclipse.net4j.util.collection.Entity;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.io.IStreamWrapper;
import org.eclipse.net4j.util.security.operations.AuthorizableOperation;
import org.eclipse.net4j.util.security.operations.AuthorizableOperationFactory;

public class CDONet4jSessionImpl
extends CDOSessionImpl
implements CDOSession {
    private IStreamWrapper streamWrapper;
    private IConnector connector;
    private String repositoryName;
    private long signalTimeout = 10000L;
    private AuthorizationCache authorizationCache;

    public IManagedContainer getContainer() {
        IManagedContainer container = ContainerUtil.getContainer((Object)this.connector);
        if (container != null) {
            return container;
        }
        return super.getContainer();
    }

    public IStreamWrapper getStreamWrapper() {
        return this.streamWrapper;
    }

    public void setStreamWrapper(IStreamWrapper streamWrapper) {
        this.streamWrapper = streamWrapper;
    }

    public IConnector getConnector() {
        return this.connector;
    }

    public void setConnector(IConnector connector) {
        this.connector = connector;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public long getSignalTimeout() {
        return this.signalTimeout;
    }

    public void setSignalTimeout(long signalTimeout) {
        this.signalTimeout = signalTimeout;
        CDOClientProtocol clientProtocol = this.getClientProtocol();
        if (clientProtocol != null) {
            clientProtocol.setTimeout(this.signalTimeout);
        }
    }

    @Deprecated
    public void changeCredentials() {
        this.changeServerPassword();
        CDOSessionProtocol sessionProtocol = this.getSessionProtocol();
        sessionProtocol.requestChangeCredentials();
    }

    public char[] changeServerPassword() {
        AtomicReference<Object> result = new AtomicReference<Object>();
        CDOSessionProtocol sessionProtocol = this.getSessionProtocol();
        sessionProtocol.requestChangeServerPassword(result);
        return result.getAndSet(null);
    }

    public void resetCredentials(String userID) {
        CDOSessionProtocol sessionProtocol = this.getSessionProtocol();
        sessionProtocol.requestResetCredentials(userID);
    }

    @Override
    public OptionsImpl options() {
        return (OptionsImpl)super.options();
    }

    protected OptionsImpl createOptions() {
        return new OptionsImpl();
    }

    protected InternalCDOBranchManager createBranchManager() {
        return CDOBranchUtil.createBranchManager();
    }

    protected void authorizeOperationsRemote(AuthorizableOperation[] operations, String[] vetoes) {
        if (this.authorizationCache != null) {
            this.authorizationCache.authorizeOperations(operations, vetoes);
        }
    }

    protected CDOSessionProtocol.OpenSessionResult openSession() {
        CDOSessionProtocol.OpenSessionResult result;
        AuthorizableOperation[] operations;
        block5: {
            CDOClientProtocol protocol = this.createProtocol();
            this.setSessionProtocol(protocol);
            this.hookSessionProtocol();
            try {
                String userID = this.getUserID();
                boolean loginPeek = this.isLoginPeek();
                boolean passiveUpdateEnabled = this.options().isPassiveUpdateEnabled();
                CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode = this.options().getPassiveUpdateMode();
                CDOCommonSession.Options.LockNotificationMode lockNotificationMode = this.options().getLockNotificationMode();
                InternalCDORemoteSessionManager remoteSessionManager = this.getRemoteSessionManager();
                boolean subscribed = remoteSessionManager != null ? remoteSessionManager.isSubscribed() : false;
                operations = AuthorizableOperationFactory.getAuthorizableOperations((IManagedContainer)this.getContainer());
                result = protocol.openSession(this.repositoryName, this.getSessionID(), userID, this.getOneTimeLoginToken(), loginPeek, passiveUpdateEnabled, passiveUpdateMode, lockNotificationMode, subscribed, operations);
                if (result != null) break block5;
                return null;
            }
            catch (RemoteException ex) {
                if (ex.getCause() instanceof SecurityException) {
                    throw (SecurityException)ex.getCause();
                }
                throw ex;
            }
        }
        this.setSessionID(result.getSessionID());
        this.setUserID(result.getUserID());
        this.setLastUpdateTime(result.getLastUpdateTime());
        this.setOpeningTime(result.getOpeningTime());
        this.setRepositoryInfo(new CDONet4jSessionConfigurationImpl.RepositoryInfo((InternalCDOSession)this, result));
        this.setClientEntities(result.getClientEntities());
        if (result.isAuthorizingOperations()) {
            this.authorizationCache = new AuthorizationCache(this.getSessionProtocol(), operations, result.getAuthorizationResults());
        }
        return result;
    }

    protected void doActivate() throws Exception {
        CDOUserInfoManager userInfoManager;
        InternalCDOBranchManager branchManager;
        InternalCDOPackageRegistry packageRegistry = this.getPackageRegistry();
        if (packageRegistry == null) {
            packageRegistry = (InternalCDOPackageRegistry)CDOModelUtil.createPackageRegistry();
            this.setPackageRegistry(packageRegistry);
        }
        packageRegistry.setPackageProcessor((InternalCDOPackageRegistry.PackageProcessor)this);
        packageRegistry.setPackageLoader((InternalCDOPackageRegistry.PackageLoader)this);
        packageRegistry.activate();
        CDOSessionProtocol.OpenSessionResult result = this.openSession();
        if (result == null) {
            throw new NotAuthenticatedException();
        }
        super.doActivate();
        CDORepositoryInfo repository = this.getRepositoryInfo();
        CDOSessionProtocol sessionProtocol = this.getSessionProtocol();
        InternalCDORevisionManager revisionManager = this.getRevisionManager();
        if (revisionManager == null) {
            revisionManager = (InternalCDORevisionManager)CDORevisionUtil.createRevisionManager();
            this.setRevisionManager(revisionManager);
        }
        if (!revisionManager.isActive()) {
            revisionManager.setSupportingAudits(repository.isSupportingAudits());
            revisionManager.setSupportingBranches(repository.isSupportingBranches());
            revisionManager.setRevisionLoader((InternalCDORevisionManager.RevisionLoader)sessionProtocol);
            revisionManager.setRevisionLocker((InternalCDORevisionManager.RevisionLocker)this);
            revisionManager.activate();
        }
        if ((branchManager = this.getBranchManager()) == null) {
            branchManager = this.createBranchManager();
            this.setBranchManager(branchManager);
        }
        if (!branchManager.isActive()) {
            branchManager.setRepository((CDOCommonRepository)repository);
            branchManager.setBranchLoader((InternalCDOBranchManager.BranchLoader)sessionProtocol);
            branchManager.initMainBranch(this.isMainBranchLocal(), repository.getCreationTime());
            branchManager.setTagModCount(result.getTagModCount());
            branchManager.activate();
        }
        this.doActivateAfterBranchManager();
        InternalCDOCommitInfoManager commitInfoManager = this.getCommitInfoManager();
        if (commitInfoManager == null) {
            commitInfoManager = CDOCommitInfoUtil.createCommitInfoManager((boolean)true);
            this.setCommitInfoManager(commitInfoManager);
        }
        if (!commitInfoManager.isActive()) {
            commitInfoManager.setRepository((CDOCommonRepository)repository);
            commitInfoManager.setBranchManager((CDOBranchManager)branchManager);
            commitInfoManager.setCommitInfoLoader((InternalCDOCommitInfoManager.CommitInfoLoader)sessionProtocol);
            commitInfoManager.setLastCommitOfBranch(null, this.getLastUpdateTime());
            commitInfoManager.activate();
        }
        if ((userInfoManager = this.getUserInfoManager()) == null) {
            userInfoManager = new UserInfoManager();
            this.setUserInfoManager(userInfoManager);
        }
        for (InternalCDOPackageUnit packageUnit : result.getPackageUnits()) {
            this.getPackageRegistry().putPackageUnit(packageUnit);
        }
        repository.getTimeStamp(true);
        sessionProtocol.openedSession();
    }

    protected void doDeactivate() throws Exception {
        InternalCDOBranchManager branchManager;
        InternalCDORevisionManager revisionManager;
        CDOSessionProtocol sessionProtocol = this.getSessionProtocol();
        super.doDeactivate();
        InternalCDOCommitInfoManager commitInfoManager = this.getCommitInfoManager();
        if (commitInfoManager.getCommitInfoLoader() == sessionProtocol) {
            commitInfoManager.deactivate();
        }
        if ((revisionManager = this.getRevisionManager()).getRevisionLoader() == sessionProtocol) {
            revisionManager.deactivate();
        }
        if ((branchManager = this.getBranchManager()).getBranchLoader() == sessionProtocol) {
            branchManager.deactivate();
        }
        this.getPackageRegistry().deactivate();
    }

    private CDOClientProtocol createProtocol() {
        CDOClientProtocol protocol = new CDOClientProtocol();
        protocol.setInfraStructure(this);
        if (this.streamWrapper != null) {
            protocol.setStreamWrapper(this.streamWrapper);
        }
        protocol.open(this.connector);
        protocol.setTimeout(this.signalTimeout);
        return protocol;
    }

    private CDOClientProtocol getClientProtocol() {
        CDOSessionProtocol sessionProtocol = this.getSessionProtocol();
        CDOClientProtocol clientProtocol = sessionProtocol instanceof DelegatingSessionProtocol ? (CDOClientProtocol)((DelegatingSessionProtocol)sessionProtocol).getDelegate() : (CDOClientProtocol)sessionProtocol;
        return clientProtocol;
    }

    private static final class AuthorizationCache {
        private static final String GRANTED = new String("");
        private final Map<String, String> authorizations = new HashMap<String, String>();
        private final CDOSessionProtocol sessionProtocol;

        public AuthorizationCache(CDOSessionProtocol sessionProtocol, AuthorizableOperation[] operations, String[] authorizations) {
            this.sessionProtocol = sessionProtocol;
            int i = 0;
            while (i < operations.length) {
                this.authorizations.put(operations[i].getID(), authorizations[i]);
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void authorizeOperations(AuthorizableOperation[] operations, String[] vetoes) {
            int size;
            int count = operations.length;
            LinkedHashMap<AuthorizableOperation, Integer> operationsToLoad = null;
            Map<String, String> map = this.authorizations;
            synchronized (map) {
                int i = 0;
                while (i < count) {
                    AuthorizableOperation operation = operations[i];
                    if (operation != null && !operation.hasParameters()) {
                        String operationID = operation.getID();
                        String authorization = this.authorizations.get(operationID);
                        if (authorization != null) {
                            vetoes[i] = authorization == GRANTED ? null : authorization;
                        } else {
                            if (operationsToLoad == null) {
                                operationsToLoad = new LinkedHashMap<AuthorizableOperation, Integer>();
                            }
                            operationsToLoad.put(operation, i);
                        }
                    }
                    ++i;
                }
            }
            int n = size = operationsToLoad == null ? 0 : operationsToLoad.size();
            if (size != 0) {
                AuthorizableOperation[] requestOperations = operationsToLoad.keySet().toArray(new AuthorizableOperation[size]);
                String[] responseVetoes = this.sessionProtocol.authorizeOperations(requestOperations);
                Map<String, String> map2 = this.authorizations;
                synchronized (map2) {
                    int i = 0;
                    while (i < responseVetoes.length) {
                        AuthorizableOperation operation = requestOperations[i];
                        String veto = responseVetoes[i];
                        this.authorizations.put(operation.getID(), veto == null ? GRANTED : veto);
                        int index = (Integer)operationsToLoad.get(operation);
                        vetoes[index] = veto;
                        ++i;
                    }
                }
            }
        }
    }

    protected class OptionsImpl
    extends CDOSessionImpl.OptionsImpl
    implements CDOSession.Options {
        private int commitTimeout;
        private int progressInterval;

        public OptionsImpl() {
            super((CDOSessionImpl)CDONet4jSessionImpl.this);
            this.commitTimeout = 10;
            this.progressInterval = 1;
        }

        public CDONet4jSession getContainer() {
            return (CDONet4jSession)super.getContainer();
        }

        @Override
        public ISignalProtocol<CDONet4jSession> getNet4jProtocol() {
            CDOSessionProtocol protocol = CDONet4jSessionImpl.this.getSessionProtocol();
            if (protocol instanceof DelegatingSessionProtocol) {
                protocol = ((DelegatingSessionProtocol)protocol).getDelegate();
            }
            ISignalProtocol signalProtocol = (ISignalProtocol)protocol;
            return signalProtocol;
        }

        @Override
        public ISignalProtocol<CDOSession> getProtocol() {
            ISignalProtocol<CDONet4jSession> net4jProtocol = this.getNet4jProtocol();
            return net4jProtocol;
        }

        @Override
        public long getSignalTimeout() {
            return CDONet4jSessionImpl.this.getSignalTimeout();
        }

        @Override
        public void setSignalTimeout(long signalTimeout) {
            CDONet4jSessionImpl.this.setSignalTimeout(signalTimeout);
        }

        @Override
        public int getCommitTimeout() {
            return this.commitTimeout;
        }

        @Override
        public synchronized void setCommitTimeout(int commitTimeout) {
            this.commitTimeout = commitTimeout;
        }

        @Override
        public int getProgressInterval() {
            return this.progressInterval;
        }

        @Override
        public synchronized void setProgressInterval(int progressInterval) {
            this.progressInterval = progressInterval;
        }
    }

    private final class UserInfoManager
    implements CDOUserInfoManager {
        private final Map<String, Entity> userInfos = new ConcurrentHashMap<String, Entity>();

        public org.eclipse.emf.cdo.session.CDOSession getSession() {
            return CDONet4jSessionImpl.this;
        }

        public Map<String, Entity> getUserInfos(Iterable<String> userIDs) {
            HashMap<String, Entity> result = new HashMap<String, Entity>();
            ArrayList<String> userIDsToRequest = null;
            for (String userID : userIDs) {
                Entity userInfo = this.userInfos.get(userID);
                if (userInfo != null) {
                    result.put(userID, userInfo);
                    continue;
                }
                if (userIDsToRequest == null) {
                    userIDsToRequest = new ArrayList<String>();
                }
                userIDsToRequest.add(userID);
            }
            if (userIDsToRequest != null) {
                String[] names = userIDsToRequest.toArray(new String[userIDsToRequest.size()]);
                Map<String, Entity> entities = CDONet4jSessionImpl.this.getClientProtocol().requestEntities("cdo/user/info", names);
                this.userInfos.putAll(entities);
                result.putAll(entities);
            }
            return result;
        }
    }
}

