/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.util.Map;
import java.util.Objects;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.security.operations.AuthorizableOperation;
import org.eclipse.net4j.util.security.operations.OperationAuthorizer;
import org.eclipse.net4j.util.security.operations.OperationAuthorizerFactory;

public abstract class AbstractOperationAuthorizer<CONTEXT>
implements OperationAuthorizer<CONTEXT> {
    private final String operationID;

    public AbstractOperationAuthorizer(String operationID) {
        this.operationID = operationID;
    }

    public final String getOperationID() {
        return this.operationID;
    }

    public String authorizeOperation(CONTEXT context, AuthorizableOperation operation) {
        if (!Objects.equals(this.operationID, operation.getID())) {
            return null;
        }
        Map parameters = operation.getParameters();
        return this.authorizeOperation(context, parameters);
    }

    protected abstract String authorizeOperation(CONTEXT var1, Map<String, Object> var2);

    public static abstract class Factory<CONTEXT>
    extends OperationAuthorizerFactory<CONTEXT> {
        public Factory(String type) {
            super(type);
        }

        public OperationAuthorizer<CONTEXT> create(String description) throws ProductCreationException {
            if (StringUtil.isEmpty((String)description)) {
                throw new ProductCreationException("No description: " + (Object)((Object)this));
            }
            int colon = description.indexOf(58);
            String operationID = colon == -1 ? description : description.substring(0, colon);
            description = colon == -1 ? null : description.substring(colon + 1);
            return this.create(operationID, description);
        }

        protected abstract OperationAuthorizer<CONTEXT> create(String var1, String var2) throws ProductCreationException;
    }
}

