/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.branch;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchChangedEvent;
import org.eclipse.emf.cdo.common.branch.CDOBranchCreatedEvent;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchTag;
import org.eclipse.emf.cdo.common.branch.CDODuplicateBranchException;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.common.util.CDOTimeProvider;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchImpl;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchTagImpl;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.io.RemoteException;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.ref.ReferenceValueMap;

public class CDOBranchManagerImpl
extends Container<CDOBranch>
implements InternalCDOBranchManager {
    private CDOCommonRepository repository;
    private InternalCDOBranchManager.BranchLoader branchLoader;
    private InternalCDOBranch mainBranch;
    private Map<Integer, InternalCDOBranch> branches = this.createBranchMap();
    private Map<String, CDOBranchTagImpl> tags = this.createTagMap();
    private Reference<CDOTagListImpl> tagListReference;
    private List<TagChange> tagChangeQueue = new ArrayList<TagChange>();
    private int tagModCount = -1;

    @Override
    public CDOCommonRepository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(CDOCommonRepository repository) {
        this.repository = repository;
    }

    @Override
    public InternalCDOBranchManager.BranchLoader getBranchLoader() {
        return this.branchLoader;
    }

    @Override
    public void setBranchLoader(InternalCDOBranchManager.BranchLoader branchLoader) {
        this.checkInactive();
        this.branchLoader = branchLoader;
    }

    @Override
    public CDOTimeProvider getTimeProvider() {
        return this.repository;
    }

    @Override
    @Deprecated
    public void setTimeProvider(CDOTimeProvider timeProvider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initMainBranch(boolean local, long timeStamp) {
        this.mainBranch = new CDOBranchImpl.Main(this, local, timeStamp);
    }

    @Override
    @Deprecated
    public void handleBranchCreated(InternalCDOBranch branch) {
        this.handleBranchChanged(branch, CDOBranchChangedEvent.ChangeKind.CREATED);
    }

    @Override
    @Deprecated
    public void handleBranchChanged(InternalCDOBranch branch, CDOBranchChangedEvent.ChangeKind changeKind) {
        this.handleBranchChanged(branch, changeKind, branch.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleBranchChanged(InternalCDOBranch branch, CDOBranchChangedEvent.ChangeKind changeKind, int ... branchIDs) {
        switch (changeKind) {
            case CREATED: {
                CDOBranchPoint base = branch.getBase();
                InternalCDOBranch baseBranch = (InternalCDOBranch)base.getBranch();
                baseBranch.addChild(branch);
                this.fireEvent(new BranchCreatedEvent(branch));
                break;
            }
            case RENAMED: {
                this.fireEvent(new BranchChangedEvent(branch, changeKind, branchIDs));
                break;
            }
            case DELETED: {
                CDOBranch[] deletedBranches = new CDOBranch[branchIDs.length];
                Map<Integer, InternalCDOBranch> baseBranch = this.branches;
                synchronized (baseBranch) {
                    int i = 0;
                    while (i < branchIDs.length) {
                        int branchID = branchIDs[i];
                        try {
                            branch = this.branches.get(branchID);
                            if (branch != null) {
                                branch.setDeleted();
                                deletedBranches[i] = branch;
                            }
                        }
                        catch (Exception ex) {
                            OM.LOG.error((Throwable)ex);
                        }
                        ++i;
                    }
                }
                CDOTagListImpl tagList = this.getTagListOrNull();
                if (tagList != null) {
                    tagList.branchesDeleted(deletedBranches);
                }
                this.fireBranchDeletedEvents(deletedBranches);
                this.fireEvent(new BranchChangedEvent(branch, changeKind, branchIDs));
                break;
            }
        }
    }

    private void fireBranchDeletedEvents(CDOBranch[] branches) {
        CDOBranch[] cDOBranchArray = branches;
        int n = branches.length;
        int n2 = 0;
        while (n2 < n) {
            CDOBranch branch = cDOBranchArray[n2];
            if (branch != null) {
                branch.fireDeletedEvent();
            }
            ++n2;
        }
    }

    public CDOBranch[] getElements() {
        return new CDOBranch[]{this.getMainBranch()};
    }

    @Override
    public InternalCDOBranch getMainBranch() {
        this.checkActive();
        return this.mainBranch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDOBranch getBranch(int branchID) {
        InternalCDOBranch branch;
        this.checkActive();
        if (branchID == 0) {
            return this.mainBranch;
        }
        if (!this.repository.isSupportingBranches()) {
            return null;
        }
        Map<Integer, InternalCDOBranch> map = this.branches;
        synchronized (map) {
            branch = this.branches.get(branchID);
            if (branch == null) {
                branch = new CDOBranchImpl(this, branchID, null, null);
                this.putBranch(branch);
            }
        }
        return branch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDOBranch getBranch(int id, String name, InternalCDOBranch baseBranch, long baseTimeStamp) {
        Map<Integer, InternalCDOBranch> map = this.branches;
        synchronized (map) {
            InternalCDOBranch branch = this.branches.get(id);
            if (branch == null) {
                branch = new CDOBranchImpl(this, id, name, baseBranch.getPoint(baseTimeStamp));
                this.putBranch(branch);
            } else if (branch.isProxy()) {
                branch.setBranchInfo(name, baseBranch, baseTimeStamp);
            }
            return branch;
        }
    }

    @Override
    public InternalCDOBranch getBranch(int id, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        String name = branchInfo.getName();
        InternalCDOBranch baseBranch = this.getBranch(branchInfo.getBaseBranchID());
        long baseTimeStamp = branchInfo.getBaseTimeStamp();
        return this.getBranch(id, name, baseBranch, baseTimeStamp);
    }

    @Override
    public InternalCDOBranch getBranch(String path) {
        int sep;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((sep = path.indexOf("/")) == -1) {
            if ("MAIN".equals(path)) {
                return this.mainBranch;
            }
            return null;
        }
        if (!this.repository.isSupportingBranches()) {
            return null;
        }
        String name = path.substring(0, sep);
        if ("MAIN".equals(name)) {
            String rest = path.substring(sep + 1);
            return this.mainBranch.getBranch(rest);
        }
        return null;
    }

    @Override
    public int getBranches(int startID, int endID, CDOBranchHandler handler) {
        this.checkActive();
        if (!this.repository.isSupportingBranches()) {
            if (startID <= 0 && endID >= 0) {
                handler.handleBranch(this.mainBranch);
                return 1;
            }
            return 0;
        }
        return this.branchLoader.loadBranches(startID, endID, handler);
    }

    @Override
    public LinkedHashSet<CDOBranch> getBranches(int rootID) {
        LinkedHashSet<CDOBranch> result = new LinkedHashSet<CDOBranch>();
        InternalCDOBranch branch = this.getBranch(rootID);
        CDOBranchUtil.forEachBranchInTree(branch, result::add);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDOBranch createBranch(int branchID, String name, InternalCDOBranch baseBranch, long baseTimeStamp) throws CDODuplicateBranchException {
        Pair<Integer, Long> result;
        this.checkActive();
        if (!this.repository.isSupportingBranches()) {
            throw new IllegalStateException("Branching is not supported");
        }
        CDOBranchManagerImpl.checkBranchName(name);
        try {
            result = this.branchLoader.createBranch(branchID, new InternalCDOBranchManager.BranchLoader.BranchInfo(name, baseBranch.getID(), baseTimeStamp));
        }
        catch (RemoteException ex) {
            throw ex.unwrap();
        }
        int actualBranchID = (Integer)result.getElement1();
        long actualBaseTimeStamp = (Long)result.getElement2();
        CDOBranchPoint base = baseBranch.getPoint(actualBaseTimeStamp);
        InternalCDOBranch branch = this.createBranch(actualBranchID, name, base, baseTimeStamp);
        Map<Integer, InternalCDOBranch> map = this.branches;
        synchronized (map) {
            this.putBranch(branch);
        }
        this.handleBranchChanged(branch, CDOBranchChangedEvent.ChangeKind.CREATED);
        return branch;
    }

    protected InternalCDOBranch createBranch(int branchID, String name, CDOBranchPoint base, long originalBaseTimeStamp) {
        return new CDOBranchImpl(this, branchID, name, base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOBranch[] deleteBranches(int id, OMMonitor monitor) {
        this.checkActive();
        if (!(this.branchLoader instanceof InternalCDOBranchManager.BranchLoader5)) {
            throw new UnsupportedOperationException("Deleting branches is not supported by " + this.branchLoader);
        }
        CDOBranch[] deletedBranches = ((InternalCDOBranchManager.BranchLoader5)this.branchLoader).deleteBranches(id, monitor);
        Map<Integer, InternalCDOBranch> map = this.branches;
        synchronized (map) {
            int i = deletedBranches.length - 1;
            while (i >= 0) {
                InternalCDOBranch branch = (InternalCDOBranch)deletedBranches[i];
                branch.setDeleted();
                --i;
            }
        }
        this.fireBranchDeletedEvents(deletedBranches);
        return deletedBranches;
    }

    @Override
    @Deprecated
    public void renameBranch(CDOBranch branch, String newName) {
        branch.setName(newName);
    }

    @Override
    public int getTagModCount() {
        return this.tagModCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTagModCount(int tagModCount) {
        Map<String, CDOBranchTagImpl> map = this.tags;
        synchronized (map) {
            boolean initial = this.tagModCount == -1;
            this.tagModCount = tagModCount;
            if (initial) {
                this.executeTagChanges();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTagChanged(int modCount, String oldName, String newName, CDOBranchPoint branchPoint) {
        Map<String, CDOBranchTagImpl> map = this.tags;
        synchronized (map) {
            this.tagChangeQueue.add(new TagChange(modCount, oldName, newName, branchPoint));
            this.tagChangeQueue.sort(null);
            this.executeTagChanges();
        }
    }

    protected void executeTagChanges() {
        while (!this.tagChangeQueue.isEmpty() && this.tagModCount != -1) {
            TagChange tagChange = this.tagChangeQueue.get(0);
            int newModCount = this.tagModCount + 1;
            if (tagChange.getModCount() != newModCount) continue;
            this.tagModCount = newModCount;
            this.executeTagChange(tagChange.getOldName(), tagChange.getNewName(), tagChange.getBranchPoint());
            this.tagChangeQueue.remove(0);
        }
    }

    protected void executeTagChange(String oldName, String newName, CDOBranchPoint branchPoint) {
        switch (InternalCDOBranchManager.getTagChangeKind(oldName, newName, branchPoint)) {
            case CREATED: {
                this.createTagInternal(newName, branchPoint);
                break;
            }
            case RENAMED: {
                this.renameTagInternal(oldName, newName);
                break;
            }
            case MOVED: {
                this.moveTagInternal(oldName, branchPoint);
                break;
            }
            case DELETED: {
                this.deleteTagInternal(oldName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOBranchPoint changeTagWithModCount(AtomicInteger modCount, String oldName, String newName, CDOBranchPoint branchPoint) {
        Map<String, CDOBranchTagImpl> map = this.tags;
        synchronized (map) {
            if (modCount != null && modCount.get() != this.tagModCount) {
                throw new ConcurrentModificationException();
            }
            CDOBranchPoint result = null;
            switch (InternalCDOBranchManager.getTagChangeKind(oldName, newName, branchPoint)) {
                case CREATED: {
                    CDOBranchTagImpl tag = this.tags.get(newName);
                    if (tag != null) {
                        throw new CDOException("Tag name exists: " + newName);
                    }
                    boolean success = false;
                    if (this.branchLoader instanceof InternalCDOBranchManager.BranchLoader4) {
                        result = ((InternalCDOBranchManager.BranchLoader4)this.branchLoader).changeTag(modCount, null, newName, branchPoint);
                        if (result != null) {
                            branchPoint = result;
                            result = null;
                        }
                        success = true;
                    }
                    if (!success) break;
                    result = this.createTagInternal(newName, branchPoint);
                    break;
                }
                case RENAMED: {
                    ((InternalCDOBranchManager.BranchLoader4)this.branchLoader).changeTag(modCount, oldName, newName, null);
                    this.renameTagInternal(oldName, newName);
                    break;
                }
                case MOVED: {
                    result = ((InternalCDOBranchManager.BranchLoader4)this.branchLoader).changeTag(modCount, oldName, null, branchPoint);
                    if (result != null) {
                        branchPoint = result;
                        result = null;
                    }
                    this.moveTagInternal(oldName, branchPoint);
                    break;
                }
                case DELETED: {
                    ((InternalCDOBranchManager.BranchLoader4)this.branchLoader).changeTag(modCount, oldName, null, null);
                    this.deleteTagInternal(oldName);
                }
            }
            ++this.tagModCount;
            if (modCount != null) {
                modCount.set(this.tagModCount);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOBranchTag createTag(String name, CDOBranchPoint branchPoint) {
        Map<String, CDOBranchTagImpl> map = this.tags;
        synchronized (map) {
            AtomicInteger modCount = new AtomicInteger(this.tagModCount);
            return (CDOBranchTag)this.changeTagWithModCount(modCount, null, name, branchPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameTag(String oldName, String newName) {
        Map<String, CDOBranchTagImpl> map = this.tags;
        synchronized (map) {
            AtomicInteger modCount = new AtomicInteger(this.tagModCount);
            this.changeTagWithModCount(modCount, oldName, newName, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTag(CDOBranchTag tag, CDOBranchPoint branchPoint) {
        Map<String, CDOBranchTagImpl> map = this.tags;
        synchronized (map) {
            String name = tag.getName();
            AtomicInteger modCount = new AtomicInteger(this.tagModCount);
            this.changeTagWithModCount(modCount, name, null, branchPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTag(CDOBranchTag tag) {
        Map<String, CDOBranchTagImpl> map = this.tags;
        synchronized (map) {
            String name = tag.getName();
            AtomicInteger modCount = new AtomicInteger(this.tagModCount);
            this.changeTagWithModCount(modCount, name, null, null);
        }
    }

    private CDOBranchTagImpl createTagInternal(String name, CDOBranchPoint branchPoint) {
        CDOBranchTagImpl tag = new CDOBranchTagImpl(name, branchPoint.getBranch(), branchPoint.getTimeStamp());
        this.tags.put(name, tag);
        CDOTagListImpl tagList = this.getTagListOrNull();
        if (tagList != null) {
            tagList.addTag(tag);
        }
        return tag;
    }

    private void renameTagInternal(String oldName, String newName) {
        CDOBranchTagImpl tag = this.tags.remove(oldName);
        tag.setNameInternal(newName);
        this.tags.put(newName, tag);
        CDOTagListImpl tagList = this.getTagListOrNull();
        if (tagList != null) {
            tagList.fireTagRenamedEvent(tag, oldName, newName);
        }
        tag.fireTagRenamedEvent(oldName, newName);
    }

    private void moveTagInternal(String name, CDOBranchPoint branchPoint) {
        CDOBranchTagImpl tag = this.tags.get(name);
        CDOBranchPoint oldBranchPoint = CDOBranchUtil.copyBranchPoint(tag);
        tag.moveInternal(branchPoint.getBranch(), branchPoint.getTimeStamp());
        CDOTagListImpl tagList = this.getTagListOrNull();
        if (tagList != null) {
            tagList.fireTagMovedEvent(tag, oldBranchPoint, branchPoint);
        }
        tag.fireTagMovedEvent(oldBranchPoint, branchPoint);
    }

    private void deleteTagInternal(String name) {
        CDOBranchTagImpl tag = this.tags.remove(name);
        tag.deleteInternal();
        CDOTagListImpl tagList = this.getTagListOrNull();
        if (tagList != null) {
            tagList.removeTag(tag);
        }
        tag.fireTagDeletedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOBranchTag getTag(String name) {
        Map<String, CDOBranchTagImpl> map = this.tags;
        synchronized (map) {
            CDOBranchTagImpl tag = this.tags.get(name);
            if (tag == null && this.branchLoader instanceof InternalCDOBranchManager.BranchLoader4) {
                AtomicReference result = new AtomicReference();
                ((InternalCDOBranchManager.BranchLoader4)this.branchLoader).loadTags(name, branchInfo -> result.set(branchInfo));
                InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo2 = (InternalCDOBranchManager.BranchLoader.BranchInfo)result.get();
                if (branchInfo2 != null) {
                    int branchID = branchInfo2.getBaseBranchID();
                    long timeStamp = branchInfo2.getBaseTimeStamp();
                    InternalCDOBranch branch = this.getBranch(branchID);
                    tag = new CDOBranchTagImpl(name, branch, timeStamp);
                    this.tags.put(name, tag);
                }
            }
            return tag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOBranchManager.CDOTagList getTagList() {
        Map<String, CDOBranchTagImpl> map = this.tags;
        synchronized (map) {
            CDOTagListImpl tagList = this.getTagListOrNull();
            if (tagList != null) {
                return tagList;
            }
            if (this.branchLoader instanceof InternalCDOBranchManager.BranchLoader4) {
                CDOTagListImpl newTagList = new CDOTagListImpl();
                ((InternalCDOBranchManager.BranchLoader4)this.branchLoader).loadTags(null, branchInfo -> newTagList.addTag(branchInfo));
                this.tagListReference = this.createTagListReference(newTagList);
                newTagList.activate();
                return newTagList;
            }
            return null;
        }
    }

    private CDOTagListImpl getTagListOrNull() {
        CDOTagListImpl tagList;
        if (this.tagListReference != null && (tagList = this.tagListReference.get()) != null) {
            return tagList;
        }
        return null;
    }

    public String toString() {
        return MessageFormat.format("BranchManager[loader={0}]", this.branchLoader);
    }

    private boolean putBranch(InternalCDOBranch branch) {
        int id = branch.getID();
        if (this.branches.containsKey(id)) {
            return false;
        }
        this.branches.put(id, branch);
        return true;
    }

    protected Map<Integer, InternalCDOBranch> createBranchMap() {
        return new ReferenceValueMap.Soft();
    }

    protected Map<String, CDOBranchTagImpl> createTagMap() {
        return new ReferenceValueMap.Soft();
    }

    protected Reference<CDOTagListImpl> createTagListReference(CDOTagListImpl tagList) {
        return new SoftReference<CDOTagListImpl>(tagList);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.repository, "repository");
        this.checkState(this.branchLoader, "branchLoader");
    }

    public static void checkBranchName(String name) throws IllegalArgumentException {
        if (StringUtil.isEmpty((String)name)) {
            throw new IllegalArgumentException("Branch name is empty");
        }
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Branch name contains '/'");
        }
    }

    private static class BranchChangedEvent
    extends Event
    implements CDOBranchChangedEvent {
        private static final long serialVersionUID = 1L;
        private final CDOBranch branch;
        private final CDOBranchChangedEvent.ChangeKind changeKind;
        private final int[] branchIDs;

        public BranchChangedEvent(CDOBranch branch, CDOBranchChangedEvent.ChangeKind changeKind, int ... branchIDs) {
            super((INotifier)branch.getBranchManager());
            this.branch = branch;
            this.changeKind = changeKind;
            this.branchIDs = branchIDs;
        }

        @Override
        public CDOBranchManager getSource() {
            return (CDOBranchManager)super.getSource();
        }

        @Override
        public CDOBranch getBranch() {
            return this.branch;
        }

        @Override
        public int[] getBranchIDs() {
            return this.branchIDs;
        }

        @Override
        public CDOBranchChangedEvent.ChangeKind getChangeKind() {
            return this.changeKind;
        }
    }

    @Deprecated
    private static final class BranchCreatedEvent
    extends BranchChangedEvent
    implements CDOBranchCreatedEvent {
        private static final long serialVersionUID = 1L;

        public BranchCreatedEvent(CDOBranch branch) {
            super(branch, CDOBranchChangedEvent.ChangeKind.CREATED, branch.getID());
        }
    }

    public final class CDOTagListImpl
    extends Container<CDOBranchTag>
    implements CDOBranchManager.CDOTagList {
        private final List<CDOBranchTag> list = new ArrayList<CDOBranchTag>();
        private CDOBranchTag[] array;

        @Override
        public CDOBranchManager getBranchManager() {
            return CDOBranchManagerImpl.this;
        }

        public CDOBranchTag[] getElements() {
            return this.getTags();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CDOBranchTag[] getTags() {
            List<CDOBranchTag> list = this.list;
            synchronized (list) {
                if (this.array == null) {
                    this.array = this.list.toArray(new CDOBranchTag[this.list.size()]);
                    Arrays.sort(this.array);
                }
                return this.array;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CDOBranchTag[] getTags(CDOBranch branch) {
            ArrayList<CDOBranchTag> result = new ArrayList<CDOBranchTag>();
            List<CDOBranchTag> list = this.list;
            synchronized (list) {
                for (CDOBranchTag tag : this.list) {
                    if (tag.getBranch() != branch) continue;
                    result.add(tag);
                }
            }
            return result.toArray(new CDOBranchTag[result.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void branchesDeleted(CDOBranch[] deletedBranches) {
            IListener[] listeners = this.getListeners();
            ContainerEvent event = listeners.length == 0 ? null : new ContainerEvent((IContainer)this);
            ArrayList<CDOBranchTagImpl> deletedTags = new ArrayList<CDOBranchTagImpl>();
            Map map = CDOBranchManagerImpl.this.tags;
            synchronized (map) {
                List<CDOBranchTag> list = this.list;
                synchronized (list) {
                    Iterator<CDOBranchTag> it = this.list.iterator();
                    block6: while (it.hasNext()) {
                        CDOBranchTagImpl tag = (CDOBranchTagImpl)it.next();
                        CDOBranch[] cDOBranchArray = deletedBranches;
                        int n = deletedBranches.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CDOBranch deletedBranch = cDOBranchArray[n2];
                            if (tag.getBranch() == deletedBranch) {
                                it.remove();
                                CDOBranchManagerImpl.this.tags.remove(tag.getName());
                                tag.deleteInternal();
                                if (event != null) {
                                    event.addDelta((Object)tag, IContainerDelta.Kind.REMOVED);
                                }
                                if (!tag.hasListeners()) continue block6;
                                deletedTags.add(tag);
                                continue block6;
                            }
                            ++n2;
                        }
                    }
                }
            }
            if (event != null && !event.isEmpty()) {
                this.fireEvent((IEvent)event, listeners);
            }
            for (CDOBranchTagImpl deletedTag : deletedTags) {
                deletedTag.fireTagDeletedEvent();
            }
        }

        private void addTag(InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
            String name = branchInfo.getName();
            CDOBranchTagImpl tag = (CDOBranchTagImpl)CDOBranchManagerImpl.this.tags.get(name);
            if (tag == null) {
                int branchID = branchInfo.getBaseBranchID();
                long timeStamp = branchInfo.getBaseTimeStamp();
                InternalCDOBranch branch = CDOBranchManagerImpl.this.getBranch(branchID);
                tag = new CDOBranchTagImpl(name, branch, timeStamp);
                CDOBranchManagerImpl.this.tags.put(name, tag);
            }
            this.addTag(tag);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addTag(CDOBranchTag tag) {
            List<CDOBranchTag> list = this.list;
            synchronized (list) {
                this.list.add(tag);
                this.array = null;
            }
            if (this.isActive()) {
                this.fireElementAddedEvent(tag);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeTag(CDOBranchTag tag) {
            List<CDOBranchTag> list = this.list;
            synchronized (list) {
                if (this.list.remove(tag)) {
                    this.array = null;
                } else {
                    tag = null;
                }
            }
            if (tag != null) {
                this.fireElementRemovedEvent(tag);
            }
        }

        private void fireTagRenamedEvent(CDOBranchTagImpl tag, String oldName, String newName) {
            this.fireEvent(new TagRenamedEventImpl(this, tag, oldName, newName));
        }

        private void fireTagMovedEvent(CDOBranchTagImpl tag, CDOBranchPoint oldBranchPoint, CDOBranchPoint newBranchPoint) {
            this.fireEvent(new TagMovedEventImpl(this, tag, oldBranchPoint, newBranchPoint));
        }
    }

    private static final class TagChange
    implements Comparable<TagChange> {
        private final int modCount;
        private final String oldName;
        private final String newName;
        private final CDOBranchPoint branchPoint;

        public TagChange(int modCount, String oldName, String newName, CDOBranchPoint branchPoint) {
            this.modCount = modCount;
            this.oldName = oldName;
            this.newName = newName;
            this.branchPoint = branchPoint;
        }

        public int getModCount() {
            return this.modCount;
        }

        public String getOldName() {
            return this.oldName;
        }

        public String getNewName() {
            return this.newName;
        }

        public CDOBranchPoint getBranchPoint() {
            return this.branchPoint;
        }

        @Override
        public int compareTo(TagChange o) {
            return Integer.compare(this.modCount, o.modCount);
        }
    }

    private static abstract class TagListEventImpl
    extends Event
    implements CDOBranchManager.CDOTagList.TagListEvent,
    CDOBranchTag.TagEvent {
        private static final long serialVersionUID = 1L;
        private final CDOBranchTagImpl tag;

        public TagListEventImpl(CDOTagListImpl tagList, CDOBranchTagImpl tag) {
            super((INotifier)tagList);
            this.tag = tag;
        }

        @Override
        public CDOBranchManager.CDOTagList getTagList() {
            return (CDOBranchManager.CDOTagList)this.getSource();
        }

        @Override
        public CDOBranchTagImpl getTag() {
            return this.tag;
        }

        protected String formatAdditionalParameters() {
            return "tag=" + this.tag;
        }
    }

    public static final class TagMovedEventImpl
    extends TagListEventImpl
    implements CDOBranchManager.CDOTagList.TagMovedEvent {
        private static final long serialVersionUID = 1L;
        private final CDOBranchPoint oldBranchPoint;
        private final CDOBranchPoint newBranchPoint;

        public TagMovedEventImpl(CDOTagListImpl tagList, CDOBranchTagImpl tag, CDOBranchPoint oldBranchPoint, CDOBranchPoint newBranchPoint) {
            super(tagList, tag);
            this.oldBranchPoint = oldBranchPoint;
            this.newBranchPoint = newBranchPoint;
        }

        @Override
        public CDOBranchPoint getOldBranchPoint() {
            return this.oldBranchPoint;
        }

        @Override
        public CDOBranchPoint getNewBranchPoint() {
            return this.newBranchPoint;
        }

        @Override
        protected String formatAdditionalParameters() {
            return String.valueOf(super.formatAdditionalParameters()) + ", oldBranchPoint=" + this.oldBranchPoint + ", newBranchPoint=" + this.newBranchPoint;
        }
    }

    private static final class TagRenamedEventImpl
    extends TagListEventImpl
    implements CDOBranchManager.CDOTagList.TagRenamedEvent {
        private static final long serialVersionUID = 1L;
        private final String oldName;
        private final String newName;

        public TagRenamedEventImpl(CDOTagListImpl tagList, CDOBranchTagImpl tag, String oldName, String newName) {
            super(tagList, tag);
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        public String getOldName() {
            return this.oldName;
        }

        @Override
        public String getNewName() {
            return this.newName;
        }

        @Override
        protected String formatAdditionalParameters() {
            return String.valueOf(super.formatAdditionalParameters()) + ", oldName=" + this.oldName + ", newName=" + this.newName;
        }
    }
}

