/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.impl;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.Group;
import org.eclipse.emf.cdo.security.Permission;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.security.UserPassword;
import org.eclipse.emf.cdo.security.impl.AssigneeImpl;
import org.eclipse.emf.cdo.security.impl.DerivedList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.net4j.util.StringUtil;

public class UserImpl
extends AssigneeImpl
implements User {
    private EList<Group> allGroups = new DerivedList<Group>(){

        @Override
        protected InternalEObject getOwner() {
            return UserImpl.this;
        }

        @Override
        protected EStructuralFeature getFeature() {
            return SecurityPackage.Literals.USER__ALL_GROUPS;
        }

        @Override
        protected Object[] getData() {
            HashSet<Group> result = new HashSet<Group>();
            for (Group group : UserImpl.this.getGroups()) {
                result.add(group);
                result.addAll((Collection<Group>)group.getAllInheritedGroups());
            }
            return result.toArray();
        }
    };
    private EList<Role> allRoles = new DerivedList<Role>(){

        @Override
        protected InternalEObject getOwner() {
            return UserImpl.this;
        }

        @Override
        protected EStructuralFeature getFeature() {
            return SecurityPackage.Literals.USER__ALL_ROLES;
        }

        @Override
        protected Object[] getData() {
            HashSet<Role> result = new HashSet<Role>();
            result.addAll((Collection<Role>)UserImpl.this.getRoles());
            for (Group group : UserImpl.this.getAllGroups()) {
                result.addAll((Collection<Role>)group.getAllRoles());
            }
            return result.toArray();
        }
    };
    private EList<Permission> allPermissions = new DerivedList<Permission>(){

        @Override
        protected InternalEObject getOwner() {
            return UserImpl.this;
        }

        @Override
        protected EStructuralFeature getFeature() {
            return SecurityPackage.Literals.USER__ALL_PERMISSIONS;
        }

        @Override
        protected Object[] getData() {
            BasicEList result = new BasicEList();
            for (Role role : UserImpl.this.getAllRoles()) {
                result.addAll(role.getPermissions());
            }
            return result.toArray();
        }
    };
    private EList<Role> unassignedRoles = new DerivedList<Role>(){

        @Override
        protected InternalEObject getOwner() {
            return UserImpl.this;
        }

        @Override
        protected EStructuralFeature getFeature() {
            return SecurityPackage.Literals.USER__UNASSIGNED_ROLES;
        }

        @Override
        protected Object[] getData() {
            HashSet<Role> result = new HashSet<Role>();
            Realm realm = UserImpl.this.getRealm();
            if (realm != null) {
                result.addAll((Collection<Role>)realm.getAllRoles());
                result.removeAll((Collection<?>)UserImpl.this.getAllRoles());
            }
            return result.toArray();
        }
    };

    protected UserImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SecurityPackage.Literals.USER;
    }

    @Override
    public EList<Group> getGroups() {
        return (EList)this.eGet((EStructuralFeature)SecurityPackage.Literals.USER__GROUPS, true);
    }

    @Override
    public EList<Group> getAllGroups() {
        return this.allGroups;
    }

    @Override
    public EList<Role> getAllRoles() {
        return this.allRoles;
    }

    @Override
    public EList<Permission> getAllPermissions() {
        return this.allPermissions;
    }

    @Override
    public EList<Role> getUnassignedRoles() {
        return this.unassignedRoles;
    }

    @Override
    public String getLabel() {
        String label = this.getLastName();
        String firstName = this.getFirstName();
        if (!StringUtil.isEmpty((String)firstName)) {
            label = String.valueOf(firstName) + " " + this.getLastName();
        }
        return label;
    }

    @Override
    public String getFirstName() {
        return (String)this.eGet((EStructuralFeature)SecurityPackage.Literals.USER__FIRST_NAME, true);
    }

    @Override
    public void setFirstName(String newFirstName) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.USER__FIRST_NAME, newFirstName);
    }

    @Override
    public String getLastName() {
        return (String)this.eGet((EStructuralFeature)SecurityPackage.Literals.USER__LAST_NAME, true);
    }

    @Override
    public void setLastName(String newLastName) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.USER__LAST_NAME, newLastName);
    }

    @Override
    public String getEmail() {
        return (String)this.eGet((EStructuralFeature)SecurityPackage.Literals.USER__EMAIL, true);
    }

    @Override
    public void setEmail(String newEmail) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.USER__EMAIL, newEmail);
    }

    @Override
    public Access getDefaultAccessOverride() {
        return (Access)((Object)this.eGet((EStructuralFeature)SecurityPackage.Literals.USER__DEFAULT_ACCESS_OVERRIDE, true));
    }

    @Override
    public void setDefaultAccessOverride(Access newDefaultAccessOverride) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.USER__DEFAULT_ACCESS_OVERRIDE, (Object)newDefaultAccessOverride);
    }

    @Override
    public Access getDefaultAccess() {
        Access defaultAccessOverride = this.getDefaultAccessOverride();
        if (defaultAccessOverride != null) {
            return defaultAccessOverride;
        }
        Realm realm = this.getRealm();
        if (realm != null) {
            return realm.getDefaultAccess();
        }
        return null;
    }

    @Override
    public boolean isLocked() {
        return (Boolean)this.eGet((EStructuralFeature)SecurityPackage.Literals.USER__LOCKED, true);
    }

    @Override
    public void setLocked(boolean newLocked) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.USER__LOCKED, newLocked);
    }

    @Override
    public UserPassword getPassword() {
        return (UserPassword)this.eGet((EStructuralFeature)SecurityPackage.Literals.USER__PASSWORD, true);
    }

    @Override
    public void setPassword(UserPassword newPassword) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.USER__PASSWORD, newPassword);
    }
}

