/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security.operations;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

public final class AuthorizableOperation {
    private static final ClassLoader CLASS_LOADER = OM.BUNDLE.getClass().getClassLoader();
    private final String id;
    private final Map<String, Object> parameters;

    private AuthorizableOperation(String id, Map<String, Object> parameters) {
        this.id = id;
        this.parameters = parameters;
    }

    public String getID() {
        return this.id;
    }

    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public AuthorizableOperation stripParameters() {
        return this.parameters.isEmpty() ? this : AuthorizableOperation.build(this.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AuthorizableOperation)) {
            return false;
        }
        AuthorizableOperation other = (AuthorizableOperation)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        if (this.parameters.isEmpty()) {
            return "AuthorizableOperation[" + this.id + "]";
        }
        return "AuthorizableOperation[" + this.id + ", parameters=" + this.parameters + "]";
    }

    public void write(ExtendedDataOutput out) throws IOException {
        out.writeString(this.id);
        out.writeVarInt(this.parameters.size());
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            out.writeString(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    public static AuthorizableOperation read(ExtendedDataInput in) throws IOException {
        String id = in.readString();
        Builder builder = AuthorizableOperation.builder(id);
        int size = in.readVarInt();
        int i = 0;
        while (i < size) {
            String key = in.readString();
            Object value = in.readObject(CLASS_LOADER);
            builder.parameter(key, value);
            ++i;
        }
        return builder.build();
    }

    public static AuthorizableOperation build(String operationID) {
        return AuthorizableOperation.builder(operationID).build();
    }

    public static Builder builder(String operationID) {
        return new Builder(operationID);
    }

    /* synthetic */ AuthorizableOperation(String string, Map map, AuthorizableOperation authorizableOperation) {
        this(string, map);
    }

    public static final class Builder {
        private static final Map<String, WeakReference<AuthorizableOperation>> OPERATIONS = new HashMap<String, WeakReference<AuthorizableOperation>>();
        private final String id;
        private final Map<String, Object> parameters = new HashMap<String, Object>();

        public Builder(String id) {
            CheckUtil.checkArg(id, "id");
            this.id = id.intern();
        }

        public String id() {
            return this.id;
        }

        public Map<String, Object> parameters() {
            return this.parameters;
        }

        public Object parameter(String key) {
            return this.parameters.get(key);
        }

        public Builder parameter(String key, Object value) {
            CheckUtil.checkArg(key, "key");
            CheckUtil.checkArg(value, "value");
            this.parameters.put(key.intern(), value);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AuthorizableOperation build() {
            if (this.parameters.isEmpty()) {
                AuthorizableOperation operation;
                Map<String, WeakReference<AuthorizableOperation>> map = OPERATIONS;
                synchronized (map) {
                    WeakReference<AuthorizableOperation> ref = OPERATIONS.get(this.id);
                    if (ref != null && (operation = (AuthorizableOperation)ref.get()) != null) {
                        return operation;
                    }
                    operation = new AuthorizableOperation(this.id, Collections.emptyMap(), null);
                    OPERATIONS.put(this.id, new WeakReference<AuthorizableOperation>(operation));
                }
                return operation;
            }
            return new AuthorizableOperation(this.id, this.parameters, null);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)obj;
            return this.id == other.id;
        }

        public String toString() {
            if (this.parameters.isEmpty()) {
                return "AuthorizableOperation.Builder[" + this.id + "]";
            }
            return "AuthorizableOperation.Builder[" + this.id + ", parameters=" + this.parameters + "]";
        }
    }
}

