/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOUserInfoManager;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.Entity;
import org.eclipse.net4j.util.ui.chat.ChatMessage;

public class CDOAuthorCache {
    private static final String PROPERTIES_KEY = CDOAuthorCache.class.getName();
    private final CDOSession session;
    private final ChatMessage.Author.Cache cache;

    public CDOAuthorCache(CDOSession session) {
        this.session = session;
        this.cache = new ChatMessage.Author.Cache(this::loadAuthors);
    }

    public final CDOSession getSession() {
        return this.session;
    }

    public ChatMessage.Author getAuthor(String userID) {
        return this.cache.getAuthor(userID);
    }

    public Map<String, ChatMessage.Author> getAuthors(Iterable<String> userIDs) {
        return this.cache.getAuthors(userIDs);
    }

    private Map<String, ChatMessage.Author> loadAuthors(Iterable<String> userIDs) {
        HashMap<String, ChatMessage.Author> authors = new HashMap<String, ChatMessage.Author>();
        CDOUserInfoManager userInfoManager = this.session.getUserInfoManager();
        Map userInfos = userInfoManager.getUserInfos(userIDs);
        for (String userID : userIDs) {
            ChatMessage.Author.Builder builder = ChatMessage.Author.builder((String)userID);
            Entity entity = (Entity)userInfos.get(userID);
            if (entity != null) {
                String avatarUri;
                String initials;
                builder.firstName(entity.property("givenName"));
                builder.lastName(entity.property("sn"));
                String fullName = entity.property("cn");
                if (!StringUtil.isEmpty((String)fullName)) {
                    builder.fullName(fullName);
                }
                if (!StringUtil.isEmpty((String)(initials = entity.property("Initials")))) {
                    builder.initials(initials);
                }
                if (!StringUtil.isEmpty((String)(avatarUri = entity.property("avatarUri")))) {
                    try {
                        builder.avatar(URI.create(avatarUri));
                    }
                    catch (Exception ex) {
                        OM.LOG.warn("Malformed URI: " + avatarUri, (Throwable)ex);
                    }
                } else if (StringUtil.isTrue((String)entity.property("gravatar"))) {
                    builder.gravatar(entity.property("mail"));
                }
            }
            authors.put(userID, builder.build());
        }
        return authors;
    }

    public static CDOAuthorCache of(CDOSession session) {
        return (CDOAuthorCache)session.properties().computeIfAbsent((Object)PROPERTIES_KEY, k -> new CDOAuthorCache(session));
    }
}

