/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequestWithMonitoring;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class LoadMergeDataRequest
extends CDOClientRequestWithMonitoring<CDOSessionProtocol.MergeDataResult> {
    private CDORevisionAvailabilityInfo targetInfo;
    private CDORevisionAvailabilityInfo sourceInfo;
    private CDORevisionAvailabilityInfo targetBaseInfo;
    private CDORevisionAvailabilityInfo sourceBaseInfo;
    private int infos;
    private boolean auto;

    public LoadMergeDataRequest(CDOClientProtocol protocol, CDORevisionAvailabilityInfo targetInfo, CDORevisionAvailabilityInfo sourceInfo, CDORevisionAvailabilityInfo targetBaseInfo, CDORevisionAvailabilityInfo sourceBaseInfo) {
        super(protocol, (short)45);
        this.targetInfo = targetInfo;
        this.sourceInfo = sourceInfo;
        this.targetBaseInfo = targetBaseInfo;
        this.sourceBaseInfo = sourceBaseInfo;
        this.infos = 2 + (targetBaseInfo != null ? 1 : 0) + (sourceBaseInfo != null ? 1 : 0);
    }

    @Override
    protected void requesting(CDODataOutput out, OMMonitor monitor) throws IOException {
        out.writeXInt(this.infos);
        monitor.begin((double)this.infos);
        try {
            this.writeRevisionAvailabilityInfo(out, this.targetInfo, monitor.fork());
            this.writeRevisionAvailabilityInfo(out, this.sourceInfo, monitor.fork());
            if (this.infos > 2) {
                this.writeRevisionAvailabilityInfo(out, this.targetBaseInfo, monitor.fork());
            }
            if (this.infos > 3) {
                this.writeRevisionAvailabilityInfo(out, this.sourceBaseInfo, monitor.fork());
            }
        }
        finally {
            monitor.done();
        }
    }

    private void writeRevisionAvailabilityInfo(CDODataOutput out, CDORevisionAvailabilityInfo info, OMMonitor monitor) throws IOException {
        CDOBranchPoint branchPoint = info.getBranchPoint();
        if (branchPoint != CDOBranchUtil.AUTO_BRANCH_POINT) {
            out.writeBoolean(true);
            Set availableRevisions = info.getAvailableRevisions().keySet();
            int size = availableRevisions.size();
            out.writeCDOBranchPoint(branchPoint);
            out.writeXInt(size);
            monitor.begin((double)size);
            try {
                for (CDOID id : availableRevisions) {
                    out.writeCDOID(id);
                    monitor.worked();
                }
            }
            finally {
                monitor.done();
            }
        } else {
            out.writeBoolean(false);
            this.auto = true;
        }
    }

    @Override
    protected CDOSessionProtocol.MergeDataResult confirming(CDODataInput in, OMMonitor monitor) throws IOException {
        CDOSessionProtocol.MergeDataResult result = new CDOSessionProtocol.MergeDataResult();
        monitor.begin((double)(1 + this.infos));
        try {
            LoadMergeDataRequest.readIDs(in, id -> {
                boolean bl = result.getTargetIDs().add(id);
            });
            LoadMergeDataRequest.readIDs(in, id -> {
                result.getTargetIDs().add(id);
                result.getSourceIDs().add(id);
            });
            LoadMergeDataRequest.readIDs(in, id -> {
                boolean bl = result.getSourceIDs().add(id);
            });
            monitor.worked();
            if (this.auto) {
                this.targetBaseInfo.setBranchPoint(in.readCDOBranchPoint());
                if (in.readBoolean()) {
                    this.sourceBaseInfo.setBranchPoint(in.readCDOBranchPoint());
                } else {
                    this.sourceBaseInfo.setBranchPoint(this.targetBaseInfo.getBranchPoint());
                    this.infos = 3;
                }
            }
            this.readRevisionAvailabilityInfo(in, this.targetInfo, result.getTargetIDs(), monitor.fork());
            this.readRevisionAvailabilityInfo(in, this.sourceInfo, result.getSourceIDs(), monitor.fork());
            if (this.infos > 2) {
                this.readRevisionAvailabilityInfo(in, this.targetBaseInfo, result.getTargetIDs(), monitor.fork());
            }
            if (this.infos > 3) {
                this.readRevisionAvailabilityInfo(in, this.sourceBaseInfo, result.getSourceIDs(), monitor.fork());
            }
            result.setResultBase(CDOBranchUtil.readBranchPointOrNull((CDODataInput)in));
            CDOSessionProtocol.MergeDataResult mergeDataResult = result;
            return mergeDataResult;
        }
        finally {
            monitor.done();
        }
    }

    private void readRevisionAvailabilityInfo(CDODataInput in, CDORevisionAvailabilityInfo info, Set<CDOID> result, OMMonitor monitor) throws IOException {
        int size = in.readXInt();
        monitor.begin((double)(size + 1));
        try {
            int i = 0;
            while (i < size) {
                CDORevision revision;
                if (in.readBoolean()) {
                    revision = in.readCDORevision();
                } else {
                    CDORevisionKey key = in.readCDORevisionKey();
                    revision = this.getRevision(key, this.targetInfo);
                    if (revision == null && this.sourceInfo != null) {
                        revision = this.getRevision(key, this.sourceInfo);
                    }
                    if (revision == null && this.targetBaseInfo != null) {
                        revision = this.getRevision(key, this.targetBaseInfo);
                    }
                    if (revision == null) {
                        throw new IllegalStateException("Missing revision: " + key);
                    }
                }
                info.addRevision((CDORevisionKey)revision);
                monitor.worked();
                ++i;
            }
            Set entrySet = info.getAvailableRevisions().entrySet();
            Iterator it = entrySet.iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (result.contains(entry.getKey())) continue;
                it.remove();
            }
            monitor.worked();
        }
        finally {
            monitor.done();
        }
    }

    private CDORevision getRevision(CDORevisionKey key, CDORevisionAvailabilityInfo info) {
        CDORevision revision = info.getRevision(key.getID());
        if (revision instanceof CDORevision && key.equals(revision)) {
            return revision;
        }
        return null;
    }

    private static void readIDs(CDODataInput in, Consumer<CDOID> consumer) throws IOException {
        CDOID id;
        while (!CDOIDUtil.isNull((CDOID)(id = in.readCDOID()))) {
            consumer.accept(id);
        }
    }
}

