/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.utilities;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.pivot.qvtimperative.CheckStatement;
import org.eclipse.qvtd.pivot.qvtimperative.MappingLoop;
import org.eclipse.qvtd.pivot.qvtimperative.NewStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SetStatement;
import org.eclipse.qvtd.pivot.qvtimperative.Statement;
import org.eclipse.qvtd.pivot.qvtimperative.VariableStatement;

public class StatementComparator
implements Comparator<Statement> {
    private final @NonNull List<@NonNull Statement> statements;
    private @Nullable Map<@NonNull Statement, @NonNull Set<@NonNull VariableDeclaration>> statement2referencedVariables = null;

    public StatementComparator(@NonNull List<@NonNull Statement> statements) {
        this.statements = statements;
    }

    @Override
    public int compare(@NonNull Statement o1, @NonNull Statement o2) {
        boolean isOk = o2 instanceof MappingLoop;
        if (isOk != o1 instanceof MappingLoop) {
            return isOk ? -1 : 1;
        }
        isOk = o2 instanceof SetStatement;
        if (isOk != o1 instanceof SetStatement) {
            return isOk ? -1 : 1;
        }
        isOk = o2 instanceof NewStatement;
        if (isOk != o1 instanceof NewStatement) {
            return isOk ? -1 : 1;
        }
        isOk = o2 instanceof CheckStatement;
        Map<@NonNull Statement, @NonNull Set<@NonNull VariableDeclaration>> statement2referencedVariables2 = this.statement2referencedVariables;
        if (statement2referencedVariables2 == null) {
            statement2referencedVariables2 = this.statement2referencedVariables = this.computeReferencedVariableClosure();
        }
        Set<@NonNull VariableDeclaration> r1 = statement2referencedVariables2.get(o1);
        Set<@NonNull VariableDeclaration> r2 = statement2referencedVariables2.get(o2);
        assert (r1 != null && r2 != null);
        int diff = r1.size() - r2.size();
        if (diff != 0) {
            return diff;
        }
        String n1 = o1.getName();
        String n2 = o2.getName();
        return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Map<@NonNull Statement, @NonNull Set<@NonNull VariableDeclaration>> computeReferencedVariableClosure() {
        boolean more;
        HashMap<@NonNull Statement, @NonNull Set<@NonNull VariableDeclaration>> statement2referencedVariables2 = new HashMap<Statement, Set<VariableDeclaration>>();
        HashMap<@NonNull VariableStatement, @NonNull Statement> variable2statement = new HashMap<VariableStatement, Statement>();
        for (Statement statement : this.statements) {
            if (statement instanceof VariableStatement) {
                variable2statement.put((VariableStatement)statement, statement);
            }
            HashSet<@NonNull VariableDeclaration> referencedVariables = new HashSet<VariableDeclaration>();
            for (EObject eObject : new TreeIterable((EObject)statement, false)) {
                if (eObject instanceof VariableExp) {
                    VariableDeclaration referredVariable = ((VariableExp)eObject).getReferredVariable();
                    assert (referredVariable != null);
                    referencedVariables.add(referredVariable);
                    continue;
                }
                if (!(eObject instanceof VariableDeclaration)) continue;
                referencedVariables.add((VariableDeclaration)eObject);
            }
            statement2referencedVariables2.put(statement, referencedVariables);
        }
        do {
            more = false;
            for (Statement statement : statement2referencedVariables2.keySet()) {
                @NonNull Set referencedVariables = (Set)statement2referencedVariables2.get(statement);
                assert (referencedVariables != null);
                for (VariableDeclaration referencedVariable : new ArrayList(referencedVariables)) {
                    Set referencedReferencedVariables;
                    Statement referencedStatement = (Statement)variable2statement.get(referencedVariable);
                    if (referencedStatement == null || (referencedReferencedVariables = (Set)statement2referencedVariables2.get(referencedStatement)) == null || !referencedVariables.addAll(referencedReferencedVariables)) continue;
                    more = true;
                }
            }
        } while (more);
        return statement2referencedVariables2;
    }
}

