/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.internal.evaluation;

import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.ClassId;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.evaluation.EvaluationCache;
import org.eclipse.ocl.pivot.internal.values.SetValueImpl;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.SetValue;
import org.eclipse.qvtd.runtime.evaluation.AbstractObjectManager;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.Connection;
import org.eclipse.qvtd.runtime.evaluation.DefaultInterval;
import org.eclipse.qvtd.runtime.evaluation.ExecutionVisitor;
import org.eclipse.qvtd.runtime.evaluation.Interval;
import org.eclipse.qvtd.runtime.evaluation.InvalidEvaluationException;
import org.eclipse.qvtd.runtime.evaluation.InvocationFailedException;
import org.eclipse.qvtd.runtime.evaluation.InvocationManager;
import org.eclipse.qvtd.runtime.evaluation.ModeFactory;
import org.eclipse.qvtd.runtime.evaluation.ObjectManager;
import org.eclipse.qvtd.runtime.evaluation.TransformationExecutor;
import org.eclipse.qvtd.runtime.evaluation.Transformer;
import org.eclipse.qvtd.runtime.evaluation.TypedModelInstance;
import org.eclipse.qvtd.runtime.internal.evaluation.IncrementalInvocationManager;
import org.eclipse.qvtd.runtime.internal.evaluation.IncrementalObjectManager;
import org.eclipse.qvtd.runtime.internal.evaluation.LazyInvocationManager;
import org.eclipse.qvtd.runtime.internal.evaluation.LazyObjectManager;
import org.eclipse.qvtd.runtime.internal.evaluation.RuntimeModelsManager;
import org.eclipse.qvtd.runtime.qvttrace.TransformationExecution;

public abstract class AbstractTransformerInternal
implements Transformer {
    protected final @NonNull TransformationExecutor executor;
    @Deprecated
    protected final @NonNull Evaluator evaluator;
    protected final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IdResolver.IdResolverExtension idResolver;
    protected final @NonNull RuntimeModelsManager.Model @NonNull [] models;
    protected final @NonNull RuntimeModelsManager modelsManager;
    protected final boolean debugAssignments = AbstractTransformer.ASSIGNMENTS.isActive();
    protected final boolean debugCreations = AbstractTransformer.CREATIONS.isActive();
    protected final boolean debugExceptions = AbstractTransformer.EXCEPTIONS.isActive();
    protected final boolean debugGettings = AbstractTransformer.GETTINGS.isActive();
    protected final boolean debugInvocations = AbstractTransformer.INVOCATIONS.isActive();
    protected final @NonNull InvocationManager invocationManager;
    protected final @NonNull ObjectManager objectManager;
    protected final @NonNull EvaluationCache evaluationCache;

    protected AbstractTransformerInternal(@NonNull TransformationExecutor executor, @NonNull String @NonNull [] modelNames, @NonNull PropertyId @Nullable [] propertyIndex2propertyId, @NonNull ClassId @NonNull [] classIndex2classId, int @Nullable [] @NonNull [] classIndex2allClassIndexes) {
        this(executor, modelNames.length);
        if (propertyIndex2propertyId != null) {
            this.initOpposites(propertyIndex2propertyId);
        }
        int i = 0;
        while (i < modelNames.length) {
            RuntimeModelsManager.Model model = this.initModel(i, modelNames[i]);
            model.initClassIds(classIndex2classId, classIndex2allClassIndexes);
            ++i;
        }
        this.initConnections();
    }

    protected AbstractTransformerInternal(@NonNull TransformationExecutor executor, int models) {
        this.executor = executor;
        this.evaluator = executor;
        this.idResolver = (IdResolver.IdResolverExtension)executor.getIdResolver();
        this.invocationManager = this.createInvocationManager();
        this.objectManager = this.createObjectManager();
        this.evaluationCache = this.createEvaluationCache();
        this.modelsManager = new RuntimeModelsManager(models);
        this.models = this.modelsManager.getModels();
    }

    @Override
    public <R> R accept(@NonNull ExecutionVisitor<R> visitor) {
        return visitor.visitTransformer(this);
    }

    @Deprecated
    protected @NonNull Connection createConnection(@NonNull String name, @NonNull TypeId typeId, boolean isStrict) {
        return this.createConnection(this.invocationManager.getRootInterval(), name, typeId, isStrict, this.getModeFactory());
    }

    protected @NonNull Connection createConnection(@NonNull Interval interval, @NonNull String name, @NonNull TypeId typeId, boolean isStrict, @NonNull ModeFactory modeFactory) {
        return interval.createConnection(name, typeId, isStrict, modeFactory);
    }

    protected @NonNull EvaluationCache createEvaluationCache() {
        return new EvaluationCache((Executor)this.executor);
    }

    protected @NonNull Interval createInterval(int intervalIndex) {
        return new DefaultInterval(this.getInvocationManager(), intervalIndex);
    }

    protected @NonNull InvocationManager createInvocationManager() {
        return new LazyInvocationManager((Executor)this.executor);
    }

    protected @NonNull RuntimeModelsManager.Model createTypedModelInstance(@NonNull String modelName) {
        return new RuntimeModelsManager.Model(this.modelsManager, modelName);
    }

    @Deprecated
    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SetValue.Accumulator createUnenforcedSetAccumulatorValue(@NonNull CollectionTypeId typeId) {
        return new UnenforcedSetAccumulator(typeId);
    }

    protected @NonNull ObjectManager createObjectManager() {
        return new LazyObjectManager((LazyInvocationManager)this.invocationManager);
    }

    @Deprecated
    public @NonNull Iterable<@NonNull Object> get(@NonNull Class type) {
        return this.models[0].getObjectsOfKind(type);
    }

    @Override
    public @NonNull EvaluationCache getEvaluationCache() {
        return this.evaluationCache;
    }

    @Override
    public @NonNull TransformationExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public @NonNull InvocationManager getInvocationManager() {
        return this.invocationManager;
    }

    public @NonNull ModeFactory getModeFactory() {
        return ModeFactory.NON_INCREMENTAL;
    }

    @Override
    public @NonNull RuntimeModelsManager getModelsManager() {
        return this.modelsManager;
    }

    @Override
    public @NonNull ObjectManager getObjectManager() {
        return this.objectManager;
    }

    @Override
    public int getTypedModelIndex(@NonNull String targetModelName) {
        return this.modelsManager.getTypedModelIndex(targetModelName);
    }

    @Override
    public @Nullable TransformationExecution getTransformationExecution() {
        return null;
    }

    @Override
    public @NonNull TypedModelInstance getTypedModelInstance(@NonNull String modelName) {
        return this.modelsManager.getTypedModelInstance(modelName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleExecutionFailure(@NonNull String mappingName, @NonNull Throwable e) throws InvocationFailedException {
        if (e instanceof InvocationFailedException) {
            throw (InvocationFailedException)((Object)e);
        }
        if (e instanceof InvalidEvaluationException) {
            if (!this.debugExceptions) throw (InvalidEvaluationException)((Object)e);
            AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
            throw (InvalidEvaluationException)((Object)e);
        }
        if (e instanceof AssertionError) {
            if (!this.debugExceptions) throw (AssertionError)((Object)e);
            AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
        } else {
            if (e instanceof Error) {
                if (!this.debugExceptions) throw (Error)e;
                AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
                throw (Error)e;
            }
            if (e instanceof InvalidValueException) {
                if (this.debugExceptions) {
                    AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
                }
            } else if (e instanceof NullPointerException) {
                if (this.debugExceptions) {
                    AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
                }
            } else if (this.debugExceptions) {
                AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
            }
        }
        if (!(e instanceof Exception)) throw new InvalidEvaluationException(new RuntimeException(e));
        throw new InvalidEvaluationException((Exception)e);
    }

    protected void initConnections() {
        Interval rootInterval = this.lazyCreateInterval(0);
        ModeFactory modeFactory = this.getModeFactory();
        RuntimeModelsManager.Model[] modelArray = this.models;
        int n = this.models.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull RuntimeModelsManager.Model model = modelArray[n2];
            model.initConnections(rootInterval, modeFactory);
            ++n2;
        }
    }

    protected @NonNull RuntimeModelsManager.Model initModel(int i, @NonNull String modelName) {
        RuntimeModelsManager.Model model = this.createTypedModelInstance(modelName);
        this.modelsManager.initTypedModelInstance(i, model);
        return model;
    }

    protected void initOpposites(@NonNull PropertyId @NonNull [] propertyIndex2propertyId) {
        this.modelsManager.initOpposites(propertyIndex2propertyId);
    }

    protected @NonNull Interval lazyCreateInterval(int intervalIndex) {
        if (intervalIndex < 0) {
            return this.invocationManager.createInterval();
        }
        int i = this.invocationManager.getIntervalsSize();
        while (i < intervalIndex) {
            this.createInterval(i);
            ++i;
        }
        Interval interval = this.invocationManager.basicGetInterval(intervalIndex);
        return interval != null ? interval : this.createInterval(intervalIndex);
    }

    @Override
    public void analyzeInputResources() {
        RuntimeModelsManager.Model[] modelArray = this.models;
        int n = this.models.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull RuntimeModelsManager.Model model = modelArray[n2];
            model.analyzeInputResources();
            ++n2;
        }
    }

    @Override
    public boolean run() throws Exception {
        return false;
    }

    @Override
    public boolean run(@NonNull String targetName) throws Exception {
        return false;
    }

    public @NonNull Object throwInvalidEvaluationException(@NonNull String message, Object ... bindings) {
        throw new InvalidEvaluationException(message, bindings);
    }

    protected @NonNull String toDebugString(@Nullable Object object) {
        return AbstractObjectManager.toDebugString(object);
    }

    public static abstract class Incremental
    extends AbstractTransformerInternal {
        protected Incremental(@NonNull TransformationExecutor executor, @NonNull String @NonNull [] modelNames, @NonNull PropertyId @Nullable [] propertyIndex2propertyId, @NonNull ClassId @NonNull [] classIndex2classId, int @Nullable [] @NonNull [] classIndex2allClassIndexes) {
            super(executor, modelNames, propertyIndex2propertyId, classIndex2classId, classIndex2allClassIndexes);
        }

        protected Incremental(@NonNull TransformationExecutor executor, int models) {
            super(executor, models);
        }

        @Override
        @Deprecated
        protected @NonNull Connection createConnection(@NonNull String name, @NonNull TypeId typeId, boolean isStrict) {
            return this.createConnection(this.invocationManager.getRootInterval(), name, typeId, isStrict, ModeFactory.NON_INCREMENTAL);
        }

        @Override
        protected @NonNull Connection createConnection(@NonNull Interval interval, @NonNull String name, @NonNull TypeId typeId, boolean isStrict, @NonNull ModeFactory modeFactory) {
            return interval.createConnection(name, typeId, isStrict, modeFactory);
        }

        @Override
        protected @NonNull InvocationManager createInvocationManager() {
            return new IncrementalInvocationManager((Executor)this.executor);
        }

        @Override
        protected @NonNull RuntimeModelsManager.Model createTypedModelInstance(@NonNull String modelName) {
            return new RuntimeModelsManager.Model.Incremental(this.modelsManager, modelName);
        }

        @Override
        protected @NonNull ObjectManager createObjectManager() {
            return new IncrementalObjectManager((IncrementalInvocationManager)this.invocationManager);
        }

        @Override
        public @NonNull ModeFactory getModeFactory() {
            return ModeFactory.INCREMENTAL;
        }
    }

    @Deprecated
    private static class UnenforcedSetAccumulator
    extends SetValueImpl
    implements SetValue.Accumulator {
        public UnenforcedSetAccumulator(@NonNull CollectionTypeId typeId) {
            super(typeId, new ArrayList());
        }

        public boolean add(@Nullable Object value) {
            assert (!this.elements.contains(value));
            return this.elements.add(value);
        }
    }
}

