/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractSimplePartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.BasicPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtschedule.BasicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class WhenPartitionFactory
extends AbstractSimplePartitionFactory {
    protected final boolean useActivators;
    private final @NonNull Iterable<@NonNull Node> executionNodes;
    private final @NonNull Iterable<@NonNull Node> realizedWhenNodes;
    private final @Nullable Node dispatchNode;

    public WhenPartitionFactory(@NonNull MappingPartitioner mappingPartitioner, boolean useActivators) {
        super(mappingPartitioner);
        this.executionNodes = mappingPartitioner.getExecutionNodes();
        this.realizedWhenNodes = mappingPartitioner.getRealizedWhenNodes();
        this.useActivators = useActivators;
        this.dispatchNode = mappingPartitioner.basicGetDispatchNode();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull BasicPartitionAnalysis createPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis) {
        ReachabilityForest reachabilityForest = this.createReachabilityForest();
        String name = this.computeName("when");
        @NonNull Iterable headNodes = this.useActivators ? this.executionNodes : QVTscheduleUtil.getHeadNodes((Region)this.mappingPartitioner.getRegion());
        BasicPartition partition = this.createBasicPartition(name, headNodes);
        int partitionNumber = ((RuleRegion)this.region).getNextPartitionNumber();
        BasicPartitionAnalysis basicPartitionAnalysis = new BasicPartitionAnalysis(partitionedTransformationAnalysis, partition, reachabilityForest, "\u00abwhen\u00bb", "_p" + partitionNumber);
        this.initializePartition(basicPartitionAnalysis);
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            this.scheduleManager.writeDebugGraphs((Graphable)partition, null);
        }
        return basicPartitionAnalysis;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected @NonNull Iterable<@NonNull Node> getReachabilityRootNodes() {
        @NonNull Iterable headNodes = QVTscheduleUtil.getHeadNodes((Region)this.mappingPartitioner.getRegion());
        List<@NonNull Node> traceNodes = this.mappingPartitioner.getTraceNodes();
        ArrayList<@NonNull Node> rootNodes = new ArrayList<Node>();
        for (Node node : this.useActivators ? traceNodes : headNodes) {
            if (node.isDependency()) continue;
            rootNodes.add(node);
        }
        for (Node node : this.mappingPartitioner.getConstantInputNodes()) {
            rootNodes.add(node);
        }
        return rootNodes;
    }

    protected void initializePartition(@NonNull BasicPartitionAnalysis partitionAnalysis) {
        BasicPartition partition = (BasicPartition)partitionAnalysis.getPartition();
        for (Node traceNode : this.executionNodes) {
            this.addNode(partition, traceNode, Role.PREDICATED);
        }
        for (Node realizedWhenNode : this.realizedWhenNodes) {
            this.addNode(partition, realizedWhenNode);
            for (Edge incomingEdge : QVTscheduleUtil.getIncomingEdges((Node)realizedWhenNode)) {
                Node argumentNode = QVTscheduleUtil.getSourceNode((Edge)incomingEdge);
                if (!this.scheduleManager.isInput(argumentNode)) continue;
                this.addNode(partition, argumentNode);
            }
        }
        this.resolvePrecedingNodes(partitionAnalysis);
        this.resolveDisambiguations(partition);
        this.resolveEdges(partitionAnalysis);
    }

    @Override
    protected boolean isAvailable(@NonNull BasicPartition partition, @NonNull Node node) {
        return node.isConstant() || node.isLoaded();
    }

    protected boolean isTraced(@NonNull Node node, @NonNull Iterable<@NonNull Node> executionNodes) {
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            Node sourceNode;
            assert (!edge.isCast());
            if (!edge.isNavigation() || !Iterables.contains(executionNodes, (Object)(sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge)))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        Role edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED) {
            if (this.mappingPartitioner.hasRealizedEdge(edge)) {
                edgeRole = Role.PREDICATED;
            } else if (this.dispatchNode == edge.getSourceNode()) {
                edgeRole = null;
            }
        }
        return edgeRole;
    }
}

