/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.PivotPropertyKey;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTcRelations;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.Rule;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.InvokedRelationToMappingForEnforcement;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.QVTcoreBaseBottomPatternKey;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.QVTcoreBaseCoreDomainKey;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.QVTcoreBaseGuardPatternKey;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.QVTcoreMappingKey;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.QVTcoreVariableKey;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.RelationalTransformationToMappingTransformation;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.RelationalTransformationToTracePackage;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.RuleBindings;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.TopLevelRelationToMappingForEnforcement;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.utilities.TransformationTraceData;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.utilities.TransformationTraceDataImpl;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.QVTbaseFactory;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtcore.CoreModel;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.QVTcoreFactory;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.CorePattern;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.QVTcoreBaseFactory;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

public class QvtrToQvtcTransformation {
    @NonNull
    private final TransformationTraceData traceData;
    @NonNull
    private final Resource qvtrModel;
    @NonNull
    private final Resource qvtcModel;
    @Nullable
    private final Resource qvtcTraceModel;
    @NonNull
    private final List<EObject> potentialOrphans = new ArrayList<EObject>();
    @NonNull
    private final List<EObject> traceRoots = new ArrayList<EObject>();
    @NonNull
    private final List<EObject> coreRoots = new ArrayList<EObject>();
    @NonNull
    private final Map<Variable, Variable> variableTrace = new HashMap<Variable, Variable>();
    @NonNull
    private final Map<Relation, Class> relationToTraceClass = new HashMap<Relation, Class>();
    @NonNull
    private final Map<RelationalTransformation, Package> transformationToPackage = new HashMap<RelationalTransformation, Package>();
    private final Map<Type, Key> keyForType = new HashMap<Type, Key>();
    private final Map<Variable, TemplateExp> templateExpForVaraible = new HashMap<Variable, TemplateExp>();
    private final Map<Relation, List<RelationCallExp>> relationCallExpsForRelation = new HashMap<Relation, List<RelationCallExp>>();
    private final Map<RelationCallExp, Relation> invokingRelationsForRelationCallExp = new HashMap<RelationCallExp, Relation>();
    private boolean doGlobalSearch = true;
    @NonNull
    private final EnvironmentFactory environmentFactory;
    private QVTcoreMappingKey mappings = new QVTcoreMappingKey();
    private QVTcoreBaseGuardPatternKey guardPatterns = new QVTcoreBaseGuardPatternKey();
    private QVTcoreBaseBottomPatternKey botttomPatterns = new QVTcoreBaseBottomPatternKey();
    private QVTcoreBaseCoreDomainKey coreDomains = new QVTcoreBaseCoreDomainKey();
    private PivotPropertyKey properties = new PivotPropertyKey();
    private QVTcoreVariableKey variables = new QVTcoreVariableKey();
    private QVTcoreVariableKey realizedVariables = new QVTcoreVariableKey();
    private CoreModel coreModel;

    public QvtrToQvtcTransformation(@NonNull EnvironmentFactory environmentFactory, @NonNull Resource qvtrModel, @NonNull Resource qvtcModel, @Nullable Resource qvtcTraceModel) {
        this.environmentFactory = environmentFactory;
        this.qvtrModel = qvtrModel;
        this.qvtcModel = qvtcModel;
        this.qvtcTraceModel = qvtcTraceModel;
        this.traceData = new TransformationTraceDataImpl();
        this.coreModel = QVTcoreFactory.eINSTANCE.createCoreModel();
        TreeIterator it = qvtrModel.getAllContents();
        while (it.hasNext()) {
            EObject eo = (EObject)it.next();
            if (eo instanceof Key) {
                this.keyForType.put((Type)((Key)eo).getIdentifies(), (Key)eo);
            }
            if (eo instanceof Pattern) {
                Pattern p = (Pattern)eo;
                for (Predicate pred : p.getPredicate()) {
                    p.getBindsTo().addAll(this.getVarsOfExp(pred.getConditionExpression()));
                }
                if (eo instanceof DomainPattern) {
                    DomainPattern dp = (DomainPattern)eo;
                    TemplateExp te = dp.getTemplateExpression();
                    dp.getBindsTo().add((Object)te.getBindsTo());
                    if (te instanceof ObjectTemplateExp) {
                        dp.getBindsTo().addAll(this.getNestedBindToVariable((ObjectTemplateExp)te));
                    }
                }
            }
            if (eo instanceof TemplateExp) {
                TemplateExp te = (TemplateExp)eo;
                this.templateExpForVaraible.put(te.getBindsTo(), te);
            }
            if (eo instanceof RelationCallExp) {
                Relation ir;
                RelationCallExp ri = (RelationCallExp)eo;
                Relation r = ri.getReferredRelation();
                assert (r != null);
                Predicate p = (Predicate)ri.eContainer();
                Pattern pattern = p.getPattern();
                if (pattern.eContainer() instanceof Relation && (ir = (Relation)pattern.eContainer()).getWhere() == pattern) {
                    if (this.relationCallExpsForRelation.get(r) != null) {
                        this.relationCallExpsForRelation.get(r).add(ri);
                    } else {
                        ArrayList<RelationCallExp> callExps = new ArrayList<RelationCallExp>();
                        callExps.add(ri);
                        this.relationCallExpsForRelation.put(r, callExps);
                    }
                    this.invokingRelationsForRelationCallExp.put(ri, ir);
                }
            }
            if (!(eo instanceof Import)) continue;
            this.coreModel.getOwnedImports().add((Import)EcoreUtil.copy((EObject)eo));
        }
    }

    public void addOrphan(@NonNull EObject eObject) {
        this.potentialOrphans.add(eObject);
    }

    @NonNull
    public OperationCallExp createOperationCallExp() {
        OperationCallExp oce = PivotFactory.eINSTANCE.createOperationCallExp();
        assert (oce != null);
        this.addOrphan((EObject)oce);
        return oce;
    }

    @NonNull
    public Predicate createPredicate() {
        Predicate pd = QVTbaseFactory.eINSTANCE.createPredicate();
        assert (pd != null);
        this.addOrphan((EObject)pd);
        return pd;
    }

    @NonNull
    public PropertyAssignment createPropertyAssignment() {
        PropertyAssignment a = QVTcoreBaseFactory.eINSTANCE.createPropertyAssignment();
        assert (a != null);
        this.addOrphan((EObject)a);
        return a;
    }

    @NonNull
    public PropertyCallExp createPropertyCallExp() {
        PropertyCallExp pce = PivotFactory.eINSTANCE.createPropertyCallExp();
        assert (pce != null);
        this.addOrphan((EObject)pce);
        return pce;
    }

    @NonNull
    public VariableExp createVariableExp() {
        VariableExp ve = PivotFactory.eINSTANCE.createVariableExp();
        assert (ve != null);
        this.addOrphan((EObject)ve);
        return ve;
    }

    public void dispose() {
    }

    public void execute() {
        this.executeFactory(RelationalTransformationToTracePackage.FACTORY);
        for (EObject eObject : this.potentialOrphans) {
            if (eObject.eContainer() != null) continue;
            this.traceRoots.add(eObject);
        }
        this.potentialOrphans.clear();
        this.executeFactory(RelationalTransformationToMappingTransformation.FACTORY);
        this.executeFactory(TopLevelRelationToMappingForEnforcement.FACTORY);
        this.executeFactory(InvokedRelationToMappingForEnforcement.FACTORY);
        for (EObject eObject : this.potentialOrphans) {
            if (eObject.eContainer() != null) continue;
            this.coreRoots.add(eObject);
        }
    }

    public void executeFactory(@NonNull Rule.Factory factory) {
        for (Rule rule : factory.getRules(this, this.qvtrModel)) {
            if (rule == null) continue;
            this.executeTopLevelRule(rule);
            if (!rule.hasExecuted()) continue;
            this.traceData.addRecord(rule);
        }
    }

    public void executeNestedRule(@NonNull Rule rule) {
        if (!rule.hasExecuted()) {
            rule.check();
            if (rule.when()) {
                rule.instantiateOutput();
                rule.setExecuted(true);
                rule.where();
                rule.setAttributes();
            }
        }
        if (rule.hasExecuted()) {
            this.traceData.addRecord(rule);
        }
    }

    public void executeTopLevelRule(@NonNull Rule rule) {
        if (!rule.hasExecuted()) {
            rule.check();
            if (rule.when()) {
                rule.instantiateOutput();
                rule.setExecuted(true);
                rule.where();
                rule.setAttributes();
            }
        }
    }

    @NonNull
    public BottomPattern findBottomPattern(@NonNull Area area) {
        BottomPattern mb = null;
        if (this.doGlobalSearch) {
            mb = this.botttomPatterns.get(area);
        }
        if (mb == null) {
            mb = QVTcoreBaseFactory.eINSTANCE.createBottomPattern();
            assert (mb != null);
            mb.setArea(area);
            mb.getBindsTo();
            this.botttomPatterns.add(mb);
        }
        return mb;
    }

    @NonNull
    public CoreDomain findCoreDomain(@NonNull String name, @NonNull org.eclipse.qvtd.pivot.qvtbase.Rule rule) {
        CoreDomain md = null;
        if (this.doGlobalSearch) {
            md = this.coreDomains.get(name, rule);
        }
        if (md == null) {
            md = QVTcoreBaseFactory.eINSTANCE.createCoreDomain();
            assert (md != null);
            md.setName(name);
            md.setRule(rule);
            this.coreDomains.add(md);
        }
        return md;
    }

    @NonNull
    public GuardPattern findGuardPattern(@NonNull Area area) {
        GuardPattern mg = null;
        if (this.doGlobalSearch) {
            mg = this.guardPatterns.get(area);
        }
        if (mg == null) {
            mg = QVTcoreBaseFactory.eINSTANCE.createGuardPattern();
            assert (mg != null);
            mg.setArea(area);
            this.guardPatterns.add(mg);
        }
        return mg;
    }

    @NonNull
    public Mapping findMapping(@NonNull String mn, @NonNull Transformation mt) {
        Mapping m = null;
        if (this.doGlobalSearch) {
            m = this.mappings.get(mn, mt);
        }
        if (m == null) {
            m = QVTcoreFactory.eINSTANCE.createMapping();
            assert (m != null);
            m.setName(mn);
            m.setTransformation(mt);
            this.mappings.add(m);
        }
        return m;
    }

    public Property findProperty(@NonNull String name, @NonNull Class owningType) {
        Property p = null;
        if (this.doGlobalSearch) {
            p = this.properties.get(name, (Type)owningType);
        }
        if (p == null) {
            p = PivotFactory.eINSTANCE.createProperty();
            assert (p != null);
            p.setName(name);
            p.setOwningClass(owningType);
            this.properties.add(p);
        }
        return p;
    }

    @NonNull
    public RealizedVariable findRealizedVariable(@NonNull Variable sv, @NonNull CorePattern pattern) {
        RealizedVariable rv = null;
        String name = sv.getName();
        Type type = sv.getType();
        assert (name != null && type != null);
        if (this.doGlobalSearch) {
            rv = (RealizedVariable)this.realizedVariables.get(name, type, pattern);
        }
        if (rv == null) {
            rv = QVTcoreBaseFactory.eINSTANCE.createRealizedVariable();
            assert (rv != null);
            rv.setName(name);
            rv.setType(type);
            this.realizedVariables.add((Variable)rv, pattern);
            pattern.getVariable().add((Object)rv);
            this.putVariableTrace(sv, (Variable)rv);
        }
        return rv;
    }

    @NonNull
    public RealizedVariable findTraceRealizedVariable(@NonNull String name, @NonNull Type type, @NonNull CorePattern pattern) {
        RealizedVariable rv = null;
        if (this.doGlobalSearch) {
            rv = (RealizedVariable)this.realizedVariables.get(name, type, pattern);
        }
        if (rv == null) {
            rv = QVTcoreBaseFactory.eINSTANCE.createRealizedVariable();
            assert (rv != null);
            rv.setName(name);
            rv.setType(type);
            this.realizedVariables.add((Variable)rv, pattern);
            pattern.getVariable().add((Object)rv);
        }
        return rv;
    }

    @NonNull
    public Variable findVariable(@NonNull Variable sv, @NonNull CorePattern pattern) {
        Variable v = null;
        String name = sv.getName();
        Type type = sv.getType();
        assert (name != null && type != null);
        if (this.doGlobalSearch) {
            v = this.variables.get(name, type, pattern);
        }
        if (v == null) {
            v = PivotFactory.eINSTANCE.createVariable();
            assert (v != null);
            v.setName(name);
            v.setType(type);
            this.variables.add(v, pattern);
            pattern.getVariable().add((Object)v);
            this.putVariableTrace(sv, v);
        }
        return v;
    }

    @NonNull
    public Variable findVariable(@NonNull String name, @NonNull Type type, @NonNull CorePattern pattern) {
        Variable v = null;
        if (this.doGlobalSearch) {
            v = this.variables.get(name, type, pattern);
        }
        if (v == null) {
            v = PivotFactory.eINSTANCE.createVariable();
            assert (v != null);
            v.setName(name);
            v.setType(type);
            this.variables.add(v, pattern);
            pattern.getVariable().add((Object)v);
        }
        return v;
    }

    @NonNull
    public Collection<? extends EObject> getCoreRoots() {
        return this.coreRoots;
    }

    @Nullable
    public Key getKeyforType(@NonNull Type type) {
        return this.keyForType.get(type);
    }

    @NonNull
    public StandardLibrary getStandardLibrary() {
        return this.environmentFactory.getStandardLibrary();
    }

    private Set<Variable> getNestedBindToVariable(ObjectTemplateExp ote) {
        HashSet<Variable> vars = new HashSet<Variable>();
        for (PropertyTemplateItem p : ote.getPart()) {
            OCLExpression e = p.getValue();
            if (e instanceof ObjectTemplateExp) {
                vars.add(((ObjectTemplateExp)e).getBindsTo());
                vars.addAll(this.getNestedBindToVariable((ObjectTemplateExp)e));
                continue;
            }
            vars.addAll(this.getVarsOfExp(e));
        }
        return vars;
    }

    public Resource getQvtcSource() {
        return this.qvtcModel;
    }

    @Nullable
    public Rule getRecord(@NonNull RuleBindings relationsBindings) {
        return this.traceData.getRecord(relationsBindings);
    }

    @Nullable
    public Relation getInvokingRelationForRelationCallExp(@NonNull RelationCallExp e) {
        return this.invokingRelationsForRelationCallExp.get(e);
    }

    @Nullable
    public List<RelationCallExp> getRelationCallExpsForRelation(@NonNull Relation r) {
        return this.relationCallExpsForRelation.get(r);
    }

    @NonNull
    public Collection<? extends EObject> getTraceRoots() {
        return this.traceRoots;
    }

    @Nullable
    public Class getRelationTrace(@NonNull Relation relation) {
        return this.relationToTraceClass.get(relation);
    }

    @Nullable
    public Package getTransformationToPackageTrace(RelationalTransformation rt) {
        return this.transformationToPackage.get(rt);
    }

    @Nullable
    public Variable getVariableTrace(@NonNull Variable referredVariable) {
        return this.variableTrace.get(referredVariable);
    }

    private Set<Variable> getVarsOfExp(OCLExpression e) {
        QVTr2QVTcRelations rels = new QVTr2QVTcRelations(this);
        return rels.getVarsOfExp(e);
    }

    public boolean isDoGlobalSearch() {
        return this.doGlobalSearch;
    }

    public void prepare() {
        try {
            this.qvtrModel.load(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void putRelationTrace(@NonNull Relation r, @NonNull Class rc) {
        this.relationToTraceClass.put(r, rc);
    }

    public void putTransformationToPackageTrace(RelationalTransformation rt, Package p) {
        this.transformationToPackage.put(rt, p);
    }

    public void putVariableTrace(@NonNull Variable rv, @NonNull Variable mv) {
        Variable oldVal = this.variableTrace.put(rv, mv);
        if (oldVal != null) {
            System.out.println("putVariableTrace replacing value for " + rv.getName());
        }
    }

    public void saveTrace(@NonNull Resource asResource, @NonNull Collection<? extends EObject> eObjects, @NonNull Map<?, ?> options) throws IOException {
        Model root = PivotFactory.eINSTANCE.createModel();
        root.setExternalURI(asResource.getURI().toString());
        asResource.getContents().add((Object)root);
        for (EObject eObject : eObjects) {
            if (eObject instanceof Package) {
                Package p = (Package)eObject;
                root.getOwnedPackages().add(p);
                Import i = PivotFactory.eINSTANCE.createImport();
                i.setName(p.getName());
                i.setImportedNamespace((Namespace)p);
                this.coreModel.getOwnedImports().add(i);
                continue;
            }
            asResource.getContents().add((Object)eObject);
        }
        asResource.save(options);
    }

    public void saveCore(@NonNull Resource asResource, @NonNull Collection<? extends EObject> eObjects, @NonNull Map<?, ?> options) throws IOException {
        this.coreModel.setExternalURI(asResource.getURI().toString());
        Package capsule = PivotFactory.eINSTANCE.createPackage();
        this.coreModel.getOwnedPackages().add(capsule);
        asResource.getContents().add((Object)this.coreModel);
        for (EObject eObject : eObjects) {
            if (eObject instanceof Transformation) {
                capsule.getOwnedClasses().add((Transformation)eObject);
                continue;
            }
            asResource.getContents().add((Object)eObject);
        }
        asResource.save(options);
    }

    public void setDoGlobalSearch(boolean doGlobalSearch) {
        this.doGlobalSearch = doGlobalSearch;
    }

    public TemplateExp getTemplateExpression(Variable dv) {
        return this.templateExpForVaraible.get(dv);
    }

    public Predicate getPredicateForRelationCallExp(RelationCallExp ri) {
        return null;
    }
}

