/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui.pages;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugModelPresentationExtension;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugTarget;
import org.eclipse.ocl.examples.debug.vm.core.VMLineBreakpoint;
import org.eclipse.ocl.examples.debug.vm.core.VMStackFrame;
import org.eclipse.ocl.examples.debug.vm.core.VMThread;
import org.eclipse.ocl.examples.debug.vm.core.VMValue;
import org.eclipse.ocl.examples.debug.vm.core.VMVariable;
import org.eclipse.ocl.examples.debug.vm.data.VMLocationData;
import org.eclipse.osgi.util.NLS;
import org.eclipse.qvtd.debug.ui.QVTdDebugUIPlugin;
import org.eclipse.qvtd.debug.ui.actions.QVTiDebugImages;
import org.eclipse.qvtd.debug.ui.messages.DebugUIMessages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class QVTiDebugModelPresentation
implements IDebugModelPresentation,
IDebugEditorPresentation,
IDebugModelPresentationExtension,
IColorProvider,
ILabelProvider {
    public void setAttribute(String attribute, Object value) {
    }

    public Image getImage(Object element) {
        if (element instanceof VMDebugTarget) {
            return QVTiDebugImages.getImage("Transformation");
        }
        if (element instanceof VMThread) {
            return null;
        }
        if (element instanceof VMStackFrame) {
            return null;
        }
        if (element instanceof VMVariable) {
            VMVariable var = (VMVariable)element;
            if (var.isModelParameter()) {
                return QVTiDebugImages.getImage("modelParameter");
            }
            if (var.isReference()) {
                return QVTiDebugImages.getImage("reference");
            }
            if (var.isAttribute()) {
                return QVTiDebugImages.getImage("attribute");
            }
            if (var.isIntermProperty()) {
                return QVTiDebugImages.getImage("intermediateProperty");
            }
            if (var.isLocalVariable()) {
                return QVTiDebugImages.getImage("localVariable");
            }
            if (var.isPredefinedVariable()) {
                try {
                    if ("this".equals(var.getName())) {
                        return QVTiDebugImages.getImage("thisVariable");
                    }
                }
                catch (DebugException debugException) {
                    // empty catch block
                }
                return QVTiDebugImages.getImage("predefinedVariable");
            }
            if (var.isCollectionElement()) {
                return QVTiDebugImages.getImage("collectionElement");
            }
        } else if (element instanceof VMLineBreakpoint) {
            VMLineBreakpoint breakpoint = (VMLineBreakpoint)element;
            try {
                if (breakpoint.isConditionEnabled()) {
                    return breakpoint.isEnabled() ? QVTiDebugImages.getImage("conditionalBreakpointEnabled") : QVTiDebugImages.getImage("conditionalBreakpointDisabled");
                }
            }
            catch (CoreException ex) {
                QVTdDebugUIPlugin.log(ex);
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof VMDebugTarget) {
            VMDebugTarget debugTarget = (VMDebugTarget)element;
            String moduleName = debugTarget.getMainModuleName();
            String launchConfigName = debugTarget.getLaunch().getLaunchConfiguration().getName();
            return NLS.bind((String)DebugUIMessages.QVTiDebugModelPresentation_TransformationLabel, (Object)moduleName, (Object)launchConfigName);
        }
        if (element instanceof VMThread) {
            VMThread thread = (VMThread)element;
            String name = "main";
            String state = thread.isSuspended() ? DebugUIMessages.QVTiDebugModelPresentation_Suspended : DebugUIMessages.QVTiDebugModelPresentation_Running;
            return MessageFormat.format(DebugUIMessages.QVTiDebugModelPresentation_ThreadLabel, name, state);
        }
        if (element instanceof VMStackFrame) {
            VMStackFrame frame = (VMStackFrame)element;
            VMLocationData location = frame.getLocation();
            String source = frame.getUnitURI().lastSegment();
            int line = frame.getLineNumber();
            StringBuilder s = new StringBuilder();
            String elementSignature = location.getElementSignature();
            if (elementSignature != null) {
                s.append(elementSignature);
            }
            s.append(" - ");
            s.append(source);
            s.append(":");
            s.append(line);
            return s.toString();
        }
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        if (value instanceof VMValue) {
            VMValue qvtValue = (VMValue)value;
            try {
                listener.detailComputed(value, qvtValue.computeDetail());
            }
            catch (DebugException e) {
                QVTdDebugUIPlugin.log(e.getStatus());
            }
        } else {
            listener.detailComputed(value, value.toString());
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof ILineBreakpoint) {
            return new FileEditorInput((IFile)((ILineBreakpoint)element).getMarker().getResource());
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (element instanceof IFile || element instanceof ILineBreakpoint) {
            return "org.eclipse.qvtd.xtext.qvtimperative.QVTimperative";
        }
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public boolean addAnnotations(IEditorPart editorPart, IStackFrame frame) {
        return false;
    }

    public void removeAnnotations(IEditorPart editorPart, IThread thread) {
    }

    public void dispose() {
    }

    public boolean requiresUIThread(Object element) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

