/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenModelGeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.importer.ecore.EcoreImporter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreGeneratorAdapterFactory;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Detail;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerConstants;
import org.eclipse.qvtd.compiler.internal.common.AbstractQVTc2QVTc;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.InvokedRelationToMappingForEnforcement;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.KeyToFunctionForIdentification;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTrNameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.RelationalTransformationToMappingTransformation;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.RelationalTransformationToTracePackage;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.TopLevelRelationToMappingForEnforcement;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtbase.utilities.TreeIterable;
import org.eclipse.qvtd.pivot.qvtcore.CoreModel;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.QVTcoreFactory;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreHelper;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.QVTcoreBaseFactory;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationModel;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

public class QVTr2QVTc
extends AbstractQVTc2QVTc {
    public static final @NonNull TracingOption SYNTHESIS = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtr2qvtc/synthesis");
    public static final @NonNull TracingOption VARIABLES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtr2qvtc/variables");
    private final @NonNull Resource qvtrResource;
    private final @NonNull Resource qvtcResource;
    protected final @NonNull QVTcoreHelper helper;
    protected final @NonNull QVTrNameGenerator nameGenerator;
    private @Nullable String traceNsURI = null;
    private final @NonNull Map<@NonNull Element, @NonNull Element> globalTarget2source = new HashMap<Element, Element>();
    private final @NonNull Map<@NonNull Element, @NonNull List<@NonNull Element>> globalSource2targets = new HashMap<Element, List<Element>>();
    private final @NonNull List<@NonNull Package> txTracePackages = new ArrayList<Package>();
    private final @NonNull Map<@NonNull Key, @NonNull Function> key2function = new HashMap<Key, Function>();
    private final @NonNull Map<@NonNull Class, @NonNull Key> class2key = new HashMap<Class, Key>();
    private final @NonNull Map<@NonNull Relation, @NonNull Class> relation2traceClass = new HashMap<Relation, Class>();
    private final @NonNull Map<@NonNull Relation, @NonNull List<@NonNull RelationCallExp>> relation2invocations = new HashMap<Relation, List<RelationCallExp>>();
    @Deprecated
    private final @NonNull Map<@NonNull RelationCallExp, @NonNull Relation> invocation2invokingRelation = new HashMap<RelationCallExp, Relation>();
    private @NonNull CoreModel coreModel;
    private @NonNull Map<@NonNull RelationalTransformation, @NonNull Transformation> relationalTransformation2coreTransformation = new HashMap<RelationalTransformation, Transformation>();
    private @NonNull Map<@NonNull RelationalTransformation, @NonNull Package> relationalTransformation2tracePackage = new HashMap<RelationalTransformation, Package>();
    private @NonNull Map<@NonNull TypedModel, @NonNull TypedModel> relationalTypedModel2coreTypedModel = new HashMap<TypedModel, TypedModel>();
    private @NonNull Map<@NonNull Class, @NonNull Map<@NonNull String, @NonNull Property>> traceClass2name2traceProperty = new HashMap<Class, Map<String, Property>>();
    private @NonNull Map<@NonNull Transformation, @NonNull Map<@NonNull String, @NonNull Mapping>> transformation2name2mapping = new HashMap<Transformation, Map<String, Mapping>>();
    private @NonNull Map<@NonNull Relation, @NonNull List<@NonNull Variable>> relation2rootVariables = new HashMap<Relation, List<Variable>>();

    public QVTr2QVTc(@NonNull EnvironmentFactory environmentFactory, @NonNull Resource qvtrResource, @NonNull Resource qvtcResource) {
        super(environmentFactory);
        this.qvtrResource = qvtrResource;
        this.qvtcResource = qvtcResource;
        this.helper = new QVTcoreHelper(environmentFactory);
        this.nameGenerator = new QVTrNameGenerator(this);
        this.coreModel = QVTcoreFactory.eINSTANCE.createCoreModel();
        TreeIterator it = qvtrResource.getAllContents();
        while (it.hasNext()) {
            EObject eo = (EObject)it.next();
            if (eo instanceof Key) {
                this.analyzeKey((Key)eo);
            }
            if (eo instanceof Relation) {
                Relation relation = (Relation)eo;
                this.analyzeInvocations(relation);
                this.analyzeRootVariables(relation);
            }
            if (!(eo instanceof Import)) continue;
            this.coreModel.getOwnedImports().add((Import)EcoreUtil.copy((EObject)eo));
        }
    }

    protected void analyzeInvocations(@NonNull Relation callingRelation) {
        Pattern wherePattern = callingRelation.getWhere();
        if (wherePattern != null) {
            for (Predicate predicate : wherePattern.getPredicate()) {
                OCLExpression predicateExpression = predicate.getConditionExpression();
                if (!(predicateExpression instanceof RelationCallExp)) continue;
                RelationCallExp relationInvocation = (RelationCallExp)predicateExpression;
                Relation calledRelation = (Relation)ClassUtil.nonNullState((Object)relationInvocation.getReferredRelation());
                List<@NonNull RelationCallExp> relationInvocations = this.relation2invocations.get(calledRelation);
                if (relationInvocations == null) {
                    relationInvocations = new ArrayList<RelationCallExp>();
                    this.relation2invocations.put(calledRelation, relationInvocations);
                }
                relationInvocations.add(relationInvocation);
                this.invocation2invokingRelation.put(relationInvocation, callingRelation);
            }
        }
    }

    protected void analyzeKey(@NonNull Key key) {
        Class identifies = key.getIdentifies();
        assert (identifies != null);
        this.class2key.put(identifies, key);
    }

    protected void analyzeRootVariables(@NonNull Relation relation) {
        ArrayList<@NonNull Variable> rootVariables = new ArrayList<Variable>();
        for (Domain rDomain : ClassUtil.nullFree((EList)relation.getDomain())) {
            for (DomainPattern rDomainPattern : ClassUtil.nullFree((EList)((RelationDomain)rDomain).getPattern())) {
                Variable rRootVariable;
                TemplateExp rRootTemplateExpression = rDomainPattern.getTemplateExpression();
                if (rRootTemplateExpression == null || (rRootVariable = rRootTemplateExpression.getBindsTo()) == null) continue;
                rootVariables.add(rRootVariable);
            }
        }
        this.relation2rootVariables.put(relation, rootVariables);
    }

    public @Nullable Property basicGetProperty(Type aClass, @NonNull NamedElement rNamedElement) throws CompilerChainException {
        String name = rNamedElement.getName();
        assert (aClass != null && name != null);
        CompleteClass completeClass = this.environmentFactory.getCompleteModel().getCompleteClass(aClass);
        return completeClass.getProperty(name);
    }

    public @NonNull CoreDomain createCoreDomain(@NonNull TypedModel typedModel) {
        CoreDomain coreDomain = QVTcoreBaseFactory.eINSTANCE.createCoreDomain();
        coreDomain.setTypedModel(typedModel);
        coreDomain.setName((String)ClassUtil.nonNullState((Object)typedModel.getName()));
        GuardPattern guardPattern = QVTcoreBaseFactory.eINSTANCE.createGuardPattern();
        coreDomain.setGuardPattern(guardPattern);
        BottomPattern bottomPattern = QVTcoreBaseFactory.eINSTANCE.createBottomPattern();
        coreDomain.setBottomPattern(bottomPattern);
        return coreDomain;
    }

    @Override
    protected @NonNull AbstractQVTc2QVTc.AbstractCreateVisitor<@NonNull ?> createCreateVisitor() {
        return new CreateVisitor(this);
    }

    public @NonNull String createKeyFunctionName(@NonNull Key rKey) {
        return this.nameGenerator.createKeyFunctionName(rKey);
    }

    public @NonNull String createKeyedVariableName(@NonNull Variable identifiedVariable) {
        return this.nameGenerator.createKeyedVariableName(identifiedVariable);
    }

    @NonNull Mapping createMapping(@NonNull Relation relation, @NonNull String name) {
        RelationalTransformation rt = (RelationalTransformation)relation.getTransformation();
        assert (rt != null);
        @NonNull Transformation coreTransformation = this.getCoreTransformation(rt);
        Map<@NonNull String, @NonNull Mapping> name2mapping = this.transformation2name2mapping.get(coreTransformation);
        if (name2mapping == null) {
            name2mapping = new HashMap<String, Mapping>();
            this.transformation2name2mapping.put(coreTransformation, name2mapping);
        }
        Mapping coreMapping = name2mapping.get(name);
        assert (coreMapping == null);
        coreMapping = this.helper.createMapping(name);
        this.putGlobalTrace((Element)coreMapping, (Element)relation);
        coreMapping.setTransformation(coreTransformation);
        name2mapping.put(name, coreMapping);
        return coreMapping;
    }

    public @NonNull RealizedVariable createRealizedVariable(@NonNull TypedElement typedElement) {
        return this.createRealizedVariable((String)ClassUtil.nonNullState((Object)typedElement.getName()), (Type)ClassUtil.nonNullState((Object)typedElement.getType()));
    }

    public @NonNull RealizedVariable createRealizedVariable(@NonNull String name, @NonNull Type type) {
        RealizedVariable realizedVariable = QVTcoreBaseFactory.eINSTANCE.createRealizedVariable();
        realizedVariable.setName(name);
        realizedVariable.setType(type);
        realizedVariable.setIsRequired(true);
        return realizedVariable;
    }

    public @NonNull String createTraceClassName(@NonNull Relation relation) {
        return this.nameGenerator.createTraceClassName(relation);
    }

    @Override
    protected @NonNull AbstractQVTc2QVTc.AbstractUpdateVisitor<@NonNull ?> createUpdateVisitor() {
        return new UpdateVisitor(this);
    }

    public void dispose() {
    }

    public void execute() throws CompilerChainException {
        this.transformToTracePackages();
        this.transformToCoreTransformations();
    }

    public void generateModels(@NonNull GenModel genModel) {
        ((PivotMetamodelManager)this.environmentFactory.getMetamodelManager()).addGenModel(genModel);
        GeneratorAdapterFactory.Descriptor.Registry generatorAdapterDescriptorRegistry = GeneratorAdapterFactory.Descriptor.Registry.INSTANCE;
        if (!generatorAdapterDescriptorRegistry.getDescriptors("http://www.eclipse.org/emf/2002/GenModel").contains(GenModelGeneratorAdapterFactory.DESCRIPTOR)) {
            generatorAdapterDescriptorRegistry.addDescriptor("http://www.eclipse.org/emf/2002/GenModel", GenModelGeneratorAdapterFactory.DESCRIPTOR);
        }
        if (!generatorAdapterDescriptorRegistry.getDescriptors("http://www.eclipse.org/emf/2002/GenModel").contains(OCLinEcoreGeneratorAdapterFactory.DESCRIPTOR)) {
            generatorAdapterDescriptorRegistry.addDescriptor("http://www.eclipse.org/emf/2002/GenModel", OCLinEcoreGeneratorAdapterFactory.DESCRIPTOR);
        }
        genModel.setValidateModel(true);
        genModel.setForceOverwrite(false);
        genModel.setCanGenerate(true);
        Diagnostic diagnostic = genModel.diagnose();
        this.reportDiagnostics(new Issues(), diagnostic);
        Generator generator = GenModelUtil.createGenerator((GenModel)genModel);
        BasicMonitor monitor = new BasicMonitor();
        diagnostic = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)monitor);
        this.reportDiagnostics(new Issues(), diagnostic);
    }

    @NonNull Transformation getCoreTransformation(@NonNull RelationalTransformation relationalTransformation) {
        return (Transformation)ClassUtil.nonNullState((Object)this.relationalTransformation2coreTransformation.get(relationalTransformation));
    }

    @NonNull TypedModel getCoreTypedModel(@NonNull TypedModel relationTypedModel) {
        return (TypedModel)ClassUtil.nonNullState((Object)this.relationalTypedModel2coreTypedModel.get(relationTypedModel));
    }

    @Override
    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    @Override
    public @NonNull QVTcoreHelper getHelper() {
        return this.helper;
    }

    @NonNull Relation getInvokingRelation(@NonNull RelationCallExp rInvocation) {
        Relation rRelation1 = (Relation)ClassUtil.nonNullState((Object)this.invocation2invokingRelation.get(rInvocation));
        Relation rRelation2 = (Relation)((Predicate)rInvocation.eContainer()).getPattern().eContainer();
        assert (rRelation1 == rRelation2);
        return rRelation1;
    }

    public @Nullable Key getKeyForType(@NonNull Type type) {
        return this.class2key.get(type);
    }

    @NonNull Function getKeyFunction(@NonNull Key key) {
        return (Function)ClassUtil.nonNullState((Object)this.key2function.get(key));
    }

    public Predicate getPredicateForRelationCallExp(RelationCallExp ri) {
        return null;
    }

    public @NonNull String getProjectName(@NonNull URI traceURI) {
        URI trimFileExtension = traceURI.trimFileExtension();
        if (trimFileExtension.isPlatform()) {
            return trimFileExtension.segment(1);
        }
        return trimFileExtension.segment(0);
    }

    protected @NonNull Property getProperty(Type aClass, @NonNull NamedElement rNamedElement) throws CompilerChainException {
        Property property = this.getProperty(aClass, rNamedElement.getName());
        if (rNamedElement instanceof Property) assert (rNamedElement == property);
        return property;
    }

    protected @NonNull Property getProperty(Type aClass, String name) throws CompilerChainException {
        assert (aClass != null && name != null);
        CompleteClass completeClass = this.environmentFactory.getCompleteModel().getCompleteClass(aClass);
        Property p = completeClass.getProperty(name);
        if (p != null) {
            return p;
        }
        throw new CompilerChainException("No property '" + name + "' in '" + aClass + "::" + "'", new Object[0]);
    }

    public Resource getQvtcSource() {
        return this.qvtcResource;
    }

    public @NonNull List<@NonNull RelationCallExp> getRelationCallExpsForRelation(@NonNull Relation relation) {
        List<@NonNull RelationCallExp> invocations = this.relation2invocations.get(relation);
        return invocations != null ? invocations : Collections.emptyList();
    }

    public @NonNull List<@NonNull Variable> getRootVariables(@NonNull Relation relation) {
        return (List)ClassUtil.nonNullState(this.relation2rootVariables.get(relation));
    }

    public @NonNull StandardLibrary getStandardLibrary() {
        return this.environmentFactory.getStandardLibrary();
    }

    public @Nullable List<@NonNull Element> getGlobalTargets(@NonNull Element element) {
        return this.globalSource2targets.get(element);
    }

    @NonNull Class getTraceClass(@NonNull Relation relation) {
        return (Class)ClassUtil.nonNullState((Object)this.relation2traceClass.get(relation));
    }

    @NonNull Package getTracePackage(@NonNull RelationalTransformation relationalTransformation) {
        return (Package)ClassUtil.nonNullState((Object)this.relationalTransformation2tracePackage.get(relationalTransformation));
    }

    public @NonNull Set<@NonNull Class> getUsedClasses(@NonNull TypedModel rTypedModel) {
        HashSet<@NonNull Class> usedClasses = new HashSet<Class>();
        for (Package rPackage : ClassUtil.nullFree((EList)rTypedModel.getUsedPackage())) {
            usedClasses.addAll(ClassUtil.nullFree((List)rPackage.getOwnedClasses()));
        }
        return usedClasses;
    }

    private void mapFunctions(@NonNull RelationalTransformation relationalTransformation, @NonNull Transformation coreTransformation) {
        ArrayList<@NonNull Operation> cOperations = new ArrayList<Operation>();
        for (Operation rOperation : ClassUtil.nullFree((List)relationalTransformation.getOwnedOperations())) {
            Element cOperation = (Element)rOperation.accept((Visitor)this.createVisitor);
            if (!(cOperation instanceof Operation)) continue;
            cOperations.add((Operation)cOperation);
        }
        coreTransformation.getOwnedOperations().addAll(cOperations);
        for (Operation cOperation : cOperations) {
            cOperation.accept((Visitor)this.updateVisitor);
        }
    }

    public void prepare() {
        try {
            this.qvtrResource.load(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void putCoreTransformation(@NonNull RelationalTransformation relationTransformation, @NonNull Transformation coreTransformation) {
        this.relationalTransformation2coreTransformation.put(relationTransformation, coreTransformation);
        this.putGlobalTrace((Element)coreTransformation, (Element)relationTransformation);
    }

    void putGlobalTrace(@NonNull Element coreElement, @NonNull Element relationElement) {
        Element oldRelationElement = this.globalTarget2source.put(coreElement, relationElement);
        assert (oldRelationElement == null);
        List<@NonNull Element> targets = this.globalSource2targets.get(relationElement);
        if (targets == null) {
            targets = new ArrayList<Element>();
            this.globalSource2targets.put(relationElement, targets);
        }
        targets.add(coreElement);
    }

    void putKeyFunction(@NonNull Key rKey, @NonNull Function keyFunction) {
        Function oldFunction = this.key2function.put(rKey, keyFunction);
        assert (oldFunction == null);
    }

    void putRelationTrace(@NonNull Relation rRelation, @NonNull Class traceClass) {
        Class oldTraceClass = this.relation2traceClass.put(rRelation, traceClass);
        assert (oldTraceClass == null);
    }

    void putTracePackage(@NonNull RelationalTransformation rt, @NonNull Package tracePackage) {
        Package oldTracePackage = this.relationalTransformation2tracePackage.put(rt, tracePackage);
        assert (oldTracePackage == null);
    }

    public void putTypedModel(@NonNull TypedModel relationTypedModel, @NonNull TypedModel coreTypedModel) {
        TypedModel oldTypedModel = this.relationalTypedModel2coreTypedModel.put(relationTypedModel, coreTypedModel);
        assert (oldTypedModel == null);
    }

    protected void reportDiagnostics(Issues issues, Diagnostic diagnostic) {
        int severity = diagnostic.getSeverity();
        if (severity != 0) {
            List children = diagnostic.getChildren();
            if (children.size() > 0) {
                for (Diagnostic child : children) {
                    String message;
                    severity = child.getSeverity();
                    List data = child.getData();
                    Throwable throwable = null;
                    if (data.size() == 1 && data.get(0) instanceof Throwable) {
                        throwable = (Throwable)data.get(0);
                        data = null;
                        message = child.getMessage();
                    } else {
                        message = child.toString();
                    }
                    if (severity == 4) {
                        issues.addError(this, message, null, null, throwable, data);
                        continue;
                    }
                    if (severity != 2) continue;
                    issues.addWarning(this, message, null, null, throwable, data);
                }
            } else if (severity == 4) {
                issues.addError(this, diagnostic.toString());
            } else if (severity == 2) {
                issues.addWarning(this, diagnostic.toString());
            }
        }
    }

    public void saveCore(@NonNull Resource asResource, @NonNull Map<?, ?> options) throws IOException {
        asResource.getContents().add((Object)this.coreModel);
        for (Package asPackage : this.txTracePackages) {
            Import asImport = this.helper.createImport(null, (Namespace)asPackage);
            this.coreModel.getOwnedImports().add(asImport);
        }
        asResource.save(options);
    }

    public @NonNull GenModel saveGenModel(@NonNull Resource asResource, @NonNull URI traceURI, @NonNull URI genModelURI, @Nullable Map<@NonNull String, @Nullable String> genModelOptions, @NonNull Map<Object, Object> saveOptions2, @Nullable Collection<@NonNull ? extends GenPackage> usedGenPackages) throws IOException {
        String copyrightText;
        URI trimFileExtension = traceURI.trimFileExtension();
        String projectName = this.getProjectName(traceURI);
        Resource genmodelResource = this.environmentFactory.getResourceSet().createResource(genModelURI);
        @NonNull GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
        genModel.getForeignModel().add((Object)traceURI.lastSegment());
        String string = copyrightText = genModelOptions != null ? genModelOptions.get("genModelCopyrightText") : null;
        if (copyrightText != null) {
            genModel.setCopyrightText(copyrightText);
        }
        if (usedGenPackages != null) {
            genModel.getUsedGenPackages().addAll(usedGenPackages);
        }
        genModel.setModelDirectory("/" + projectName + "/src-gen");
        genModel.setModelPluginID(projectName);
        genModel.setModelName(trimFileExtension.lastSegment());
        genModel.setBundleManifest(false);
        genModel.setUpdateClasspath(false);
        genModel.setImporterID(new EcoreImporter().getID());
        genModel.setComplianceLevel(GenJDKLevel.JDK80_LITERAL);
        genModel.setCopyrightFields(false);
        genModel.setOperationReflection(true);
        genModel.setImportOrganizing(true);
        genModel.setRootExtendsClass(MinimalEObjectImpl.Container.class.getName());
        genModel.setPluginKey("");
        genmodelResource.getContents().add((Object)genModel);
        String basePrefix = genModelOptions != null ? genModelOptions.get("genModelBasePrefix") : null;
        EList genPackages = genModel.getGenPackages();
        for (EObject eObject : asResource.getContents()) {
            if (!(eObject instanceof Model)) continue;
            Model asModel = (Model)eObject;
            for (Package asPackage : ClassUtil.nullFree((List)asModel.getOwnedPackages())) {
                GenPackage genPackage = genModel.createGenPackage();
                EPackage ePackage = (EPackage)asPackage.getESObject();
                genPackage.setEcorePackage(ePackage);
                genPackage.setPrefix(ePackage.getName());
                if (basePrefix != null) {
                    genPackage.setBasePackage(basePrefix);
                }
                genPackages.add(genPackage);
            }
            HashSet<@NonNull Package> asPackages = new HashSet<Package>();
            for (EObject element : new TreeIterable((EObject)asModel, false)) {
                Package asPackage;
                if (!(element instanceof Property)) continue;
                Property property = (Property)element;
                Type type = property.getType();
                while (type instanceof CollectionType) {
                    type = ((CollectionType)type).getElementType();
                }
                if (!(type instanceof Class) || (asPackage = ((Class)type).getOwningPackage()) == null) continue;
                asPackages.add(asPackage);
            }
            for (Import asImport : ClassUtil.nullFree((List)asModel.getOwnedImports())) {
                Namespace asNamespace = asImport.getImportedNamespace();
                if (!(asNamespace instanceof Package)) continue;
                @NonNull Package asPackage = (Package)asNamespace;
                asPackages.add(asPackage);
            }
            ArrayList<@NonNull E> asPackageList = new ArrayList(asPackages);
            Collections.sort(asPackageList, NameUtil.NAMEABLE_COMPARATOR);
            for (Package asPackage : asPackageList) {
                EPackage ePackage = (EPackage)asPackage.getESObject();
                if (ePackage == null) continue;
                GenPackage genPackage = null;
                if (usedGenPackages != null) {
                    for (GenPackage genPackage2 : usedGenPackages) {
                        EPackage ecorePackage = genPackage2.getEcorePackage();
                        if (ecorePackage == null || !ClassUtil.safeEquals((Object)ecorePackage.getNsURI(), (Object)ePackage.getNsURI())) continue;
                        genPackage = genPackage2;
                        break;
                    }
                }
                if (genPackage != null) continue;
                genPackage = genModel.createGenPackage();
                genPackage.setEcorePackage(ePackage);
                genPackage.setPrefix(ePackage.getName());
                if (basePrefix != null) {
                    genPackage.setBasePackage(basePrefix);
                }
                genPackages.add(genPackage);
            }
        }
        genModel.reconcile();
        HashMap<Object, Object> saveOptions = new HashMap<Object, Object>(saveOptions2);
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("LINE_DELIMITER", "\n");
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        saveOptions.put("LINE_DELIMITER", "");
        genmodelResource.save(saveOptions);
        return genModel;
    }

    public @NonNull Resource saveTrace(@NonNull Resource asResource, @NonNull URI traceURI, @NonNull URI genModelURI, @Nullable Map<@NonNull String, @Nullable String> traceOptions, @NonNull Map<?, ?> saveOptions) throws IOException {
        Model root = PivotFactory.eINSTANCE.createModel();
        root.setExternalURI(traceURI.toString());
        asResource.getContents().add((Object)root);
        if (this.traceNsURI != null && this.txTracePackages.size() == 1) {
            this.txTracePackages.get(0).setURI(this.traceNsURI);
        }
        Iterator<Package> iterator = this.txTracePackages.iterator();
        while (iterator.hasNext()) {
            Package txTracePackage;
            @NonNull Package rootPackage = txTracePackage = iterator.next();
            EObject eContainer = rootPackage.eContainer();
            while (eContainer instanceof Package) {
                rootPackage = (Package)eContainer;
                eContainer = eContainer.eContainer();
            }
            if (root.getOwnedPackages().contains(rootPackage)) continue;
            root.getOwnedPackages().add(rootPackage);
        }
        AS2Ecore as2ecore = new AS2Ecore((EnvironmentFactoryInternal)this.environmentFactory, traceURI, null);
        XMLResource ecoreResource = as2ecore.convertResource(asResource, traceURI);
        ecoreResource.save(saveOptions);
        return ecoreResource;
    }

    public void setTraceNsURI(@Nullable String traceNsURI) {
        this.traceNsURI = traceNsURI;
    }

    public void transformToCoreTransformations() throws CompilerChainException {
        this.setDebugSource(this.qvtrResource);
        for (EObject eObject : this.qvtrResource.getContents()) {
            if (!(eObject instanceof RelationModel)) continue;
            RelationModel relationModel = (RelationModel)eObject;
            String externalURI = relationModel.getExternalURI();
            if (externalURI.endsWith(".qvtras")) {
                externalURI = externalURI.replace(".qvtras", ".qvtcas");
            } else if (externalURI.endsWith(".qvtr")) {
                externalURI = externalURI.replace(".qvtr", ".qvtcas");
            }
            this.coreModel.setExternalURI(externalURI);
            this.transformToCoreTransformationHierarchy(ClassUtil.nullFree((List)this.coreModel.getOwnedPackages()), ClassUtil.nullFree((List)relationModel.getOwnedPackages()));
        }
        StandardLibrary standardLibrary = this.getStandardLibrary();
        ArrayList<@NonNull RelationalTransformation> relationalTransformations = new ArrayList<RelationalTransformation>(this.relationalTransformation2coreTransformation.keySet());
        Collections.sort(relationalTransformations, NameUtil.NAMEABLE_COMPARATOR);
        for (RelationalTransformation relationalTransformation : relationalTransformations) {
            Relation rRelation;
            ArrayList<@NonNull E> rules = new ArrayList(ClassUtil.nullFree((EList)relationalTransformation.getRule()));
            Collections.sort(rules, NameUtil.NAMEABLE_COMPARATOR);
            Transformation coreTransformation = this.getCoreTransformation(relationalTransformation);
            this.pushScope((NamedElement)coreTransformation);
            Variable cThis = QVTbaseUtil.getContextVariable((StandardLibrary)standardLibrary, (Transformation)coreTransformation);
            Variable rThis = QVTbaseUtil.getContextVariable((StandardLibrary)standardLibrary, (Transformation)relationalTransformation);
            this.addTrace((Element)rThis, (Element)cThis);
            ArrayList<@NonNull E> rKeys = new ArrayList(ClassUtil.nullFree((EList)relationalTransformation.getOwnedKey()));
            ArrayList<@NonNull TypedModel> rEnforceableTypdModels = new ArrayList<TypedModel>();
            for (Rule rule : rules) {
                if (!(rule instanceof Relation)) continue;
                for (Domain rDomain : ClassUtil.nullFree((EList)rule.getDomain())) {
                    TypedModel rTypedModel;
                    if (!rDomain.isIsEnforceable() || rEnforceableTypdModels.contains(rTypedModel = (TypedModel)ClassUtil.nonNullState((Object)rDomain.getTypedModel()))) continue;
                    rEnforceableTypdModels.add(rTypedModel);
                }
            }
            for (TypedModel rTypedModel : rEnforceableTypdModels) {
                Set<@NonNull Class> usedClasses = this.getUsedClasses(rTypedModel);
                for (Key rKey : rKeys) {
                    @NonNull Class identifiedClass = (Class)ClassUtil.nonNullState((Object)rKey.getIdentifies());
                    if (!usedClasses.contains(identifiedClass)) continue;
                    SYNTHESIS.println("key " + rKey);
                    KeyToFunctionForIdentification keyToMapping = new KeyToFunctionForIdentification(this, rKey);
                    Function cKeyFunction = keyToMapping.transform();
                    this.putKeyFunction(rKey, cKeyFunction);
                    coreTransformation.getOwnedOperations().add(cKeyFunction);
                }
            }
            this.mapFunctions(relationalTransformation, coreTransformation);
            for (Rule rule : rules) {
                if (!(rule instanceof Relation) || !(rRelation = (Relation)rule).isIsTopLevel()) continue;
                SYNTHESIS.println("topLevel " + rRelation);
                TopLevelRelationToMappingForEnforcement topLevelRelationToMappingForEnforcement = new TopLevelRelationToMappingForEnforcement(this, rRelation);
                topLevelRelationToMappingForEnforcement.transform();
            }
            for (Rule rule : rules) {
                if (!(rule instanceof Relation) || (rRelation = (Relation)rule).isIsTopLevel()) continue;
                InvokedRelationToMappingForEnforcement invokedRelationToMappingForEnforcement = new InvokedRelationToMappingForEnforcement(this, rRelation);
                invokedRelationToMappingForEnforcement.transform();
            }
            CompilerUtil.normalizeNameables(ClassUtil.nullFree((List)coreTransformation.getOwnedOperations()));
            CompilerUtil.normalizeNameables((List<? extends Nameable>)ClassUtil.nullFree((EList)coreTransformation.getRule()));
            this.popScope();
        }
    }

    private void transformToCoreTransformationHierarchy(@NonNull List<@NonNull Package> corePackages, @NonNull Iterable<@NonNull Package> relationPackages) {
        for (Package relationPackage : relationPackages) {
            String name = relationPackage.getName();
            assert (name != null);
            @NonNull Package corePackage = this.helper.createPackage(name, relationPackage.getNsPrefix(), relationPackage.getURI());
            corePackages.add(corePackage);
            for (Class relationClass : ClassUtil.nullFree((List)relationPackage.getOwnedClasses())) {
                if (!(relationClass instanceof RelationalTransformation)) continue;
                RelationalTransformationToMappingTransformation relationalTransformationToMappingTransformation = new RelationalTransformationToMappingTransformation(this);
                Transformation coreTransformation = relationalTransformationToMappingTransformation.doRelationalTransformationToMappingTransformation((RelationalTransformation)relationClass);
                corePackage.getOwnedClasses().add(coreTransformation);
                CompilerUtil.normalizeNameables((List<? extends Nameable>)ClassUtil.nullFree((EList)coreTransformation.getRule()));
            }
            CompilerUtil.normalizeNameables(ClassUtil.nullFree((List)corePackage.getOwnedClasses()));
            this.transformToCoreTransformationHierarchy(ClassUtil.nullFree((List)corePackage.getOwnedPackages()), ClassUtil.nullFree((List)relationPackage.getOwnedPackages()));
        }
    }

    public void transformToTracePackages() {
        ArrayList<@NonNull Package> rootTracePackages = null;
        for (EObject eObject : this.qvtrResource.getContents()) {
            List<Package> tracePackages;
            if (!(eObject instanceof RelationModel) || (tracePackages = this.transformToTracePackageHierarchy(ClassUtil.nullFree((List)((RelationModel)eObject).getOwnedPackages()))) == null) continue;
            if (rootTracePackages == null) {
                rootTracePackages = new ArrayList<Package>();
            }
            rootTracePackages.addAll(tracePackages);
        }
        if (rootTracePackages != null) {
            CompilerUtil.normalizeNameables(rootTracePackages);
        }
    }

    private @Nullable List<@NonNull Package> transformToTracePackageHierarchy(@NonNull Iterable<@NonNull Package> relationPackages) {
        ArrayList<@NonNull Package> nestingTracePackages = null;
        for (Package relationPackage : relationPackages) {
            ArrayList<Package> nestedTracePackages = null;
            for (Class relationClass : ClassUtil.nullFree((List)relationPackage.getOwnedClasses())) {
                if (!(relationClass instanceof RelationalTransformation)) continue;
                RelationalTransformationToTracePackage relationalTransformationToTracePackage = new RelationalTransformationToTracePackage(this);
                Package nestedTracePackage = relationalTransformationToTracePackage.doRelationalTransformationToTracePackage((RelationalTransformation)relationClass);
                this.txTracePackages.add(nestedTracePackage);
                if (nestedTracePackages == null) {
                    nestedTracePackages = new ArrayList();
                }
                nestedTracePackages.add(nestedTracePackage);
            }
            List<@NonNull Package> nestedTracePackages2 = this.transformToTracePackageHierarchy(ClassUtil.nullFree((List)relationPackage.getOwnedPackages()));
            if (nestedTracePackages2 != null) {
                if (nestedTracePackages == null) {
                    nestedTracePackages = new ArrayList<Package>();
                }
                nestedTracePackages.addAll(nestedTracePackages2);
            }
            if (nestedTracePackages == null) continue;
            CompilerUtil.normalizeNameables(nestedTracePackages);
            if (nestingTracePackages == null) {
                nestingTracePackages = new ArrayList<Package>();
            }
            nestingTracePackages.addAll(nestedTracePackages);
        }
        return nestingTracePackages;
    }

    @NonNull Property whenTraceProperty(@Nullable Domain rDomain, @NonNull Class traceClass, @NonNull String name, @NonNull Type type, boolean isRequired, boolean isMany) {
        Property traceProperty;
        Map<@NonNull String, @NonNull Property> name2traceProperty = this.traceClass2name2traceProperty.get(traceClass);
        if (name2traceProperty == null) {
            name2traceProperty = new HashMap<String, Property>();
            this.traceClass2name2traceProperty.put(traceClass, name2traceProperty);
        }
        if ((traceProperty = name2traceProperty.get(name)) == null) {
            traceProperty = PivotFactory.eINSTANCE.createProperty();
            traceProperty.setName(name);
            traceProperty.setType(type);
            traceProperty.setIsRequired(isRequired);
            if (rDomain != null) {
                Annotation domainAnnotation = PivotFactory.eINSTANCE.createAnnotation();
                domainAnnotation.setName("http://www.eclipse.org/qvt#Domains");
                Detail domainDetail = PivotFactory.eINSTANCE.createDetail();
                domainDetail.setName("referredDomain");
                domainDetail.getValues().add(rDomain.getName());
                domainAnnotation.getOwnedDetails().add(domainDetail);
                traceProperty.getOwnedAnnotations().add(domainAnnotation);
            }
            name2traceProperty.put(name, traceProperty);
            traceProperty.setOwningClass(traceClass);
            if (!(type instanceof DataType)) {
                Property oppositeProperty = PivotFactory.eINSTANCE.createProperty();
                oppositeProperty.setName(traceClass.getName());
                oppositeProperty.setType((Type)(isMany ? this.environmentFactory.getCompleteEnvironment().getSetType((Type)traceClass, true, null, null) : traceClass));
                oppositeProperty.setIsRequired(isMany);
                oppositeProperty.setIsImplicit(true);
                oppositeProperty.setOwningClass((Class)type);
                traceProperty.setOpposite(oppositeProperty);
                oppositeProperty.setOpposite(traceProperty);
            }
        } else assert (traceProperty.getType() == type);
        return traceProperty;
    }

    protected static class CreateVisitor
    extends AbstractQVTc2QVTc.AbstractCreateVisitor<QVTr2QVTc> {
        public CreateVisitor(@NonNull QVTr2QVTc context) {
            super(context);
        }
    }

    private class Issues {
        private Issues() {
        }

        public void addError(QVTr2QVTc qvTrToQVTc, String message, Object object, Object object2, Throwable throwable, List<Object> data) {
            System.err.println(message);
        }

        public void addWarning(QVTr2QVTc qvTrToQVTc, String message, Object object, Object object2, Throwable throwable, List<Object> data) {
            System.out.println(message);
        }

        public void addError(QVTr2QVTc qvTrToQVTc, String string) {
            System.err.println(string);
        }

        public void addWarning(QVTr2QVTc qvTrToQVTc, String string) {
            System.out.println(string);
        }
    }

    protected static class UpdateVisitor
    extends AbstractQVTc2QVTc.AbstractUpdateVisitor<QVTr2QVTc> {
        public UpdateVisitor(@NonNull QVTr2QVTc context) {
            super(context);
        }
    }
}

