/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ocl.lpg.AbstractProblemHandler;
import org.eclipse.ocl.lpg.ProblemHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemLog
extends AbstractProblemHandler {
    private Map<ProblemHandler.Phase, Map<ProblemHandler.Severity, List<Problem>>> problems = new HashMap<ProblemHandler.Phase, Map<ProblemHandler.Severity, List<Problem>>>();
    private int allProblemCount = 0;

    public ProblemLog() {
        super(null);
    }

    public int getAllProblems() {
        return this.allProblemCount;
    }

    public Set<ProblemHandler.Phase> getProcessingPhases() {
        return this.problems.keySet();
    }

    public Map<ProblemHandler.Severity, List<Problem>> getProblems(ProblemHandler.Phase processingPhase) {
        Map<ProblemHandler.Severity, List<Problem>> phaseProblems = this.problems.get(processingPhase);
        if (phaseProblems != null) {
            return phaseProblems;
        }
        return Collections.emptyMap();
    }

    public List<Problem> getProblems(ProblemHandler.Severity problemSeverity, ProblemHandler.Phase processingPhase) {
        List<Problem> phaseSeverityProblems;
        Map<ProblemHandler.Severity, List<Problem>> phaseProblems = this.problems.get(processingPhase);
        List<Problem> list = phaseSeverityProblems = phaseProblems != null ? phaseProblems.get(problemSeverity) : null;
        if (phaseSeverityProblems != null) {
            return phaseSeverityProblems;
        }
        return Collections.emptyList();
    }

    public void handleProblem(ProblemHandler.Severity problemSeverity, ProblemHandler.Phase processingPhase, String problemMessage, String processingContext, int startOffset, int endOffset) {
        List<Problem> phaseSeverityProblems;
        Map<ProblemHandler.Severity, List<Problem>> phaseProblems = this.problems.get(processingPhase);
        if (phaseProblems == null) {
            phaseProblems = new HashMap<ProblemHandler.Severity, List<Problem>>();
            this.problems.put(processingPhase, phaseProblems);
        }
        if ((phaseSeverityProblems = phaseProblems.get(problemSeverity)) == null) {
            phaseSeverityProblems = new ArrayList<Problem>();
            phaseProblems.put(problemSeverity, phaseSeverityProblems);
        }
        phaseSeverityProblems.add(new Problem(problemMessage, processingContext, startOffset, endOffset));
        ++this.allProblemCount;
    }

    public StringBuffer toString(StringBuffer s, String prefix) {
        ArrayList<ProblemHandler.Phase> phases = new ArrayList<ProblemHandler.Phase>(this.getProcessingPhases());
        Collections.sort(phases);
        for (ProblemHandler.Phase phase : phases) {
            Map<ProblemHandler.Severity, List<Problem>> phaseProblems = this.getProblems(phase);
            ArrayList severities = new ArrayList(phaseProblems.keySet());
            for (ProblemHandler.Severity severity : severities) {
                if (s.length() > 0) {
                    s.append("\n");
                    s.append(prefix);
                }
                s.append(phase);
                s.append("-");
                s.append(severity);
                for (Problem problem : phaseProblems.get(severity)) {
                    s.append("\n");
                    s.append(prefix);
                    s.append("  ");
                    s.append(problem.problemMessage);
                    if (problem.processingContext != null) {
                        s.append(" @");
                        s.append(problem.processingContext);
                    }
                    if (problem.startOffset < 0) continue;
                    s.append(" : ");
                    s.append(problem.startOffset);
                    if (problem.endOffset < 0) continue;
                    s.append(" : ");
                    s.append(problem.endOffset);
                    if (this.getParser() == null) continue;
                    int token = this.getParser().getTokenIndexAtCharacter(problem.startOffset);
                    s.append(" ");
                    try {
                        s.append(this.getParser().getLine(token));
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        s.append("???");
                    }
                    s.append(":");
                    try {
                        s.append(this.getParser().getColumn(token));
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        s.append("???");
                    }
                    s.append(" '");
                    s.append(this.getParser().computeInputString(problem.startOffset, problem.endOffset));
                    s.append("'");
                }
            }
        }
        return s;
    }

    public static class Problem {
        public final String problemMessage;
        public final String processingContext;
        public final int startOffset;
        public int endOffset;

        public Problem(String problemMessage, String processingContext, int startOffset, int endOffset) {
            this.problemMessage = problemMessage != null ? problemMessage : "";
            this.processingContext = processingContext;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }
    }
}

