/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.debug.internal.core.IInternalDebugCoreConstants;
import org.eclipse.debug.internal.core.Preferences;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.internal.ArrayUtil;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.server.StreamConnectionProvider;

public class LaunchConfigurationStreamProvider
implements StreamConnectionProvider,
IAdaptable {
    private @Nullable StreamProxyInputStream inputStream;
    private @Nullable StreamProxyInputStream errorStream;
    private @Nullable OutputStream outputStream;
    private @Nullable ILaunch launch;
    private @Nullable IProcess process;
    private final ILaunchConfiguration launchConfiguration;
    private Set<String> launchModes;

    public LaunchConfigurationStreamProvider(ILaunchConfiguration launchConfig, @Nullable Set<String> launchModes) {
        Assert.isNotNull((Object)launchConfig);
        this.launchConfiguration = launchConfig;
        this.launchModes = launchModes != null ? launchModes : Set.of("run");
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LaunchConfigurationStreamProvider) {
            LaunchConfigurationStreamProvider other = (LaunchConfigurationStreamProvider)obj;
            if (this.launchConfiguration.equals(other.launchConfiguration) && this.launchModes.equals(other.launchModes)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.launchConfiguration.hashCode() ^ this.launchModes.hashCode();
    }

    public static @Nullable ILaunchConfiguration findLaunchConfiguration(String typeId, String name) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(typeId);
        ILaunchConfiguration res = null;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = manager.getLaunchConfigurations(type);
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration launch = iLaunchConfigurationArray[n2];
                if (launch.getName().equals(name)) {
                    res = launch;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError(e);
        }
        return res;
    }

    @Override
    public void start() throws IOException {
        block14: {
            boolean statusHandlerToUpdate = this.disableStatusHandler();
            try {
                try {
                    IStreamMonitor mon;
                    IStreamMonitor mon2;
                    ILaunch launch = this.launch = this.launchConfiguration.launch(this.launchModes.iterator().next(), (IProgressMonitor)new NullProgressMonitor(), false);
                    long initialTimestamp = System.currentTimeMillis();
                    while (launch.getProcesses().length == 0 && System.currentTimeMillis() - initialTimestamp < 5000L) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            LanguageServerPlugin.logError(e);
                            Thread.currentThread().interrupt();
                        }
                    }
                    if (launch.getProcesses().length <= 0) break block14;
                    IProcess process = this.process = launch.getProcesses()[0];
                    StreamProxyInputStream inputStream = this.inputStream = new StreamProxyInputStream(process);
                    IStreamsProxy proxy = process.getStreamsProxy();
                    if (proxy != null && (mon2 = proxy.getOutputStreamMonitor()) != null) {
                        mon2.addListener((IStreamListener)inputStream);
                    }
                    try {
                        Method systemProcessGetter = RuntimeProcess.class.getDeclaredMethod("getSystemProcess", new Class[0]);
                        systemProcessGetter.setAccessible(true);
                        Process systemProcess = (Process)systemProcessGetter.invoke((Object)process, new Object[0]);
                        this.outputStream = NullSafetyHelper.castNonNull(systemProcess).getOutputStream();
                    }
                    catch (ReflectiveOperationException ex) {
                        LanguageServerPlugin.logError(ex);
                    }
                    StreamProxyInputStream errorStream = this.errorStream = new StreamProxyInputStream(process);
                    if (proxy != null && (mon = proxy.getErrorStreamMonitor()) != null) {
                        mon.addListener((IStreamListener)errorStream);
                    }
                }
                catch (Exception e) {
                    LanguageServerPlugin.logError(e);
                    if (statusHandlerToUpdate) {
                        this.setStatusHandler(true);
                    }
                }
            }
            finally {
                if (statusHandlerToUpdate) {
                    this.setStatusHandler(true);
                }
            }
        }
    }

    private boolean disableStatusHandler() {
        boolean enabled = Platform.getPreferencesService().getBoolean(DebugPlugin.getUniqueIdentifier(), IInternalDebugCoreConstants.PREF_ENABLE_STATUS_HANDLERS, false, null);
        if (enabled) {
            this.setStatusHandler(false);
        }
        return enabled;
    }

    private void setStatusHandler(boolean enabled) {
        Preferences.setBoolean((String)DebugPlugin.getUniqueIdentifier(), (String)IInternalDebugCoreConstants.PREF_ENABLE_STATUS_HANDLERS, (boolean)enabled, null);
    }

    public <T> @Nullable T getAdapter(@Nullable Class<T> adapter) {
        if (adapter == ProcessHandle.class && this.process != null) {
            return (T)this.process.getAdapter(adapter);
        }
        return null;
    }

    @Override
    public @Nullable InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public @Nullable OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public @Nullable InputStream getErrorStream() {
        return this.errorStream;
    }

    @Override
    public void stop() {
        ILaunch launch = this.launch;
        if (launch == null) {
            return;
        }
        try {
            launch.terminate();
            IProcess[] iProcessArray = launch.getProcesses();
            int n = iProcessArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcess p = iProcessArray[n2];
                p.terminate();
                ++n2;
            }
        }
        catch (DebugException e1) {
            LanguageServerPlugin.logError(e1);
        }
        this.launch = null;
        this.process = null;
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException e) {
            LanguageServerPlugin.logError(e);
        }
        try {
            if (this.errorStream != null) {
                this.errorStream.close();
            }
        }
        catch (IOException e) {
            LanguageServerPlugin.logError(e);
        }
        this.inputStream = null;
        this.outputStream = null;
        this.errorStream = null;
    }

    protected static class StreamProxyInputStream
    extends InputStream
    implements IStreamListener {
        private static final int EOF = -1;
        private final ConcurrentLinkedQueue<byte[]> queue = new ConcurrentLinkedQueue();
        private final IProcess process;
        private byte[] currentBuffer = ArrayUtil.NO_BYTES;
        private int currentBufferPos = 0;

        public StreamProxyInputStream(IProcess process) {
            this.process = process;
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            byte[] bytes = text.getBytes();
            if (bytes.length > 0) {
                this.queue.offer(bytes);
            }
        }

        @Override
        public int read() throws IOException {
            if (this.currentBufferPos >= this.currentBuffer.length && !this.fillCurrentBuffer()) {
                return -1;
            }
            return this.currentBuffer[this.currentBufferPos++] & 0xFF;
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            Objects.checkFromIndexSize(off, len, buf.length);
            if (len == 0) {
                return 0;
            }
            int totalBytesRead = 0;
            while (totalBytesRead < len) {
                if (this.currentBufferPos >= this.currentBuffer.length && !this.fillCurrentBuffer()) {
                    return totalBytesRead == 0 ? -1 : totalBytesRead;
                }
                int bytesToRead = Math.min(len - totalBytesRead, this.currentBuffer.length - this.currentBufferPos);
                System.arraycopy(this.currentBuffer, this.currentBufferPos, buf, off + totalBytesRead, bytesToRead);
                this.currentBufferPos += bytesToRead;
                totalBytesRead += bytesToRead;
            }
            return totalBytesRead;
        }

        @Override
        public int available() throws IOException {
            return this.currentBuffer.length - this.currentBufferPos + this.queue.stream().mapToInt(arr -> ((byte[])arr).length).sum();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean fillCurrentBuffer() throws IOException {
            try {
                while (true) {
                    if (!this.queue.isEmpty()) {
                        this.currentBuffer = (byte[])this.queue.remove();
                        this.currentBufferPos = 0;
                        return this.currentBuffer.length > 0;
                    }
                    if (this.process.isTerminated()) {
                        return false;
                    }
                    Thread.sleep(5L);
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IOException("Thread interrupted while reading.", ex);
            }
        }
    }
}

