/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.EndpointConfig;
import org.mandas.docker.client.messages.NetworkConnection;

final class ImmutableNetworkConnection
implements NetworkConnection {
    private final String containerId;
    @Nullable
    private final EndpointConfig endpointConfig;

    private ImmutableNetworkConnection(String containerId, @Nullable EndpointConfig endpointConfig) {
        this.containerId = containerId;
        this.endpointConfig = endpointConfig;
    }

    @Override
    @JsonProperty(value="Container")
    public String containerId() {
        return this.containerId;
    }

    @Override
    @JsonProperty(value="EndpointConfig")
    @Nullable
    public EndpointConfig endpointConfig() {
        return this.endpointConfig;
    }

    public final ImmutableNetworkConnection withContainerId(String value) {
        String newValue = Objects.requireNonNull(value, "containerId");
        if (this.containerId.equals(newValue)) {
            return this;
        }
        return new ImmutableNetworkConnection(newValue, this.endpointConfig);
    }

    public final ImmutableNetworkConnection withEndpointConfig(@Nullable EndpointConfig value) {
        if (this.endpointConfig == value) {
            return this;
        }
        return new ImmutableNetworkConnection(this.containerId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNetworkConnection && this.equalsByValue((ImmutableNetworkConnection)another);
    }

    private boolean equalsByValue(ImmutableNetworkConnection another) {
        return this.containerId.equals(another.containerId) && Objects.equals(this.endpointConfig, another.endpointConfig);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.containerId.hashCode();
        h += (h << 5) + Objects.hashCode(this.endpointConfig);
        return h;
    }

    public String toString() {
        return "NetworkConnection{containerId=" + this.containerId + ", endpointConfig=" + String.valueOf(this.endpointConfig) + "}";
    }

    public static ImmutableNetworkConnection copyOf(NetworkConnection instance) {
        if (instance instanceof ImmutableNetworkConnection) {
            return (ImmutableNetworkConnection)instance;
        }
        return ImmutableNetworkConnection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements NetworkConnection.Builder {
        private static final long INIT_BIT_CONTAINER_ID = 1L;
        private long initBits = 1L;
        private String containerId;
        private EndpointConfig endpointConfig;

        private Builder() {
        }

        public final Builder from(NetworkConnection instance) {
            Objects.requireNonNull(instance, "instance");
            this.containerId(instance.containerId());
            EndpointConfig endpointConfigValue = instance.endpointConfig();
            if (endpointConfigValue != null) {
                this.endpointConfig(endpointConfigValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Container")
        public final Builder containerId(String containerId) {
            this.containerId = Objects.requireNonNull(containerId, "containerId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="EndpointConfig")
        public final Builder endpointConfig(@Nullable EndpointConfig endpointConfig) {
            this.endpointConfig = endpointConfig;
            return this;
        }

        @Override
        public ImmutableNetworkConnection build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNetworkConnection(this.containerId, this.endpointConfig);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("containerId");
            }
            return "Cannot build NetworkConnection, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

