/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.builder;

import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.builder.ProxyConfiguration;

final class ImmutableProxyConfiguration
implements ProxyConfiguration {
    private final String host;
    private final String port;
    @Nullable
    private final String username;
    @Nullable
    private final String password;

    private ImmutableProxyConfiguration(String host, String port, @Nullable String username, @Nullable String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public String port() {
        return this.port;
    }

    @Override
    @Nullable
    public String username() {
        return this.username;
    }

    @Override
    @Nullable
    public String password() {
        return this.password;
    }

    public final ImmutableProxyConfiguration withHost(String value) {
        String newValue = Objects.requireNonNull(value, "host");
        if (this.host.equals(newValue)) {
            return this;
        }
        return new ImmutableProxyConfiguration(newValue, this.port, this.username, this.password);
    }

    public final ImmutableProxyConfiguration withPort(String value) {
        String newValue = Objects.requireNonNull(value, "port");
        if (this.port.equals(newValue)) {
            return this;
        }
        return new ImmutableProxyConfiguration(this.host, newValue, this.username, this.password);
    }

    public final ImmutableProxyConfiguration withUsername(@Nullable String value) {
        if (Objects.equals(this.username, value)) {
            return this;
        }
        return new ImmutableProxyConfiguration(this.host, this.port, value, this.password);
    }

    public final ImmutableProxyConfiguration withPassword(@Nullable String value) {
        if (Objects.equals(this.password, value)) {
            return this;
        }
        return new ImmutableProxyConfiguration(this.host, this.port, this.username, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProxyConfiguration && this.equalsByValue((ImmutableProxyConfiguration)another);
    }

    private boolean equalsByValue(ImmutableProxyConfiguration another) {
        return this.host.equals(another.host) && this.port.equals(another.port) && Objects.equals(this.username, another.username) && Objects.equals(this.password, another.password);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.host.hashCode();
        h += (h << 5) + this.port.hashCode();
        h += (h << 5) + Objects.hashCode(this.username);
        h += (h << 5) + Objects.hashCode(this.password);
        return h;
    }

    public String toString() {
        return "ProxyConfiguration{host=" + this.host + ", port=" + this.port + ", username=" + this.username + ", password=" + this.password + "}";
    }

    public static ImmutableProxyConfiguration copyOf(ProxyConfiguration instance) {
        if (instance instanceof ImmutableProxyConfiguration) {
            return (ImmutableProxyConfiguration)instance;
        }
        return ImmutableProxyConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements ProxyConfiguration.Builder {
        private static final long INIT_BIT_HOST = 1L;
        private static final long INIT_BIT_PORT = 2L;
        private long initBits = 3L;
        private String host;
        private String port;
        private String username;
        private String password;

        private Builder() {
        }

        public final Builder from(ProxyConfiguration instance) {
            String passwordValue;
            Objects.requireNonNull(instance, "instance");
            this.host(instance.host());
            this.port(instance.port());
            String usernameValue = instance.username();
            if (usernameValue != null) {
                this.username(usernameValue);
            }
            if ((passwordValue = instance.password()) != null) {
                this.password(passwordValue);
            }
            return this;
        }

        @Override
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder port(String port) {
            this.port = Objects.requireNonNull(port, "port");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public final Builder username(@Nullable String username) {
            this.username = username;
            return this;
        }

        @Override
        public final Builder password(@Nullable String password) {
            this.password = password;
            return this;
        }

        @Override
        public ImmutableProxyConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProxyConfiguration(this.host, this.port, this.username, this.password);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("host");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("port");
            }
            return "Cannot build ProxyConfiguration, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

