/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.deployment.download.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.concurrent.CancellationException;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.core.deployment.CloudDeploymentHandlerV2;
import org.eclipse.kura.core.deployment.DownloadStatus;
import org.eclipse.kura.core.deployment.download.DeploymentPackageDownloadOptions;
import org.eclipse.kura.core.deployment.download.DownloadCountingOutputStream;
import org.eclipse.kura.core.deployment.download.DownloadFactory;
import org.eclipse.kura.core.deployment.download.DownloadFileUtilities;
import org.eclipse.kura.core.deployment.download.DownloadOptions;
import org.eclipse.kura.core.deployment.download.impl.KuraNotifyPayload;
import org.eclipse.kura.core.deployment.install.DeploymentPackageInstallOptions;
import org.eclipse.kura.core.deployment.progress.ProgressEvent;
import org.eclipse.kura.core.deployment.progress.ProgressListener;
import org.eclipse.kura.core.deployment.util.FileUtilities;
import org.eclipse.kura.core.deployment.util.HashUtil;
import org.eclipse.kura.deployment.hook.DeploymentHook;
import org.eclipse.kura.message.KuraResponsePayload;
import org.eclipse.kura.ssl.SslManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadImpl
implements ProgressListener {
    private static final Logger s_logger = LoggerFactory.getLogger(DownloadImpl.class);
    public static final String RESOURCE_DOWNLOAD = "download";
    private final CloudDeploymentHandlerV2 callback;
    private final DeploymentPackageDownloadOptions options;
    private DownloadCountingOutputStream downloadHelper;
    private SslManagerService sslManagerService;
    private boolean alreadyDownloadedFlag;
    private String verificationDirectory;

    public DownloadImpl(DeploymentPackageDownloadOptions options, CloudDeploymentHandlerV2 callback) {
        this.options = options;
        this.callback = callback;
    }

    public DownloadCountingOutputStream getDownloadHelper() {
        return this.downloadHelper;
    }

    public void setSslManager(SslManagerService sslManager) {
        this.sslManagerService = sslManager;
    }

    public void setAlreadyDownloadedFlag(boolean alreadyDownloaded) {
        this.alreadyDownloadedFlag = alreadyDownloaded;
    }

    public void setVerificationDirectory(String verificationDirectory) {
        this.verificationDirectory = verificationDirectory;
    }

    @Override
    public void progressChanged(ProgressEvent progress) {
        s_logger.info("{}% downloaded", (Object)progress.getTransferProgress());
        KuraNotifyPayload notify = new KuraNotifyPayload(progress.getClientId());
        notify.setTimestamp(new Date());
        notify.setTransferSize(progress.getTransferSize());
        notify.setTransferProgress(progress.getTransferProgress());
        notify.setTransferStatus(progress.getTransferStatus());
        notify.setJobId(progress.getJobId());
        if (progress.getExceptionMessage() != null) {
            notify.setErrorMessage(progress.getExceptionMessage());
        }
        notify.setTransferIndex(progress.getDownloadIndex());
        this.callback.publishMessage(this.options, notify, RESOURCE_DOWNLOAD);
    }

    public void downloadDeploymentPackageInternal() throws KuraException {
        DeploymentHook hook;
        File dpFile = null;
        int downloadIndex = 0;
        boolean downloadSuccess = true;
        try {
            dpFile = DownloadFileUtilities.getDpDownloadFile(this.options);
            boolean forceDownload = this.options.isDownloadForced();
            if (!this.alreadyDownloadedFlag || forceDownload) {
                s_logger.info("To download");
                this.incrementalDownloadFromURL(dpFile, this.options.getDeployUri(), downloadIndex);
                ++downloadIndex;
                if (this.options.getVerifierURL() != null) {
                    File dpVerifier = this.getDpVerifierFile(this.options);
                    this.incrementalDownloadFromURL(dpVerifier, this.options.getVerifierURL(), downloadIndex);
                }
            } else {
                this.alreadyDownloadedAsync();
            }
        }
        catch (CancellationException ce) {
            s_logger.error("Download exception", (Throwable)ce);
            downloadSuccess = false;
        }
        catch (Exception e) {
            s_logger.info("Download exception", (Throwable)e);
            downloadSuccess = false;
            this.downloadFailedAsync(downloadIndex, null);
        }
        if ((hook = this.options.getDeploymentHook()) != null) {
            try {
                hook.postDownload(this.options.getHookRequestContext(), this.options.getHookProperties());
            }
            catch (Exception e) {
                s_logger.warn("DeploymentHook cancelled operation at postDownload phase");
                throw e;
            }
        }
        if (downloadSuccess && dpFile != null && this.options.isInstall()) {
            s_logger.info("Ready to install");
            this.callback.installDownloadedFile(dpFile, this.options);
        }
    }

    public boolean isAlreadyDownloaded() throws KuraException {
        try {
            File dp = DownloadFileUtilities.getDpDownloadFile(this.options);
            return dp.exists();
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)e, new Object[0]);
        }
    }

    public boolean deleteDownloadedFile() throws KuraException {
        try {
            return DownloadFileUtilities.deleteDownloadedFile(this.options);
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)e, new Object[0]);
        }
    }

    protected DownloadCountingOutputStream getDownloadInstance(String protocol, DownloadOptions downloadOptions) {
        return DownloadFactory.getDownloadInstance(protocol, downloadOptions);
    }

    private void incrementalDownloadFromURL(File dpFile, String url, int downloadIndex) throws Exception {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(dpFile);
            DownloadOptions downloadOptions = new DownloadOptions();
            downloadOptions.setOut(os);
            downloadOptions.setRequestOptions(this.options);
            downloadOptions.setCallback(this);
            downloadOptions.setSslManagerService(this.sslManagerService);
            downloadOptions.setDownloadURL(url);
            downloadOptions.setAlreadyDownloaded(downloadIndex);
            this.downloadHelper = this.getDownloadInstance(this.options.getDownloadProtocol(), downloadOptions);
            this.downloadHelper.startWork();
            this.downloadHelper.close();
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e1) {
                    s_logger.error("Exception while trying to close stream.", (Throwable)e1);
                }
            }
        }
        if (this.options.getHash() != null) {
            String[] hashAlgorithmValue = this.options.getHash().split(":");
            String hashAlgorithm = null;
            String hashValue = null;
            if (hashAlgorithmValue.length == 2) {
                hashAlgorithm = hashAlgorithmValue[0].trim();
                hashValue = hashAlgorithmValue[1].trim();
            }
            s_logger.info("--> Going to verify hash signature!");
            try {
                if (hashAlgorithm == null || "".equals(hashAlgorithm) || hashValue == null || "".equals(hashValue)) {
                    throw new KuraException(KuraErrorCode.INTERNAL_ERROR, null, new Object[]{"Failed to verify checksum with empty algorithm: " + hashAlgorithm});
                }
                String checksum = HashUtil.hash(hashAlgorithm, dpFile);
                if (checksum == null || !checksum.equals(hashValue)) {
                    throw new KuraException(KuraErrorCode.INTERNAL_ERROR, null, new Object[]{"Failed to verify checksum with algorithm: " + hashAlgorithm});
                }
            }
            catch (Exception e) {
                dpFile.delete();
                throw e;
            }
        }
    }

    public static void downloadInProgressSyncMessage(KuraResponsePayload respPayload, DownloadCountingOutputStream downloadHelper, DeploymentPackageDownloadOptions downloadOptions) {
        respPayload.setTimestamp(new Date());
        respPayload.addMetric("dp.download.size", (Object)downloadHelper.getTotalBytes().intValue());
        respPayload.addMetric("dp.download.progress", (Object)downloadHelper.getDownloadTransferProgressPercentage().intValue());
        respPayload.addMetric("dp.download.status", (Object)downloadHelper.getDownloadTransferStatus().getStatusString());
        respPayload.addMetric("job.id", (Object)downloadOptions.getJobId());
    }

    public static void downloadAlreadyDoneSyncMessage(KuraResponsePayload respPayload) {
        respPayload.setTimestamp(new Date());
        respPayload.addMetric("dp.download.size", (Object)0);
        respPayload.addMetric("dp.download.progress", (Object)100);
        respPayload.addMetric("dp.download.status", (Object)DownloadStatus.ALREADY_DONE.getStatusString());
    }

    private void alreadyDownloadedAsync() {
        KuraNotifyPayload notify = new KuraNotifyPayload(this.options.getClientId());
        notify.setTimestamp(new Date());
        notify.setTransferSize(0);
        notify.setTransferProgress(100);
        notify.setTransferStatus(DownloadStatus.COMPLETED.getStatusString());
        notify.setJobId(this.options.getJobId());
        this.callback.publishMessage(this.options, notify, RESOURCE_DOWNLOAD);
    }

    private void downloadFailedAsync(int downloadIndex, Exception e) {
        KuraNotifyPayload notify = new KuraNotifyPayload(this.options.getClientId());
        notify.setTimestamp(new Date());
        notify.setTransferSize(0);
        notify.setTransferProgress(0);
        notify.setTransferStatus(DownloadStatus.FAILED.getStatusString());
        notify.setJobId(this.options.getJobId());
        notify.setErrorMessage(e == null ? "Error during download process and verification!" : e.getMessage());
        notify.setTransferIndex(downloadIndex);
        this.callback.publishMessage(this.options, notify, RESOURCE_DOWNLOAD);
    }

    private File getDpVerifierFile(DeploymentPackageInstallOptions options) {
        String shName = FileUtilities.getFileName(options.getDpName(), options.getDpVersion(), ".sh_verifier.sh", "-");
        String packageFilename = this.verificationDirectory + File.separator + shName;
        return new File(packageFilename);
    }
}

