/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.certificate;

import java.security.KeyStore;
import java.security.cert.Certificate;

public class KuraCertificateEntry {
    private String certificateId;
    private String keystoreId;
    private String alias;
    private KeyStore.TrustedCertificateEntry certificateEntry;

    public KuraCertificateEntry(String keystoreId, String alias, Certificate certificate) {
        this.keystoreId = keystoreId;
        this.alias = alias;
        this.certificateEntry = new KeyStore.TrustedCertificateEntry(certificate);
        this.certificateId = String.valueOf(keystoreId) + ":" + alias;
    }

    public KuraCertificateEntry(String keystoreId, String alias, KeyStore.TrustedCertificateEntry entry) {
        this.keystoreId = keystoreId;
        this.alias = alias;
        this.certificateEntry = entry;
        this.certificateId = String.valueOf(keystoreId) + ":" + alias;
    }

    public String getCertificateId() {
        return this.certificateId;
    }

    public String getKeystoreId() {
        return this.keystoreId;
    }

    public String getAlias() {
        return this.alias;
    }

    public KeyStore.TrustedCertificateEntry getCertificateEntry() {
        return this.certificateEntry;
    }

    public static String getKeystoreId(String id) {
        if (id != null) {
            return id.split(":")[0];
        }
        return "";
    }

    public static String getAlias(String id) {
        if (id != null) {
            String[] fields = id.split(":");
            if (fields.length == 1) {
                return "";
            }
            return fields[fields.length - 1];
        }
        return "";
    }
}

