/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.URLClassLoader;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;

public class ClassLoaderDump
implements Dumpable {
    final ClassLoader _loader;

    public ClassLoaderDump(ClassLoader loader) {
        this._loader = loader;
    }

    public String dump() {
        return Dumpable.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        if (this._loader == null) {
            out.append("No ClassLoader\n");
        } else if (this._loader instanceof Dumpable) {
            ((Dumpable)this._loader).dump(out, indent);
        } else if (this._loader instanceof URLClassLoader) {
            String loader = this._loader.toString();
            DumpableCollection urls = DumpableCollection.fromArray((String)"URLs", (Object[])((URLClassLoader)this._loader).getURLs());
            ClassLoader parent = this._loader.getParent();
            if (parent == null) {
                Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)loader, (Object[])new Object[]{urls});
            } else if (parent == Server.class.getClassLoader()) {
                Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)loader, (Object[])new Object[]{urls, parent.toString()});
            } else if (parent instanceof Dumpable) {
                Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)loader, (Object[])new Object[]{urls, parent});
            } else {
                Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)loader, (Object[])new Object[]{urls, new ClassLoaderDump(parent)});
            }
        } else {
            String loader = this._loader.toString();
            ClassLoader parent = this._loader.getParent();
            if (parent == null) {
                Dumpable.dumpObject((Appendable)out, (Object)loader);
            }
            if (parent == Server.class.getClassLoader()) {
                Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)loader, (Object[])new Object[]{parent.toString()});
            } else if (parent instanceof Dumpable) {
                Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)loader, (Object[])new Object[]{parent});
            } else if (parent != null) {
                Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)loader, (Object[])new Object[]{new ClassLoaderDump(parent)});
            }
        }
    }
}

