/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.data.store;

import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.kura.KuraStoreException;
import org.eclipse.kura.core.data.DataServiceOptions;
import org.eclipse.kura.core.data.store.HouseKeeperTask;
import org.eclipse.kura.message.store.provider.MessageStore;
import org.eclipse.kura.message.store.provider.MessageStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageStoreState {
    private static final Logger logger = LoggerFactory.getLogger(MessageStoreState.class);
    private final MessageStoreProvider messageStoreProvider;
    private DataServiceOptions options;
    private Optional<MessageStore> messageStore = Optional.empty();
    private Optional<ScheduledExecutorService> houseKeeperExecutor = Optional.empty();

    public MessageStoreState(MessageStoreProvider messageStoreProvider, DataServiceOptions options) {
        this.messageStoreProvider = messageStoreProvider;
        this.update(options);
    }

    public synchronized void update(DataServiceOptions dataServiceOptions) {
        this.options = dataServiceOptions;
        this.shutdown();
        if (!this.houseKeeperExecutor.isPresent()) {
            this.houseKeeperExecutor = Optional.of(Executors.newSingleThreadScheduledExecutor());
            this.houseKeeperExecutor.get().scheduleWithFixedDelay(new HouseKeeperTask(this, dataServiceOptions.getStorePurgeAge()), 1L, dataServiceOptions.getStoreHousekeeperInterval(), TimeUnit.SECONDS);
        }
    }

    public MessageStoreProvider getMessageStoreProvider() {
        return this.messageStoreProvider;
    }

    public synchronized MessageStore getOrOpenMessageStore() throws KuraStoreException {
        if (this.messageStore.isPresent()) {
            return this.messageStore.get();
        }
        return this.openMessageStore();
    }

    public synchronized MessageStore openMessageStore() throws KuraStoreException {
        MessageStore result = this.messageStoreProvider.openMessageStore(this.options.getKuraServicePid());
        this.messageStore = Optional.of(result);
        return result;
    }

    public synchronized void shutdown() {
        if (this.houseKeeperExecutor.isPresent()) {
            this.houseKeeperExecutor.get().shutdown();
            try {
                this.houseKeeperExecutor.get().awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted while waiting for housekeeper task shutdown", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            this.houseKeeperExecutor = Optional.empty();
        }
        if (this.messageStore.isPresent()) {
            this.messageStore.get().close();
            this.messageStore = Optional.empty();
        }
    }
}

