/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsStreamVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;
import org.bouncycastle.util.Arrays;

public class BcTlsSM2Verifier
extends BcTlsVerifier {
    protected final byte[] identifier;

    public BcTlsSM2Verifier(BcTlsCrypto bcTlsCrypto, ECPublicKeyParameters eCPublicKeyParameters, byte[] byArray) {
        super(bcTlsCrypto, (AsymmetricKeyParameter)eCPublicKeyParameters);
        this.identifier = Arrays.clone((byte[])byArray);
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned digitallySigned) {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm == null) {
            throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
        }
        ParametersWithID parametersWithID = new ParametersWithID((CipherParameters)this.publicKey, this.identifier);
        SM2Signer sM2Signer = new SM2Signer();
        sM2Signer.init(false, (CipherParameters)parametersWithID);
        return new BcTlsStreamVerifier((Signer)sM2Signer, digitallySigned.getSignature());
    }
}

