/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.configuration.metatype.AD;
import org.eclipse.kura.configuration.metatype.Icon;
import org.eclipse.kura.configuration.metatype.OCD;
import org.eclipse.kura.configuration.metatype.Option;
import org.eclipse.kura.core.configuration.ComponentConfigurationImpl;
import org.eclipse.kura.core.configuration.XmlComponentConfigurations;
import org.eclipse.kura.core.configuration.metatype.Tad;
import org.eclipse.kura.core.configuration.metatype.Tocd;
import org.eclipse.kura.driver.descriptor.DriverDescriptor;
import org.eclipse.kura.marshalling.Marshaller;
import org.eclipse.kura.rest.configuration.api.ComponentConfigurationList;
import org.eclipse.kura.rest.configuration.api.DTOUtil;
import org.eclipse.kura.util.service.ServiceUtil;
import org.eclipse.kura.web.Console;
import org.eclipse.kura.web.server.servlet.DeviceSnapshotsServlet;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtComponentInstanceInfo;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtConfigParameter;
import org.eclipse.kura.web.shared.model.GwtModemInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtWifiConfig;
import org.eclipse.kura.web.shared.model.GwtWifiNetInterfaceConfig;
import org.eclipse.kura.web.shared.validator.PasswordStrengthValidators;
import org.eclipse.kura.web.shared.validator.Validator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GwtServerUtil {
    private static final String JSON_FORMAT = "json";
    private static final String XML_FORMAT = "xml";
    public static final String PASSWORD_PLACEHOLDER = "Placeholder";
    public static final String PATTERN_CONFIGURATION_REQUIRE = "configuration-policy=\"require\"";
    public static final String PATTERN_SERVICE_PROVIDE_CONFIGURABLE_COMP = "provide interface=\"org.eclipse.kura.configuration.ConfigurableComponent\"";
    public static final String PATTERN_SERVICE_PROVIDE_EMITTER = "provide interface=\"org.eclipse.kura.wire.WireEmitter\"";
    public static final String PATTERN_SERVICE_PROVIDE_RECEIVER = "provide interface=\"org.eclipse.kura.wire.WireReceiver\"";
    public static final String PATTERN_SERVICE_PROVIDE_SELF_CONFIGURING_COMP = "provide interface=\"org.eclipse.kura.configuration.SelfConfiguringComponent\"";
    private static final String DRIVER_PID = "driver.pid";
    private static final Logger logger = LoggerFactory.getLogger(GwtServerUtil.class);

    public static Object getObjectValue(GwtConfigParameter param) {
        Object objValue = null;
        GwtConfigParameter.GwtConfigParameterType gwtType = param.getType();
        String strValue = param.getValue();
        if (gwtType == GwtConfigParameter.GwtConfigParameterType.STRING) {
            objValue = strValue;
        } else if (strValue != null && !strValue.trim().isEmpty()) {
            String trimmedValue = strValue.trim();
            switch (gwtType) {
                case LONG: {
                    objValue = Long.parseLong(trimmedValue);
                    break;
                }
                case DOUBLE: {
                    objValue = Double.parseDouble(trimmedValue);
                    break;
                }
                case FLOAT: {
                    objValue = Float.valueOf(Float.parseFloat(trimmedValue));
                    break;
                }
                case INTEGER: {
                    objValue = Integer.parseInt(trimmedValue);
                    break;
                }
                case SHORT: {
                    objValue = Short.parseShort(trimmedValue);
                    break;
                }
                case BYTE: {
                    objValue = Byte.parseByte(trimmedValue);
                    break;
                }
                case BOOLEAN: {
                    objValue = Boolean.parseBoolean(trimmedValue);
                    break;
                }
                case PASSWORD: {
                    objValue = new Password(trimmedValue);
                    break;
                }
                case CHAR: {
                    objValue = Character.valueOf(trimmedValue.charAt(0));
                    break;
                }
            }
        }
        return objValue;
    }

    public static Object[] getObjectValues(GwtConfigParameter param, String[] defaultValues) {
        ArrayList<Object> values = new ArrayList<Object>();
        GwtConfigParameter.GwtConfigParameterType type = param.getType();
        List trimmedValues = Stream.of(defaultValues).map(String::trim).collect(Collectors.toList());
        switch (type) {
            case BOOLEAN: {
                for (String value : trimmedValues) {
                    if (value.isEmpty()) continue;
                    values.add(Boolean.valueOf(value));
                }
                return values.toArray(new Boolean[0]);
            }
            case BYTE: {
                for (String value : trimmedValues) {
                    if (value.isEmpty()) continue;
                    values.add(Byte.valueOf(value));
                }
                return values.toArray(new Byte[0]);
            }
            case CHAR: {
                for (String value : trimmedValues) {
                    if (value.isEmpty()) continue;
                    values.add(new Character(value.charAt(0)));
                }
                return values.toArray(new Character[0]);
            }
            case DOUBLE: {
                for (String value : trimmedValues) {
                    if (value.isEmpty()) continue;
                    values.add(Double.valueOf(value));
                }
                return values.toArray(new Double[0]);
            }
            case FLOAT: {
                for (String value : trimmedValues) {
                    if (value.isEmpty()) continue;
                    values.add(Float.valueOf(value));
                }
                return values.toArray(new Float[0]);
            }
            case INTEGER: {
                for (String value : trimmedValues) {
                    if (value.isEmpty()) continue;
                    values.add(Integer.valueOf(value));
                }
                return values.toArray(new Integer[0]);
            }
            case LONG: {
                for (String value : trimmedValues) {
                    if (value.isEmpty()) continue;
                    values.add(Long.valueOf(value));
                }
                return values.toArray(new Long[0]);
            }
            case SHORT: {
                for (String value : trimmedValues) {
                    if (value.isEmpty()) continue;
                    values.add(Short.valueOf(value));
                }
                return values.toArray(new Short[0]);
            }
            case PASSWORD: {
                for (String value : trimmedValues) {
                    if (value.isEmpty()) continue;
                    values.add(new Password(value));
                }
                return values.toArray(new Password[0]);
            }
            case STRING: {
                for (String value : trimmedValues) {
                    if (value.isEmpty()) continue;
                    values.add(value);
                }
                return values.toArray(new String[0]);
            }
        }
        return null;
    }

    public static Object getUserDefinedObject(GwtConfigParameter param, Object currentObjValue) {
        Object objValue;
        int cardinality = param.getCardinality();
        if (cardinality == 0 || cardinality == 1 || cardinality == -1) {
            String strValue = param.getValue();
            objValue = currentObjValue instanceof Password && PASSWORD_PLACEHOLDER.equals(strValue) ? currentObjValue : GwtServerUtil.getObjectValue(param);
        } else {
            String[] strValues = param.getValues();
            if (currentObjValue instanceof Password[]) {
                Password[] currentPasswordValue = (Password[])currentObjValue;
                int i = 0;
                while (i < strValues.length) {
                    if (PASSWORD_PLACEHOLDER.equals(strValues[i])) {
                        strValues[i] = new String(currentPasswordValue[i].getPassword());
                    }
                    ++i;
                }
            }
            objValue = GwtServerUtil.getObjectValues(param, strValues);
        }
        return objValue;
    }

    public static String stripPidPrefix(String pid) {
        if (pid == null) {
            return null;
        }
        int start = pid.lastIndexOf(46);
        if (start < 0) {
            return pid;
        }
        int begin = start + 1;
        if (begin < pid.length()) {
            return pid.substring(begin);
        }
        return pid;
    }

    private GwtServerUtil() {
    }

    public static Map<String, Object> fillPropertiesFromConfiguration(GwtConfigComponent config, ComponentConfiguration currentCC) {
        HashMap<String, Object> properties = new HashMap<String, Object>(config.getProperties());
        ComponentConfiguration backupCC = currentCC;
        if (backupCC == null) {
            for (GwtConfigParameter gwtConfigParam : config.getParameters()) {
                properties.put(gwtConfigParam.getId(), GwtServerUtil.getUserDefinedObject(gwtConfigParam, null));
            }
        } else {
            Map backupConfigProp = backupCC.getConfigurationProperties();
            for (GwtConfigParameter gwtConfigParam : config.getParameters()) {
                Map currentConfigProp = currentCC.getConfigurationProperties();
                properties.put(gwtConfigParam.getId(), GwtServerUtil.getUserDefinedObject(gwtConfigParam, currentConfigProp.get(gwtConfigParam.getName())));
            }
            if (backupConfigProp.get("kura.service.pid") != null) {
                properties.put("kura.service.pid", backupConfigProp.get("kura.service.pid"));
            }
        }
        String factoryPid = config.getFactoryId();
        if (factoryPid != null) {
            properties.put("service.factoryPid", factoryPid);
        }
        return properties;
    }

    private static List<GwtConfigParameter> getADProperties(ComponentConfiguration config) {
        ArrayList<GwtConfigParameter> gwtParams = new ArrayList<GwtConfigParameter>();
        OCD ocd = config.getDefinition();
        for (AD ad : ocd.getAD()) {
            Object value = null;
            if (config.getConfigurationProperties() != null) {
                value = config.getConfigurationProperties().get(ad.getId());
            }
            gwtParams.add(GwtServerUtil.toGwtConfigParameter(ad, value));
        }
        return gwtParams;
    }

    public static GwtConfigParameter toGwtConfigParameter(AD ad, Object value) {
        GwtConfigParameter gwtParam = new GwtConfigParameter();
        gwtParam.setId(ad.getId());
        gwtParam.setName(ad.getName());
        gwtParam.setDescription(ad.getDescription());
        gwtParam.setType(GwtConfigParameter.GwtConfigParameterType.valueOf(ad.getType().name()));
        gwtParam.setRequired(ad.isRequired());
        gwtParam.setCardinality(ad.getCardinality());
        gwtParam.setDefault(ad.getDefault());
        if (ad.getOption() != null && !ad.getOption().isEmpty()) {
            HashMap<String, String> options = new HashMap<String, String>();
            for (Option option : ad.getOption()) {
                options.put(option.getLabel(), option.getValue());
            }
            gwtParam.setOptions(options);
        }
        gwtParam.setMin(ad.getMin());
        gwtParam.setMax(ad.getMax());
        int cardinality = ad.getCardinality();
        if (value != null) {
            if (cardinality == 0 || cardinality == 1 || cardinality == -1) {
                if (gwtParam.getType().equals((Object)GwtConfigParameter.GwtConfigParameterType.PASSWORD)) {
                    gwtParam.setValue(PASSWORD_PLACEHOLDER);
                } else {
                    gwtParam.setValue(String.valueOf(value));
                }
            } else if (value instanceof Object[]) {
                Object[] objValues = (Object[])value;
                ArrayList<String> strValues = new ArrayList<String>();
                Object[] objectArray = objValues;
                int n = objValues.length;
                int n2 = 0;
                while (n2 < n) {
                    Object v = objectArray[n2];
                    if (v != null) {
                        if (gwtParam.getType().equals((Object)GwtConfigParameter.GwtConfigParameterType.PASSWORD)) {
                            strValues.add(PASSWORD_PLACEHOLDER);
                        } else {
                            strValues.add(String.valueOf(v));
                        }
                    }
                    ++n2;
                }
                gwtParam.setValues(strValues.toArray(new String[0]));
            }
        }
        return gwtParam;
    }

    public static GwtConfigComponent toGwtConfigComponent(ComponentConfiguration config) {
        GwtConfigComponent gwtConfig = null;
        OCD ocd = config.getDefinition();
        if (ocd != null) {
            gwtConfig = new GwtConfigComponent();
            gwtConfig.setComponentId(config.getPid());
            Map props = config.getConfigurationProperties();
            if (props != null && props.get(DRIVER_PID) != null) {
                gwtConfig.set(DRIVER_PID, props.get(DRIVER_PID));
            }
            if (props != null && props.get("service.factoryPid") != null) {
                gwtConfig.setFactoryComponent(true);
                gwtConfig.setFactoryPid(String.valueOf(props.get("service.factoryPid")));
            } else {
                gwtConfig.setFactoryComponent(false);
            }
            if (ocd.getName() != null) {
                gwtConfig.setComponentName(ocd.getName());
            }
            gwtConfig.setComponentDescription(ocd.getDescription());
            if (ocd.getIcon() != null && !ocd.getIcon().isEmpty()) {
                Icon icon = (Icon)ocd.getIcon().get(0);
                gwtConfig.setComponentIcon(icon.getResource());
            }
            if (gwtConfig.getComponentName() == null) {
                gwtConfig.setComponentName(GwtServerUtil.stripPidPrefix(config.getPid()));
            }
            ArrayList<GwtConfigParameter> gwtParams = new ArrayList<GwtConfigParameter>();
            gwtConfig.setParameters(gwtParams);
            gwtParams.addAll(GwtServerUtil.getADProperties(config));
        }
        return gwtConfig;
    }

    public static GwtConfigComponent toGwtConfigComponent(String pid, Object descriptor) {
        if (!(descriptor instanceof List)) {
            return null;
        }
        List ads = (List)descriptor;
        Tocd ocd = new Tocd();
        ocd.setId(pid);
        for (Object ad : ads) {
            if (!(ad instanceof Tad)) {
                return null;
            }
            ocd.addAD((Tad)ad);
        }
        return GwtServerUtil.toGwtConfigComponent((ComponentConfiguration)new ComponentConfigurationImpl(pid, ocd, null));
    }

    public static ComponentConfiguration fromGwtConfigComponent(GwtConfigComponent gwtCompConfig, ComponentConfiguration currentCC) {
        String factoryPid;
        if (currentCC == null) {
            ComponentConfigurationImpl result = new ComponentConfigurationImpl();
            result.setPid(gwtCompConfig.getComponentId());
            result.setProperties(GwtServerUtil.fillPropertiesFromConfiguration(gwtCompConfig, null));
            return result;
        }
        HashMap properties = new HashMap();
        Map currentConfigProp = currentCC.getConfigurationProperties();
        for (GwtConfigParameter gwtConfigParam : gwtCompConfig.getParameters()) {
            Object currentValue = currentConfigProp.get(gwtConfigParam.getId());
            boolean isReadOnly = gwtConfigParam.getMin() != null && gwtConfigParam.getMin().equals(gwtConfigParam.getMax());
            Object objValue = isReadOnly ? currentValue : GwtServerUtil.getUserDefinedObject(gwtConfigParam, currentValue);
            properties.put(gwtConfigParam.getId(), objValue);
        }
        if (currentConfigProp.get("kura.service.pid") != null) {
            properties.put("kura.service.pid", currentConfigProp.get("kura.service.pid"));
        }
        if ((factoryPid = gwtCompConfig.getFactoryId()) != null) {
            properties.put("service.factoryPid", factoryPid);
        }
        currentConfigProp.clear();
        currentConfigProp.putAll(properties);
        return currentCC;
    }

    public static GwtConfigComponent toGwtConfigComponent(DriverDescriptor descriptor) {
        Object channelDescriptor = descriptor.getChannelDescriptor();
        if (channelDescriptor == null) {
            return null;
        }
        return GwtServerUtil.toGwtConfigComponent(descriptor.getPid(), channelDescriptor);
    }

    public static <T> Set<T> getArrayProperty(Object raw, Class<T> elementValue) {
        if (!(raw instanceof Object[])) {
            return Collections.emptySet();
        }
        Object[] asArray = (Object[])raw;
        HashSet<Object> result = new HashSet<Object>();
        Object[] objectArray = asArray;
        int n = asArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (elementValue.isInstance(o)) {
                result.add(o);
            }
            ++n2;
        }
        return result;
    }

    public static boolean isFactoryOf(String factoryPid, Predicate<Set<String>> filter) {
        try {
            return ServiceLocator.applyToServiceOptionally(ServiceComponentRuntime.class, scr -> scr.getComponentDescriptionDTOs(new Bundle[0]).stream().anyMatch(c -> {
                if (!Objects.equals(factoryPid, c.name)) {
                    return false;
                }
                return GwtServerUtil.providedInterfacesMatch(c.serviceInterfaces, filter);
            }));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isFactoryOfAnyService(String factoryPid, Class<?> ... interfaces) {
        return GwtServerUtil.isFactoryOf(factoryPid, s -> {
            Class[] classArray2 = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class intf = classArray2[n2];
                if (s.contains(intf.getName())) {
                    return true;
                }
                ++n2;
            }
            return false;
        });
    }

    public static Set<String> getServiceProviderComponentNames(Predicate<Set<String>> filter) throws GwtKuraException {
        try {
            return ServiceLocator.applyToServiceOptionally(ServiceComponentRuntime.class, scr -> scr.getComponentDescriptionDTOs(new Bundle[0]).stream().filter(c -> GwtServerUtil.providedInterfacesMatch(c.serviceInterfaces, filter))).map(c -> c.name).collect(Collectors.toSet());
        }
        catch (Exception e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static Set<String> getServiceProviderFactoryPids(Predicate<Set<String>> filter) throws GwtKuraException {
        Set<String> names = GwtServerUtil.getServiceProviderComponentNames(filter);
        Set factoryPids = ServiceLocator.applyToServiceOptionally(ConfigurationService.class, ConfigurationService::getFactoryComponentPids);
        names.removeIf(n -> !factoryPids.contains(n));
        return names;
    }

    public static List<GwtComponentInstanceInfo> getComponentInstances(Predicate<Set<String>> filter) throws GwtKuraException {
        try {
            return ServiceLocator.applyToServiceOptionally(ServiceComponentRuntime.class, scr -> scr.getComponentDescriptionDTOs(new Bundle[0]).stream().filter(c -> GwtServerUtil.providedInterfacesMatch(c.serviceInterfaces, filter)).flatMap(c -> scr.getComponentConfigurationDTOs(c).stream()).map(c -> {
                Map properties = c.properties;
                Object kuraServicePid = properties.get("kura.service.pid");
                Object rawFactoryPid = properties.get("service.factoryPid");
                if (!(kuraServicePid instanceof String)) {
                    return null;
                }
                Optional<String> factoryPid = rawFactoryPid instanceof String ? Optional.of((String)rawFactoryPid) : Optional.empty();
                return new GwtComponentInstanceInfo((String)kuraServicePid, factoryPid);
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        catch (Exception e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    private static boolean providedInterfacesMatch(String[] providedInterfaces, Predicate<Set<String>> filter) {
        if (providedInterfaces == null) {
            return filter.test(Collections.emptySet());
        }
        return filter.test(Arrays.stream(providedInterfaces).collect(Collectors.toSet()));
    }

    public static boolean providesService(String kuraServicePid, Class<?> serviceInterface) {
        return GwtServerUtil.providesService(kuraServicePid, (Set<String> s) -> s.contains(serviceInterface.getName()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean providesService(String kuraServicePid, Predicate<Set<String>> filter) {
        BundleContext context = FrameworkUtil.getBundle(GwtServerUtil.class).getBundleContext();
        String pidFilter = "(kura.service.pid=" + kuraServicePid + ")";
        try {
            ServiceReference[] refs = context.getAllServiceReferences(null, pidFilter);
            if (refs == null) {
                return false;
            }
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ServiceReference ref = serviceReferenceArray[n2];
                Object rawProvidedInterfaces = ref.getProperty("objectClass");
                Set<String> providedInterfaces = rawProvidedInterfaces instanceof String ? Collections.singleton((String)rawProvidedInterfaces) : (rawProvidedInterfaces instanceof String[] ? Arrays.asList((String[])rawProvidedInterfaces).stream().collect(Collectors.toSet()) : Collections.emptySet());
                if (filter.test(providedInterfaces)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    private static ServiceReference<Marshaller>[] getXmlMarshallers() {
        String filterString = String.format("(&(kura.service.pid=%s))", "org.eclipse.kura.xml.marshaller.unmarshaller.provider");
        return ServiceUtil.getServiceReferences((BundleContext)FrameworkUtil.getBundle(DeviceSnapshotsServlet.class).getBundleContext(), Marshaller.class, (String)filterString);
    }

    private static void ungetServiceReferences(ServiceReference<?>[] refs) {
        ServiceUtil.ungetServiceReferences((BundleContext)FrameworkUtil.getBundle(DeviceSnapshotsServlet.class).getBundleContext(), refs);
    }

    private static String marshal(Object object) {
        String result = null;
        ServiceReference<Marshaller>[] marshallerSRs = GwtServerUtil.getXmlMarshallers();
        try {
            try {
                ServiceReference<Marshaller>[] serviceReferenceArray = marshallerSRs;
                int n = marshallerSRs.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference<Marshaller> marshallerSR = serviceReferenceArray[n2];
                    Marshaller marshaller = (Marshaller)FrameworkUtil.getBundle(DeviceSnapshotsServlet.class).getBundleContext().getService(marshallerSR);
                    result = marshaller.marshal(object);
                    if (result != null) {
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                logger.warn("Failed to marshal configuration.");
                GwtServerUtil.ungetServiceReferences(marshallerSRs);
            }
        }
        finally {
            GwtServerUtil.ungetServiceReferences(marshallerSRs);
        }
        return result;
    }

    public static void writeXmlSnapshot(HttpServletResponse response, PrintWriter writer, String filename, List<ComponentConfiguration> configs) {
        ArrayList<ComponentConfiguration> configImpls = new ArrayList<ComponentConfiguration>();
        for (ComponentConfiguration config : configs) {
            configImpls.add(config);
        }
        XmlComponentConfigurations xmlConfigs = new XmlComponentConfigurations();
        xmlConfigs.setConfigurations(configImpls);
        String result = GwtServerUtil.marshal(xmlConfigs);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/xml");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename);
        response.setHeader("Cache-Control", "no-transform, max-age=0");
        writer.write(result);
    }

    public static void writeJsonSnapshot(HttpServletResponse response, PrintWriter writer, String filename, List<ComponentConfiguration> configs) {
        ComponentConfigurationList dto = DTOUtil.toComponentConfigurationList(configs, null, (boolean)false);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename);
        response.setHeader("Cache-Control", "no-transform, max-age=0");
        gson.toJson((Object)dto, (Appendable)writer);
    }

    public static void writeSnapshot(HttpServletRequest request, HttpServletResponse response, List<ComponentConfiguration> configs, String filename) throws ServletException {
        String format = request.getParameter("format");
        if (format == null || format.isEmpty()) {
            format = XML_FORMAT;
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PrintWriter writer = response.getWriter();){
                if (XML_FORMAT.equalsIgnoreCase(format)) {
                    GwtServerUtil.writeXmlSnapshot(response, writer, String.valueOf(filename) + ".xml", configs);
                } else if (JSON_FORMAT.equalsIgnoreCase(format)) {
                    GwtServerUtil.writeJsonSnapshot(response, writer, String.valueOf(filename) + ".json", configs);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error("Error exporting snapshot");
            throw new ServletException((Throwable)e);
        }
    }

    public static List<GwtNetInterfaceConfig> replaceNetworkConfigListSensitivePasswordsWithPlaceholder(List<GwtNetInterfaceConfig> gwtNetworkConfigList) {
        for (GwtNetInterfaceConfig netConfig : gwtNetworkConfigList) {
            if (netConfig instanceof GwtWifiNetInterfaceConfig) {
                GwtWifiConfig gwtStationWifiConfig;
                GwtWifiNetInterfaceConfig wifiConfig = (GwtWifiNetInterfaceConfig)netConfig;
                GwtWifiConfig gwtAPWifiConfig = wifiConfig.getAccessPointWifiConfig();
                if (gwtAPWifiConfig != null) {
                    gwtAPWifiConfig.setPassword(PASSWORD_PLACEHOLDER);
                }
                if ((gwtStationWifiConfig = wifiConfig.getStationWifiConfig()) == null) continue;
                gwtStationWifiConfig.setPassword(PASSWORD_PLACEHOLDER);
                continue;
            }
            if (!(netConfig instanceof GwtModemInterfaceConfig)) continue;
            GwtModemInterfaceConfig modemConfig = (GwtModemInterfaceConfig)netConfig;
            modemConfig.setPassword(PASSWORD_PLACEHOLDER);
        }
        return gwtNetworkConfigList;
    }

    public static void validateUserPassword(String password) throws GwtKuraException {
        List<Validator<String>> validators = PasswordStrengthValidators.fromConfig(Console.getConsoleOptions().getUserOptions());
        ArrayList errors = new ArrayList();
        for (Validator<String> validator : validators) {
            validator.validate(password, errors::add);
        }
        if (!errors.isEmpty()) {
            logger.warn("password strenght requirements not satisfied: {}", errors);
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT);
        }
    }
}

