/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.net2.status;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.core.net.util.NetworkUtil;
import org.eclipse.kura.core.util.NetUtil;
import org.eclipse.kura.net.IP4Address;
import org.eclipse.kura.net.IP6Address;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.status.NetworkInterfaceIpAddress;
import org.eclipse.kura.net.status.NetworkInterfaceStatus;
import org.eclipse.kura.net.status.NetworkInterfaceType;
import org.eclipse.kura.net.status.NetworkStatusService;
import org.eclipse.kura.net.status.modem.ModemInterfaceStatus;
import org.eclipse.kura.net.status.modem.Sim;
import org.eclipse.kura.net.status.wifi.WifiAccessPoint;
import org.eclipse.kura.net.status.wifi.WifiChannel;
import org.eclipse.kura.net.status.wifi.WifiInterfaceStatus;
import org.eclipse.kura.net.status.wifi.WifiMode;
import org.eclipse.kura.net.status.wifi.WifiSecurity;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtModemInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtNetIfConfigMode;
import org.eclipse.kura.web.shared.model.GwtNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtWifiChannelFrequency;
import org.eclipse.kura.web.shared.model.GwtWifiCiphers;
import org.eclipse.kura.web.shared.model.GwtWifiConfig;
import org.eclipse.kura.web.shared.model.GwtWifiHotspotEntry;
import org.eclipse.kura.web.shared.model.GwtWifiNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtWifiSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkStatusServiceAdapter {
    private static final String EMPTY_STRING = "";
    private final Logger logger = LoggerFactory.getLogger(NetworkStatusServiceAdapter.class);
    private final NetworkStatusService networkStatusService = ServiceLocator.getInstance().getService(NetworkStatusService.class);

    public List<String> getNetInterfaces() throws KuraException {
        return this.networkStatusService.getInterfaceIds();
    }

    public void fillWithStatusProperties(String ifName, GwtNetInterfaceConfig gwtConfigToUpdate) throws KuraException {
        Optional networkInterfaceInfo = this.networkStatusService.getNetworkStatus(ifName);
        if (networkInterfaceInfo.isPresent()) {
            this.setCommonStateProperties(gwtConfigToUpdate, (NetworkInterfaceStatus)networkInterfaceInfo.get());
            this.setIpv4DhcpClientProperties(gwtConfigToUpdate, (NetworkInterfaceStatus)networkInterfaceInfo.get());
            this.setIpv6StatusProperties(gwtConfigToUpdate, (NetworkInterfaceStatus)networkInterfaceInfo.get());
            this.setWifiStateProperties(gwtConfigToUpdate, (NetworkInterfaceStatus)networkInterfaceInfo.get());
            this.setModemStateProperties(gwtConfigToUpdate, (NetworkInterfaceStatus)networkInterfaceInfo.get());
        }
    }

    public Optional<NetworkInterfaceType> getNetInterfaceType(String ifName) throws KuraException {
        Optional networkInterfaceInfo = this.networkStatusService.getNetworkStatus(ifName);
        Optional<NetworkInterfaceType> ifType = Optional.empty();
        if (networkInterfaceInfo.isPresent()) {
            ifType = Optional.of(((NetworkInterfaceStatus)networkInterfaceInfo.get()).getType());
        }
        return ifType;
    }

    public List<GwtWifiChannelFrequency> getAllSupportedChannels(String ifname) throws KuraException {
        Optional netInterface = this.networkStatusService.getNetworkStatus(ifname);
        if (!netInterface.isPresent() || !(netInterface.get() instanceof WifiInterfaceStatus)) {
            return new ArrayList<GwtWifiChannelFrequency>();
        }
        WifiInterfaceStatus wifiInterfaceInfo = (WifiInterfaceStatus)netInterface.get();
        List channels = wifiInterfaceInfo.getChannels();
        ArrayList<GwtWifiChannelFrequency> gwtChannels = new ArrayList<GwtWifiChannelFrequency>();
        for (WifiChannel channel : channels) {
            GwtWifiChannelFrequency gwtChannel = new GwtWifiChannelFrequency(channel.getChannel(), channel.getFrequency());
            Optional isDisabled = channel.getDisabled();
            Optional isNoInitiatingRadiation = channel.getNoInitiatingRadiation();
            Optional isRadarDetection = channel.getRadarDetection();
            if (isDisabled.isPresent()) {
                gwtChannel.setDisabled((Boolean)isDisabled.get());
            }
            if (isNoInitiatingRadiation.isPresent()) {
                gwtChannel.setNoIrradiation((Boolean)isNoInitiatingRadiation.get());
            }
            if (isRadarDetection.isPresent()) {
                gwtChannel.setRadarDetection((Boolean)isRadarDetection.get());
            }
            gwtChannels.add(gwtChannel);
        }
        return gwtChannels;
    }

    public String getWifiCountryCode() throws KuraException {
        List interfaceNames = this.networkStatusService.getInterfaceIds();
        for (String interfaceName : interfaceNames) {
            try {
                Optional ifaceStatus = this.networkStatusService.getNetworkStatus(interfaceName);
                if (!ifaceStatus.isPresent() || !(ifaceStatus.get() instanceof WifiInterfaceStatus)) continue;
                return ((WifiInterfaceStatus)ifaceStatus.get()).getCountryCode();
            }
            catch (KuraException e) {
                this.logger.error("Cannot retrieve wifi country code", (Throwable)e);
            }
        }
        return EMPTY_STRING;
    }

    public List<GwtWifiHotspotEntry> findWifiHotspots(String interfaceName, boolean recompute) throws KuraException {
        ArrayList<GwtWifiHotspotEntry> result = new ArrayList<GwtWifiHotspotEntry>();
        Optional ifStatus = this.networkStatusService.getNetworkStatus(interfaceName, recompute);
        if (ifStatus.isPresent() && ifStatus.get() instanceof WifiInterfaceStatus) {
            WifiInterfaceStatus wifiStatus = (WifiInterfaceStatus)ifStatus.get();
            for (WifiAccessPoint ap : wifiStatus.getAvailableWifiAccessPoints()) {
                GwtWifiHotspotEntry entry = new GwtWifiHotspotEntry();
                entry.setChannel(ap.getChannel().getChannel());
                entry.setFrequency(ap.getChannel().getFrequency());
                entry.setMacAddress(NetworkUtil.macToString((byte[])ap.getHardwareAddress()));
                entry.setSSID(ap.getSsid());
                entry.setsignalStrength(ap.getSignalStrength());
                entry.setGroupCiphers(GwtWifiCiphers.netWifiCiphers_NONE.name());
                entry.setPairwiseCiphers(GwtWifiCiphers.netWifiCiphers_NONE.name());
                entry.setSecurity(GwtWifiSecurity.netWifiSecurityNONE.name());
                this.parseAndSetWifiSecurity(entry, ap.getRsnSecurity());
                this.parseAndSetWifiSecurity(entry, ap.getWpaSecurity());
                result.add(entry);
            }
        }
        return result;
    }

    private void setCommonStateProperties(GwtNetInterfaceConfig gwtConfig, NetworkInterfaceStatus networkInterfaceStatus) {
        gwtConfig.setName(networkInterfaceStatus.getInterfaceId());
        gwtConfig.setInterfaceName(networkInterfaceStatus.getInterfaceName());
        gwtConfig.setHwState(networkInterfaceStatus.getState().name());
        gwtConfig.setHwType(networkInterfaceStatus.getType().name());
        gwtConfig.setHwAddress(NetUtil.hardwareAddressToString((byte[])networkInterfaceStatus.getHardwareAddress()));
        gwtConfig.setHwName(networkInterfaceStatus.getInterfaceId());
        gwtConfig.setHwDriver(networkInterfaceStatus.getDriver());
        gwtConfig.setHwDriverVersion(networkInterfaceStatus.getDriverVersion());
        gwtConfig.setHwFirmware(networkInterfaceStatus.getFirmwareVersion());
        gwtConfig.setHwMTU(networkInterfaceStatus.getMtu());
    }

    private void setIpv4DhcpClientProperties(GwtNetInterfaceConfig gwtConfig, NetworkInterfaceStatus networkInterfaceInfo) {
        String ipConfigMode = gwtConfig.getConfigMode();
        if (this.isDhcpClient(ipConfigMode)) {
            networkInterfaceInfo.getInterfaceIp4Addresses().ifPresent(address -> {
                if (!address.getAddresses().isEmpty()) {
                    NetworkInterfaceIpAddress firstAddress = (NetworkInterfaceIpAddress)address.getAddresses().get(0);
                    gwtConfig.setIpAddress(((IP4Address)firstAddress.getAddress()).getHostAddress());
                    gwtConfig.setSubnetMask(NetworkUtil.getNetmaskStringForm((int)firstAddress.getPrefix()));
                }
                String gatewayAddress = address.getGateway().isPresent() ? ((IP4Address)address.getGateway().get()).getHostAddress() : EMPTY_STRING;
                gwtConfig.setGateway(gatewayAddress);
                gwtConfig.setReadOnlyDnsServers(this.prettyPrintDnsServers(address.getDnsServerAddresses()));
            });
        }
    }

    private boolean isDhcpClient(String ipConfigMode) {
        return ipConfigMode != null && ipConfigMode.equals(GwtNetIfConfigMode.netIPv4ConfigModeDHCP.name());
    }

    private void setIpv6StatusProperties(GwtNetInterfaceConfig gwtConfig, NetworkInterfaceStatus networkInterfaceInfo) {
        String ipConfigMode = gwtConfig.getIpv6ConfigMode();
        if (this.isIpv6AutoConfig(ipConfigMode)) {
            networkInterfaceInfo.getInterfaceIp6Addresses().ifPresent(address -> {
                if (!address.getAddresses().isEmpty()) {
                    NetworkInterfaceIpAddress firstAddress = (NetworkInterfaceIpAddress)address.getAddresses().get(0);
                    gwtConfig.setIpv6Address(((IP6Address)firstAddress.getAddress()).getHostAddress());
                    gwtConfig.setIpv6SubnetMask(Integer.valueOf(firstAddress.getPrefix()));
                }
                String gatewayAddress = address.getGateway().isPresent() ? ((IP6Address)address.getGateway().get()).getHostAddress() : EMPTY_STRING;
                gwtConfig.setIpv6Gateway(gatewayAddress);
                gwtConfig.setIpv6ReadOnlyDnsServers(this.prettyPrintDnsServers(address.getDnsServerAddresses()));
            });
        }
    }

    private boolean isIpv6AutoConfig(String ipConfigMode) {
        return ipConfigMode != null && (ipConfigMode.equals("netIPv6MethodAuto") || ipConfigMode.equals("netIPv6MethodDhcp"));
    }

    private <T extends IPAddress> String prettyPrintDnsServers(List<T> dnsAddresses) {
        StringBuilder result = new StringBuilder();
        for (IPAddress dnsAddress : dnsAddresses) {
            result.append(dnsAddress.getHostAddress());
            result.append("\n");
        }
        return result.toString();
    }

    private void setModemStateProperties(GwtNetInterfaceConfig gwtConfig, NetworkInterfaceStatus networkInterfaceInfo) {
        if (gwtConfig instanceof GwtModemInterfaceConfig && networkInterfaceInfo instanceof ModemInterfaceStatus) {
            GwtModemInterfaceConfig gwtModemConfig = (GwtModemInterfaceConfig)gwtConfig;
            ModemInterfaceStatus modemInterfaceInfo = (ModemInterfaceStatus)networkInterfaceInfo;
            Sim activeSim = null;
            List availableSims = modemInterfaceInfo.getAvailableSims();
            for (Sim sim : availableSims) {
                if (!sim.isActive() || !sim.isPrimary()) continue;
                activeSim = sim;
            }
            gwtModemConfig.setHwState(modemInterfaceInfo.getConnectionStatus().name());
            gwtModemConfig.setHwSerial(modemInterfaceInfo.getSerialNumber());
            gwtModemConfig.setHwRssi(String.valueOf(modemInterfaceInfo.getSignalStrength()));
            gwtModemConfig.setHwICCID(activeSim != null ? activeSim.getIccid() : "NA");
            gwtModemConfig.setHwIMSI(activeSim != null ? activeSim.getImsi() : "NA");
            gwtModemConfig.setHwRegistration(modemInterfaceInfo.getRegistrationStatus().toString());
            gwtModemConfig.setHwNetwork(modemInterfaceInfo.getOperatorName());
            gwtModemConfig.setHwRadio(this.getModemAccessTechnologies(modemInterfaceInfo));
            gwtModemConfig.setHwBand(this.getModemBands(modemInterfaceInfo));
            gwtModemConfig.setModel(this.ellipsis(modemInterfaceInfo.getModel(), 40));
            gwtModemConfig.setManufacturer(this.ellipsis(modemInterfaceInfo.getManufacturer(), 20));
            gwtModemConfig.setModemId(modemInterfaceInfo.getModel());
            gwtModemConfig.setGpsSupported(modemInterfaceInfo.isGpsSupported());
            gwtModemConfig.setHwFirmware(modemInterfaceInfo.getFirmwareVersion());
            gwtModemConfig.setConnectionType(modemInterfaceInfo.getConnectionType().toString());
            gwtModemConfig.setNetworkTechnology(modemInterfaceInfo.getAccessTechnologies().stream().map(Enum::name).collect(Collectors.toList()));
            gwtModemConfig.setHwRssi(String.valueOf(modemInterfaceInfo.getSignalStrength()));
            gwtModemConfig.setIpAddress(gwtConfig.getIpAddress());
            gwtModemConfig.setSubnetMask(gwtConfig.getSubnetMask());
            gwtModemConfig.setGateway(gwtConfig.getGateway());
        }
    }

    private String getModemAccessTechnologies(ModemInterfaceStatus modemInterfaceInfo) {
        StringBuilder sb = new StringBuilder();
        modemInterfaceInfo.getAccessTechnologies().forEach(accessTechnology -> {
            StringBuilder stringBuilder2 = sb.append(accessTechnology).append(",");
        });
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    private String getModemBands(ModemInterfaceStatus modemInterfaceInfo) {
        StringBuilder sb = new StringBuilder();
        modemInterfaceInfo.getCurrentBands().forEach(band -> {
            StringBuilder stringBuilder2 = sb.append(band).append(",");
        });
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    private String ellipsis(String text, int length) {
        if (text.length() <= length) {
            return text;
        }
        return String.valueOf(text.substring(0, length)) + "...";
    }

    private void setWifiStateProperties(GwtNetInterfaceConfig gwtNetInterfaceConfig, NetworkInterfaceStatus networkInterfaceInfo) {
        if (gwtNetInterfaceConfig instanceof GwtWifiNetInterfaceConfig && networkInterfaceInfo instanceof WifiInterfaceStatus) {
            GwtWifiNetInterfaceConfig gwtWifiNetInterfaceConfig = (GwtWifiNetInterfaceConfig)gwtNetInterfaceConfig;
            WifiInterfaceStatus wifiInterfaceInfo = (WifiInterfaceStatus)networkInterfaceInfo;
            gwtWifiNetInterfaceConfig.setHwState(wifiInterfaceInfo.getState().toString());
            if (wifiInterfaceInfo.getMode() == WifiMode.MASTER) {
                this.setWifiMasterStateProperties(gwtWifiNetInterfaceConfig, wifiInterfaceInfo);
            } else if (wifiInterfaceInfo.getMode() == WifiMode.INFRA) {
                this.setWifiInfraStateProperties(gwtWifiNetInterfaceConfig, wifiInterfaceInfo);
            }
        }
    }

    private void setWifiMasterStateProperties(GwtWifiNetInterfaceConfig gwtWifiNetInterfaceConfig, WifiInterfaceStatus wifiInterfaceInfo) {
        GwtWifiConfig gwtConfig;
        if (Objects.nonNull(gwtWifiNetInterfaceConfig.getAccessPointWifiConfig())) {
            gwtConfig = gwtWifiNetInterfaceConfig.getAccessPointWifiConfig();
        } else {
            gwtConfig = gwtWifiNetInterfaceConfig.getActiveWifiConfig();
            gwtWifiNetInterfaceConfig.setAccessPointWifiConfig(gwtConfig);
        }
        ChannelsBuilder channelsBuilder = new ChannelsBuilder();
        Optional activeAP = wifiInterfaceInfo.getActiveWifiAccessPoint();
        if (activeAP.isPresent()) {
            channelsBuilder.setActiveChannel(((WifiAccessPoint)activeAP.get()).getChannel());
        } else {
            List<Integer> activeChannel = gwtConfig.getChannels();
            if (activeChannel != null && activeChannel.size() == 1) {
                channelsBuilder.setActiveChannel(activeChannel.get(0));
            }
        }
        channelsBuilder.addChannels(wifiInterfaceInfo.getChannels());
        gwtConfig.setChannels(channelsBuilder.getChannelsIntegers());
    }

    private void setWifiInfraStateProperties(GwtWifiNetInterfaceConfig gwtWifiNetInterfaceConfig, WifiInterfaceStatus wifiInterfaceInfo) {
        GwtWifiConfig gwtConfig;
        AtomicReference<String> rssi = new AtomicReference<String>("N/A");
        wifiInterfaceInfo.getActiveWifiAccessPoint().ifPresent(accessPoint -> rssi.set(String.valueOf(accessPoint.getSignalStrength())));
        gwtWifiNetInterfaceConfig.setHwRssi(rssi.get());
        if (Objects.nonNull(gwtWifiNetInterfaceConfig.getStationWifiConfig())) {
            gwtConfig = gwtWifiNetInterfaceConfig.getStationWifiConfig();
        } else {
            gwtConfig = gwtWifiNetInterfaceConfig.getActiveWifiConfig();
            gwtWifiNetInterfaceConfig.setStationWifiConfig(gwtConfig);
        }
        ChannelsBuilder channelsBuilder = new ChannelsBuilder();
        List<Integer> activeChannel = gwtConfig.getChannels();
        if (activeChannel != null && activeChannel.size() == 1) {
            channelsBuilder.setActiveChannel(activeChannel.get(0));
        }
        channelsBuilder.addChannels(wifiInterfaceInfo.getChannels());
        gwtConfig.setChannels(channelsBuilder.getChannelsIntegers());
    }

    private void parseAndSetWifiSecurity(GwtWifiHotspotEntry entryToModify, Set<WifiSecurity> supportedSecurity) {
        boolean isGroupCCMP = supportedSecurity.contains(WifiSecurity.GROUP_CCMP);
        boolean isGroupTKIP = supportedSecurity.contains(WifiSecurity.GROUP_TKIP);
        boolean isPairCCMP = supportedSecurity.contains(WifiSecurity.PAIR_CCMP);
        boolean isPairTKIP = supportedSecurity.contains(WifiSecurity.PAIR_TKIP);
        if (isGroupCCMP && isGroupTKIP) {
            entryToModify.setGroupCiphers(GwtWifiCiphers.netWifiCiphers_CCMP_TKIP.name());
        } else if (isGroupCCMP) {
            entryToModify.setGroupCiphers(GwtWifiCiphers.netWifiCiphers_CCMP.name());
        } else if (isGroupTKIP) {
            entryToModify.setGroupCiphers(GwtWifiCiphers.netWifiCiphers_TKIP.name());
        }
        if (isPairCCMP && isPairTKIP) {
            entryToModify.setPairwiseCiphers(GwtWifiCiphers.netWifiCiphers_CCMP_TKIP.name());
        } else if (isPairCCMP) {
            entryToModify.setPairwiseCiphers(GwtWifiCiphers.netWifiCiphers_CCMP.name());
        } else if (isPairTKIP) {
            entryToModify.setPairwiseCiphers(GwtWifiCiphers.netWifiCiphers_TKIP.name());
        }
        entryToModify.setSecurity(this.wifiSecurityCollectionToString(supportedSecurity));
    }

    private String wifiSecurityCollectionToString(Set<WifiSecurity> wifiSecurities) {
        StringBuilder prettyPrint = new StringBuilder();
        for (WifiSecurity wifiSecurity : wifiSecurities) {
            String secString = wifiSecurity.name();
            if (!secString.contains("KEY_MGMT")) continue;
            prettyPrint.append(secString.replace("KEY_MGMT_", EMPTY_STRING));
            prettyPrint.append(", ");
        }
        if (prettyPrint.length() > 2) {
            prettyPrint.deleteCharAt(prettyPrint.length() - 1);
            prettyPrint.deleteCharAt(prettyPrint.length() - 1);
        }
        return prettyPrint.toString();
    }

    private class ChannelsBuilder {
        List<WifiChannel> channels = new LinkedList<WifiChannel>();

        public ChannelsBuilder setActiveChannel(WifiChannel channel) {
            this.channels.add(0, channel);
            return this;
        }

        public ChannelsBuilder setActiveChannel(int channel) {
            this.channels.add(0, WifiChannel.builder((int)channel, (int)0).build());
            return this;
        }

        public ChannelsBuilder addChannels(List<WifiChannel> otherChannels) {
            this.channels.addAll(otherChannels);
            return this;
        }

        public List<Integer> getChannelsIntegers() {
            ArrayList<Integer> intChannels = new ArrayList<Integer>();
            this.channels.forEach(channel -> {
                boolean bl = intChannels.add(channel.getChannel());
            });
            return intChannels;
        }
    }
}

