/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.keystore.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.bc.BcPEMDecryptorProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class CertificateUtil {
    private CertificateUtil() {
    }

    public static X509Certificate toJavaX509Certificate(Object o) throws Exception {
        CertificateFactory fac = CertificateFactory.getInstance("X509");
        if (o instanceof X509CertificateHolder) {
            return (X509Certificate)fac.generateCertificate(new ByteArrayInputStream(((X509CertificateHolder)o).getEncoded()));
        }
        if (o instanceof X509Certificate) {
            return (X509Certificate)fac.generateCertificate(new ByteArrayInputStream(((X509Certificate)o).getEncoded()));
        }
        if (o instanceof X509Certificate) {
            return (X509Certificate)o;
        }
        if (o instanceof PemObject) {
            return (X509Certificate)fac.generateCertificate(new ByteArrayInputStream(((PemObject)o).getContent()));
        }
        throw new IllegalArgumentException("Object not one of X509CertificateHolder, X509Certificate or PemObject.");
    }

    public static Set<TrustAnchor> toTrustAnchor(List<X509Certificate> certificates) throws Exception {
        HashSet<TrustAnchor> out = new HashSet<TrustAnchor>();
        for (X509Certificate c : certificates) {
            out.add(new TrustAnchor(c, null));
        }
        return out;
    }

    public static String x509CertificateToPem(Certificate cert) throws IOException {
        StringWriter writer = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
        pemWriter.writeObject((Object)cert);
        pemWriter.flush();
        pemWriter.close();
        return writer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<X509Certificate> readPemCertificates(String pemString) throws Exception {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            StringReader r = new StringReader(pemString);
            try {
                try (PemReader reader = new PemReader((Reader)r);){
                    PemObject o;
                    while ((o = reader.readPemObject()) != null) {
                        certs.add(CertificateUtil.toJavaX509Certificate(o));
                    }
                }
                if (r == null) return certs;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (r == null) throw throwable;
                ((Reader)r).close();
                throw throwable;
            }
            ((Reader)r).close();
            return certs;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public static PrivateKey readEncryptedPrivateKey(String pemString, String password) throws IOException, PKCSException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            PrivateKey privateKey;
            PEMParser pemParser;
            StringReader r;
            block20: {
                block19: {
                    PrivateKeyInfo privateKeyInfo;
                    r = new StringReader(pemString);
                    pemParser = new PEMParser((Reader)r);
                    JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
                    Object o = pemParser.readObject();
                    if (o instanceof PKCS8EncryptedPrivateKeyInfo) {
                        PKCS8EncryptedPrivateKeyInfo epki = (PKCS8EncryptedPrivateKeyInfo)o;
                        JcePKCSPBEInputDecryptorProviderBuilder builder = new JcePKCSPBEInputDecryptorProviderBuilder().setProvider("BC");
                        InputDecryptorProvider idp = builder.build(password.toCharArray());
                        privateKeyInfo = epki.decryptPrivateKeyInfo(idp);
                    } else if (o instanceof PEMEncryptedKeyPair) {
                        PEMEncryptedKeyPair epki = (PEMEncryptedKeyPair)o;
                        PEMKeyPair pkp = epki.decryptKeyPair((PEMDecryptorProvider)new BcPEMDecryptorProvider(password.toCharArray()));
                        privateKeyInfo = pkp.getPrivateKeyInfo();
                    } else {
                        throw new PKCSException("Invalid encrypted private key class: " + o.getClass().getName());
                    }
                    privateKey = converter.getPrivateKey(privateKeyInfo);
                    if (pemParser == null) break block19;
                    pemParser.close();
                }
                if (r == null) break block20;
                ((Reader)r).close();
            }
            return privateKey;
            {
                catch (Throwable throwable2) {
                    try {
                        if (pemParser != null) {
                            pemParser.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (r != null) {
                            ((Reader)r).close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public static PublicKey readPublicKey(String pemString, String algorithm) throws Exception {
        KeyFactory factory = KeyFactory.getInstance(algorithm);
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            PublicKey publicKey;
            PemReader pemReader;
            StringReader r;
            block16: {
                block15: {
                    r = new StringReader(pemString);
                    pemReader = new PemReader((Reader)r);
                    PemObject pemObject = pemReader.readPemObject();
                    byte[] content = pemObject.getContent();
                    X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(content);
                    publicKey = factory.generatePublic(pubKeySpec);
                    if (pemReader == null) break block15;
                    pemReader.close();
                }
                if (r == null) break block16;
                ((Reader)r).close();
            }
            return publicKey;
            {
                catch (Throwable throwable2) {
                    try {
                        if (pemReader != null) {
                            pemReader.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (r != null) {
                            ((Reader)r).close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static X509Certificate[] generateCertificateChain(KeyPair keyPair, String signatureAlgorithm, String attributes, Date startDate, Date endDate) throws OperatorCreationException, CertificateException {
        BouncyCastleProvider bcProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bcProvider);
        X500Name dnName = new X500Name(attributes);
        BigInteger certSerialNumber = BigInteger.valueOf(System.currentTimeMillis());
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
        X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(dnName, certSerialNumber, startDate, endDate, dnName, subjectPublicKeyInfo);
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).setProvider((Provider)bcProvider).build(keyPair.getPrivate());
        X509CertificateHolder certificateHolder = certificateBuilder.build(contentSigner);
        return new X509Certificate[]{new JcaX509CertificateConverter().getCertificate(certificateHolder)};
    }

    public static Store<X509CertificateHolder> toX509CertificateHolderStore(String pemString) throws Exception {
        List<X509Certificate> certs = CertificateUtil.readPemCertificates(pemString);
        List x509CertificateHolderCerts = certs.stream().map(cert -> {
            try {
                return new X509CertificateHolder(cert.getEncoded());
            }
            catch (IOException | CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        return new JcaCertStore(x509CertificateHolderCerts);
    }

    public static CertStore toCertStore(Store<?> store) throws Exception {
        List certificatesX509 = store.getMatches(null).stream().map(t -> {
            try {
                return CertificateUtil.toJavaX509Certificate(t);
            }
            catch (Exception exception) {
                return null;
            }
        }).collect(Collectors.toList());
        try {
            return CertStore.getInstance("Collection", new CollectionCertStoreParameters(certificatesX509));
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new Exception(e);
        }
    }
}

