/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.coordinator;

import java.util.Timer;
import org.eclipse.equinox.coordinator.CoordinatorImpl;
import org.eclipse.equinox.coordinator.LogTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.coordinator.Coordinator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinatorServiceFactory
implements ServiceFactory<Coordinator> {
    private final BundleContext bundleContext;
    private final LogTracker logTracker;
    private final Timer timer = new Timer(true);

    public CoordinatorServiceFactory(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.logTracker = new LogTracker(bundleContext, System.out);
    }

    public Coordinator getService(Bundle bundle, ServiceRegistration<Coordinator> registration) {
        return new CoordinatorImpl(bundle, this.logTracker, this.timer, this.getMaxTimeout());
    }

    public void ungetService(Bundle bundle, ServiceRegistration<Coordinator> registration, Coordinator service) {
        ((CoordinatorImpl)service).shutdown();
    }

    void shutdown() {
        this.timer.cancel();
        this.logTracker.close();
    }

    private long getMaxTimeout() {
        String prop = this.bundleContext.getProperty("org.eclipse.equinox.coordinator.timeout");
        return prop == null ? 0L : Long.parseLong(prop);
    }
}

