/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.net2.utils;

import java.util.Optional;
import org.eclipse.kura.net.NetInterfaceStatus;
import org.eclipse.kura.net.modem.ModemConfig;
import org.eclipse.kura.net.wifi.WifiCiphers;
import org.eclipse.kura.net.wifi.WifiMode;
import org.eclipse.kura.net.wifi.WifiRadioMode;
import org.eclipse.kura.net.wifi.WifiSecurity;
import org.eclipse.kura.web.shared.model.GwtModemAuthType;
import org.eclipse.kura.web.shared.model.GwtModemPdpType;
import org.eclipse.kura.web.shared.model.GwtNetIfStatus;
import org.eclipse.kura.web.shared.model.GwtWifiCiphers;
import org.eclipse.kura.web.shared.model.GwtWifiRadioMode;
import org.eclipse.kura.web.shared.model.GwtWifiSecurity;
import org.eclipse.kura.web.shared.model.GwtWifiWirelessMode;

public class EnumsParser {
    private EnumsParser() {
    }

    public static String getGwtWifiWirelessMode(Optional<String> wifiMode) {
        if (wifiMode.isPresent()) {
            if (wifiMode.get().equals(WifiMode.MASTER.name())) {
                return GwtWifiWirelessMode.netWifiWirelessModeAccessPoint.name();
            }
            if (wifiMode.get().equals(WifiMode.INFRA.name())) {
                return GwtWifiWirelessMode.netWifiWirelessModeStation.name();
            }
            if (wifiMode.get().equals(WifiMode.ADHOC.name())) {
                return GwtWifiWirelessMode.netWifiWirelessModeAdHoc.name();
            }
        }
        return GwtWifiWirelessMode.netWifiWirelessModeDisabled.name();
    }

    public static String getWifiMode(Optional<String> gwtWifiWirelessMode) {
        if (gwtWifiWirelessMode.isPresent()) {
            if (gwtWifiWirelessMode.get().equals(GwtWifiWirelessMode.netWifiWirelessModeAccessPoint.name())) {
                return WifiMode.MASTER.name();
            }
            if (gwtWifiWirelessMode.get().equals(GwtWifiWirelessMode.netWifiWirelessModeStation.name())) {
                return WifiMode.INFRA.name();
            }
            if (gwtWifiWirelessMode.get().equals(GwtWifiWirelessMode.netWifiWirelessModeAdHoc.name())) {
                return WifiMode.ADHOC.name();
            }
        }
        return WifiMode.UNKNOWN.toString();
    }

    public static String getGwtNetIfStatus(Optional<String> netInterfaceStatus) {
        if (netInterfaceStatus.isPresent()) {
            if (netInterfaceStatus.get().equals(NetInterfaceStatus.netIPv4StatusEnabledLAN.name())) {
                return GwtNetIfStatus.netIPv4StatusEnabledLAN.name();
            }
            if (netInterfaceStatus.get().equals(NetInterfaceStatus.netIPv4StatusEnabledWAN.name())) {
                return GwtNetIfStatus.netIPv4StatusEnabledWAN.name();
            }
            if (netInterfaceStatus.get().equals(NetInterfaceStatus.netIPv4StatusL2Only.name())) {
                return GwtNetIfStatus.netIPv4StatusL2Only.name();
            }
            if (netInterfaceStatus.get().equals(NetInterfaceStatus.netIPv4StatusUnmanaged.name())) {
                return GwtNetIfStatus.netIPv4StatusUnmanaged.name();
            }
        }
        return GwtNetIfStatus.netIPv4StatusDisabled.name();
    }

    public static String getNetInterfaceStatus(Optional<String> gwtNetIfStatus) {
        if (gwtNetIfStatus.isPresent()) {
            if (gwtNetIfStatus.get().equals(GwtNetIfStatus.netIPv4StatusDisabled.name())) {
                return NetInterfaceStatus.netIPv4StatusDisabled.name();
            }
            if (gwtNetIfStatus.get().equals(GwtNetIfStatus.netIPv4StatusEnabledLAN.name())) {
                return NetInterfaceStatus.netIPv4StatusEnabledLAN.name();
            }
            if (gwtNetIfStatus.get().equals(GwtNetIfStatus.netIPv4StatusEnabledWAN.name())) {
                return NetInterfaceStatus.netIPv4StatusEnabledWAN.name();
            }
            if (gwtNetIfStatus.get().equals(GwtNetIfStatus.netIPv4StatusL2Only.name())) {
                return NetInterfaceStatus.netIPv4StatusL2Only.name();
            }
            if (gwtNetIfStatus.get().equals(GwtNetIfStatus.netIPv4StatusUnmanaged.name())) {
                return NetInterfaceStatus.netIPv4StatusUnmanaged.name();
            }
        }
        return NetInterfaceStatus.netIPv4StatusUnknown.name();
    }

    public static String getGwtWifiSecurity(Optional<String> wifiSecurity) {
        if (wifiSecurity.isPresent()) {
            if (wifiSecurity.get().equals(WifiSecurity.NONE.name())) {
                return GwtWifiSecurity.netWifiSecurityNONE.name();
            }
            if (wifiSecurity.get().equals(WifiSecurity.SECURITY_WEP.name())) {
                return GwtWifiSecurity.netWifiSecurityWEP.name();
            }
            if (wifiSecurity.get().equals(WifiSecurity.SECURITY_WPA.name())) {
                return GwtWifiSecurity.netWifiSecurityWPA.name();
            }
            if (wifiSecurity.get().equals(WifiSecurity.SECURITY_WPA2.name())) {
                return GwtWifiSecurity.netWifiSecurityWPA2.name();
            }
            if (wifiSecurity.get().equals(WifiSecurity.SECURITY_WPA_WPA2.name())) {
                return GwtWifiSecurity.netWifiSecurityWPA_WPA2.name();
            }
        }
        return GwtWifiSecurity.netWifiSecurityWPA2.name();
    }

    public static String getWifiSecurity(Optional<String> gwtWifiSecurity) {
        if (gwtWifiSecurity.isPresent()) {
            if (gwtWifiSecurity.get().equals(GwtWifiSecurity.netWifiSecurityWEP.name())) {
                return WifiSecurity.SECURITY_WEP.name();
            }
            if (gwtWifiSecurity.get().equals(GwtWifiSecurity.netWifiSecurityWPA.name())) {
                return WifiSecurity.SECURITY_WPA.name();
            }
            if (gwtWifiSecurity.get().equals(GwtWifiSecurity.netWifiSecurityWPA2.name())) {
                return WifiSecurity.SECURITY_WPA2.name();
            }
            if (gwtWifiSecurity.get().equals(GwtWifiSecurity.netWifiSecurityWPA_WPA2.name())) {
                return WifiSecurity.SECURITY_WPA_WPA2.name();
            }
        }
        return WifiSecurity.NONE.name();
    }

    public static String getGwtWifiCiphers(Optional<String> wifiCiphers) {
        if (wifiCiphers.isPresent()) {
            if (wifiCiphers.get().equals(WifiCiphers.CCMP.name())) {
                return GwtWifiCiphers.netWifiCiphers_CCMP.name();
            }
            if (wifiCiphers.get().equals(WifiCiphers.TKIP.name())) {
                return GwtWifiCiphers.netWifiCiphers_TKIP.name();
            }
            if (wifiCiphers.get().equals(WifiCiphers.CCMP_TKIP.name())) {
                return GwtWifiCiphers.netWifiCiphers_CCMP_TKIP.name();
            }
        }
        return GwtWifiCiphers.netWifiCiphers_CCMP.name();
    }

    public static Optional<String> getWifiCiphers(Optional<String> gwtWifiCiphers) {
        if (gwtWifiCiphers.isPresent()) {
            if (gwtWifiCiphers.get().equals(GwtWifiCiphers.netWifiCiphers_CCMP.name())) {
                return Optional.of(WifiCiphers.CCMP.name());
            }
            if (gwtWifiCiphers.get().equals(GwtWifiCiphers.netWifiCiphers_CCMP_TKIP.name())) {
                return Optional.of(WifiCiphers.CCMP_TKIP.name());
            }
            if (gwtWifiCiphers.get().equals(GwtWifiCiphers.netWifiCiphers_TKIP.name())) {
                return Optional.of(WifiCiphers.TKIP.name());
            }
        }
        return Optional.empty();
    }

    public static Optional<String> getGwtWifiRadioMode(Optional<String> wifiRadioMode) {
        if (wifiRadioMode.isPresent()) {
            if (wifiRadioMode.get().equals(WifiRadioMode.RADIO_MODE_80211_AC.name())) {
                return Optional.of(GwtWifiRadioMode.netWifiRadioModeANAC.name());
            }
            if (wifiRadioMode.get().equals(WifiRadioMode.RADIO_MODE_80211a.name())) {
                return Optional.of(GwtWifiRadioMode.netWifiRadioModeA.name());
            }
            if (wifiRadioMode.get().equals(WifiRadioMode.RADIO_MODE_80211b.name())) {
                return Optional.of(GwtWifiRadioMode.netWifiRadioModeB.name());
            }
            if (wifiRadioMode.get().equals(WifiRadioMode.RADIO_MODE_80211g.name())) {
                return Optional.of(GwtWifiRadioMode.netWifiRadioModeBG.name());
            }
            if (wifiRadioMode.get().equals(WifiRadioMode.RADIO_MODE_80211nHT20.name()) || wifiRadioMode.get().equals(WifiRadioMode.RADIO_MODE_80211nHT40above.name()) || wifiRadioMode.get().equals(WifiRadioMode.RADIO_MODE_80211nHT40below.name())) {
                return Optional.of(GwtWifiRadioMode.netWifiRadioModeBGN.name());
            }
        }
        return Optional.of(GwtWifiRadioMode.netWifiRadioModeBGN.name());
    }

    public static Optional<String> getWifiRadioMode(Optional<String> gwtWifiRadioMode) {
        if (gwtWifiRadioMode.isPresent()) {
            if (gwtWifiRadioMode.get().equals(GwtWifiRadioMode.netWifiRadioModeA.name())) {
                return Optional.of(WifiRadioMode.RADIO_MODE_80211a.name());
            }
            if (gwtWifiRadioMode.get().equals(GwtWifiRadioMode.netWifiRadioModeANAC.name())) {
                return Optional.of(WifiRadioMode.RADIO_MODE_80211_AC.name());
            }
            if (gwtWifiRadioMode.get().equals(GwtWifiRadioMode.netWifiRadioModeB.name())) {
                return Optional.of(WifiRadioMode.RADIO_MODE_80211b.name());
            }
            if (gwtWifiRadioMode.get().equals(GwtWifiRadioMode.netWifiRadioModeBG.name())) {
                return Optional.of(WifiRadioMode.RADIO_MODE_80211g.name());
            }
            if (gwtWifiRadioMode.get().equals(GwtWifiRadioMode.netWifiRadioModeBGN.name())) {
                return Optional.of(WifiRadioMode.RADIO_MODE_80211nHT20.name());
            }
        }
        return Optional.empty();
    }

    public static GwtModemAuthType getGwtModemAuthType(Optional<String> authType) {
        if (authType.isPresent()) {
            if (authType.get().equals(ModemConfig.AuthType.AUTO.name())) {
                return GwtModemAuthType.netModemAuthAUTO;
            }
            if (authType.get().equals(ModemConfig.AuthType.CHAP.name())) {
                return GwtModemAuthType.netModemAuthCHAP;
            }
            if (authType.get().equals(ModemConfig.AuthType.PAP.name())) {
                return GwtModemAuthType.netModemAuthPAP;
            }
        }
        return GwtModemAuthType.netModemAuthNONE;
    }

    public static String getAuthType(Optional<GwtModemAuthType> gwtModemAuthType) {
        if (gwtModemAuthType.isPresent()) {
            switch (gwtModemAuthType.get()) {
                case netModemAuthAUTO: {
                    return ModemConfig.AuthType.AUTO.name();
                }
                case netModemAuthCHAP: {
                    return ModemConfig.AuthType.CHAP.name();
                }
                case netModemAuthPAP: {
                    return ModemConfig.AuthType.PAP.name();
                }
            }
        }
        return ModemConfig.AuthType.NONE.name();
    }

    public static GwtModemPdpType getGwtModemPdpType(Optional<String> pdpType) {
        if (pdpType.isPresent()) {
            if (pdpType.get().equals(ModemConfig.PdpType.IP.name())) {
                return GwtModemPdpType.netModemPdpIP;
            }
            if (pdpType.get().equals(ModemConfig.PdpType.PPP.name())) {
                return GwtModemPdpType.netModemPdpPPP;
            }
            if (pdpType.get().equals(ModemConfig.PdpType.IPv6.name())) {
                return GwtModemPdpType.netModemPdpIPv6;
            }
        }
        return GwtModemPdpType.netModemPdpUnknown;
    }

    public static String getPdpType(Optional<GwtModemPdpType> gwtModemPdpType) {
        if (gwtModemPdpType.isPresent()) {
            switch (gwtModemPdpType.get()) {
                case netModemPdpIP: {
                    return ModemConfig.PdpType.IP.name();
                }
                case netModemPdpIPv6: {
                    return ModemConfig.PdpType.IPv6.name();
                }
                case netModemPdpPPP: {
                    return ModemConfig.PdpType.PPP.name();
                }
            }
        }
        return ModemConfig.PdpType.UNKNOWN.name();
    }
}

